/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.TabularLayout;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdtUiUtils {
    public static final JBFont DEFAULT_FONT = JBUI.Fonts.label((float)10.0f);
    public static final Color DEFAULT_FONT_COLOR = JBColor.foreground();
    public static final Color DEFAULT_BORDER_COLOR = new JBColor((Color)Gray._201, (Color)Gray._40);
    public static final Border DEFAULT_TOP_BORDER = BorderFactory.createMatteBorder(1, 0, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_LEFT_BORDER = BorderFactory.createMatteBorder(0, 1, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_BOTTOM_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_RIGHT_BORDER = BorderFactory.createMatteBorder(0, 0, 0, 1, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_HORIZONTAL_BORDERS = BorderFactory.createMatteBorder(1, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_VERTICAL_BORDERS = BorderFactory.createMatteBorder(0, 1, 0, 1, DEFAULT_BORDER_COLOR);
    public static final GridBagConstraints GBC_FULL = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0);

    private AdtUiUtils() {
    }

    public static String shrinkToFit(String text, FontMetrics metrics, float availableSpace) {
        return AdtUiUtils.shrinkToFit(text, s -> (float)metrics.stringWidth((String)s) <= availableSpace);
    }

    public static String shrinkToFit(String text, Predicate<String> textFitPredicate) {
        if (textFitPredicate.test(text)) {
            return text;
        }
        if (!textFitPredicate.test("...")) {
            return "";
        }
        int smallestLength = 0;
        int largestLength = text.length();
        int bestLength = smallestLength;
        do {
            int midLength;
            if (textFitPredicate.test(text.substring(0, midLength = smallestLength + (largestLength - smallestLength) / 2) + "...")) {
                bestLength = midLength;
                smallestLength = midLength + 1;
                continue;
            }
            largestLength = midLength - 1;
        } while (smallestLength <= largestLength);
        return bestLength > 0 ? text.substring(0, bestLength) + "..." : "";
    }

    public static int unscale(int i) {
        return Math.round((float)i / JBUI.scale((float)1.0f));
    }

    public static Color overlayColor(int backgroundRgb, int foregroundRbg, float foregroundOpacity) {
        Color background = new Color(backgroundRgb);
        Color forground = new Color(foregroundRbg);
        return new Color(Math.round((float)background.getRed() * (1.0f - foregroundOpacity) + (float)forground.getRed() * foregroundOpacity), Math.round((float)background.getGreen() * (1.0f - foregroundOpacity) + (float)forground.getGreen() * foregroundOpacity), Math.round((float)background.getBlue() * (1.0f - foregroundOpacity) + (float)forground.getBlue() * foregroundOpacity));
    }

    public static boolean isActionKeyDown(@NotNull InputEvent event) {
        if (event == null) {
            AdtUiUtils.$$$reportNull$$$0(0);
        }
        return SystemInfo.isMac ? event.isMetaDown() : event.isControlDown();
    }

    public static int getActionMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    public static JComponent createHorizontalSeparator() {
        JPanel separatorWrapper = new JPanel(new TabularLayout("*", "*,Fit,*"));
        separatorWrapper.add((Component)new JSeparator(), new TabularLayout.Constraint(1, 0));
        Dimension size = new Dimension(1, 12);
        separatorWrapper.setMinimumSize(size);
        separatorWrapper.setPreferredSize(size);
        separatorWrapper.setOpaque(false);
        return separatorWrapper;
    }

    @NotNull
    public static JBScrollPane createNestedVScrollPane(@NotNull JComponent component) {
        if (component == null) {
            AdtUiUtils.$$$reportNull$$$0(1);
        }
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.addMouseWheelListener((MouseWheelListener)new DelegateMouseWheelListener((JScrollPane)scrollPane));
        scrollPane.setHorizontalScrollBarPolicy(30);
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            AdtUiUtils.$$$reportNull$$$0(2);
        }
        return jBScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/common/AdtUiUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/common/AdtUiUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedVScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActionKeyDown";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createNestedVScrollPane";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegateMouseWheelListener
    implements MouseWheelListener {
        @NotNull
        private final JScrollPane myScrollPane;
        @Nullable
        private JScrollPane myParentScrollPane;
        private int myLastScrollOffset;

        DelegateMouseWheelListener(@NotNull JScrollPane scrollPane) {
            if (scrollPane == null) {
                DelegateMouseWheelListener.$$$reportNull$$$0(0);
            }
            this.myLastScrollOffset = 0;
            this.myScrollPane = scrollPane;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int terminalValue;
            this.setParentScrollPane();
            if (this.myParentScrollPane == null) {
                this.myScrollPane.removeMouseWheelListener(this);
                return;
            }
            JScrollBar scrollBar = this.myScrollPane.getVerticalScrollBar();
            int n = terminalValue = e.getWheelRotation() < 0 ? 0 : scrollBar.getMaximum() - scrollBar.getVisibleAmount();
            if (scrollBar.getValue() == terminalValue && this.myLastScrollOffset == terminalValue) {
                this.myParentScrollPane.dispatchEvent(DelegateMouseWheelListener.clone(this.myParentScrollPane, e));
            }
            this.myLastScrollOffset = scrollBar.getValue();
        }

        private void setParentScrollPane() {
            if (this.myParentScrollPane == null) {
                Container parent;
                for (parent = this.myScrollPane.getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
                }
                this.myParentScrollPane = (JScrollPane)parent;
            }
        }

        private static MouseWheelEvent clone(JScrollPane source, MouseWheelEvent e) {
            return new MouseWheelEvent((Component)source, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollPane", "com/android/tools/adtui/common/AdtUiUtils$DelegateMouseWheelListener", "<init>"));
        }
    }
}

