/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.eventrenderer;

import com.android.tools.adtui.eventrenderer.SimpleEventRenderer;
import com.android.tools.adtui.model.event.EventAction;
import com.intellij.ui.ColorUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;

public class ExpandingEventRenderer<E>
implements SimpleEventRenderer<E> {
    private static final int LINE_WIDTH = 12;
    private final Color myLineColor;

    public ExpandingEventRenderer(Color lineColor) {
        this.myLineColor = lineColor;
    }

    @Override
    public void draw(@NotNull Component parent, @NotNull Graphics2D g2d, @NotNull AffineTransform transform, double length, boolean isMouseOver, EventAction<E> eventAction) {
        if (parent == null) {
            ExpandingEventRenderer.$$$reportNull$$$0(0);
        }
        if (g2d == null) {
            ExpandingEventRenderer.$$$reportNull$$$0(1);
        }
        if (transform == null) {
            ExpandingEventRenderer.$$$reportNull$$$0(2);
        }
        Color currentColor = g2d.getColor();
        Stroke currentStroke = g2d.getStroke();
        double xPosition = transform.getTranslateX() - 6.0;
        double yPosition = transform.getTranslateY() + 6.0;
        BasicStroke str = new BasicStroke(12.0f);
        g2d.setStroke(str);
        RoundRectangle2D.Double markerRect = new RoundRectangle2D.Double(xPosition, yPosition, 3.0, 12.0, 1.0, 1.0);
        g2d.setColor(this.myLineColor);
        g2d.fill(markerRect);
        if (isMouseOver) {
            RoundRectangle2D.Double expandedRect = new RoundRectangle2D.Double(xPosition, yPosition, length, 12.0, 1.0, 1.0);
            Color temp = ColorUtil.withAlpha((Color)this.myLineColor, (double)0.8);
            g2d.setColor(temp);
            g2d.fill(expandedRect);
        }
        g2d.setColor(currentColor);
        g2d.setStroke(currentStroke);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "g2d";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "transform";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/eventrenderer/ExpandingEventRenderer";
        objectArray[2] = "draw";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

