/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterModel {
    private final ArrayList<BiConsumer<Pattern, FilterModel>> myConsumers = new ArrayList();
    private boolean myIsRegex;
    private boolean myIsMatchCase;
    private String myFilterString;

    public void setFilterString(@NotNull String filterString) {
        if (filterString == null) {
            FilterModel.$$$reportNull$$$0(0);
        }
        if (!filterString.equals(this.myFilterString)) {
            this.myFilterString = filterString;
            this.notifyFilterChange();
        }
    }

    public boolean getIsRegex() {
        return this.myIsRegex;
    }

    public void setIsRegex(boolean regex) {
        if (this.myIsRegex != regex) {
            this.myIsRegex = regex;
            this.notifyFilterChange();
        }
    }

    public boolean getIsMatchCase() {
        return this.myIsMatchCase;
    }

    public void setIsMatchCase(boolean matchCase) {
        if (this.myIsMatchCase != matchCase) {
            this.myIsMatchCase = matchCase;
            this.notifyFilterChange();
        }
    }

    public void addOnFilterChange(@NotNull BiConsumer<Pattern, FilterModel> callback) {
        if (callback == null) {
            FilterModel.$$$reportNull$$$0(1);
        }
        this.myConsumers.add(callback);
    }

    private void notifyFilterChange() {
        for (BiConsumer<Pattern, FilterModel> consumer : this.myConsumers) {
            consumer.accept(FilterModel.getFilterPattern(this.myFilterString, this.myIsMatchCase, this.myIsRegex), this);
        }
    }

    @Nullable
    public static Pattern getFilterPattern(@Nullable String filter, boolean isMatchCase, boolean isRegex) {
        Pattern pattern = null;
        if (filter != null && !filter.isEmpty()) {
            int flags;
            block5: {
                int n = flags = isMatchCase ? 0 : 2;
                if (isRegex) {
                    try {
                        pattern = Pattern.compile("^.*" + filter + ".*$", flags);
                    }
                    catch (PatternSyntaxException e) {
                        String error = e.getMessage();
                        if ($assertionsDisabled || error != null) break block5;
                        throw new AssertionError();
                    }
                }
            }
            if (pattern == null) {
                pattern = Pattern.compile("^.*" + Pattern.quote(filter) + ".*$", flags);
            }
        }
        return pattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/model/FilterModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setFilterString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addOnFilterChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

