/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.axis;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import org.jetbrains.annotations.NotNull;

public final class ClampedAxisComponentModel
extends AxisComponentModel
implements Updatable {
    private boolean myIsUpdating;

    private ClampedAxisComponentModel(@NotNull AxisComponentModel.BaseBuilder<ClampedAxisComponentModel> builder) {
        if (builder == null) {
            ClampedAxisComponentModel.$$$reportNull$$$0(0);
        }
        super(builder);
        this.myIsUpdating = false;
    }

    @Override
    public void update(long elapsedNs) {
        double max;
        if (this.myIsUpdating) {
            return;
        }
        this.myIsUpdating = true;
        boolean needsUpdate = false;
        double clampedMaxTarget = this.calculateClampedMaxTarget();
        double d = max = this.myFirstUpdate ? clampedMaxTarget : Updater.lerp(this.myRange.getMax(), clampedMaxTarget, 0.99f, elapsedNs, (double)((float)(clampedMaxTarget * (double)0.001f)));
        if (Double.compare(max, this.myRange.getMax()) != 0 || this.myFirstUpdate) {
            this.myRange.setMax(max);
            needsUpdate = true;
        }
        this.myFirstUpdate = false;
        if (needsUpdate) {
            this.changed(AxisComponentModel.Aspect.AXIS);
        }
        this.myIsUpdating = false;
    }

    @Override
    public void updateImmediately() {
        this.update(0L);
    }

    private double calculateClampedMaxTarget() {
        double maxTarget = this.myRange.getMax() - this.getZero();
        double rangeTarget = this.myRange.getLength();
        long majorInterval = this.myFormatter.getMajorInterval(rangeTarget);
        float majorNumTicksTarget = (float)Math.ceil(maxTarget / (double)majorInterval);
        return (double)(majorNumTicksTarget * (float)majorInterval) + this.getZero();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/adtui/model/axis/ClampedAxisComponentModel", "<init>"));
    }

    public static class Builder
    extends AxisComponentModel.BaseBuilder<ClampedAxisComponentModel> {
        public Builder(@NotNull Range range, @NotNull BaseAxisFormatter formatter) {
            if (range == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (formatter == null) {
                Builder.$$$reportNull$$$0(1);
            }
            super(range, formatter);
        }

        @Override
        @NotNull
        public ClampedAxisComponentModel build() {
            ClampedAxisComponentModel clampedAxisComponentModel = new ClampedAxisComponentModel(this);
            if (clampedAxisComponentModel == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return clampedAxisComponentModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/model/axis/ClampedAxisComponentModel$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/model/axis/ClampedAxisComponentModel$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

