/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.legend;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.updater.Updatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LegendComponentModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final List<Legend> myLegends;
    private final Map<Legend, String> myLegendStringMap;
    private final long mUpdateFrequencyNs;
    private long mElapsedNs;

    public LegendComponentModel(int updateFrequencyMs) {
        this.mUpdateFrequencyNs = TimeUnit.MILLISECONDS.toNanos(updateFrequencyMs);
        this.myLegends = new ArrayList<Legend>();
        this.myLegendStringMap = new HashMap<Legend, String>();
        this.mElapsedNs = this.mUpdateFrequencyNs;
    }

    @NotNull
    public List<Legend> getLegends() {
        List<Legend> list = this.myLegends;
        if (list == null) {
            LegendComponentModel.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public void update(long elapsedNs) {
        this.mElapsedNs += elapsedNs;
        if (this.mElapsedNs >= this.mUpdateFrequencyNs) {
            this.mElapsedNs = 0L;
            boolean changed = false;
            for (Legend legend : this.myLegends) {
                if (this.myLegends.contains(legend)) {
                    String newValue = legend.getValue();
                    String oldValue = this.myLegendStringMap.put(legend, newValue);
                    if (Objects.equals(oldValue, newValue)) continue;
                    changed = true;
                    continue;
                }
                changed = true;
                this.myLegendStringMap.put(legend, legend.getValue());
            }
            if (changed) {
                this.changed(Aspect.LEGEND);
            }
        }
    }

    public void add(@NotNull Legend legend) {
        if (legend == null) {
            LegendComponentModel.$$$reportNull$$$0(1);
        }
        this.myLegends.add(legend);
        this.changed(Aspect.LEGEND);
    }

    public void remove(@NotNull Legend legend) {
        if (legend == null) {
            LegendComponentModel.$$$reportNull$$$0(2);
        }
        this.myLegends.remove(legend);
        this.myLegendStringMap.remove(legend);
        this.changed(Aspect.LEGEND);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/legend/LegendComponentModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "legend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegends";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/legend/LegendComponentModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        LEGEND;

    }
}

