/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonBorderModel;
import com.android.tools.adtui.stdui.CommonBorder;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.StandardDimensions;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0010B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/adtui/stdui/CommonTextFieldUI;", "Ljavax/swing/plaf/basic/BasicTextFieldUI;", "editor", "Lcom/android/tools/adtui/stdui/CommonTextField;", "(Lcom/android/tools/adtui/stdui/CommonTextField;)V", "textColor", "Ljava/awt/Color;", "getTextColor", "()Ljava/awt/Color;", "installDefaults", "", "paintBackground", "g", "Ljava/awt/Graphics;", "paintSafely", "printPlaceHolderText", "EditorCommonBorderModel", "intellij.android.adt.ui"})
public class CommonTextFieldUI
extends BasicTextFieldUI {
    private final CommonTextField<?> editor;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.editor.getBorder() == null || this.editor.getBorder() instanceof UIResource) {
            this.editor.setBorder(new BorderUIResource(new CommonBorder(StandardDimensions.INSTANCE.getTEXT_FIELD_CORNER_RADIUS(), new EditorCommonBorderModel(this.editor), new Insets(StandardDimensions.INSTANCE.getVERTICAL_PADDING(), StandardDimensions.INSTANCE.getHORIZONTAL_PADDING(), 0, StandardDimensions.INSTANCE.getHORIZONTAL_PADDING()))));
        }
        if (this.editor.getForeground() == null || this.editor.getForeground() instanceof UIResource) {
            this.editor.setForeground(new ColorUIResource(StandardColors.TEXT_COLOR));
        }
        if (this.editor.getBackground() == null || this.editor.getBackground() instanceof UIResource) {
            this.editor.setBackground(new ColorUIResource(StandardColors.BACKGROUND_COLOR));
        }
        if (this.editor.getSelectedTextColor() == null || this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(new ColorUIResource(StandardColors.SELECTED_TEXT_COLOR));
        }
        if (this.editor.getSelectionColor() == null || this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(new ColorUIResource(StandardColors.SELECTED_BACKGROUND_COLOR));
        }
        if (this.editor.getDisabledTextColor() == null || this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(new ColorUIResource(StandardColors.DISABLED_TEXT_COLOR));
        }
        LookAndFeel.installProperty(this.editor, "opaque", false);
    }

    @Override
    protected void paintSafely(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        this.paintBackground(g);
        String string = this.editor.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"editor.text");
        CharSequence charSequence = string;
        if (charSequence.length() == 0 && (charSequence = (CharSequence)this.editor.getEditorModel().getPlaceHolderValue()).length() > 0) {
            this.printPlaceHolderText(g);
        }
        g.setColor(this.getTextColor());
        super.paintSafely(g);
    }

    @Override
    protected void paintBackground(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Insets insets = this.editor.getBorder().getBorderInsets(this.editor);
        g.setColor(this.editor.getBackground());
        g.fillRect(insets.left, insets.top, this.editor.getWidth() - insets.left - insets.right, this.editor.getHeight() - insets.top - insets.bottom);
    }

    private final Color getTextColor() {
        Color color;
        if (this.editor.isEnabled()) {
            Color color2 = StandardColors.TEXT_COLOR;
            color = color2;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"StandardColors.TEXT_COLOR");
        } else {
            Color color3 = StandardColors.DISABLED_TEXT_COLOR;
            color = color3;
            Intrinsics.checkExpressionValueIsNotNull((Object)color3, (String)"StandardColors.DISABLED_TEXT_COLOR");
        }
        return color;
    }

    private final void printPlaceHolderText(Graphics g) {
        Insets insets = this.editor.getInsets();
        int baseline = this.editor.getBaseline(this.editor.getWidth(), this.editor.getHeight());
        g.setColor(StandardColors.PLACEHOLDER_TEXT_COLOR);
        g.setFont(this.editor.getFont());
        g.drawString(this.editor.getEditorModel().getPlaceHolderValue(), insets.left, baseline);
    }

    public CommonTextFieldUI(@NotNull CommonTextField<?> editor2) {
        Intrinsics.checkParameterIsNotNull(editor2, (String)"editor");
        this.editor = editor2;
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                editor.repaint();
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                editor.repaint();
            }
        });
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/adtui/stdui/CommonTextFieldUI$EditorCommonBorderModel;", "Lcom/android/tools/adtui/model/stdui/CommonBorderModel;", "editor", "Lcom/android/tools/adtui/stdui/CommonTextField;", "(Lcom/android/tools/adtui/stdui/CommonTextField;)V", "hasError", "", "getHasError", "()Z", "hasPlaceHolder", "getHasPlaceHolder", "intellij.android.adt.ui"})
    private static final class EditorCommonBorderModel
    implements CommonBorderModel {
        private final CommonTextField<?> editor;

        @Override
        public boolean getHasError() {
            CharSequence charSequence = this.editor.getEditorModel().validate(this.editor.getEditorModel().getText());
            return charSequence.length() > 0;
        }

        @Override
        public boolean getHasPlaceHolder() {
            CharSequence charSequence = this.editor.getEditorModel().getText();
            return charSequence.length() == 0 && (charSequence = (CharSequence)this.editor.getEditorModel().getPlaceHolderValue()).length() > 0;
        }

        public EditorCommonBorderModel(@NotNull CommonTextField<?> editor2) {
            Intrinsics.checkParameterIsNotNull(editor2, (String)"editor");
            this.editor = editor2;
        }
    }
}

