/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"paintBackground", "", "graphics", "Ljava/awt/Graphics;", "component", "Ljavax/swing/JComponent;", "applyInset", "Ljava/awt/geom/Rectangle2D$Float;", "inset", "", "applyInsets", "insets", "Ljava/awt/Insets;", "setColorAndAlpha", "Ljava/awt/Graphics2D;", "color", "Ljava/awt/Color;", "intellij.android.adt.ui"})
public final class GraphicsUtilKt {
    public static final void setColorAndAlpha(@NotNull Graphics2D $receiver, @NotNull Color color) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        $receiver.setColor(color);
        if (color.getAlpha() == 255) {
            $receiver.setComposite(AlphaComposite.SrcOver);
        } else {
            $receiver.setComposite(AlphaComposite.getInstance(3, (float)color.getAlpha() / 255.0f));
        }
    }

    public static final void applyInset(@NotNull Rectangle2D.Float $receiver, float inset) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.x += inset;
        $receiver.y += inset;
        $receiver.width -= (float)2 * inset;
        $receiver.height -= (float)2 * inset;
    }

    public static final void applyInsets(@NotNull Rectangle2D.Float $receiver, @NotNull Insets insets) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)insets, (String)"insets");
        $receiver.x += (float)insets.left;
        $receiver.y += (float)insets.top;
        $receiver.width -= (float)(insets.left + insets.right);
        $receiver.height -= (float)(insets.top + insets.bottom);
    }

    public static final void paintBackground(@NotNull Graphics graphics, @NotNull JComponent component) {
        Intrinsics.checkParameterIsNotNull((Object)graphics, (String)"graphics");
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Graphics2D g = (Graphics2D)graphics;
        Dimension size = component.getSize();
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Component opaque = UIUtil.findNearestOpaque((Component)component);
        Color bg = opaque != null ? opaque.getBackground() : component.getBackground();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(1.0, 1.0, size.width - 3, size.height - 3, 4.0, 4.0);
        if (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDefaultMacTheme()) {
            g.setColor((Color)Gray.xE0);
            g.fill(rect);
            g.setColor((Color)Gray.xCA);
            g.draw(rect);
        } else {
            boolean dark = UIUtil.isUnderDarcula();
            g.setColor((Color)new JBColor((Color)Gray.xE8, new Color(4606541)));
            g.fill(rect);
            g.setColor((Color)new JBColor((Color)Gray.xCC, new Color(7699328)));
            g.draw(rect);
        }
        config.restore();
    }
}

