/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.stdui.CommonToggleButton;
import com.android.tools.adtui.stdui.menu.CommonDropDownButtonUI;
import com.android.tools.adtui.stdui.menu.CommonMenu;
import com.android.tools.adtui.stdui.menu.CommonMenuItem;
import com.android.tools.adtui.stdui.menu.CommonPopupMenu;
import com.intellij.ui.PopupMenuListenerAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class CommonDropDownButton
extends CommonToggleButton
implements PropertyChangeListener {
    @NotNull
    private final CommonPopupMenu myPopup;
    @NotNull
    private final CommonAction myAction;

    public CommonDropDownButton(@NotNull CommonAction action) {
        if (action == null) {
            CommonDropDownButton.$$$reportNull$$$0(0);
        }
        super(action.getText(), action.getIcon());
        this.myAction = action;
        this.myPopup = new CommonPopupMenu();
        this.myPopup.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(@NotNull PopupMenuEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                CommonDropDownButton.this.setSelected(false);
            }

            public void popupMenuCanceled(@NotNull PopupMenuEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                CommonDropDownButton.this.setSelected(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonDropDownButton$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "popupMenuWillBecomeInvisible";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "popupMenuCanceled";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                CommonDropDownButton menu;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((menu = CommonDropDownButton.this).isSelected()) {
                    CommonDropDownButton.this.myAction.actionPerformed(event);
                    CommonDropDownButton.this.populateAndShowPopup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/stdui/menu/CommonDropDownButton$2", "actionPerformed"));
            }
        });
        this.addPropertyChangeListenerRecursive(this.myAction);
    }

    @Override
    @NotNull
    public CommonAction getAction() {
        CommonAction commonAction = this.myAction;
        if (commonAction == null) {
            CommonDropDownButton.$$$reportNull$$$0(1);
        }
        return commonAction;
    }

    private void populateAndShowPopup() {
        this.myPopup.removeAll();
        List<CommonAction> actions = this.myAction.getChildrenActions();
        for (CommonAction action : actions) {
            JMenuItem menu;
            if (action instanceof CommonAction.SeparatorAction) {
                this.myPopup.addSeparator();
                continue;
            }
            if (action.getChildrenActionCount() == 0) {
                menu = new CommonMenuItem(action);
            } else {
                menu = new CommonMenu(action);
                this.populateMenuRecursive((CommonMenu)menu, action.getChildrenActions());
            }
            menu.setFont(this.getFont());
            this.myPopup.add(menu);
        }
        this.myPopup.show(this, 0, this.getHeight());
    }

    private void populateMenuRecursive(CommonMenu parent, List<CommonAction> actions) {
        for (CommonAction action : actions) {
            JMenuItem menu;
            if (action instanceof CommonAction.SeparatorAction) {
                parent.addSeparator();
                continue;
            }
            if (action.getChildrenActionCount() == 0) {
                menu = new CommonMenuItem(action);
            } else {
                menu = new CommonMenu(action);
                this.populateMenuRecursive((CommonMenu)menu, action.getChildrenActions());
            }
            menu.setFont(this.getFont());
            parent.add(menu);
            action.addPropertyChangeListener(this);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new CommonDropDownButtonUI());
        this.revalidate();
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            CommonDropDownButton.$$$reportNull$$$0(2);
        }
        switch (event.getPropertyName()) {
            case "childrenActions": {
                if (this.myPopup.isShowing()) {
                    this.myPopup.setVisible(false);
                }
                List oldValues = (List)event.getOldValue();
                oldValues.forEach(action -> this.removePropertyChangeListenerRecursive((CommonAction)action));
                List newValues = (List)event.getNewValue();
                newValues.forEach(action -> this.addPropertyChangeListenerRecursive((CommonAction)action));
                break;
            }
            case "Name": 
            case "SmallIcon": 
            case "showExpandArrow": 
            case "isSelected": {
                break;
            }
        }
    }

    private void addPropertyChangeListenerRecursive(@NotNull CommonAction action) {
        if (action == null) {
            CommonDropDownButton.$$$reportNull$$$0(3);
        }
        action.addPropertyChangeListener(this);
        action.getChildrenActions().forEach(child -> this.addPropertyChangeListenerRecursive((CommonAction)child));
    }

    private void removePropertyChangeListenerRecursive(@NotNull CommonAction action) {
        if (action == null) {
            CommonDropDownButton.$$$reportNull$$$0(4);
        }
        action.removePropertyChangeListener(this);
        action.getChildrenActions().forEach(child -> this.removePropertyChangeListenerRecursive((CommonAction)child));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/stdui/menu/CommonDropDownButton";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonDropDownButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "propertyChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListenerRecursive";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListenerRecursive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

