/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.DetachedToolWindow;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetachedToolWindowManager
implements ProjectComponent {
    private final Application myApplication;
    private final Project myProject;
    private final FileEditorManager myEditorManager;
    private final MyFileEditorManagerListener myEditorManagerListener;
    private final Map<FileEditor, WorkBench> myWorkBenchMap;
    private final HashMap<String, DetachedToolWindow> myToolWindowMap;
    private DetachedToolWindowFactory myDetachedToolWindowFactory;
    private FileEditor myLastSelectedEditor;

    public static DetachedToolWindowManager getInstance(@NotNull Project project) {
        if (project == null) {
            DetachedToolWindowManager.$$$reportNull$$$0(0);
        }
        return (DetachedToolWindowManager)project.getComponent(DetachedToolWindowManager.class);
    }

    DetachedToolWindowManager(@NotNull Application application, @NotNull Project currentProject, @NotNull FileEditorManager fileEditorManager) {
        if (application == null) {
            DetachedToolWindowManager.$$$reportNull$$$0(1);
        }
        if (currentProject == null) {
            DetachedToolWindowManager.$$$reportNull$$$0(2);
        }
        if (fileEditorManager == null) {
            DetachedToolWindowManager.$$$reportNull$$$0(3);
        }
        this.myApplication = application;
        this.myProject = currentProject;
        this.myEditorManager = fileEditorManager;
        this.myEditorManagerListener = new MyFileEditorManagerListener();
        this.myWorkBenchMap = new IdentityHashMap<FileEditor, WorkBench>(13);
        this.myToolWindowMap = new HashMap(8);
        this.myDetachedToolWindowFactory = DetachedToolWindow::new;
    }

    void setDetachedToolWindowFactory(@NotNull DetachedToolWindowFactory factory) {
        if (factory == null) {
            DetachedToolWindowManager.$$$reportNull$$$0(4);
        }
        this.myDetachedToolWindowFactory = factory;
    }

    FileEditorManagerListener getFileEditorManagerListener() {
        return this.myEditorManagerListener;
    }

    public void register(@Nullable FileEditor fileEditor, @NotNull WorkBench workBench) {
        if (workBench == null) {
            DetachedToolWindowManager.$$$reportNull$$$0(5);
        }
        if (fileEditor != null) {
            this.myWorkBenchMap.put(fileEditor, workBench);
            if (fileEditor == this.myLastSelectedEditor) {
                this.updateToolWindowsForWorkBench(workBench);
            }
        }
    }

    public void unregister(@Nullable FileEditor fileEditor) {
        if (fileEditor != null) {
            this.myWorkBenchMap.remove(fileEditor);
        }
    }

    @NotNull
    public String getComponentName() {
        String string = DetachedToolWindowManager.class.getSimpleName();
        if (string == null) {
            DetachedToolWindowManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myEditorManagerListener);
    }

    public void projectClosed() {
        for (DetachedToolWindow detachedToolWindow : this.myToolWindowMap.values()) {
            detachedToolWindow.updateSettingsInAttachedToolWindow();
        }
    }

    @Nullable
    private WorkBench getActiveWorkBench() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof WorkBench) {
            return (WorkBench)((Object)focusOwner);
        }
        WorkBench current = (WorkBench)((Object)SwingUtilities.getAncestorOfClass(WorkBench.class, focusOwner));
        if (current != null) {
            return current;
        }
        FileEditor[] selectedEditors = this.myEditorManager.getSelectedEditors();
        if (selectedEditors.length == 0) {
            return null;
        }
        if (selectedEditors.length == 1) {
            return this.myWorkBenchMap.get(selectedEditors[0]);
        }
        if (focusOwner != null) {
            for (FileEditor editor2 : selectedEditors) {
                if (!SwingUtilities.isDescendingFrom(focusOwner, editor2.getComponent())) continue;
                return this.myWorkBenchMap.get(editor2);
            }
        }
        return this.myWorkBenchMap.get(selectedEditors[0]);
    }

    public void updateToolWindowsForWorkBench(@Nullable WorkBench workBench) {
        if (this.myProject.isDisposed()) {
            return;
        }
        HashSet<String> ids = new HashSet<String>(this.myToolWindowMap.keySet());
        if (workBench != null) {
            List detachedToolWindows = workBench.getDetachedToolWindows();
            for (AttachedToolWindow tool : detachedToolWindows) {
                ToolWindowDefinition definition = tool.getDefinition();
                String id2 = definition.getName();
                DetachedToolWindow detachedToolWindow = this.myToolWindowMap.get(id2);
                if (detachedToolWindow == null) {
                    detachedToolWindow = this.myDetachedToolWindowFactory.create(this.myProject, definition);
                    Disposer.register((Disposable)this.myProject, (Disposable)detachedToolWindow);
                    this.myToolWindowMap.put(id2, detachedToolWindow);
                }
                if (!ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled()) {
                    detachedToolWindow.show(tool);
                }
                ids.remove(id2);
            }
        }
        ids.forEach(id -> this.myToolWindowMap.get(id).hide());
    }

    public void restoreDefaultLayout() {
        this.myApplication.invokeLater(() -> this.updateToolWindowsForWorkBench(this.getActiveWorkBench()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workBench";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/workbench/DetachedToolWindowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/workbench/DetachedToolWindowManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDetachedToolWindowFactory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface DetachedToolWindowFactory {
        public DetachedToolWindow create(@NotNull Project var1, @NotNull ToolWindowDefinition var2);
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            DetachedToolWindowManager.this.myApplication.invokeLater(() -> DetachedToolWindowManager.this.updateToolWindowsForWorkBench(DetachedToolWindowManager.this.getActiveWorkBench()));
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            if (file == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(3);
            }
            DetachedToolWindowManager.this.myApplication.invokeLater(() -> DetachedToolWindowManager.this.updateToolWindowsForWorkBench(DetachedToolWindowManager.this.getActiveWorkBench()));
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(4);
            }
            DetachedToolWindowManager.this.myLastSelectedEditor = event.getNewEditor();
            DetachedToolWindowManager.this.updateToolWindowsForWorkBench((WorkBench)((Object)DetachedToolWindowManager.this.myWorkBenchMap.get(DetachedToolWindowManager.this.myLastSelectedEditor)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/DetachedToolWindowManager$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileClosed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

