/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Query;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.InlineCallableUsagesSearcher;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/InlineCallableUsagesSearcher;", "", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "(Lcom/intellij/debugger/engine/DebugProcess;)V", "checkIfInline", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findInlinedCalls", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "transformer", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "getScopeForInlineDeclarationUsages", "Lcom/intellij/psi/search/GlobalSearchScope;", "inlineDeclaration", "idea-jvm"})
public final class InlineCallableUsagesSearcher {
    private final DebugProcess myDebugProcess;

    @NotNull
    public final KotlinDebuggerCaches.ComputedClassNames findInlinedCalls(@NotNull KtDeclaration declaration2, @NotNull BindingContext bindingContext2, @NotNull Function1<? super PsiElement, KotlinDebuggerCaches.ComputedClassNames> transformer) {
        boolean bl;
        boolean bl2;
        List list;
        block9: {
            KotlinDebuggerCaches.ComputedClassNames it;
            Iterable $receiver$iv$iv;
            ApplicationEx applicationEx;
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkParameterIsNotNull(transformer, (String)"transformer");
            if (!this.checkIfInline(declaration2, bindingContext2)) {
                return KotlinDebuggerCaches.ComputedClassNames.Companion.getEMPTY();
            }
            HashSet searchResult = new HashSet();
            String declarationName2 = (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(declaration2){
                final /* synthetic */ KtDeclaration $declaration;

                @Nullable
                public final String invoke() {
                    return this.$declaration.getName();
                }
                {
                    this.$declaration = ktDeclaration;
                    super(0);
                }
            }));
            Runnable task2 = new Runnable(this, declaration2, searchResult){
                final /* synthetic */ InlineCallableUsagesSearcher this$0;
                final /* synthetic */ KtDeclaration $declaration;
                final /* synthetic */ HashSet $searchResult;

                public final void run() {
                    Query query = ReferencesSearch.search((PsiElement)((PsiElement)this.$declaration), (SearchScope)((SearchScope)InlineCallableUsagesSearcher.access$getScopeForInlineDeclarationUsages(this.this$0, this.$declaration)));
                    Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"ReferencesSearch.search(\u2026ationUsages(declaration))");
                    Iterable $receiver$iv = (Iterable)query;
                    for (T element$iv : $receiver$iv) {
                        PsiElement usage;
                        PsiElement psiElement;
                        PsiReference it = (PsiReference)element$iv;
                        if (((Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(it){
                            final /* synthetic */ PsiReference $it;

                            public final boolean invoke() {
                                PsiReference psiReference = this.$it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
                                return UtilsKt.isImportUsage((PsiReference)psiReference);
                            }
                            {
                                this.$it = psiReference;
                                super(0);
                            }
                        }))).booleanValue()) continue;
                        PsiReference psiReference = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
                        PsiElement psiElement2 = psiReference.getElement();
                        if (!(psiElement2 instanceof KtElement)) {
                            psiElement2 = null;
                        }
                        if ((KtElement)psiElement2 != null) {
                            KtElement ktElement;
                            PsiElement p1 = (PsiElement)ktElement;
                            psiElement = DebuggerClassNameProvider.Companion.getRelevantElement$idea_jvm(p1);
                        } else {
                            psiElement = null;
                        }
                        if ((usage = psiElement) == null || ((Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(usage, this){
                            final /* synthetic */ PsiElement $usage;
                            final /* synthetic */ findInlinedCalls.task.1 this$0;
                            {
                                this.$usage = psiElement;
                                this.this$0 = var2_2;
                                super(0);
                            }

                            public final boolean invoke() {
                                return PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)this.this$0.$declaration), (PsiElement)this.$usage, (boolean)false, (int)2, null);
                            }
                        }))).booleanValue()) continue;
                        this.$searchResult.add(usage);
                    }
                }
                {
                    this.this$0 = inlineCallableUsagesSearcher;
                    this.$declaration = ktDeclaration;
                    this.$searchResult = hashSet;
                }
            };
            boolean isSuccess = true;
            ApplicationEx applicationEx2 = applicationEx = ApplicationManagerEx.getApplicationEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationEx2, (String)"applicationEx");
            if (applicationEx2.isDispatchThread()) {
                isSuccess = ProgressManager.getInstance().runProcessWithProgressSynchronously(task2, "Compute class names for declaration " + declarationName2, true, this.myDebugProcess.getProject());
            } else {
                ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)new EmptyProgressIndicator());
            }
            if (!isSuccess) {
                XDebugSessionImpl.NOTIFICATION_GROUP.createNotification("Debugger can skip some executions of " + declarationName2 + " because the computation of class names was interrupted", MessageType.WARNING).notify(this.myDebugProcess.getProject());
            }
            Iterable $receiver$iv = searchResult;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                PsiElement psiElement = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                KotlinDebuggerCaches.ComputedClassNames computedClassNames = (KotlinDebuggerCaches.ComputedClassNames)transformer.invoke((Object)it);
                collection.add(computedClassNames);
            }
            List results = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv = (Iterable)results;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (KotlinDebuggerCaches.ComputedClassNames)element$iv$iv;
                Iterable list$iv$iv = it.getClassNames();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
            $receiver$iv = results;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KotlinDebuggerCaches.ComputedClassNames it2 = (KotlinDebuggerCaches.ComputedClassNames)element$iv;
                    if (it2.getShouldBeCached()) continue;
                    bl2 = false;
                    break block9;
                }
                bl2 = true;
            }
        }
        boolean bl3 = bl = bl2;
        List list2 = list;
        return new KotlinDebuggerCaches.ComputedClassNames(list2, bl3);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinDebuggerCaches.ComputedClassNames findInlinedCalls$default(InlineCallableUsagesSearcher inlineCallableUsagesSearcher, KtDeclaration ktDeclaration, BindingContext bindingContext2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            BindingContext bindingContext3 = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper((PsiElement)ktDeclaration).getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"KotlinDebuggerCaches.get\u2026claration).bindingContext");
            bindingContext2 = bindingContext3;
        }
        return inlineCallableUsagesSearcher.findInlinedCalls(ktDeclaration, bindingContext2, (Function1<? super PsiElement, KotlinDebuggerCaches.ComputedClassNames>)function1);
    }

    private final boolean checkIfInline(KtDeclaration declaration2, BindingContext bindingContext2) {
        DeclarationDescriptor descriptor2;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)declaration2);
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor2 = declarationDescriptor;
        return declarationDescriptor2 instanceof FunctionDescriptor ? InlineUtil.isInline((DeclarationDescriptor)descriptor2) : (declarationDescriptor2 instanceof PropertyDescriptor ? InlineUtil.hasInlineAccessors((PropertyDescriptor)((PropertyDescriptor)descriptor2)) : false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final GlobalSearchScope getScopeForInlineDeclarationUsages(KtDeclaration inlineDeclaration) {
        GlobalSearchScope globalSearchScope;
        VirtualFile virtualFile2 = (VirtualFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<VirtualFile>(inlineDeclaration){
            final /* synthetic */ KtDeclaration $inlineDeclaration;

            public final VirtualFile invoke() {
                PsiFile psiFile = this.$inlineDeclaration.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"inlineDeclaration.containingFile");
                return psiFile.getVirtualFile();
            }
            {
                this.$inlineDeclaration = ktDeclaration;
                super(0);
            }
        }));
        if (virtualFile2 != null) {
            Project project = this.myDebugProcess.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myDebugProcess.project");
            if (ProjectRootsUtil.isLibraryFile((Project)project, (VirtualFile)virtualFile2)) {
                GlobalSearchScope globalSearchScope2 = this.myDebugProcess.getSearchScope();
                GlobalSearchScope globalSearchScope3 = GlobalSearchScope.allScope((Project)this.myDebugProcess.getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope3, (String)"GlobalSearchScope.allScope(myDebugProcess.project)");
                Project project2 = this.myDebugProcess.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"myDebugProcess.project");
                GlobalSearchScope globalSearchScope4 = globalSearchScope2.uniteWith(KotlinSourceFilterScope.Companion.librarySources(globalSearchScope3, project2));
                globalSearchScope = globalSearchScope4;
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope4, (String)"myDebugProcess.searchSco\u2026 myDebugProcess.project))");
                return globalSearchScope;
            }
        }
        GlobalSearchScope globalSearchScope5 = this.myDebugProcess.getSearchScope();
        globalSearchScope = globalSearchScope5;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope5, (String)"myDebugProcess.searchScope");
        return globalSearchScope;
    }

    public InlineCallableUsagesSearcher(@NotNull DebugProcess myDebugProcess) {
        Intrinsics.checkParameterIsNotNull((Object)myDebugProcess, (String)"myDebugProcess");
        this.myDebugProcess = myDebugProcess;
    }

    @NotNull
    public static final /* synthetic */ GlobalSearchScope access$getScopeForInlineDeclarationUsages(InlineCallableUsagesSearcher $this, @NotNull KtDeclaration inlineDeclaration) {
        return $this.getScopeForInlineDeclarationUsages(inlineDeclaration);
    }
}

