/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.VariablesCollector;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"findAdditionalExpressions", "", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "position", "Lcom/intellij/debugger/SourcePosition;", "getContainingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "Lcom/intellij/psi/PsiElement;", "getLineRangeForElement", "Lcom/intellij/openapi/util/TextRange;", "containingElement", "doc", "Lcom/intellij/openapi/editor/Document;", "shouldSkipLine", "", "file", "Lcom/intellij/psi/PsiFile;", "line", "", "idea-jvm"})
public final class KotlinFrameExtraVariablesProviderKt {
    private static final Set<TextWithImports> findAdditionalExpressions(SourcePosition position2) {
        PsiElement elem;
        Integer n;
        int it;
        Document doc;
        PsiFile file2;
        int line = position2.getLine();
        PsiFile psiFile = file2 = position2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
        VirtualFile vFile = psiFile.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return SetsKt.emptySet();
        }
        Integer n2 = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)file2, (int)line);
        if (n2 == null || (n2 = (it = ((Number)(n = n2)).intValue()) > 0 ? n : null) == null) {
            return SetsKt.emptySet();
        }
        int offset = n2;
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return SetsKt.emptySet();
        }
        PsiElement psiElement2 = elem = psiElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elem");
        KtElement ktElement = KotlinFrameExtraVariablesProviderKt.getContainingElement(psiElement2);
        PsiElement containingElement = ktElement != null ? (PsiElement)ktElement : elem;
        TextRange limit = KotlinFrameExtraVariablesProviderKt.getLineRangeForElement(containingElement, doc);
        int startLine = Math.max(limit.getStartOffset(), line);
        while (startLine - 1 > limit.getStartOffset() && KotlinFrameExtraVariablesProviderKt.shouldSkipLine(file2, doc, startLine - 1)) {
            --startLine;
        }
        int endLine = Math.min(limit.getEndOffset(), line);
        while (endLine + 1 < limit.getEndOffset() && KotlinFrameExtraVariablesProviderKt.shouldSkipLine(file2, doc, endLine + 1)) {
            ++endLine;
        }
        Integer n3 = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)file2, (int)startLine);
        if (n3 == null) {
            return SetsKt.emptySet();
        }
        int startOffset = n3;
        Integer n4 = KotlinRefactoringUtilKt.getLineEndOffset((PsiFile)file2, (int)endLine);
        if (n4 == null) {
            return SetsKt.emptySet();
        }
        int endOffset = n4;
        if (startOffset >= endOffset) {
            return SetsKt.emptySet();
        }
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (lineRange.isEmpty()) {
            return SetsKt.emptySet();
        }
        LinkedHashSet expressions = new LinkedHashSet();
        VariablesCollector variablesCollector = new VariablesCollector(lineRange, expressions);
        containingElement.accept((PsiElementVisitor)variablesCollector);
        return expressions;
    }

    private static final KtElement getContainingElement(PsiElement element) {
        KtElement contElement;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, KtDeclaration.class);
        KtElement ktElement = contElement = ktDeclaration != null ? (KtElement)ktDeclaration : (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element, KtElement.class);
        if (contElement instanceof KtProperty && ((KtProperty)contElement).isLocal()) {
            PsiElement parent;
            PsiElement psiElement = parent = ((KtProperty)contElement).getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
            return KotlinFrameExtraVariablesProviderKt.getContainingElement(psiElement);
        }
        if (contElement instanceof KtDeclarationWithBody) {
            return (KtElement)((KtDeclarationWithBody)contElement).getBodyExpression();
        }
        return contElement;
    }

    private static final TextRange getLineRangeForElement(PsiElement containingElement, Document doc) {
        TextRange elemRange;
        TextRange textRange = elemRange = containingElement.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"elemRange");
        return new TextRange(doc.getLineNumber(textRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
    }

    private static final boolean shouldSkipLine(PsiFile file2, Document doc, int line) {
        PsiElement topmostElementAtOffset;
        PsiElement elemAtOffset;
        int end;
        int start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \n\t");
        if (start >= (end = doc.getLineEndOffset(line))) {
            return true;
        }
        PsiElement psiElement = elemAtOffset = file2.findElementAt(start);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return !((topmostElementAtOffset = CodeInsightUtils.getTopmostElementAtOffset((PsiElement)psiElement, (int)start)) instanceof KtDeclaration);
    }

    @NotNull
    public static final /* synthetic */ Set access$findAdditionalExpressions(@NotNull SourcePosition position2) {
        return KotlinFrameExtraVariablesProviderKt.findAdditionalExpressions(position2);
    }
}

