/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.LocalVariableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016J\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/MockStackFrame;", "Lcom/sun/jdi/StackFrame;", "location", "Lcom/sun/jdi/Location;", "vm", "Lcom/sun/jdi/VirtualMachine;", "(Lcom/sun/jdi/Location;Lcom/sun/jdi/VirtualMachine;)V", "visibleVariables", "", "", "Lcom/sun/jdi/LocalVariable;", "createVisibleVariables", "", "getArgumentValues", "", "Lcom/sun/jdi/Value;", "getValue", "", "variable", "getValues", "variables", "setValue", "value", "thisObject", "thread", "virtualMachine", "visibleVariableByName", "name", "idea-jvm"})
final class MockStackFrame
implements StackFrame {
    private Map<String, ? extends LocalVariable> visibleVariables;
    private final Location location;
    private final VirtualMachine vm;

    @Override
    @NotNull
    public Location location() {
        return this.location;
    }

    @Nullable
    public Void thread() {
        return null;
    }

    @Nullable
    public Void thisObject() {
        return null;
    }

    private final void createVisibleVariables() {
        if (this.visibleVariables == null) {
            Method method = this.location.method();
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"location.method()");
            List<LocalVariable> allVariables = DebuggerUtilKt.safeVariables(method);
            HashMap<String, LocalVariableImpl> map = new HashMap<String, LocalVariableImpl>(allVariables.size());
            Iterator<LocalVariable> iterator = allVariables.iterator();
            while (iterator.hasNext()) {
                LocalVariable allVariable;
                LocalVariable localVariable = allVariable = iterator.next();
                if (localVariable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.sun.tools.jdi.LocalVariableImpl");
                }
                LocalVariableImpl variable = (LocalVariableImpl)localVariable;
                String name = variable.name();
                if (!variable.isVisible(this)) continue;
                map.put(name, variable);
            }
            this.visibleVariables = map;
        }
    }

    @Override
    @NotNull
    public List<LocalVariable> visibleVariables() {
        this.createVisibleVariables();
        Map<String, ? extends LocalVariable> map = this.visibleVariables;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<? extends LocalVariable> mapAsList = new ArrayList<LocalVariable>(map.values());
        Collections.sort((List)mapAsList);
        return mapAsList;
    }

    @Override
    @Nullable
    public LocalVariable visibleVariableByName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.createVisibleVariables();
        Map<String, ? extends LocalVariable> map = this.visibleVariables;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        return map.get(name);
    }

    @Nullable
    public Void getValue(@NotNull LocalVariable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return null;
    }

    @Override
    @NotNull
    public Map<LocalVariable, Value> getValues(@NotNull List<? extends LocalVariable> variables) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        return MapsKt.emptyMap();
    }

    @Override
    public void setValue(@NotNull LocalVariable variable, @NotNull Value value) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
    }

    @Override
    @NotNull
    public List<Value> getArgumentValues() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public VirtualMachine virtualMachine() {
        return this.vm;
    }

    public MockStackFrame(@NotNull Location location2, @NotNull VirtualMachine vm) {
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        this.location = location2;
        this.vm = vm;
    }
}

