/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinEditorTextProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilder;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluator;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.j2k.AfterConversionPass;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\"\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010\u000e2\b\u0010%\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010&\u001a\u00020'2\b\u0010 \u001a\u0004\u0018\u00010\bH\u0016J&\u0010(\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\b\u0010)\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory;", "Lcom/intellij/debugger/engine/evaluation/CodeFragmentFactory;", "()V", "createCodeFragment", "Lcom/intellij/psi/JavaCodeFragment;", "item", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "context", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "createFakeFileWithJavaContextElement", "Lorg/jetbrains/kotlin/psi/KtFile;", "funWithLocalVariables", "", "javaContext", "createPresentationCodeFragment", "createWrappingContext", "Lorg/jetbrains/kotlin/psi/KtElement;", "newFragmentText", "labels", "", "Lcom/sun/jdi/Value;", "originalContext", "fixImportIfNeeded", "import", "getEvaluatorBuilder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluationBuilder;", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "getFrameInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$FrameInfo;", "contextElement", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getWrappedContextElement", "initImports", "imports", "isContextAccepted", "", "wrapContextIfNeeded", "newContext", "Companion", "FrameInfo", "idea-jvm"})
public final class KotlinCodeFragmentFactory
extends CodeFragmentFactory {
    private static final Logger LOG;
    @NotNull
    private static final Key<Value> LABEL_VARIABLE_VALUE_KEY;
    private static final String DEBUG_LABEL_SUFFIX = "_DebugLabel";
    @NotNull
    private static final Key<DebuggerContextImpl> DEBUG_CONTEXT_FOR_TESTS;
    public static final Companion Companion;

    @NotNull
    public JavaCodeFragment createCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        KtCodeFragment ktCodeFragment;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement contextElement = this.getWrappedContextElement(project, context);
        if (contextElement == null) {
            PsiElement psiElement = context;
            LOG.warn("CodeFragment with null context created:\noriginalContext = " + (psiElement != null ? PsiUtilsKt.getElementTextWithContext((PsiElement)psiElement) : null));
        }
        if (item.getKind() == CodeFragmentKind.EXPRESSION) {
            String string = item.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"item.text");
            ktCodeFragment = (KtCodeFragment)new KtExpressionCodeFragment(project, "fragment.kt", (CharSequence)string, this.initImports(item.getImports()), contextElement);
        } else {
            String string = item.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"item.text");
            ktCodeFragment = (KtCodeFragment)new KtBlockCodeFragment(project, "fragment.kt", (CharSequence)string, this.initImports(item.getImports()), contextElement);
        }
        KtCodeFragment codeFragment = ktCodeFragment;
        codeFragment.putCopyableUserData(KtCodeFragment.Companion.getRUNTIME_TYPE_EVALUATOR(), (Object)new Function1<KtExpression, KotlinType>(project){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final KotlinType invoke(@NotNull KtExpression expression) {
                KotlinType kotlinType;
                DebuggerContextImpl debuggerContext;
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
                DebuggerContextImpl debuggerContextImpl = debuggerContext = debuggerManagerEx.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"debuggerContext");
                DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
                if (debuggerSession == null || debuggerContext.getSuspendContext() == null) {
                    kotlinType = null;
                } else {
                    Semaphore semaphore = new Semaphore();
                    semaphore.down();
                    AtomicReference<V> nameRef = new AtomicReference<V>();
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                    ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                    if (progressIndicator == null) {
                        Intrinsics.throwNpe();
                    }
                    KotlinRuntimeTypeEvaluator worker2 = new KotlinRuntimeTypeEvaluator(nameRef, semaphore, expression, debuggerContext, null, expression, debuggerContext, progressIndicator){
                        final /* synthetic */ AtomicReference $nameRef;
                        final /* synthetic */ Semaphore $semaphore;
                        final /* synthetic */ KtExpression $expression;
                        final /* synthetic */ DebuggerContextImpl $debuggerContext;

                        protected void typeCalculationFinished(@Nullable KotlinType type) {
                            this.$nameRef.set(type);
                            this.$semaphore.up();
                        }
                        {
                            this.$nameRef = $captured_local_variable$0;
                            this.$semaphore = $captured_local_variable$1;
                            this.$expression = $captured_local_variable$2;
                            this.$debuggerContext = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
                        }
                    };
                    DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
                    if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
                        debugProcessImpl.invoke((DebuggerCommandImpl)worker2);
                    }
                    int n = 0;
                    int n2 = 50;
                    while (n <= n2) {
                        void i;
                        ProgressManager.checkCanceled();
                        if (semaphore.waitFor(20L)) break;
                        ++i;
                    }
                    kotlinType = (KotlinType)nameRef.get();
                }
                return kotlinType;
            }
            {
                this.$project = project;
                super(1);
            }
        });
        if (contextElement != null && !(contextElement instanceof KtElement)) {
            codeFragment.putCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE(), (Object)new Function0<KtElement>(this, contextElement, project){
                final /* synthetic */ KotlinCodeFragmentFactory this$0;
                final /* synthetic */ PsiElement $contextElement;
                final /* synthetic */ Project $project;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                @NotNull
                public final KtElement invoke() {
                    block13: {
                        block12: {
                            emptyFile = KotlinCodeFragmentFactory.access$createFakeFileWithJavaContextElement(this.this$0, "", this.$contextElement);
                            v0 = DebuggerManagerEx.getInstanceEx((Project)this.$project);
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"DebuggerManagerEx.getInstanceEx(project)");
                            v1 = debuggerContext = v0.getContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"debuggerContext");
                            debuggerSession = v1.getDebuggerSession();
                            if (debuggerSession == null || debuggerContext.getSuspendContext() == null) {
                                v2 = ApplicationManager.getApplication();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"ApplicationManager.getApplication()");
                                if (!v2.isUnitTestMode()) {
                                    KotlinCodeFragmentFactory.access$getLOG$cp().warn("Couldn't create fake context element for java file, debugger isn't paused on breakpoint");
                                    return (KtElement)emptyFile;
                                }
                            }
                            if ((frameDescriptor = KotlinCodeFragmentFactory.access$getFrameInfo(this.this$0, this.$contextElement, debuggerContext)) == null) {
                                v3 = KotlinCodeFragmentFactory.access$getLOG$cp();
                                v4 = new StringBuilder().append("Couldn't get info about 'this' and local variables for ");
                                v5 = debuggerContext.getSourcePosition();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"debuggerContext.sourcePosition");
                                v6 = v5.getFile();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"debuggerContext.sourcePosition.file");
                                v7 = v4.append(v6.getName()).append(':');
                                v8 = debuggerContext.getSourcePosition();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"debuggerContext.sourcePosition");
                                v3.warn(v7.append(v8.getLine()).toString());
                                return (KtElement)emptyFile;
                            }
                            v9 = frameDescriptor.getThisObject();
                            if (v9 == null) ** GOTO lbl-1000
                            it = var6_5 = v9;
                            v10 = it.type().name();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it.type().name()");
                            v9 = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory$Companion.access$createKotlinProperty(KotlinCodeFragmentFactory.Companion, this.$project, "this_0", v10, it);
                            if (v9 != null) {
                                v11 = v9.getTypeReference();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v11 = null;
                            }
                            if ((v12 = (receiverTypeReference = v11)) == null) break block12;
                            it = v12;
                            it = it;
                            v13 = new StringBuilder();
                            v14 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"it");
                            v12 = v13.append(v14.getText()).append('.').toString();
                            if (v12 != null) break block13;
                        }
                        v12 = "";
                    }
                    receiverTypeText = v12;
                    it = frameDescriptor.getVisibleVariables().entrySet();
                    var20_9 = KotlinCodeFragmentFactory.Companion;
                    capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
                    var10_12 = $receiver$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    for (T element$iv$iv : $receiver$iv$iv) {
                        var14_16 = destination$iv$iv;
                        it = (Map.Entry)element$iv$iv;
                        var17_18 = TuplesKt.to((Object)((LocalVariable)it.getKey()).name(), it.getValue());
                        var14_16.put(var17_18.getFirst(), var17_18.getSecond());
                    }
                    var21_19 = destination$iv$iv;
                    kotlinVariablesText = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory$Companion.access$kotlinVariablesAsText(var20_9, var21_19, this.$project);
                    fakeFunctionText = "fun " + receiverTypeText + "_java_locals_debug_fun_() {\n" + kotlinVariablesText + "\n}";
                    fakeFile = KotlinCodeFragmentFactory.access$createFakeFileWithJavaContextElement(this.this$0, fakeFunctionText, this.$contextElement);
                    v15 = CollectionsKt.firstOrNull((List)fakeFile.getDeclarations());
                    if (!(v15 instanceof KtFunction)) {
                        v15 = null;
                    }
                    v16 = fakeFunction = (KtFunction)v15;
                    v17 /* !! */  = v16 != null ? v16.getBodyExpression() : null;
                    if (!(v17 /* !! */  instanceof KtBlockExpression)) {
                        v17 /* !! */  = null;
                    }
                    v18 = fakeContext = (v19 /* !! */  = (KtBlockExpression)v17 /* !! */ ) != null && (v19 /* !! */  = v19 /* !! */ .getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)v19 /* !! */ ) : null;
                    v20 = KotlinCodeFragmentFactory.access$wrapContextIfNeeded(this.this$0, this.$project, this.$contextElement, (KtElement)fakeContext);
                    if (v20 == null) {
                        v20 = (KtElement)emptyFile;
                    }
                    return v20;
                }
                {
                    this.this$0 = kotlinCodeFragmentFactory;
                    this.$contextElement = psiElement;
                    this.$project = project;
                    super(0);
                }
            });
        }
        return (JavaCodeFragment)codeFragment;
    }

    /*
     * WARNING - void declaration
     */
    private final FrameInfo getFrameInfo(PsiElement contextElement, DebuggerContextImpl debuggerContext) {
        void frameInfo;
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        DebuggerCommandImpl worker2 = new DebuggerCommandImpl(contextElement, debuggerContext, (Ref.ObjectRef)frameInfo, semaphore){
            final /* synthetic */ PsiElement $contextElement;
            final /* synthetic */ DebuggerContextImpl $debuggerContext;
            final /* synthetic */ Ref.ObjectRef $frameInfo;
            final /* synthetic */ Semaphore $semaphore;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void action() {
                try {
                    Map map;
                    StackFrame frame;
                    StackFrame stackFrame;
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isUnitTestMode()) {
                        PsiElement psiElement = this.$contextElement;
                        stackFrame = psiElement != null && (psiElement = (DebuggerContextImpl)psiElement.getCopyableUserData(KotlinCodeFragmentFactory.Companion.getDEBUG_CONTEXT_FOR_TESTS())) != null && (psiElement = psiElement.getFrameProxy()) != null ? psiElement.getStackFrame() : null;
                    } else {
                        StackFrameProxyImpl stackFrameProxyImpl = this.$debuggerContext.getFrameProxy();
                        stackFrame = stackFrameProxyImpl != null ? stackFrameProxyImpl.getStackFrame() : null;
                    }
                    StackFrame stackFrame2 = frame = stackFrame;
                    if (stackFrame2 != null) {
                        Map<LocalVariable, Value> values;
                        StackFrame stackFrame3;
                        StackFrame it = stackFrame3 = stackFrame2;
                        Map<LocalVariable, Value> map2 = values = it.getValues(it.visibleVariables());
                        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"values");
                        Map<LocalVariable, Value> $receiver$iv = map2;
                        LinkedHashMap<LocalVariable, Value> result$iv = new LinkedHashMap<LocalVariable, Value>();
                        Map<LocalVariable, Value> map3 = $receiver$iv;
                        for (Map.Entry<LocalVariable, Value> entry$iv : map3.entrySet()) {
                            Value it2 = entry$iv.getValue();
                            if (!(it2 != null)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        map = result$iv;
                    } else {
                        map = MapsKt.emptyMap();
                    }
                    Map visibleVariables = map;
                    StackFrame stackFrame4 = frame;
                    this.$frameInfo.element = new FrameInfo(stackFrame4 != null ? stackFrame4.thisObject() : null, visibleVariables);
                }
                catch (AbsentInformationException absentInformationException) {
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                }
                finally {
                    this.$semaphore.up();
                }
            }
            {
                this.$contextElement = $captured_local_variable$0;
                this.$debuggerContext = $captured_local_variable$1;
                this.$frameInfo = $captured_local_variable$2;
                this.$semaphore = $captured_local_variable$3;
            }
        };
        DebugProcessImpl debugProcessImpl = debuggerContext.getDebugProcess();
        if (debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getManagerThread()) != null) {
            debugProcessImpl.invoke(worker2);
        }
        int n = 0;
        int n2 = 50;
        while (n <= n2 && !semaphore.waitFor(20L)) {
            void i;
            ++i;
        }
        return (FrameInfo)frameInfo.element;
    }

    /*
     * WARNING - void declaration
     */
    private final String initImports(String imports) {
        CharSequence charSequence;
        if (imports != null && !((charSequence = (CharSequence)imports).length() == 0)) {
            void $receiver$iv$iv;
            Iterable $receiver$iv = StringsKt.split$default((CharSequence)imports, (String[])new String[]{KtCodeFragment.Companion.getIMPORT_SEPARATOR()}, (boolean)false, (int)0, (int)6, null);
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                String string;
                Object element$iv$iv = element$iv$iv$iv;
                String it = (String)element$iv$iv;
                if (this.fixImportIfNeeded(it) == null) continue;
                String it$iv$iv = string;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)KtCodeFragment.Companion.getIMPORT_SEPARATOR(), null, null, (int)0, null, null, (int)62, null);
        }
        return null;
    }

    private final String fixImportIfNeeded(String string) {
        if (StringsKt.endsWith$default((String)string, (String)"[]", (boolean)false, (int)2, null)) {
            String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"[]");
            KotlinCodeFragmentFactory kotlinCodeFragmentFactory = this;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            return kotlinCodeFragmentFactory.fixImportIfNeeded(string4);
        }
        if (Intrinsics.areEqual((Object)PsiTypesUtil.boxIfPossible((String)string), (Object)string) ^ true) {
            return null;
        }
        return string;
    }

    private final PsiElement getWrappedContextElement(Project project, PsiElement context) {
        PsiElement newContext = Companion.getContextElement(context);
        if (!(newContext instanceof KtElement)) {
            return newContext;
        }
        return (PsiElement)this.wrapContextIfNeeded(project, context, (KtElement)newContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JavaCodeFragment createPresentationCodeFragment(@NotNull TextWithImports item, @Nullable PsiElement context, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JavaCodeFragment kotlinCodeFragment = this.createCodeFragment(item, context, project);
        if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)kotlinCodeFragment)) && kotlinCodeFragment instanceof KtExpressionCodeFragment) {
            KtImportList e2;
            PsiExpression psiExpression;
            try {
                psiExpression = PsiElementFactory.SERVICE.getInstance((Project)project).createExpressionFromText(item.getText(), context);
            }
            catch (IncorrectOperationException e2) {
                psiExpression = null;
            }
            PsiExpression javaExpression = psiExpression;
            try {
                Object object;
                KtImportList ktImportList = ((KtExpressionCodeFragment)kotlinCodeFragment).importsAsImportList();
                if (ktImportList != null) {
                    KtImportList it = e2 = ktImportList;
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)it.getText());
                    if (!(psiFile instanceof PsiJavaFile)) {
                        psiFile = null;
                    }
                    PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
                    object = psiJavaFile != null ? psiJavaFile.getImportList() : null;
                } else {
                    object = null;
                }
                e2 = object;
            }
            catch (IncorrectOperationException e3) {
                e2 = null;
            }
            KtImportList importList = e2;
            if (javaExpression != null && !PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)javaExpression))) {
                void convertedFragment;
                e2 = new Ref.ObjectRef();
                e2.element = null;
                ApplicationUtilsKt.executeWriteCommand((Project)project, (String)"Convert java expression to kotlin in Evaluate Expression", (Function0)((Function0)new Function0<Unit>(javaExpression, (PsiImportList)importList, (Ref.ObjectRef)convertedFragment, project, kotlinCodeFragment){
                    final /* synthetic */ PsiExpression $javaExpression;
                    final /* synthetic */ PsiImportList $importList;
                    final /* synthetic */ Ref.ObjectRef $convertedFragment;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ JavaCodeFragment $kotlinCodeFragment;

                    public final void invoke() {
                        try {
                            String newImports;
                            String newText = KotlinRefactoringUtilKt.j2kText((PsiElement)((PsiElement)this.$javaExpression));
                            PsiImportList psiImportList = this.$importList;
                            String string = newImports = psiImportList != null ? KotlinRefactoringUtilKt.j2kText((PsiElement)((PsiElement)psiImportList)) : null;
                            if (newText != null) {
                                String string2 = ((KtExpressionCodeFragment)this.$kotlinCodeFragment).getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"kotlinCodeFragment.name");
                                this.$convertedFragment.element = new KtExpressionCodeFragment(this.$project, string2, (CharSequence)newText, newImports, ((KtExpressionCodeFragment)this.$kotlinCodeFragment).getContext());
                                AfterConversionPass afterConversionPass = new AfterConversionPass(this.$project, (PostProcessor)new J2kPostProcessor(false));
                                KtExpressionCodeFragment ktExpressionCodeFragment = (KtExpressionCodeFragment)this.$convertedFragment.element;
                                if (ktExpressionCodeFragment == null) {
                                    Intrinsics.throwNpe();
                                }
                                afterConversionPass.run((KtFile)ktExpressionCodeFragment, null);
                            }
                        }
                        catch (Throwable e) {
                            KotlinCodeFragmentFactory.access$getLOG$cp().error("Couldn't convert expression:\n`" + this.$javaExpression.getText() + '`', e);
                        }
                    }
                    {
                        this.$javaExpression = psiExpression;
                        this.$importList = psiImportList;
                        this.$convertedFragment = objectRef;
                        this.$project = project;
                        this.$kotlinCodeFragment = javaCodeFragment;
                        super(0);
                    }
                }));
                KtExpressionCodeFragment ktExpressionCodeFragment = (KtExpressionCodeFragment)convertedFragment.element;
                return ktExpressionCodeFragment != null ? (JavaCodeFragment)ktExpressionCodeFragment : kotlinCodeFragment;
            }
        }
        return kotlinCodeFragment;
    }

    public boolean isContextAccepted(@Nullable PsiElement contextElement) {
        boolean bl;
        if (contextElement instanceof PsiCodeBlock) {
            PsiElement psiElement = ((PsiCodeBlock)contextElement).getContext();
            bl = this.isContextAccepted((PsiElement)(psiElement != null ? psiElement.getContext() : null));
        } else if (contextElement == null) {
            bl = false;
        } else {
            Language language = contextElement.getLanguage();
            KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
            if (Intrinsics.areEqual((Object)language, (Object)kotlinFileType.getLanguage())) {
                bl = true;
            } else {
                Language language2 = contextElement.getLanguage();
                JavaFileType javaFileType = JavaFileType.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaFileType, (String)"JavaFileType.INSTANCE");
                if (Intrinsics.areEqual((Object)language2, (Object)javaFileType.getLanguage())) {
                    Project project = contextElement.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"contextElement.project");
                    GlobalSearchScope globalSearchScope = contextElement.getResolveScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"contextElement.resolveScope");
                    bl = KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass((Project)project, (GlobalSearchScope)globalSearchScope) != null;
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @NotNull
    public KotlinFileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
        return kotlinFileType;
    }

    @NotNull
    public KotlinEvaluationBuilder getEvaluatorBuilder() {
        return KotlinEvaluationBuilder.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement wrapContextIfNeeded(Project project, PsiElement originalContext, KtElement newContext) {
        void text2;
        Map markupMap;
        Map map;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            PsiElement psiElement = originalContext;
            map = NodeDescriptorImpl.getMarkupMap((DebugProcess)((DebugProcess)(psiElement != null && (psiElement = (DebuggerContextImpl)psiElement.getCopyableUserData(DEBUG_CONTEXT_FOR_TESTS)) != null ? psiElement.getDebugProcess() : null)));
        } else {
            XDebugSessionImpl xDebugSessionImpl;
            XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
            XDebugSession xDebugSession = xDebuggerManager.getCurrentSession();
            if (!(xDebugSession instanceof XDebugSessionImpl)) {
                xDebugSession = null;
            }
            map = (xDebugSessionImpl = (XDebugSessionImpl)xDebugSession) != null && (xDebugSessionImpl = xDebugSessionImpl.getValueMarkers()) != null ? xDebugSessionImpl.getAllMarkers() : (markupMap = null);
        }
        if (markupMap == null || markupMap.isEmpty()) {
            return newContext;
        }
        Object object = Companion.createCodeFragmentForLabeledObjects(project, markupMap);
        String string = (String)object.component1();
        Map labels = (Map)object.component2();
        object = (CharSequence)text2;
        if (object.length() == 0) {
            return newContext;
        }
        return this.createWrappingContext((String)text2, labels, newContext, project);
    }

    private final KtFile createFakeFileWithJavaContextElement(String funWithLocalVariables, PsiElement javaContext) {
        PsiJavaFile psiJavaFile;
        Object object;
        Object it;
        PsiFile psiFile = javaContext.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            psiFile = null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        StringBuilder sb = new StringBuilder();
        Object object2 = javaFile;
        if (object2 != null && (object2 = object2.getPackageName()) != null) {
            Object object3 = it = (object = object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
            object2 = !StringsKt.isBlank((CharSequence)((CharSequence)object3)) ? object : null;
            if (object2 != null) {
                it = object = object2;
                StringBuilder stringBuilder = sb.append("package ");
                Object object4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"it");
                stringBuilder.append(KtPsiUtilKt.quoteIfNeeded((String)object4)).append("\n");
            }
        }
        if ((psiJavaFile = javaFile) != null && (psiJavaFile = psiJavaFile.getImportList()) != null) {
            Object object5 = it = (object = psiJavaFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"it");
            sb.append(object5.getText()).append("\n");
        }
        sb.append(funWithLocalVariables);
        Project project = javaContext.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"javaContext.project");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return ktPsiFactory.createAnalyzableFile("fakeFileForJavaContextInDebugger.kt", string, javaContext);
    }

    private final KtElement createWrappingContext(String newFragmentText, Map<String, ? extends Value> labels, KtElement originalContext, Project project) {
        KtBlockCodeFragment codeFragment = new KtPsiFactory(project, false, 2, null).createBlockCodeFragment(newFragmentText, (PsiElement)originalContext);
        codeFragment.accept((PsiElementVisitor)new KtTreeVisitorVoid(labels){
            final /* synthetic */ Map $labels;

            public void visitProperty(@NotNull KtProperty property) {
                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                Map map = this.$labels;
                String string = property.getName();
                Value reference = (Value)map.get(string);
                if (reference != null) {
                    property.putUserData(KotlinCodeFragmentFactory.Companion.getLABEL_VARIABLE_VALUE_KEY(), (Object)reference);
                }
            }
            {
                this.$labels = $captured_local_variable$0;
            }
        });
        List list = codeFragment.getContentElement().getStatements();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"codeFragment.getContentElement().statements");
        return (KtElement)CollectionsKt.lastOrNull((List)list);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(Companion.getClass());
        Key key = Key.create((String)"_label_variable_value_key_");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Value>(\"_label_variable_value_key_\")");
        LABEL_VARIABLE_VALUE_KEY = key;
        Key key2 = Key.create((String)"DEBUG_CONTEXT_FOR_TESTS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create(\"DEBUG_CONTEXT_FOR_TESTS\")");
        DEBUG_CONTEXT_FOR_TESTS = key2;
    }

    @NotNull
    public static final /* synthetic */ KtFile access$createFakeFileWithJavaContextElement(KotlinCodeFragmentFactory $this, @NotNull String funWithLocalVariables, @NotNull PsiElement javaContext) {
        return $this.createFakeFileWithJavaContextElement(funWithLocalVariables, javaContext);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Nullable
    public static final /* synthetic */ FrameInfo access$getFrameInfo(KotlinCodeFragmentFactory $this, @Nullable PsiElement contextElement, @NotNull DebuggerContextImpl debuggerContext) {
        return $this.getFrameInfo(contextElement, debuggerContext);
    }

    @Nullable
    public static final /* synthetic */ KtElement access$wrapContextIfNeeded(KotlinCodeFragmentFactory $this, @NotNull Project project, @Nullable PsiElement originalContext, @Nullable KtElement newContext) {
        return $this.wrapContextIfNeeded(project, originalContext, newContext);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$FrameInfo;", "", "thisObject", "Lcom/sun/jdi/Value;", "visibleVariables", "", "Lcom/sun/jdi/LocalVariable;", "(Lcom/sun/jdi/Value;Ljava/util/Map;)V", "getThisObject", "()Lcom/sun/jdi/Value;", "getVisibleVariables", "()Ljava/util/Map;", "idea-jvm"})
    private static final class FrameInfo {
        @Nullable
        private final Value thisObject;
        @NotNull
        private final Map<LocalVariable, Value> visibleVariables;

        @Nullable
        public final Value getThisObject() {
            return this.thisObject;
        }

        @NotNull
        public final Map<LocalVariable, Value> getVisibleVariables() {
            return this.visibleVariables;
        }

        public FrameInfo(@Nullable Value thisObject, @NotNull Map<LocalVariable, ? extends Value> visibleVariables) {
            Intrinsics.checkParameterIsNotNull(visibleVariables, (String)"visibleVariables");
            this.thisObject = thisObject;
            this.visibleVariables = visibleVariables;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00150\u0011J*\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cJ \u0010\u001e\u001a\u00020\t*\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentFactory$Companion;", "", "()V", "DEBUG_CONTEXT_FOR_TESTS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getDEBUG_CONTEXT_FOR_TESTS", "()Lcom/intellij/openapi/util/Key;", "DEBUG_LABEL_SUFFIX", "", "LABEL_VARIABLE_VALUE_KEY", "Lcom/sun/jdi/Value;", "getLABEL_VARIABLE_VALUE_KEY", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createCodeFragmentForLabeledObjects", "Lkotlin/Pair;", "", "project", "Lcom/intellij/openapi/project/Project;", "markupMap", "Lcom/intellij/xdebugger/impl/ui/tree/ValueMarkup;", "createKotlinProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableName", "variableTypeName", "value", "getContextElement", "Lcom/intellij/psi/PsiElement;", "elementAt", "kotlinVariablesAsText", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final Key<Value> getLABEL_VARIABLE_VALUE_KEY() {
            return LABEL_VARIABLE_VALUE_KEY;
        }

        @NotNull
        public final Key<DebuggerContextImpl> getDEBUG_CONTEXT_FOR_TESTS() {
            return DEBUG_CONTEXT_FOR_TESTS;
        }

        @Nullable
        public final PsiElement getContextElement(@Nullable PsiElement elementAt) {
            int n;
            if (elementAt == null) {
                return null;
            }
            if (elementAt instanceof PsiCodeBlock) {
                PsiElement psiElement = ((PsiCodeBlock)elementAt).getContext();
                return this.getContextElement((PsiElement)(psiElement != null ? psiElement.getContext() : null));
            }
            if (elementAt instanceof KtLightClass) {
                return this.getContextElement((PsiElement)((KtLightClass)elementAt).getKotlinOrigin());
            }
            PsiFile containingFile = elementAt.getContainingFile();
            if (containingFile instanceof PsiJavaFile) {
                return elementAt;
            }
            if (!(containingFile instanceof KtFile)) {
                return null;
            }
            if (elementAt instanceof PsiWhiteSpace || elementAt instanceof PsiComment) {
                PsiElement psiElement = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAt, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                n = psiElement != null ? psiElement.getTextOffset() : elementAt.getTextOffset();
            } else {
                n = elementAt.getTextOffset();
            }
            int lineStartOffset = n;
            getContextElement.1 takeIfAcceptedAsCodeFragmentContext$ = getContextElement.1.INSTANCE;
            KtExpression ktExpression = (KtExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)containingFile, (int)lineStartOffset, KtExpression.class, (boolean)false);
            if (ktExpression != null && (ktExpression = takeIfAcceptedAsCodeFragmentContext$.invoke((KtElement)ktExpression)) != null) {
                KtExpression ktExpression2;
                KtExpression it = ktExpression2 = ktExpression;
                return (PsiElement)CodeInsightUtils.getTopmostElementAtOffset((PsiElement)((PsiElement)it), (int)lineStartOffset, (Class[])new Class[]{KtExpression.class});
            }
            KtExpression ktExpression3 = KotlinEditorTextProvider.Companion.findExpressionInner(elementAt, true);
            if (ktExpression3 != null && (ktExpression3 = takeIfAcceptedAsCodeFragmentContext$.invoke((KtElement)ktExpression3)) != null) {
                KtExpression ktExpression4;
                KtExpression it = ktExpression4 = ktExpression3;
                return (PsiElement)it;
            }
            return (PsiElement)containingFile;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<String, Map<String, Value>> createCodeFragmentForLabeledObjects(@NotNull Project project, @NotNull Map<?, ? extends ValueMarkup> markupMap) {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(markupMap, (String)"markupMap");
            Object $receiver$iv = markupMap.entrySet();
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
            Object object = $receiver$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                void value;
                Map.Entry it;
                Map.Entry entry;
                Map map = destination$iv$iv;
                Map.Entry entry2 = entry = (it = (Map.Entry)element$iv$iv);
                Object k = entry2.getKey();
                entry2 = entry;
                ValueMarkup markup = (ValueMarkup)entry2.getValue();
                String string = markup.getText() + KotlinCodeFragmentFactory.DEBUG_LABEL_SUFFIX;
                Object v1 = value;
                if (!(v1 instanceof Value)) {
                    v1 = null;
                }
                Pair pair = TuplesKt.to((Object)string, (Object)v1);
                map.put(pair.getFirst(), pair.getSecond());
            }
            $receiver$iv = destination$iv$iv;
            LinkedHashMap result$iv = new LinkedHashMap();
            object = $receiver$iv;
            for (Map.Entry entry$iv : object.entrySet()) {
                Value it = (Value)entry$iv.getValue();
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map variables = result$iv;
            return TuplesKt.to((Object)this.kotlinVariablesAsText(variables, project), (Object)variables);
        }

        private final String kotlinVariablesAsText(@NotNull Map<String, ? extends Value> $receiver, Project project) {
            StringBuilder sb = new StringBuilder();
            PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)project);
            Iterator<Map.Entry<String, ? extends Value>> iterator = $receiver.entrySet().iterator();
            while (iterator.hasNext()) {
                KtProperty kotlinProperty;
                Map.Entry<String, ? extends Value> entry;
                Map.Entry<String, ? extends Value> entry2 = entry = iterator.next();
                String variableName = entry2.getKey();
                entry2 = entry;
                Value variableValue = entry2.getValue();
                if (!psiNameHelper.isIdentifier(variableName)) continue;
                Object object = variableValue.type();
                if (object == null || (object = object.name()) == null) {
                    continue;
                }
                Object variableTypeName = object;
                if (this.createKotlinProperty(project, variableName, (String)variableTypeName, variableValue) == null) {
                    continue;
                }
                sb.append(kotlinProperty.getText() + '\n');
            }
            sb.append("val _debug_context_val = 1\n");
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        private final KtProperty createKotlinProperty(Project project, String variableName, String variableTypeName, Value value) {
            KtProperty ktField;
            block2: {
                KtProperty ktProperty;
                PsiField field;
                Type type = JdiValuesKt.asValue((Value)value).getAsmType();
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
                ClassDescriptor actualClassDescriptor = KotlinEvaluationBuilderKt.getClassDescriptor(type, globalSearchScope);
                if (actualClassDescriptor != null && actualClassDescriptor.getDefaultType().getArguments().isEmpty()) {
                    SimpleType simpleType = actualClassDescriptor.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"actualClassDescriptor.defaultType");
                    String renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(TypeUtilsKt.makeNullable((KotlinType)((KotlinType)simpleType)));
                    return new KtPsiFactory(project, false, 2, null).createProperty(KtPsiUtilKt.quoteIfNeeded((String)variableName), renderedType, false);
                }
                Function1<String, String> addArraySuffix$ = new Function1<String, String>(value){
                    final /* synthetic */ Value $value;

                    @NotNull
                    public final String invoke(@NotNull String $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        return this.$value instanceof ArrayReference ? $receiver + "[]" : $receiver;
                    }
                    {
                        this.$value = value;
                        super(1);
                    }
                };
                String className = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)variableTypeName, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"[]", null, (int)2, null);
                PsiClassType classType = PsiType.getTypeByName((String)className, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                String type2 = addArraySuffix$.invoke(!(value instanceof PrimitiveValue) && classType.resolve() == null ? "java.lang.Object" : className);
                PsiField psiField = field = PsiElementFactory.SERVICE.getInstance((Project)project).createField(variableName, (PsiType)PsiType.getTypeByName((String)type2, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
                Intrinsics.checkExpressionValueIsNotNull((Object)psiField, (String)"field");
                KtNamedDeclaration ktNamedDeclaration = KotlinRefactoringUtilKt.j2k((PsiMember)((PsiMember)psiField));
                if (!(ktNamedDeclaration instanceof KtProperty)) {
                    ktNamedDeclaration = null;
                }
                if ((ktProperty = (ktField = (KtProperty)ktNamedDeclaration)) == null || (ktProperty = ktProperty.getModifierList()) == null) break block2;
                ktProperty.delete();
            }
            return ktField;
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ KtProperty access$createKotlinProperty(Companion $this, @NotNull Project project, @NotNull String variableName, @NotNull String variableTypeName, @NotNull Value value) {
            return $this.createKotlinProperty(project, variableName, variableTypeName, value);
        }

        @NotNull
        public static final /* synthetic */ String access$kotlinVariablesAsText(Companion $this, @NotNull Map $receiver, @NotNull Project project) {
            return $this.kotlinVariablesAsText($receiver, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

