/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ExceptionUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.Eval;
import org.jetbrains.eval4j.Eval4JInterpretingException;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExtractFunctionForDebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameVisitor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentFactory;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "getSourcePosition", "()Lcom/intellij/debugger/SourcePosition;", "evaluate", "", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "getModifier", "Lcom/intellij/debugger/engine/evaluation/expression/Modifier;", "isSpecialException", "", "th", "", "Companion", "idea-jvm"})
public final class KotlinEvaluator
implements Evaluator {
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final SourcePosition sourcePosition;
    private static final Set<DiagnosticFactory<?>> IGNORED_DIAGNOSTICS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = this.codeFragment.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"codeFragment.text");
        CharSequence charSequence = string;
        if (charSequence.length() == 0) {
            DebugProcessImpl debugProcessImpl = context.getDebugProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
            return debugProcessImpl.getVirtualMachineProxy().mirrorOfVoid();
        }
        charSequence = new Ref.BooleanRef();
        ((Ref.BooleanRef)charSequence).element = true;
        try {
            InterpreterResult result2;
            Object object;
            void isCompiledDataFromCache;
            KotlinDebuggerCaches.CompiledDataDescriptor compiledData2 = KotlinDebuggerCaches.Companion.getOrCreateCompiledData(this.codeFragment, this.sourcePosition, context, (Function2<? super KtCodeFragment, ? super SourcePosition, KotlinDebuggerCaches.CompiledDataDescriptor>)((Function2)new Function2<KtCodeFragment, SourcePosition, KotlinDebuggerCaches.CompiledDataDescriptor>((Ref.BooleanRef)isCompiledDataFromCache, context){
                final /* synthetic */ Ref.BooleanRef $isCompiledDataFromCache;
                final /* synthetic */ EvaluationContextImpl $context;

                @NotNull
                public final KotlinDebuggerCaches.CompiledDataDescriptor invoke(@NotNull KtCodeFragment fragment, @NotNull SourcePosition position2) {
                    Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
                    Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
                    this.$isCompiledDataFromCache.element = false;
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$extractAndCompile(KotlinEvaluator.Companion, fragment, position2, this.$context);
                }
                {
                    this.$isCompiledDataFromCache = booleanRef;
                    this.$context = evaluationContextImpl;
                    super(2);
                }
            }));
            ClassLoaderReference classLoaderRef = CompilingEvaluatorKt.loadClassesSafely(context, (Collection<ClassToLoad>)compiledData2.getClasses());
            if (classLoaderRef != null) {
                object = KotlinEvaluator.Companion.evaluateWithCompilation(context, compiledData2, classLoaderRef);
                if (object == null) {
                    object = KotlinEvaluator.Companion.runEval4j(context, compiledData2);
                }
            } else {
                object = result2 = KotlinEvaluator.Companion.runEval4j(context, compiledData2);
            }
            if (isCompiledDataFromCache.element && result2 instanceof ExceptionThrown && ((ExceptionThrown)result2).getKind() == ExceptionThrown.ExceptionKind.BROKEN_CODE) {
                return KotlinEvaluator.Companion.toJdiValue(KotlinEvaluator.Companion.runEval4j(context, KotlinEvaluator.Companion.extractAndCompile(this.codeFragment, this.sourcePosition, context)), context);
            }
            return result2 instanceof InterpreterResult ? KotlinEvaluator.Companion.toJdiValue(result2, context) : result2;
        }
        catch (EvaluateException e) {
            throw (Throwable)e;
        }
        catch (ProcessCanceledException e) {
            Void void_ = KotlinEvaluator.Companion.exception(e);
            throw null;
        }
        catch (Eval4JInterpretingException e) {
            Void void_ = KotlinEvaluator.Companion.exception(e.getCause());
            throw null;
        }
        catch (Exception e) {
            boolean isSpecialException = this.isSpecialException(e);
            if (isSpecialException) {
                Void void_ = KotlinEvaluator.Companion.exception(e);
                throw null;
            }
            String text2 = (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ KotlinEvaluator this$0;

                @NotNull
                public final String invoke() {
                    Object object = this.this$0.getCodeFragment().getContext();
                    if (object == null || (object = object.getText()) == null) {
                        object = "null";
                    }
                    return object;
                }
                {
                    this.this$0 = kotlinEvaluator;
                    super(0);
                }
            }));
            Attachment[] attachments2 = new Attachment[]{AttachmentUtilsKt.attachmentByPsiFile((PsiFile)this.sourcePosition.getFile()), AttachmentUtilsKt.attachmentByPsiFile((PsiFile)((PsiFile)this.codeFragment)), new Attachment("breakpoint.info", "line: " + ((Number)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Integer>(this){
                final /* synthetic */ KotlinEvaluator this$0;

                public final int invoke() {
                    return this.this$0.getSourcePosition().getLine();
                }
                {
                    this.this$0 = kotlinEvaluator;
                    super(0);
                }
            }))).intValue()), new Attachment("context.info", text2)};
            KotlinEvaluationBuilderKt.getLOG().error((Object)LogMessageEx.createEvent((String)"Couldn't evaluate expression", (String)ExceptionUtil.getThrowableText((Throwable)e), (Attachment[])new Attachment[]{AttachmentUtilsKt.mergeAttachments((Attachment[])Arrays.copyOf(attachments2, attachments2.length))}));
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            Void void_ = KotlinEvaluator.Companion.exception("An exception occurs during Evaluate Expression Action " + cause);
            throw null;
        }
    }

    private final boolean isSpecialException(Throwable th) {
        Throwable throwable = th;
        return throwable instanceof ClassNotPreparedException || throwable instanceof InternalException || throwable instanceof AbsentInformationException || throwable instanceof ClassNotLoadedException || throwable instanceof IncompatibleThreadStateException || throwable instanceof InconsistentDebugInfoException || throwable instanceof ObjectCollectedException || throwable instanceof VMDisconnectedException;
    }

    @Nullable
    public Modifier getModifier() {
        return null;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public KotlinEvaluator(@NotNull KtCodeFragment codeFragment, @NotNull SourcePosition sourcePosition) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition;
    }

    static {
        Companion = new Companion(null);
        ImmutableSet immutableSet = Errors.INVISIBLE_REFERENCE_DIAGNOSTICS;
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"Errors.INVISIBLE_REFERENCE_DIAGNOSTICS");
        IGNORED_DIAGNOSTICS = (Set)immutableSet;
    }

    @NotNull
    public static final /* synthetic */ Set access$getIGNORED_DIAGNOSTICS$cp() {
        return IGNORED_DIAGNOSTICS;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001KB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020#H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\bH\u0002J\"\u0010-\u001a\u00020.*\u00020/2\b\b\u0002\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u00010/H\u0002J&\u00103\u001a\u0002H4\"\u0004\b\u0000\u00104*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H407H\u0082\b\u00a2\u0006\u0002\u00108J-\u00109\u001a\b\u0012\u0004\u0012\u00020\f0:*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00110<H\u0002\u00a2\u0006\u0002\u0010=J\u0014\u0010>\u001a\u00020\u001b*\u00020?2\u0006\u0010@\u001a\u00020\u0015H\u0002J$\u0010A\u001a\u00020B*\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020HH\u0002J\u0016\u0010I\u001a\u0004\u0018\u00010J*\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "()V", "IGNORED_DIAGNOSTICS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "mainClass", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "getMainClass", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;)Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "boxOrUnboxArgumentIfNeeded", "Lorg/jetbrains/eval4j/Value;", "eval", "Lorg/jetbrains/eval4j/jdi/JDIEval;", "argumentValue", "parameterType", "Lorg/jetbrains/org/objectweb/asm/Type;", "createClassFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "extractedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "parameters", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;", "evaluateWithCompilation", "compiledData", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "exception", "", "msg", "", "e", "", "extractAndCompile", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getClassName", "fileName", "runEval4j", "Lorg/jetbrains/eval4j/InterpreterResult;", "checkForErrors", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion$ExtendedAnalysisResult;", "Lorg/jetbrains/kotlin/psi/KtFile;", "analyzeInlineFunctions", "", "contextFile", "executeWithBreakpointsDisabled", "T", "Lcom/sun/jdi/VirtualMachine;", "block", "Lkotlin/Function0;", "(Lcom/sun/jdi/VirtualMachine;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getArgumentsForEval4j", "", "parameterTypes", "", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ParametersDescriptor;[Lorg/jetbrains/org/objectweb/asm/Type;)Ljava/util/List;", "getParametersForDebugger", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/ExtractionResult;", "fragment", "recordAnonymousType", "", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "localVariableName", "visitor", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameVisitor;", "toJdiValue", "Lcom/sun/jdi/Value;", "ExtendedAnalysisResult", "idea-jvm"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final KotlinDebuggerCaches.CompiledDataDescriptor extractAndCompile(KtCodeFragment codeFragment, SourcePosition sourcePosition, EvaluationContextImpl context) {
            void $receiver$iv$iv;
            Object object;
            void parametersDescriptor;
            Pair pair;
            org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.checkForErrors$default(this, (KtFile)codeFragment, false, null, 3, null);
            PsiFile psiFile = sourcePosition.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"sourcePosition.file");
            ExtractionResult extractionResult = ExtractFunctionForDebuggerUtilKt.getFunctionForExtractedFragment(codeFragment, psiFile, sourcePosition.getLine());
            if (extractionResult == null) {
                throw (Throwable)new IllegalStateException("Code fragment cannot be extracted to function: " + codeFragment.getText());
            }
            ExtractionResult extractionResult2 = extractionResult;
            try {
                KtNamedDeclaration ktNamedDeclaration = extractionResult2.getDeclaration();
                if (ktNamedDeclaration == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
                }
                pair = TuplesKt.to((Object)this.getParametersForDebugger(extractionResult2, codeFragment), (Object)((KtNamedFunction)ktNamedDeclaration));
            }
            finally {
                Disposer.dispose((Disposable)((Disposable)extractionResult2));
            }
            Pair pair2 = pair;
            KotlinDebuggerCaches.ParametersDescriptor parametersDescriptor2 = (KotlinDebuggerCaches.ParametersDescriptor)pair2.component1();
            KtNamedFunction extractedFunction = (KtNamedFunction)pair2.component2();
            Logger logger = KotlinEvaluationBuilderKt.getLOG();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
            if (logger.isDebugEnabled()) {
                KotlinEvaluationBuilderKt.getLOG().debug("Extracted function:\n" + (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(extractedFunction){
                    final /* synthetic */ KtNamedFunction $extractedFunction;

                    public final String invoke() {
                        return this.$extractedFunction.getText();
                    }
                    {
                        this.$extractedFunction = ktNamedFunction;
                        super(0);
                    }
                })));
            }
            ClassFileFactory classFileFactory = this.createClassFileFactory(codeFragment, extractedFunction, context, (KotlinDebuggerCaches.ParametersDescriptor)parametersDescriptor);
            List list = classFileFactory.asList();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"classFileFactory.asList()");
            Iterable outputFiles = ClassFileUtilsKt.filterClassFiles((List)list);
            for (OutputFile file2 : outputFiles) {
                Logger logger2 = KotlinEvaluationBuilderKt.getLOG();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LOG");
                if (logger2.isDebugEnabled()) {
                    KotlinEvaluationBuilderKt.getLOG().debug("Output file generated: " + file2.getRelativePath());
                }
                if (!KotlinEvaluationBuilderKt.access$getDEBUG_MODE$p()) continue;
                object = file2.asText();
                System.out.println(object);
            }
            Iterable $receiver$iv = outputFiles;
            object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                OutputFile outputFile = (OutputFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                ClassToLoad classToLoad = new ClassToLoad(Companion.getClassName(it.getRelativePath()), it.getRelativePath(), it.asByteArray());
                collection.add(classToLoad);
            }
            List additionalFiles = (List)destination$iv$iv;
            return new KotlinDebuggerCaches.CompiledDataDescriptor(additionalFiles, sourcePosition, (KotlinDebuggerCaches.ParametersDescriptor)parametersDescriptor);
        }

        private final String getClassName(String fileName) {
            return StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)fileName, (String)".class", null, (int)2, null), (String)"/", (String)".", (boolean)false, (int)4, null);
        }

        /*
         * WARNING - void declaration
         */
        private final ClassToLoad getMainClass(@NotNull KotlinDebuggerCaches.CompiledDataDescriptor $receiver) {
            Object v0;
            Iterable $receiver$iv;
            block2: {
                $receiver$iv = $receiver.getClasses();
                for (Object element$iv : $receiver$iv) {
                    ClassToLoad it = (ClassToLoad)element$iv;
                    if (!it.isMainClass()) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            ClassToLoad classToLoad = v0;
            if (classToLoad == null) {
                void strict$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Can't find main class for ");
                PsiElement psiElement = $receiver.getSourcePosition().getElementAt();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"sourcePosition.elementAt");
                $receiver$iv = psiElement;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder;
                PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclaration.class, (boolean)strict$iv);
                String string = stringBuilder2.append((KtDeclaration)psiElement2).toString();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return classToLoad;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Object evaluateWithCompilation(EvaluationContextImpl context, KotlinDebuggerCaches.CompiledDataDescriptor compiledData2, ClassLoaderReference classLoader) {
            DebugProcessImpl debugProcessImpl = context.getDebugProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
            VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"context.debugProcess.virtualMachineProxy");
            VirtualMachine vm = virtualMachineProxyImpl.getVirtualMachine();
            byte[] mainClassBytecode = this.getMainClass(compiledData2).getBytes();
            try {
                com.sun.jdi.Value value;
                void $receiver$iv;
                ObjectValue mainClassValue;
                boolean bl;
                ClassNode classNode;
                Object $receiver = classNode = new ClassNode();
                new ClassReader(mainClassBytecode).accept((ClassVisitor)$receiver, 1);
                ClassNode mainClassAsmNode = classNode;
                boolean bl2 = bl = mainClassAsmNode.methods.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    $receiver = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError($receiver));
                }
                MethodNode methodToInvoke = (MethodNode)mainClassAsmNode.methods.get(0);
                boolean bl3 = $receiver = methodToInvoke.parameters == null || methodToInvoke.parameters.isEmpty();
                if (_Assertions.ENABLED && !$receiver) {
                    String $i$a$1$apply = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$1$apply));
                }
                SuspendContextImpl suspendContextImpl = context.getSuspendContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl, (String)"context.suspendContext");
                ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                ThreadReference threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
                if (threadReference == null) {
                    Intrinsics.throwNpe();
                }
                ThreadReference thread = threadReference;
                SuspendContextImpl suspendContextImpl2 = context.getSuspendContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl2, (String)"context.suspendContext");
                int invokePolicy = KotlinEvaluationBuilderKt.getInvokePolicy((SuspendContext)suspendContextImpl2);
                VirtualMachine virtualMachine = vm;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"vm");
                JDIEval eval = new JDIEval(virtualMachine, classLoader, thread, invokePolicy);
                Type type = Type.getObjectType((String)mainClassAsmNode.name);
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getObjectType(mainClassAsmNode.name)");
                Value value2 = eval.loadClass(type, classLoader);
                if (!(value2 instanceof ObjectValue)) {
                    value2 = null;
                }
                ObjectValue objectValue = mainClassValue = (ObjectValue)value2;
                Object object = objectValue != null ? objectValue.getValue() : null;
                if (!(object instanceof ClassObjectReference)) {
                    object = null;
                }
                ClassObjectReference classObjectReference = (ClassObjectReference)object;
                ReferenceType referenceType = classObjectReference != null ? classObjectReference.reflectedType() : null;
                if (!(referenceType instanceof ClassType)) {
                    referenceType = null;
                }
                ClassType classType = (ClassType)referenceType;
                if (classType == null) {
                    return null;
                }
                ClassType mainClass = classType;
                VirtualMachine virtualMachine2 = vm;
                Companion this_$iv = this;
                List<BreakpointRequest> list = $receiver$iv.eventRequestManager().breakpointRequests();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"eventRequestManager().breakpointRequests()");
                Collection collection = list;
                List<ClassPrepareRequest> list2 = $receiver$iv.eventRequestManager().classPrepareRequests();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"eventRequestManager().classPrepareRequests()");
                List allRequests$iv = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                try {
                    void $receiver$iv$iv;
                    void $receiver$iv2;
                    Iterable $receiver$iv$iv2 = allRequests$iv;
                    for (Object element$iv$iv : $receiver$iv$iv2) {
                        EventRequest it$iv = (EventRequest)element$iv$iv;
                        it$iv.disable();
                    }
                    Object[] argumentTypes = Type.getArgumentTypes((String)methodToInvoke.desc);
                    KotlinDebuggerCaches.ParametersDescriptor parametersDescriptor = compiledData2.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)argumentTypes, (String)"argumentTypes");
                    Iterable iterable = CollectionsKt.zip((Iterable)Companion.getArgumentsForEval4j(context, parametersDescriptor, (Type[])argumentTypes), (Object[])argumentTypes);
                    void var22_32 = $receiver$iv2;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        Type type2;
                        void $value_type;
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        Value value3 = (Value)$value_type.component1();
                        Type type3 = type2 = (Type)$value_type.component2();
                        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type");
                        String string = type3.getClassName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.className");
                        eval.loadClassByName(string, classLoader);
                        com.sun.jdi.Value value4 = JdiValuesKt.asJdiValue((Value)Companion.boxOrUnboxArgumentIfNeeded(eval, value3, type2), (VirtualMachine)vm, (Type)type2);
                        collection2.add(value4);
                    }
                    List args = (List)destination$iv$iv;
                    List<Method> list3 = mainClass.methods();
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"mainClass.methods()");
                    value = mainClass.invokeMethod(thread, (Method)CollectionsKt.single(list3), args, invokePolicy);
                }
                finally {
                    Iterable $receiver$iv$iv = allRequests$iv;
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        EventRequest it$iv = (EventRequest)element$iv$iv;
                        it$iv.enable();
                    }
                }
                return value;
            }
            catch (Throwable e) {
                KotlinEvaluationBuilderKt.getLOG().error("Unable to evaluate expression with compilation", e);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final InterpreterResult runEval4j(EvaluationContextImpl context, KotlinDebuggerCaches.CompiledDataDescriptor compiledData2) {
            void resultValue;
            DebugProcessImpl debugProcessImpl = context.getDebugProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
            VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"context.debugProcess.virtualMachineProxy");
            VirtualMachine virtualMachine = virtualMachineProxyImpl.getVirtualMachine();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            byte[] mainClassBytecode = this.getMainClass(compiledData2).getBytes();
            new ClassReader(mainClassBytecode).accept(new ClassVisitor(context, compiledData2, virtualMachine, (Ref.ObjectRef)resultValue, 327680){
                final /* synthetic */ EvaluationContextImpl $context;
                final /* synthetic */ KotlinDebuggerCaches.CompiledDataDescriptor $compiledData;
                final /* synthetic */ VirtualMachine $virtualMachine;
                final /* synthetic */ Ref.ObjectRef $resultValue;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    if (Intrinsics.areEqual((Object)name, (Object)KotlinEvaluationBuilderKt.getGENERATED_FUNCTION_NAME())) {
                        Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                        KotlinDebuggerCaches.ParametersDescriptor parametersDescriptor = this.$compiledData.getParameters();
                        Intrinsics.checkExpressionValueIsNotNull((Object)argumentTypes, (String)"argumentTypes");
                        List args = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$getArgumentsForEval4j(KotlinEvaluator.Companion, this.$context, parametersDescriptor, argumentTypes);
                        return (MethodVisitor)new MethodNode(this, args, argumentTypes, access, name, desc, signature, exceptions, 327680, access, name, desc, signature, exceptions){
                            final /* synthetic */ runEval4j.1 this$0;
                            final /* synthetic */ List $args;
                            final /* synthetic */ Type[] $argumentTypes;
                            final /* synthetic */ int $access;
                            final /* synthetic */ String $name;
                            final /* synthetic */ String $desc;
                            final /* synthetic */ String $signature;
                            final /* synthetic */ String[] $exceptions;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * WARNING - void declaration
                             */
                            public void visitEnd() {
                                VirtualMachine virtualMachine = this.this$0.$virtualMachine;
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"virtualMachine");
                                VirtualMachine $receiver$iv = virtualMachine;
                                Companion this_$iv = KotlinEvaluator.Companion;
                                List<BreakpointRequest> list = $receiver$iv.eventRequestManager().breakpointRequests();
                                Intrinsics.checkExpressionValueIsNotNull(list, (String)"eventRequestManager().breakpointRequests()");
                                Collection collection = list;
                                List<ClassPrepareRequest> list2 = $receiver$iv.eventRequestManager().classPrepareRequests();
                                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"eventRequestManager().classPrepareRequests()");
                                List allRequests$iv = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                                try {
                                    Collection<Value> collection2;
                                    void $receiver$iv$iv;
                                    void $receiver$iv2;
                                    Iterable $receiver$iv$iv2 = allRequests$iv;
                                    for (T element$iv$iv : $receiver$iv$iv2) {
                                        EventRequest it$iv = (EventRequest)element$iv$iv;
                                        it$iv.disable();
                                    }
                                    VirtualMachine virtualMachine2 = this.this$0.$virtualMachine;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine2, (String)"virtualMachine");
                                    ClassLoaderReference classLoaderReference = this.this$0.$context.getClassLoader();
                                    SuspendContextImpl suspendContextImpl = this.this$0.$context.getSuspendContext();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl, (String)"context.suspendContext");
                                    ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                                    ThreadReference threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
                                    if (threadReference == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    SuspendContextImpl suspendContextImpl2 = this.this$0.$context.getSuspendContext();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl2, (String)"context.suspendContext");
                                    JDIEval eval = new JDIEval(virtualMachine2, classLoaderReference, threadReference, KotlinEvaluationBuilderKt.getInvokePolicy((SuspendContext)suspendContextImpl2));
                                    Ref.ObjectRef objectRef = this.this$0.$resultValue;
                                    MethodNode methodNode = this;
                                    MethodNode methodNode2 = this;
                                    Iterable iterable = this.$args;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)this.$argumentTypes, (String)"argumentTypes");
                                    Iterable iterable2 = CollectionsKt.zip((Iterable)iterable, (Object[])this.$argumentTypes);
                                    MethodNode methodNode3 = methodNode2;
                                    MethodNode methodNode4 = methodNode;
                                    Ref.ObjectRef objectRef2 = objectRef;
                                    void var13_17 = $receiver$iv2;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                                    for (T item$iv$iv : $receiver$iv$iv) {
                                        void it;
                                        Pair pair = (Pair)item$iv$iv;
                                        collection2 = destination$iv$iv;
                                        Value value = (Value)it.getFirst();
                                        Object object = it.getSecond();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.second");
                                        Value value2 = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$boxOrUnboxArgumentIfNeeded(KotlinEvaluator.Companion, eval, value, (Type)object);
                                        collection2.add(value2);
                                    }
                                    collection2 = (List)destination$iv$iv;
                                    objectRef2.element = InterpreterLoopKt.interpreterLoop$default((MethodNode)methodNode4, (Frame)JdiValuesKt.makeInitialFrame((MethodNode)methodNode3, (List)collection2), (Eval)((Eval)eval), null, (int)8, null);
                                    Unit unit = Unit.INSTANCE;
                                }
                                finally {
                                    Iterable $receiver$iv$iv = allRequests$iv;
                                    for (T element$iv$iv : $receiver$iv$iv) {
                                        EventRequest it$iv = (EventRequest)element$iv$iv;
                                        it$iv.enable();
                                    }
                                }
                            }
                            {
                                this.this$0 = $outer;
                                this.$args = $captured_local_variable$1;
                                this.$argumentTypes = $captured_local_variable$2;
                                this.$access = $captured_local_variable$3;
                                this.$name = $captured_local_variable$4;
                                this.$desc = $captured_local_variable$5;
                                this.$signature = $captured_local_variable$6;
                                this.$exceptions = $captured_local_variable$7;
                                super($super_call_param$8, $super_call_param$9, $super_call_param$10, $super_call_param$11, $super_call_param$12, $super_call_param$13);
                            }
                        };
                    }
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
                {
                    this.$context = $captured_local_variable$0;
                    this.$compiledData = $captured_local_variable$1;
                    this.$virtualMachine = $captured_local_variable$2;
                    this.$resultValue = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }, 0);
            InterpreterResult interpreterResult = (InterpreterResult)resultValue.element;
            if (interpreterResult == null) {
                throw (Throwable)new IllegalStateException("resultValue is null: cannot find method " + KotlinEvaluationBuilderKt.getGENERATED_FUNCTION_NAME());
            }
            return interpreterResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T executeWithBreakpointsDisabled(@NotNull VirtualMachine $receiver, Function0<? extends T> block) {
            List<BreakpointRequest> list = $receiver.eventRequestManager().breakpointRequests();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"eventRequestManager().breakpointRequests()");
            Collection collection = list;
            List<ClassPrepareRequest> list2 = $receiver.eventRequestManager().classPrepareRequests();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"eventRequestManager().classPrepareRequests()");
            List allRequests = CollectionsKt.plus((Collection)collection, (Iterable)list2);
            try {
                Iterable $receiver$iv = allRequests;
                for (Object element$iv : $receiver$iv) {
                    EventRequest it = (EventRequest)element$iv;
                    it.disable();
                }
                Object object = block.invoke();
                return (T)object;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                Iterable $receiver$iv = allRequests;
                for (Object element$iv : $receiver$iv) {
                    EventRequest it = (EventRequest)element$iv;
                    it.enable();
                }
                InlineMarker.finallyEnd((int)1);
            }
        }

        private final Value boxOrUnboxArgumentIfNeeded(JDIEval eval, Value argumentValue, Type parameterType) {
            Type argumentType = argumentValue.getAsmType();
            if (AsmUtil.isPrimitive((Type)parameterType) && !AsmUtil.isPrimitive((Type)argumentType)) {
                try {
                    Type unboxedType = AsmUtil.unboxType((Type)argumentType);
                    if (Intrinsics.areEqual((Object)parameterType, (Object)unboxedType)) {
                        return eval.unboxType(argumentValue, parameterType);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if (!AsmUtil.isPrimitive((Type)parameterType) && AsmUtil.isPrimitive((Type)argumentType) && (Intrinsics.areEqual((Object)parameterType, (Object)FrameVisitor.Companion.getOBJECT_TYPE()) || Intrinsics.areEqual((Object)parameterType, (Object)AsmUtil.boxType((Type)argumentType)))) {
                return eval.boxType(argumentValue);
            }
            return argumentValue;
        }

        private final com.sun.jdi.Value toJdiValue(@NotNull InterpreterResult $receiver, EvaluationContextImpl context) {
            Object object;
            block11: {
                VirtualMachine vm;
                Value jdiValue;
                block10: {
                    InterpreterResult interpreterResult = $receiver;
                    if (!(interpreterResult instanceof ValueReturned)) {
                        if (interpreterResult instanceof ExceptionThrown) {
                            if (((ExceptionThrown)$receiver).getKind() == ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE) {
                                Object object2 = ((ExceptionThrown)$receiver).getException().getValue();
                                if (object2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                                }
                                Void void_ = this.exception(new InvocationException((ObjectReference)object2));
                                throw null;
                            }
                            if (((ExceptionThrown)$receiver).getKind() == ExceptionThrown.ExceptionKind.BROKEN_CODE) {
                                Object object3 = ((ExceptionThrown)$receiver).getException().getValue();
                                if (object3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                                }
                                throw (Throwable)object3;
                            }
                            Void void_ = this.exception(((ExceptionThrown)$receiver).getException().toString());
                            throw null;
                        }
                        if (interpreterResult instanceof AbnormalTermination) {
                            Void void_ = this.exception(((AbnormalTermination)$receiver).getMessage());
                            throw null;
                        }
                        throw (Throwable)new IllegalStateException("Unknown result value produced by eval4j");
                    }
                    jdiValue = ((ValueReturned)$receiver).getResult();
                    DebugProcessImpl debugProcessImpl = context.getDebugProcess();
                    Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
                    VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"context.debugProcess.virtualMachineProxy");
                    vm = virtualMachineProxyImpl.getVirtualMachine();
                    Value sharedVar = new FrameVisitor(context).getValueIfSharedVar(jdiValue, jdiValue.getAsmType(), false);
                    object = sharedVar;
                    if (object == null) break block10;
                    VirtualMachine virtualMachine = vm;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"vm");
                    if ((object = JdiValuesKt.asJdiValue((Value)object, (VirtualMachine)virtualMachine, (Type)sharedVar.getAsmType())) != null) break block11;
                }
                VirtualMachine virtualMachine = vm;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"vm");
                object = JdiValuesKt.asJdiValue((Value)jdiValue, (VirtualMachine)virtualMachine, (Type)jdiValue.getAsmType());
            }
            return object;
        }

        private final KotlinDebuggerCaches.ParametersDescriptor getParametersForDebugger(@NotNull ExtractionResult $receiver, KtCodeFragment fragment) {
            return (KotlinDebuggerCaches.ParametersDescriptor)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KotlinDebuggerCaches.ParametersDescriptor>($receiver, fragment){
                final /* synthetic */ ExtractionResult receiver$0;
                final /* synthetic */ KtCodeFragment $fragment;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final KotlinDebuggerCaches.ParametersDescriptor invoke() {
                    void var3_3;
                    PsiFile contextElementFile;
                    HashMap<K, V> valuesForLabels = new HashMap<K, V>();
                    PsiElement psiElement = this.$fragment.getContext();
                    Object object = contextElementFile = psiElement != null ? psiElement.getContainingFile() : null;
                    if (contextElementFile instanceof KtCodeFragment) {
                        contextElementFile.accept((PsiElementVisitor)new KtTreeVisitorVoid(valuesForLabels){
                            final /* synthetic */ HashMap $valuesForLabels;

                            public void visitProperty(@NotNull KtProperty property) {
                                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                                com.sun.jdi.Value value = (com.sun.jdi.Value)property.getUserData(KotlinCodeFragmentFactory.Companion.getLABEL_VARIABLE_VALUE_KEY());
                                if (value != null) {
                                    String string = property.getName();
                                    String string2 = string != null ? KtPsiUtilKt.quoteIfNeeded((String)string) : null;
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    this.$valuesForLabels.put(string2, JdiValuesKt.asValue((com.sun.jdi.Value)value));
                                }
                            }
                            {
                                this.$valuesForLabels = $captured_local_variable$0;
                            }
                        });
                    }
                    KotlinDebuggerCaches.ParametersDescriptor parameters = new KotlinDebuggerCaches.ParametersDescriptor();
                    Parameter receiver = this.receiver$0.getConfig().getDescriptor().getReceiverParameter();
                    if (receiver != null) {
                        KotlinDebuggerCaches.ParametersDescriptor.add$default(parameters, KotlinEvaluationBuilderKt.getTHIS_NAME(), receiver.getParameterType(true), null, 4, null);
                    }
                    for (Parameter param : this.receiver$0.getConfig().getDescriptor().getParameters()) {
                        String string;
                        if (StringsKt.contains$default((CharSequence)param.getArgumentText(), (CharSequence)"@", (boolean)false, (int)2, null)) {
                            string = StringsKt.substringBefore$default((String)param.getArgumentText(), (String)"@", null, (int)2, null);
                        } else if (StringsKt.startsWith$default((String)param.getArgumentText(), (String)"::", (boolean)false, (int)2, null)) {
                            String string2 = param.getArgumentText();
                            int n = 2;
                            String string3 = string2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string4 = string3.substring(n);
                            string = string4;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        } else {
                            string = param.getArgumentText();
                        }
                        String paramName = string;
                        parameters.add(paramName, param.getParameterType(true), (Value)valuesForLabels.get(paramName));
                    }
                    return var3_3;
                }
                {
                    this.receiver$0 = extractionResult;
                    this.$fragment = ktCodeFragment;
                    super(0);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Value> getArgumentsForEval4j(@NotNull EvaluationContextImpl $receiver, KotlinDebuggerCaches.ParametersDescriptor parameters, Type[] parameterTypes) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            FrameVisitor frameVisitor = new FrameVisitor($receiver);
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.zip((Iterable)parameters, (Object[])parameterTypes);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                Value value;
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                if (((KotlinDebuggerCaches.Parameter)it.getFirst()).getValue() != null) {
                    value = ((KotlinDebuggerCaches.Parameter)it.getFirst()).getValue();
                    if (value == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    value = frameVisitor.findValue(((KotlinDebuggerCaches.Parameter)it.getFirst()).getCallText(), (Type)it.getSecond(), false, true);
                    if (value == null) {
                        Intrinsics.throwNpe();
                    }
                }
                Value result2 = value;
                Logger logger = KotlinEvaluationBuilderKt.getLOG();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    KotlinEvaluationBuilderKt.getLOG().debug("Parameter for eval4j: name = " + ((KotlinDebuggerCaches.Parameter)it.getFirst()).getCallText() + ", type = " + (Type)it.getSecond() + ", value = " + result2);
                }
                Value value2 = result2;
                collection.add(value2);
            }
            return (List)destination$iv$iv;
        }

        private final ClassFileFactory createClassFileFactory(KtCodeFragment codeFragment, KtNamedFunction extractedFunction, EvaluationContextImpl context, KotlinDebuggerCaches.ParametersDescriptor parameters) {
            return (ClassFileFactory)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<ClassFileFactory>(codeFragment, extractedFunction, context, parameters){
                final /* synthetic */ KtCodeFragment $codeFragment;
                final /* synthetic */ KtNamedFunction $extractedFunction;
                final /* synthetic */ EvaluationContextImpl $context;
                final /* synthetic */ KotlinDebuggerCaches.ParametersDescriptor $parameters;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ClassFileFactory invoke() {
                    void bindingContext2;
                    void moduleDescriptor;
                    KtFile fileForDebugger = KotlinEvaluationBuilderKt.access$createFileForDebugger(this.$codeFragment, this.$extractedFunction);
                    Logger logger = KotlinEvaluationBuilderKt.getLOG();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                    if (logger.isDebugEnabled()) {
                        KotlinEvaluationBuilderKt.getLOG().debug("File for eval4j:\n" + (String)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<String>(fileForDebugger){
                            final /* synthetic */ KtFile $fileForDebugger;

                            public final String invoke() {
                                return this.$fileForDebugger.getText();
                            }
                            {
                                this.$fileForDebugger = ktFile;
                                super(0);
                            }
                        })));
                    }
                    ExtendedAnalysisResult extendedAnalysisResult = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$checkForErrors(KotlinEvaluator.Companion, fileForDebugger, true, this.$codeFragment.getContextContainingFile());
                    BindingContext bindingContext3 = extendedAnalysisResult.component1();
                    ModuleDescriptor moduleDescriptor2 = extendedAnalysisResult.component2();
                    List<KtFile> files = extendedAnalysisResult.component3();
                    GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(fileForDebugger){
                        final /* synthetic */ KtFile $fileForDebugger;

                        public boolean shouldGeneratePackagePart(@NotNull KtFile ktFile) {
                            Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
                            return Intrinsics.areEqual((Object)ktFile, (Object)this.$fileForDebugger);
                        }

                        public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
                            Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                            return true;
                        }

                        public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
                            Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                            return Intrinsics.areEqual((Object)processingClassOrObject.getContainingKtFile(), (Object)this.$fileForDebugger);
                        }

                        public boolean shouldGenerateScript(@NotNull KtScript script) {
                            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                            return false;
                        }
                        {
                            this.$fileForDebugger = $captured_local_variable$0;
                        }
                    };
                    Project project = fileForDebugger.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"fileForDebugger.project");
                    ClassBuilderFactory classBuilderFactory = !KotlinEvaluationBuilderKt.access$getDEBUG_MODE$p() ? ClassBuilderFactories.BINARIES : ClassBuilderFactories.TEST;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"if (!DEBUG_MODE) ClassBu\u2026lassBuilderFactories.TEST");
                    CompilerConfiguration compilerConfiguration = CompilerConfiguration.EMPTY;
                    Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"CompilerConfiguration.EMPTY");
                    GenerationState state = new GenerationState.Builder(project, classBuilderFactory, (ModuleDescriptor)moduleDescriptor, (BindingContext)bindingContext2, files, compilerConfiguration).generateDeclaredClassFilter(generateClassFilter2).build();
                    FrameVisitor frameVisitor = new FrameVisitor(this.$context);
                    KtTypeReference ktTypeReference = this.$extractedFunction.getReceiverTypeReference();
                    if (ktTypeReference != null) {
                        KtTypeReference ktTypeReference2;
                        KtTypeReference it = ktTypeReference2 = ktTypeReference;
                        BindingTrace bindingTrace = state.getBindingTrace();
                        KtTypeReference ktTypeReference3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference3, (String)"it");
                        org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$recordAnonymousType(KotlinEvaluator.Companion, bindingTrace, ktTypeReference3, KotlinEvaluationBuilderKt.getTHIS_NAME(), frameVisitor);
                    }
                    List valueParameters = this.$extractedFunction.getValueParameters();
                    int paramIndex = 0;
                    for (KotlinDebuggerCaches.Parameter param : this.$parameters) {
                        KtParameter valueParameter;
                        KtParameter ktParameter = valueParameter = (KtParameter)valueParameters.get(paramIndex++);
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"valueParameter");
                        KtTypeReference paramRef = ktParameter.getTypeReference();
                        if (paramRef == null) {
                            KotlinEvaluationBuilderKt.getLOG().error("Each parameter for extracted function should have a type reference", new Attachment[]{new Attachment("codeFragment.txt", this.$codeFragment.getText()), new Attachment("extractedFunction.txt", this.$extractedFunction.getText())});
                            Void void_ = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$exception(KotlinEvaluator.Companion, "An exception occurs during Evaluate Expression Action");
                            throw null;
                        }
                        org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$recordAnonymousType(KotlinEvaluator.Companion, state.getBindingTrace(), paramRef, param.getCallText(), frameVisitor);
                    }
                    KotlinCodegenFacade.compileCorrectFiles((GenerationState)state, (CompilationErrorHandler)CompilationErrorHandler.THROW_EXCEPTION);
                    return state.getFactory();
                }
                {
                    this.$codeFragment = ktCodeFragment;
                    this.$extractedFunction = ktNamedFunction;
                    this.$context = evaluationContextImpl;
                    this.$parameters = parametersDescriptor;
                    super(0);
                }
            }));
        }

        private final void recordAnonymousType(@NotNull BindingTrace $receiver, KtTypeReference typeReference, String localVariableName, FrameVisitor visitor) {
            ClassifierDescriptor declarationDescriptor;
            KotlinType paramAnonymousType = CodeFragmentUtilKt.getDebugTypeInfo((KtTypeReference)typeReference);
            if (paramAnonymousType != null && (declarationDescriptor = paramAnonymousType.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
                Value value = visitor.findValue(localVariableName, null, false, false);
                if (value == null) {
                    Void void_ = this.exception("Couldn't find local variable this in current frame to get classType for anonymous type " + paramAnonymousType + '}');
                    throw null;
                }
                Value localVariable = value;
                $receiver.record(CodegenBinding.ASM_TYPE, (Object)declarationDescriptor, (Object)localVariable.getAsmType());
                Logger logger = KotlinEvaluationBuilderKt.getLOG();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
                if (logger.isDebugEnabled()) {
                    KotlinEvaluationBuilderKt.getLOG().debug("Asm type " + localVariable.getAsmType().getClassName() + " was recorded for " + ((ClassDescriptor)declarationDescriptor).getName());
                }
            }
        }

        private final Void exception(String msg) {
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)msg);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.createEvaluateException(msg)");
            throw (Throwable)evaluateException;
        }

        private final Void exception(Throwable e) {
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.createEvaluateException(e)");
            throw (Throwable)evaluateException;
        }

        private final ExtendedAnalysisResult checkForErrors(@NotNull KtFile $receiver, boolean analyzeInlineFunctions, KtFile contextFile) {
            return (ExtendedAnalysisResult)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)((Function0)new Function0<ExtendedAnalysisResult>($receiver, contextFile, analyzeInlineFunctions){
                final /* synthetic */ KtFile receiver$0;
                final /* synthetic */ KtFile $contextFile;
                final /* synthetic */ boolean $analyzeInlineFunctions;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ExtendedAnalysisResult invoke() {
                    ExtendedAnalysisResult extendedAnalysisResult;
                    Object v4;
                    Iterable $receiver$iv;
                    BindingContext bindingContext2;
                    AnalysisResult analysisResult;
                    ResolutionFacade resolutionFacade;
                    block9: {
                        Iterator<T> $receiver$iv$iv;
                        try {
                            AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)this.receiver$0));
                        }
                        catch (IllegalArgumentException e) {
                            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)e.getMessage());
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026luateException(e.message)");
                            throw (Throwable)evaluateException;
                        }
                        List filesToAnalyze = this.$contextFile == null ? CollectionsKt.listOf((Object)this.receiver$0) : CollectionsKt.listOf((Object[])new KtFile[]{this.receiver$0, this.$contextFile});
                        Project project = this.receiver$0.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        resolutionFacade = KotlinCacheService.Companion.getInstance(project).getResolutionFacade(filesToAnalyze);
                        analysisResult = resolutionFacade.analyzeWithAllCompilerChecks((Collection)filesToAnalyze);
                        if (analysisResult.isError()) {
                            Void void_ = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$exception(KotlinEvaluator.Companion, analysisResult.getError());
                            throw null;
                        }
                        bindingContext2 = analysisResult.getBindingContext();
                        Diagnostics diagnostics = bindingContext2.getDiagnostics();
                        Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics, (String)"bindingContext.diagnostics");
                        Iterable iterable = $receiver$iv = (Iterable)diagnostics;
                        Collection destination$iv$iv = new ArrayList<E>();
                        Iterator<T> iterator = $receiver$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            T element$iv$iv = iterator.next();
                            Diagnostic it = (Diagnostic)element$iv$iv;
                            if (!(!KotlinEvaluator.access$getIGNORED_DIAGNOSTICS$cp().contains(it.getFactory()))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List filteredDiagnostics = (List)destination$iv$iv;
                        $receiver$iv = filteredDiagnostics;
                        for (T element$iv : $receiver$iv) {
                            Diagnostic it = (Diagnostic)element$iv;
                            if (!(it.getSeverity() == Severity.ERROR)) continue;
                            v4 = element$iv;
                            break block9;
                        }
                        v4 = null;
                    }
                    Diagnostic diagnostic = v4;
                    if (diagnostic != null) {
                        Iterable it = $receiver$iv = diagnostic;
                        PsiElement psiElement = it.getPsiElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it.psiElement");
                        if (Intrinsics.areEqual((Object)psiElement.getContainingFile(), (Object)this.receiver$0)) {
                            String string = DefaultErrorMessages.render((Diagnostic)it);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DefaultErrorMessages.render(it)");
                            Void void_ = org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator$Companion.access$exception(KotlinEvaluator.Companion, string);
                            throw null;
                        }
                    }
                    if (this.$analyzeInlineFunctions) {
                        void newBindingContext;
                        Pair pair = DebuggerUtils.analyzeInlinedFunctions$default(DebuggerUtils.INSTANCE, resolutionFacade, this.receiver$0, false, null, 8, null);
                        $receiver$iv = (BindingContext)pair.component1();
                        List files = (List)pair.component2();
                        extendedAnalysisResult = new ExtendedAnalysisResult((BindingContext)newBindingContext, analysisResult.getModuleDescriptor(), files);
                    } else {
                        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
                        List<KtFile> list = Collections.singletonList(this.receiver$0);
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.singletonList(this)");
                        extendedAnalysisResult = new ExtendedAnalysisResult(bindingContext2, moduleDescriptor, list);
                    }
                    return extendedAnalysisResult;
                }
                {
                    this.receiver$0 = ktFile;
                    this.$contextFile = ktFile2;
                    this.$analyzeInlineFunctions = bl;
                    super(0);
                }
            }));
        }

        static /* bridge */ /* synthetic */ ExtendedAnalysisResult checkForErrors$default(Companion companion, KtFile ktFile, boolean bl, KtFile ktFile2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                ktFile2 = null;
            }
            return companion.checkForErrors(ktFile, bl, ktFile2);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List access$getArgumentsForEval4j(Companion $this, @NotNull EvaluationContextImpl $receiver, @NotNull KotlinDebuggerCaches.ParametersDescriptor parameters, @NotNull Type[] parameterTypes) {
            return $this.getArgumentsForEval4j($receiver, parameters, parameterTypes);
        }

        public static final /* synthetic */ Object access$executeWithBreakpointsDisabled(Companion $this, @NotNull VirtualMachine $receiver, @NotNull Function0 block) {
            return $this.executeWithBreakpointsDisabled($receiver, block);
        }

        @NotNull
        public static final /* synthetic */ Value access$boxOrUnboxArgumentIfNeeded(Companion $this, @NotNull JDIEval eval, @NotNull Value argumentValue, @NotNull Type parameterType) {
            return $this.boxOrUnboxArgumentIfNeeded(eval, argumentValue, parameterType);
        }

        @NotNull
        public static final /* synthetic */ ExtendedAnalysisResult access$checkForErrors(Companion $this, @NotNull KtFile $receiver, boolean analyzeInlineFunctions, @Nullable KtFile contextFile) {
            return $this.checkForErrors($receiver, analyzeInlineFunctions, contextFile);
        }

        public static final /* synthetic */ void access$recordAnonymousType(Companion $this, @NotNull BindingTrace $receiver, @NotNull KtTypeReference typeReference, @NotNull String localVariableName, @NotNull FrameVisitor visitor) {
            $this.recordAnonymousType($receiver, typeReference, localVariableName, visitor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion$ExtendedAnalysisResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFiles", "()Ljava/util/List;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea-jvm"})
        private static final class ExtendedAnalysisResult {
            @NotNull
            private final BindingContext bindingContext;
            @NotNull
            private final ModuleDescriptor moduleDescriptor;
            @NotNull
            private final List<KtFile> files;

            @NotNull
            public final BindingContext getBindingContext() {
                return this.bindingContext;
            }

            @NotNull
            public final ModuleDescriptor getModuleDescriptor() {
                return this.moduleDescriptor;
            }

            @NotNull
            public final List<KtFile> getFiles() {
                return this.files;
            }

            public ExtendedAnalysisResult(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                this.bindingContext = bindingContext2;
                this.moduleDescriptor = moduleDescriptor;
                this.files = files;
            }

            @NotNull
            public final BindingContext component1() {
                return this.bindingContext;
            }

            @NotNull
            public final ModuleDescriptor component2() {
                return this.moduleDescriptor;
            }

            @NotNull
            public final List<KtFile> component3() {
                return this.files;
            }

            @NotNull
            public final ExtendedAnalysisResult copy(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files) {
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                return new ExtendedAnalysisResult(bindingContext2, moduleDescriptor, files);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ExtendedAnalysisResult copy$default(ExtendedAnalysisResult extendedAnalysisResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    bindingContext2 = extendedAnalysisResult.bindingContext;
                }
                if ((n & 2) != 0) {
                    moduleDescriptor = extendedAnalysisResult.moduleDescriptor;
                }
                if ((n & 4) != 0) {
                    list = extendedAnalysisResult.files;
                }
                return extendedAnalysisResult.copy(bindingContext2, moduleDescriptor, list);
            }

            public String toString() {
                return "ExtendedAnalysisResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ")";
            }

            public int hashCode() {
                BindingContext bindingContext2 = this.bindingContext;
                ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
                List<KtFile> list = this.files;
                return ((bindingContext2 != null ? bindingContext2.hashCode() : 0) * 31 + (moduleDescriptor != null ? moduleDescriptor.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ExtendedAnalysisResult)) break block3;
                        ExtendedAnalysisResult extendedAnalysisResult = (ExtendedAnalysisResult)object;
                        if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)extendedAnalysisResult.bindingContext) || !Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)extendedAnalysisResult.moduleDescriptor) || !Intrinsics.areEqual(this.files, extendedAnalysisResult.files)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

