/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0005R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\rR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinLambdaSmartStepTarget;", "Lcom/intellij/debugger/actions/SmartStepTarget;", "label", "", "highlightElement", "Lorg/jetbrains/kotlin/psi/KtFunction;", "lines", "Lcom/intellij/util/Range;", "", "isInline", "", "isSuspend", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtFunction;Lcom/intellij/util/Range;ZZ)V", "()Z", "getIcon", "Ljavax/swing/Icon;", "getLambda", "Companion", "idea-jvm"})
public final class KotlinLambdaSmartStepTarget
extends SmartStepTarget {
    private final boolean isInline;
    private final boolean isSuspend;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Icon getIcon() {
        Icon icon = KotlinIcons.LAMBDA;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"KotlinIcons.LAMBDA");
        return icon;
    }

    @NotNull
    public final KtFunction getLambda() {
        PsiElement psiElement = this.getHighlightElement();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        return (KtFunction)psiElement;
    }

    public final boolean isInline() {
        return this.isInline;
    }

    public final boolean isSuspend() {
        return this.isSuspend;
    }

    public KotlinLambdaSmartStepTarget(@NotNull String label2, @NotNull KtFunction highlightElement, @NotNull Range<Integer> lines, boolean isInline, boolean isSuspend) {
        Intrinsics.checkParameterIsNotNull((Object)label2, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        super(label2, (PsiElement)highlightElement, true, lines);
        this.isInline = isInline;
        this.isSuspend = isSuspend;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinLambdaSmartStepTarget$Companion;", "", "()V", "calcLabel", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "paramName", "Lorg/jetbrains/kotlin/name/Name;", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final String calcLabel(@NotNull DeclarationDescriptor descriptor2, @NotNull Name paramName) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)paramName, (String)"paramName");
            return descriptor2.getName().asString() + ": " + paramName.asString() + '.' + OperatorNameConventions.INVOKE.asString() + "()";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

