/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\fH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodSmartStepTarget;", "Lcom/intellij/debugger/actions/SmartStepTarget;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "label", "", "highlightElement", "Lcom/intellij/psi/PsiElement;", "lines", "Lcom/intellij/util/Range;", "", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lorg/jetbrains/kotlin/psi/KtDeclaration;Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Range;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isExtension", "", "isInvoke", "()Z", "targetMethodName", "getTargetMethodName", "()Ljava/lang/String;", "equals", "other", "", "getIcon", "Ljavax/swing/Icon;", "hashCode", "Companion", "idea-jvm"})
public final class KotlinMethodSmartStepTarget
extends SmartStepTarget {
    private final boolean isInvoke;
    private final boolean isExtension;
    @NotNull
    private final String targetMethodName;
    @Nullable
    private final KtDeclaration declaration;
    private static final DescriptorRenderer renderer;
    public static final Companion Companion;

    public final boolean isInvoke() {
        return this.isInvoke;
    }

    @NotNull
    public final String getTargetMethodName() {
        return this.targetMethodName;
    }

    @Nullable
    public Icon getIcon() {
        return this.isExtension ? KotlinIcons.EXTENSION_FUNCTION : KotlinIcons.FUNCTION;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof KotlinMethodSmartStepTarget)) {
            return false;
        }
        if (this.isInvoke && ((KotlinMethodSmartStepTarget)((Object)other)).isInvoke) {
            return true;
        }
        return this.declaration == ((KotlinMethodSmartStepTarget)((Object)other)).declaration;
    }

    public int hashCode() {
        if (this.isInvoke) {
            return 42;
        }
        KtDeclaration ktDeclaration = this.declaration;
        if (ktDeclaration == null) {
            Intrinsics.throwNpe();
        }
        return ktDeclaration.hashCode();
    }

    @Nullable
    public final KtDeclaration getDeclaration() {
        return this.declaration;
    }

    public KotlinMethodSmartStepTarget(@NotNull CallableMemberDescriptor descriptor2, @Nullable KtDeclaration declaration2, @NotNull String label2, @NotNull PsiElement highlightElement, @NotNull Range<Integer> lines) {
        String string;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)label2, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        super(label2, highlightElement, false, lines);
        this.declaration = declaration2;
        this.isInvoke = descriptor2 instanceof FunctionInvokeDescriptor;
        boolean bl2 = bl = this.declaration != null || this.isInvoke;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.isExtension = DescriptorUtilsKt.isExtension((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
        CallableMemberDescriptor callableMemberDescriptor = descriptor2;
        if (callableMemberDescriptor instanceof ClassDescriptor || callableMemberDescriptor instanceof ConstructorDescriptor) {
            string = "<init>";
        } else if (callableMemberDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
            String string3 = JvmAbi.getterName((String)propertyDescriptor.getName().asString());
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"JvmAbi.getterName(descri\u2026Property.name.asString())");
        } else {
            String string4 = descriptor2.getName().asString();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"descriptor.name.asString()");
        }
        this.targetMethodName = string;
    }

    static {
        Companion = new Companion(null);
        renderer = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.withOptions((Function1)Companion.renderer.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodSmartStepTarget$Companion;", "", "()V", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "calcLabel", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final String calcLabel(@NotNull DeclarationDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            return renderer.render(descriptor2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

