/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.SimplePropertyGetterProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSimpleGetterProvider;", "Lcom/intellij/debugger/engine/SimplePropertyGetterProvider;", "()V", "isInsideSimpleGetter", "", "element", "Lcom/intellij/psi/PsiElement;", "idea-jvm"})
public final class KotlinSimpleGetterProvider
implements SimplePropertyGetterProvider {
    public boolean isInsideSimpleGetter(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof KtParameter) {
            return true;
        }
        KtPropertyAccessor accessor = (KtPropertyAccessor)PsiTreeUtil.getParentOfType((PsiElement)element, KtPropertyAccessor.class);
        if (accessor != null && accessor.isGetter()) {
            boolean bl;
            KtExpression body = accessor.getBodyExpression();
            KtExpression ktExpression = body;
            if (ktExpression instanceof KtBlockExpression) {
                KtReturnExpression ktReturnExpression;
                List list = ((KtBlockExpression)body).getStatements();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"body.statements");
                Object object = CollectionsKt.singleOrNull((List)list);
                if (!(object instanceof KtReturnExpression)) {
                    object = null;
                }
                if ((ktReturnExpression = (KtReturnExpression)object) == null || (ktReturnExpression = ktReturnExpression.getReturnedExpression()) == null) {
                    return false;
                }
                KtReturnExpression returnedExpression = ktReturnExpression;
                bl = returnedExpression.textMatches((CharSequence)"field");
            } else {
                bl = ktExpression instanceof KtExpression ? body.textMatches((CharSequence)"field") : false;
            }
            return bl;
        }
        KtProperty property = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)element, KtProperty.class);
        if (property != null) {
            return property.getGetter() == null && !property.isLocal();
        }
        return false;
    }
}

