/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.ThreadBlockedMonitor;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepOverInlinedLinesHint;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 62\u00020\u0001:\u0003678B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0002J!\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,H\u0002\u00a2\u0006\u0002\u0010-J\u001d\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010*2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002\u00a2\u0006\u0002\u00100J\u001b\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010*2\u0006\u00101\u001a\u000202H\u0002\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u000202H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory;", "", "debuggerProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "debugProcessDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/debugger/engine/DebugProcessListener;", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "getDebuggerContext", "()Lcom/intellij/debugger/impl/DebuggerContextImpl;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/debugger/impl/DebuggerSession;", "getSession", "()Lcom/intellij/debugger/impl/DebuggerSession;", "suspendManager", "Lcom/intellij/debugger/engine/SuspendManager;", "getSuspendManager", "()Lcom/intellij/debugger/engine/SuspendManager;", "threadBlockedMonitor", "Lcom/intellij/debugger/engine/ThreadBlockedMonitor;", "createKotlinStepOverInlineAction", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$KotlinStepAction;", "smartStepFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;", "doStep", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "size", "", "depth", "hint", "Lcom/intellij/debugger/engine/RequestHint;", "getFromField", "T", "fieldType", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "field", "Ljava/lang/reflect/Field;", "(Ljava/lang/reflect/Field;)Ljava/lang/Object;", "fieldName", "", "(Ljava/lang/String;)Ljava/lang/Object;", "showStatusText", "message", "Companion", "KotlinStepAction", "StepOverInlineCommand", "idea-jvm"})
public final class KotlinStepActionFactory {
    private final EventDispatcher<DebugProcessListener> debugProcessDispatcher;
    private final ThreadBlockedMonitor threadBlockedMonitor;
    private final DebugProcessImpl debuggerProcess;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final KotlinStepAction createKotlinStepOverInlineAction(@NotNull KotlinMethodFilter smartStepFilter) {
        Intrinsics.checkParameterIsNotNull((Object)smartStepFilter, (String)"smartStepFilter");
        return new StepOverInlineCommand(smartStepFilter, -2);
    }

    private final DebuggerContextImpl getDebuggerContext() {
        DebuggerContextImpl debuggerContextImpl = this.debuggerProcess.getDebuggerContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"debuggerProcess.debuggerContext");
        return debuggerContextImpl;
    }

    private final SuspendManager getSuspendManager() {
        SuspendManager suspendManager = this.debuggerProcess.getSuspendManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendManager, (String)"debuggerProcess.suspendManager");
        return suspendManager;
    }

    private final Project getProject() {
        Project project = this.debuggerProcess.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debuggerProcess.project");
        return project;
    }

    private final DebuggerSession getSession() {
        DebuggerSession debuggerSession = this.debuggerProcess.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerSession, (String)"debuggerProcess.session");
        return debuggerSession;
    }

    private final void showStatusText(String message) {
        this.debuggerProcess.showStatusText(message);
    }

    private final void doStep(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread, int size, int depth, RequestHint hint) {
        Method doStepMethod;
        Method method = doStepMethod = DebugProcessImpl.class.getDeclaredMethod("doStep", SuspendContextImpl.class, ThreadReferenceProxyImpl.class, Integer.TYPE, Integer.TYPE, RequestHint.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"doStepMethod");
        method.setAccessible(true);
        doStepMethod.invoke((Object)this.debuggerProcess, suspendContext, stepThread, size, depth, hint);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T getFromField(Class<T> fieldType) {
        void var3_4;
        void $receiver$iv;
        Field[] fieldArray = DebugProcessImpl.class.getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldArray, (String)"DebugProcessImpl::class.java.declaredFields");
        Field[] fieldArray2 = fieldArray;
        KotlinStepActionFactory kotlinStepActionFactory = this;
        Object single$iv = null;
        boolean found$iv = false;
        int n = ((void)$receiver$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it;
            void v1 = it = (element$iv = $receiver$iv[i]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!Intrinsics.areEqual(v1.getType(), fieldType)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        void var12_10 = var3_4;
        return kotlinStepActionFactory.getFromField((Field)var12_10);
    }

    private final <T> T getFromField(String fieldName) {
        return this.getFromField(DebugProcessImpl.class.getDeclaredField(fieldName));
    }

    private final <T> T getFromField(Field field) {
        Field field2 = field;
        if (field2 == null) {
            Intrinsics.throwNpe();
        }
        field2.setAccessible(true);
        return (T)field.get(this.debuggerProcess);
    }

    public KotlinStepActionFactory(@NotNull DebugProcessImpl debuggerProcess) {
        Intrinsics.checkParameterIsNotNull((Object)debuggerProcess, (String)"debuggerProcess");
        this.debuggerProcess = debuggerProcess;
        this.debugProcessDispatcher = (EventDispatcher)this.getFromField("myDebugProcessDispatcher");
        this.threadBlockedMonitor = this.getFromField(ThreadBlockedMonitor.class);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinStepActionFactory.class);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$KotlinStepAction;", "", "()V", "contextAction", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "idea-jvm"})
    public static abstract class KotlinStepAction {
        public abstract void contextAction(@NotNull SuspendContextImpl var1);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$StepOverInlineCommand;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$KotlinStepAction;", "mySmartStepFilter", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;", "myStepSize", "", "(Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory;Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinMethodFilter;I)V", "applyThreadFilter", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "thread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "contextAction", "getContextThread", "resumeAction", "idea-jvm"})
    private final class StepOverInlineCommand
    extends KotlinStepAction {
        private final KotlinMethodFilter mySmartStepFilter;
        private final int myStepSize;

        private final ThreadReferenceProxyImpl getContextThread(SuspendContextImpl suspendContext) {
            ThreadReferenceProxyImpl contextThread = KotlinStepActionFactory.this.getDebuggerContext().getThreadProxy();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = contextThread;
            if (threadReferenceProxyImpl == null) {
                threadReferenceProxyImpl = suspendContext.getThread();
            }
            return threadReferenceProxyImpl;
        }

        private final void applyThreadFilter(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread) {
            if (suspendContext.getSuspendPolicy() == 2) {
                DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)KotlinStepActionFactory.this.getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
                BreakpointManager breakpointManager = debuggerManagerEx.getBreakpointManager();
                breakpointManager.applyThreadFilter(KotlinStepActionFactory.this.debuggerProcess, thread.getThreadReference());
            }
        }

        private final void resumeAction(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread) {
            if (suspendContext.getSuspendPolicy() == 1 || Companion.isResumeOnlyCurrentThread()) {
                KotlinStepActionFactory.this.threadBlockedMonitor.startWatching((ThreadReferenceProxy)thread);
            }
            if (Companion.isResumeOnlyCurrentThread() && suspendContext.getSuspendPolicy() == 2) {
                KotlinStepActionFactory.this.getSuspendManager().resumeThread(suspendContext, thread);
            } else {
                KotlinStepActionFactory.this.getSuspendManager().resume(suspendContext);
            }
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
            KotlinStepActionFactory.this.showStatusText("Stepping over inline");
            ThreadReferenceProxyImpl stepThread = this.getContextThread(suspendContext);
            if (stepThread == null) {
                KotlinStepActionFactory.this.debuggerProcess.createStepOverCommand(suspendContext, true).contextAction(suspendContext);
                return;
            }
            KotlinStepOverInlinedLinesHint hint = new KotlinStepOverInlinedLinesHint(stepThread, suspendContext, this.mySmartStepFilter);
            hint.setResetIgnoreFilters(!KotlinStepActionFactory.this.getSession().shouldIgnoreSteppingFilters());
            try {
                KotlinStepActionFactory.this.getSession().setIgnoreStepFiltersFlag(stepThread.frameCount());
            }
            catch (EvaluateException e) {
                LOG.info((Throwable)e);
            }
            this.applyThreadFilter(suspendContext, stepThread);
            KotlinStepActionFactory.this.doStep(suspendContext, stepThread, this.myStepSize, 2, hint);
            KotlinStepActionFactory.this.showStatusText("Process resumed");
            this.resumeAction(suspendContext, stepThread);
            ((DebugProcessListener)KotlinStepActionFactory.this.debugProcessDispatcher.getMulticaster()).resumed((SuspendContext)suspendContext);
        }

        public StepOverInlineCommand(KotlinMethodFilter mySmartStepFilter, int myStepSize) {
            Intrinsics.checkParameterIsNotNull((Object)mySmartStepFilter, (String)"mySmartStepFilter");
            this.mySmartStepFilter = mySmartStepFilter;
            this.myStepSize = myStepSize;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepActionFactory$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isResumeOnlyCurrentThread", "", "()Z", "idea-jvm"})
    public static final class Companion {
        private final boolean isResumeOnlyCurrentThread() {
            return DebuggerSettings.getInstance().RESUME_ONLY_CURRENT_THREAD;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

