/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.DebugProcessImplHelper;
import org.jetbrains.kotlin.idea.debugger.stepping.DebuggerSteppingHelper;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProvider$KotlinSourcePosition$Companion$create$;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSuspendCallStepOverFilter;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ \u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ(\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSteppingCommandProvider;", "Lcom/intellij/debugger/impl/JvmSteppingCommandProvider;", "()V", "getStepOutCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$ResumeCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "debugContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "stepSize", "", "getStepOverCommand", "ignoreBreakpoints", "", "debuggerContext", "isSpecialStepOverNeeded", "kotlinSourcePosition", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSteppingCommandProvider$KotlinSourcePosition;", "KotlinSourcePosition", "idea-jvm"})
public final class KotlinSteppingCommandProvider
extends JvmSteppingCommandProvider {
    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOverCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"suspendContext.debugProcess");
        DebuggerContextImpl debuggerContextImpl = debugProcessImpl.getDebuggerContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"suspendContext.debugProcess.debuggerContext");
        SourcePosition sourcePosition = debuggerContextImpl.getSourcePosition();
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        return this.getStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition2);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @NotNull DebuggerContextImpl debuggerContext) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)debuggerContext, (String)"debuggerContext");
        SourcePosition sourcePosition = debuggerContext.getSourcePosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition, (String)"debuggerContext.sourcePosition");
        return this.getStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition);
    }

    private final DebugProcessImpl.ResumeCommand getStepOverCommand(SuspendContextImpl suspendContext, boolean ignoreBreakpoints, SourcePosition sourcePosition) {
        KotlinSourcePosition kotlinSourcePosition = KotlinSourcePosition.Companion.create(sourcePosition);
        if (kotlinSourcePosition == null) {
            return null;
        }
        KotlinSourcePosition kotlinSourcePosition2 = kotlinSourcePosition;
        if (this.isSpecialStepOverNeeded(kotlinSourcePosition2)) {
            return DebuggerSteppingHelper.createStepOverCommand(suspendContext, ignoreBreakpoints, kotlinSourcePosition2);
        }
        PsiElement psiElement = sourcePosition.getElementAt();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"sourcePosition.elementAt");
        PsiFile file2 = psiElement.getContainingFile();
        DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"suspendContext.debugProcess");
        Location location2 = (Location)DebuggerUtilKt.invokeInManagerThread(debugProcessImpl, (Function1)new Function1<DebuggerContextImpl, Location>(suspendContext){
            final /* synthetic */ SuspendContextImpl $suspendContext;

            @Nullable
            public final Location invoke(@NotNull DebuggerContextImpl it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                StackFrameProxyImpl stackFrameProxyImpl = this.$suspendContext.getFrameProxy();
                return stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null;
            }
            {
                this.$suspendContext = suspendContextImpl;
                super(1);
            }
        });
        if (location2 == null) {
            return null;
        }
        Location location3 = location2;
        if (DebuggerUtilKt.isInSuspendMethod(location3) && !DebuggerUtilKt.isOnSuspendReturnOrReenter(location3) && !DebuggerUtilKt.isLastLineLocationInMethod(location3)) {
            int n = sourcePosition.getLine();
            PsiFile psiFile = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            return (DebugProcessImpl.ResumeCommand)DebugProcessImplHelper.createStepOverCommandWithCustomFilter(suspendContext, ignoreBreakpoints, new KotlinSuspendCallStepOverFilter(n, psiFile, ignoreBreakpoints));
        }
        return null;
    }

    private final boolean isSpecialStepOverNeeded(KotlinSourcePosition kotlinSourcePosition) {
        Collection collection;
        List inlineArgumentsCallsIfAny;
        boolean hasInlineCallsOnLine;
        SourcePosition sourcePosition = kotlinSourcePosition.getSourcePosition();
        Collection collection2 = KotlinSteppingCommandProviderKt.access$getInlineFunctionCallsIfAny(sourcePosition);
        boolean bl = hasInlineCallsOnLine = !collection2.isEmpty();
        if (hasInlineCallsOnLine) {
            return true;
        }
        DeclarationDescriptor containingFunctionDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)((KtDeclaration)kotlinSourcePosition.getFunction()), null, (int)1, null);
        return InlineUtil.isInline((DeclarationDescriptor)containingFunctionDescriptor) && (inlineArgumentsCallsIfAny = KotlinSteppingCommandProviderKt.access$getInlineArgumentsCallsIfAny(sourcePosition, containingFunctionDescriptor)) != null && !(collection = (Collection)inlineArgumentsCallsIfAny).isEmpty();
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOutCommand(@NotNull SuspendContextImpl suspendContext, @NotNull DebuggerContextImpl debugContext) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)debugContext, (String)"debugContext");
        SourcePosition sourcePosition = debugContext.getSourcePosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition, (String)"debugContext.sourcePosition");
        return this.getStepOutCommand(suspendContext, sourcePosition);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOutCommand(@Nullable SuspendContextImpl suspendContext, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"suspendContext.debugProcess");
        DebuggerContextImpl debuggerContextImpl = debugProcessImpl.getDebuggerContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"suspendContext.debugProcess.debuggerContext");
        SourcePosition sourcePosition = debuggerContextImpl.getSourcePosition();
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        return this.getStepOutCommand(suspendContext, sourcePosition2);
    }

    private final DebugProcessImpl.ResumeCommand getStepOutCommand(SuspendContextImpl suspendContext, SourcePosition sourcePosition) {
        PsiFile psiFile = sourcePosition.getFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return null;
        }
        KtFile file2 = ktFile;
        if (sourcePosition.getLine() < 0) {
            return null;
        }
        Integer n = KotlinRefactoringUtilKt.getLineStartOffset((PsiFile)((PsiFile)file2), (int)sourcePosition.getLine());
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        List inlineFunctions = KotlinSteppingCommandProviderKt.access$getInlineFunctionsIfAny(file2, lineStartOffset);
        KtFunctionLiteral inlinedArgument = KotlinSteppingCommandProviderKt.access$getInlineArgumentIfAny(sourcePosition.getElementAt());
        if (inlineFunctions.isEmpty() && inlinedArgument == null) {
            return null;
        }
        return DebuggerSteppingHelper.createStepOutCommand(suspendContext, true, inlineFunctions, inlinedArgument);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSteppingCommandProvider$KotlinSourcePosition;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "linesRange", "Lkotlin/ranges/IntRange;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/ranges/IntRange;Lcom/intellij/debugger/SourcePosition;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getFunction", "()Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getLinesRange", "()Lkotlin/ranges/IntRange;", "getSourcePosition", "()Lcom/intellij/debugger/SourcePosition;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "idea-jvm"})
    public static final class KotlinSourcePosition {
        @NotNull
        private final KtFile file;
        @NotNull
        private final KtNamedFunction function;
        @NotNull
        private final IntRange linesRange;
        @NotNull
        private final SourcePosition sourcePosition;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final KtFile getFile() {
            return this.file;
        }

        @NotNull
        public final KtNamedFunction getFunction() {
            return this.function;
        }

        @NotNull
        public final IntRange getLinesRange() {
            return this.linesRange;
        }

        @NotNull
        public final SourcePosition getSourcePosition() {
            return this.sourcePosition;
        }

        public KotlinSourcePosition(@NotNull KtFile file2, @NotNull KtNamedFunction function, @NotNull IntRange linesRange, @NotNull SourcePosition sourcePosition) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
            Intrinsics.checkParameterIsNotNull((Object)linesRange, (String)"linesRange");
            Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
            this.file = file2;
            this.function = function;
            this.linesRange = linesRange;
            this.sourcePosition = sourcePosition;
        }

        @NotNull
        public final KtFile component1() {
            return this.file;
        }

        @NotNull
        public final KtNamedFunction component2() {
            return this.function;
        }

        @NotNull
        public final IntRange component3() {
            return this.linesRange;
        }

        @NotNull
        public final SourcePosition component4() {
            return this.sourcePosition;
        }

        @NotNull
        public final KotlinSourcePosition copy(@NotNull KtFile file2, @NotNull KtNamedFunction function, @NotNull IntRange linesRange, @NotNull SourcePosition sourcePosition) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
            Intrinsics.checkParameterIsNotNull((Object)linesRange, (String)"linesRange");
            Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
            return new KotlinSourcePosition(file2, function, linesRange, sourcePosition);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ KotlinSourcePosition copy$default(KotlinSourcePosition kotlinSourcePosition, KtFile ktFile, KtNamedFunction ktNamedFunction, IntRange intRange, SourcePosition sourcePosition, int n, Object object) {
            if ((n & 1) != 0) {
                ktFile = kotlinSourcePosition.file;
            }
            if ((n & 2) != 0) {
                ktNamedFunction = kotlinSourcePosition.function;
            }
            if ((n & 4) != 0) {
                intRange = kotlinSourcePosition.linesRange;
            }
            if ((n & 8) != 0) {
                sourcePosition = kotlinSourcePosition.sourcePosition;
            }
            return kotlinSourcePosition.copy(ktFile, ktNamedFunction, intRange, sourcePosition);
        }

        public String toString() {
            return "KotlinSourcePosition(file=" + this.file + ", function=" + this.function + ", linesRange=" + this.linesRange + ", sourcePosition=" + this.sourcePosition + ")";
        }

        public int hashCode() {
            KtFile ktFile = this.file;
            KtNamedFunction ktNamedFunction = this.function;
            IntRange intRange = this.linesRange;
            SourcePosition sourcePosition = this.sourcePosition;
            return (((ktFile != null ? ktFile.hashCode() : 0) * 31 + (ktNamedFunction != null ? ktNamedFunction.hashCode() : 0)) * 31 + (intRange != null ? intRange.hashCode() : 0)) * 31 + (sourcePosition != null ? sourcePosition.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KotlinSourcePosition)) break block3;
                    KotlinSourcePosition kotlinSourcePosition = (KotlinSourcePosition)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)kotlinSourcePosition.file) || !Intrinsics.areEqual((Object)this.function, (Object)kotlinSourcePosition.function) || !Intrinsics.areEqual((Object)this.linesRange, (Object)kotlinSourcePosition.linesRange) || !Intrinsics.areEqual((Object)this.sourcePosition, (Object)kotlinSourcePosition.sourcePosition)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSteppingCommandProvider$KotlinSourcePosition$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSteppingCommandProvider$KotlinSourcePosition;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "idea-jvm"})
        public static final class Companion {
            @Nullable
            public final KotlinSourcePosition create(@NotNull SourcePosition sourcePosition) {
                Object v4;
                KtFile file2;
                block8: {
                    Sequence $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
                    PsiFile psiFile = sourcePosition.getFile();
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    KtFile ktFile = (KtFile)psiFile;
                    if (ktFile == null) {
                        return null;
                    }
                    file2 = ktFile;
                    if (sourcePosition.getLine() < 0) {
                        return null;
                    }
                    PsiElement psiElement = sourcePosition.getElementAt();
                    if (psiElement == null) {
                        return null;
                    }
                    PsiElement elementAt = psiElement;
                    Sequence sequence = PsiUtilsKt.getParents((PsiElement)elementAt);
                    Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)KotlinSourcePosition$Companion$create$$inlined$filterIsInstance$1.INSTANCE);
                    if (sequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    $receiver$iv = sequence2;
                    for (Object element$iv : $receiver$iv) {
                        KtNamedFunction it = (KtNamedFunction)element$iv;
                        if (!(!it.isLocal())) continue;
                        v4 = element$iv;
                        break block8;
                    }
                    v4 = null;
                }
                KtNamedFunction ktNamedFunction = v4;
                if (ktNamedFunction == null) {
                    return null;
                }
                KtNamedFunction containingFunction = ktNamedFunction;
                int startLineNumber = KotlinRefactoringUtilKt.getLineNumber((PsiElement)((PsiElement)containingFunction), (boolean)true) + 1;
                int endLineNumber = KotlinRefactoringUtilKt.getLineNumber((PsiElement)((PsiElement)containingFunction), (boolean)false) + 1;
                if (startLineNumber > endLineNumber) {
                    return null;
                }
                int n = startLineNumber;
                IntRange linesRange = new IntRange(n, endLineNumber);
                return new KotlinSourcePosition(file2, containingFunction, linesRange, sourcePosition);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

