/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.Processor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.injection.InjectionInfo;
import org.jetbrains.kotlin.idea.injection.KotlinLanguageInjectionSupportKt;
import org.jetbrains.kotlin.idea.patterns.KotlinPatterns;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0011H\u0016J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\u000bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0019\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u001e\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/injection/KotlinLanguageInjectionSupport;", "Lorg/intellij/plugins/intelliLang/inject/AbstractLanguageInjectionSupport;", "()V", "addInjectionInPlace", "", "language", "Lcom/intellij/lang/Language;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "findAnnotationInjectionLanguageId", "Lorg/jetbrains/kotlin/idea/injection/InjectionInfo;", "Lorg/jetbrains/kotlin/psi/KtElement;", "findAnnotationInjectionLanguageId$idea_jvm", "findCommentInjection", "Lorg/intellij/plugins/intelliLang/inject/config/BaseInjection;", "Lcom/intellij/psi/PsiElement;", "commentRef", "Lcom/intellij/openapi/util/Ref;", "findInjectionComment", "Lcom/intellij/psi/PsiComment;", "getId", "", "getPatternClasses", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/idea/patterns/KotlinPatterns;", "()[Ljava/lang/Class;", "isApplicableTo", "removeInjectionInPlace", "psiElement", "useDefaultInjector", "idea-jvm"})
public final class KotlinLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    @NotNull
    public String getId() {
        return KotlinLanguageInjectionSupportKt.getKOTLIN_SUPPORT_ID();
    }

    @NotNull
    public Class<KotlinPatterns>[] getPatternClasses() {
        return new Class[]{KotlinPatterns.class};
    }

    public boolean isApplicableTo(@Nullable PsiLanguageInjectionHost host) {
        return host instanceof KtElement;
    }

    public boolean useDefaultInjector(@Nullable PsiLanguageInjectionHost host) {
        return false;
    }

    public boolean addInjectionInPlace(@Nullable Language language, @Nullable PsiLanguageInjectionHost host) {
        Configuration.AdvancedConfiguration configuration;
        if (language == null || host == null) {
            return false;
        }
        Configuration configuration2 = Configuration.getProjectInstance((Project)host.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"Configuration.getProjectInstance(host.project)");
        Configuration.AdvancedConfiguration advancedConfiguration = configuration = configuration2.getAdvancedConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)advancedConfiguration, (String)"configuration");
        if (!advancedConfiguration.isSourceModificationAllowed()) {
            host.putUserData(InjectLanguageAction.FIX_KEY, new Processor<PsiLanguageInjectionHost>(language){
                final /* synthetic */ Language $language;

                public final boolean process(@Nullable PsiLanguageInjectionHost fixHost) {
                    return fixHost != null && KotlinLanguageInjectionSupportKt.access$addInjectionInstructionInCode(this.$language, fixHost);
                }
                {
                    this.$language = language;
                }
            });
            return false;
        }
        if (!KotlinLanguageInjectionSupportKt.access$addInjectionInstructionInCode(language, host)) {
            return false;
        }
        TemporaryPlacesRegistry.getInstance((Project)host.getProject()).addHostWithUndo(host, InjectedLanguage.create((String)language.getID()));
        return true;
    }

    public boolean removeInjectionInPlace(@Nullable PsiLanguageInjectionHost psiElement) {
        if (psiElement == null || !(psiElement instanceof KtElement)) {
            return false;
        }
        Project project = psiElement.getProject();
        KtAnnotationEntry injectionAnnotation = KotlinLanguageInjectionSupportKt.access$findAnnotationInjection((KtElement)psiElement);
        PsiComment injectionComment = this.findInjectionComment((KtElement)psiElement);
        List injectInstructions = CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new PsiElement[]{(PsiElement)injectionAnnotation, (PsiElement)injectionComment}));
        Configuration configuration = Configuration.getProjectInstance((Project)project);
        TemporaryPlacesRegistry.getInstance((Project)project).removeHostWithUndo(project, psiElement);
        Project project2 = project;
        Configuration configuration2 = configuration;
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        configuration2.replaceInjectionsWithUndo(project2, list, list2, injectInstructions);
        return true;
    }

    @Nullable
    public BaseInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<PsiElement> commentRef) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        return null;
    }

    @Nullable
    public final BaseInjection findCommentInjection(@NotNull KtElement host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        return InjectorUtils.findCommentInjection((PsiElement)((PsiElement)host), (String)"", null);
    }

    private final PsiComment findInjectionComment(KtElement host) {
        Ref commentRef = Ref.create(null);
        if (InjectorUtils.findCommentInjection((PsiElement)((PsiElement)host), (String)"", (Ref)commentRef) == null) {
            return null;
        }
        Object object = commentRef.get();
        if (!(object instanceof PsiComment)) {
            object = null;
        }
        return (PsiComment)object;
    }

    @Nullable
    public final InjectionInfo findAnnotationInjectionLanguageId$idea_jvm(@NotNull KtElement host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        KtAnnotationEntry ktAnnotationEntry = KotlinLanguageInjectionSupportKt.access$findAnnotationInjection(host);
        if (ktAnnotationEntry == null) {
            return null;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        String string = KotlinLanguageInjectionSupportKt.access$extractLanguageFromInjectAnnotation(annotationEntry);
        if (string == null) {
            return null;
        }
        String extractLanguageFromInjectAnnotation = string;
        String prefix = KotlinLanguageInjectionSupportKt.access$extractStringArgumentByName(annotationEntry, "prefix");
        String suffix = KotlinLanguageInjectionSupportKt.access$extractStringArgumentByName(annotationEntry, "suffix");
        return new InjectionInfo(extractLanguageFromInjectAnnotation, prefix, suffix);
    }
}

