/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.injection.KotlinLanguageInjectionSupportKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0004\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\b\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\u000fH\u0002\u001a \u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002\u001a\u000e\u0010 \u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006!"}, d2={"KOTLIN_SUPPORT_ID", "", "getKOTLIN_SUPPORT_ID", "()Ljava/lang/String;", "addInjectionInstructionInCode", "", "language", "Lcom/intellij/lang/Language;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "canInjectWithAnnotation", "Lcom/intellij/psi/PsiElement;", "checkIsValidPlaceForInjectionWithLineComment", "statement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtElement;", "extractLanguageFromInjectAnnotation", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "extractStringArgumentByName", "name", "extractStringValue", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "findAnnotationInjection", "findElementToInjectWithAnnotation", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "findElementToInjectWithComment", "prevWalker", "", "element", "scope", "firstNonCommentChild", "idea-jvm"})
public final class KotlinLanguageInjectionSupportKt {
    @NonNls
    @NotNull
    private static final String KOTLIN_SUPPORT_ID = "kotlin";

    @NotNull
    public static final String getKOTLIN_SUPPORT_ID() {
        return KOTLIN_SUPPORT_ID;
    }

    private static final String extractStringArgumentByName(KtAnnotationEntry annotationEntry, String name) {
        Object v2;
        block2: {
            List list = annotationEntry.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"annotationEntry.valueArguments");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                ValueArgument it = (ValueArgument)element$iv;
                ValueArgumentName valueArgumentName = it.getArgumentName();
                if (!Intrinsics.areEqual((Object)(valueArgumentName != null && (valueArgumentName = valueArgumentName.getAsName()) != null ? valueArgumentName.asString() : null), (Object)name)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        ValueArgument valueArgument = v2;
        if (valueArgument == null) {
            return null;
        }
        ValueArgument namedArgument = valueArgument;
        return KotlinLanguageInjectionSupportKt.extractStringValue(namedArgument);
    }

    private static final String extractLanguageFromInjectAnnotation(KtAnnotationEntry annotationEntry) {
        List list = annotationEntry.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"annotationEntry.valueArguments");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument firstArgument = valueArgument;
        return KotlinLanguageInjectionSupportKt.extractStringValue(firstArgument);
    }

    private static final String extractStringValue(ValueArgument valueArgument) {
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (!(ktExpression instanceof KtStringTemplateExpression)) {
            ktExpression = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression firstStringArgument = ktStringTemplateExpression;
        Object[] objectArray = firstStringArgument.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"firstStringArgument.entries");
        KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])objectArray);
        if (ktStringTemplateEntry == null) {
            return null;
        }
        KtStringTemplateEntry firstStringEntry = ktStringTemplateEntry;
        return firstStringEntry.getText();
    }

    private static final KtAnnotationEntry findAnnotationInjection(KtElement host) {
        KtModifierListOwner ktModifierListOwner = KotlinLanguageInjectionSupportKt.findElementToInjectWithAnnotation(host);
        if (ktModifierListOwner == null) {
            return null;
        }
        KtModifierListOwner modifierListOwner = ktModifierListOwner;
        KtModifierList ktModifierList = modifierListOwner.getModifierList();
        if (ktModifierList == null) {
            return null;
        }
        KtModifierList modifierList = ktModifierList;
        int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)host));
        KtModifierList ktModifierList2 = modifierList;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierList2, (String)"modifierList");
        if (n < PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktModifierList2))) {
            return null;
        }
        return ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)modifierListOwner), (FqName)new FqName("org.intellij.lang.annotations.Language"));
    }

    private static final boolean canInjectWithAnnotation(PsiElement host) {
        Module module;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module2 == null) {
            return false;
        }
        Module module3 = module = module2;
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module3.getProject());
        return javaPsiFacade.findClass("org.intellij.lang.annotations.Language", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    private static final KtModifierListOwner findElementToInjectWithAnnotation(KtElement host) {
        return (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtModifierListOwner.class, (boolean)false, (Class[])new Class[]{KtBlockExpression.class, KtParameterList.class, KtTypeParameterList.class});
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final KtExpression findElementToInjectWithComment(KtElement host) {
        Object element$iv;
        Object v3;
        boolean bl;
        KtBlockExpression parentBlockExpression;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtBlockExpression.class, (boolean)true, (Class[])new Class[]{KtDeclaration.class});
        if (ktBlockExpression == null) return null;
        KtBlockExpression ktBlockExpression2 = parentBlockExpression = ktBlockExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktBlockExpression2, (String)"parentBlockExpression");
        List list = ktBlockExpression2.getStatements();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"parentBlockExpression.statements");
        Iterable $receiver$iv = list;
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v3 = null;
                return v3;
            }
            element$iv = iterator.next();
            KtExpression statement = (KtExpression)element$iv;
            if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)statement), (PsiElement)((PsiElement)host), (boolean)false)) {
                KtExpression ktExpression = statement;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"statement");
                if (KotlinLanguageInjectionSupportKt.checkIsValidPlaceForInjectionWithLineComment(ktExpression, host)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v3 = element$iv;
        return v3;
    }

    private static final boolean addInjectionInstructionInCode(Language language, PsiLanguageInjectionHost host) {
        PsiLanguageInjectionHost psiLanguageInjectionHost = host;
        if (!(psiLanguageInjectionHost instanceof KtElement)) {
            psiLanguageInjectionHost = null;
        }
        KtElement ktElement = (KtElement)psiLanguageInjectionHost;
        if (ktElement == null) {
            return false;
        }
        KtElement ktHost = ktElement;
        Project project = ktHost.getProject();
        KtModifierListOwner modifierListOwner = KotlinLanguageInjectionSupportKt.findElementToInjectWithAnnotation(ktHost);
        if (modifierListOwner != null && KotlinLanguageInjectionSupportKt.canInjectWithAnnotation((PsiElement)ktHost)) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            ApplicationUtilsKt.executeWriteCommand((Project)project2, (String)"Add injection annotation", (Function0)((Function0)new Function0<Unit>(modifierListOwner, language){
                final /* synthetic */ KtModifierListOwner $modifierListOwner;
                final /* synthetic */ Language $language;

                public final void invoke() {
                    ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)this.$modifierListOwner, (FqName)new FqName("org.intellij.lang.annotations.Language"), (String)('\"' + this.$language.getID() + '\"'), null, null, (int)12, null);
                }
                {
                    this.$modifierListOwner = ktModifierListOwner;
                    this.$language = language;
                    super(0);
                }
            }));
            return true;
        }
        KtModifierListOwner ktModifierListOwner = modifierListOwner;
        if (ktModifierListOwner == null || (ktModifierListOwner = KotlinLanguageInjectionSupportKt.firstNonCommentChild((PsiElement)ktModifierListOwner)) == null) {
            ktModifierListOwner = (PsiElement)KotlinLanguageInjectionSupportKt.findElementToInjectWithComment(ktHost);
        }
        if (ktModifierListOwner == null) {
            return false;
        }
        KtModifierListOwner commentBeforeAnchor = ktModifierListOwner;
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        KtPsiFactory psiFactory = new KtPsiFactory(project3, false, 2, null);
        PsiComment injectComment = psiFactory.createComment("//language=" + language.getID());
        ApplicationUtilsKt.executeWriteCommand((Project)project, (String)"Add injection comment", (Function0)((Function0)new Function0<Unit>((PsiElement)commentBeforeAnchor, injectComment){
            final /* synthetic */ PsiElement $commentBeforeAnchor;
            final /* synthetic */ PsiComment $injectComment;

            public final void invoke() {
                this.$commentBeforeAnchor.getParent().addBefore((PsiElement)this.$injectComment, this.$commentBeforeAnchor);
            }
            {
                this.$commentBeforeAnchor = psiElement;
                this.$injectComment = psiComment;
                super(0);
            }
        }));
        return true;
    }

    private static final boolean checkIsValidPlaceForInjectionWithLineComment(KtExpression statement, KtElement host) {
        int statementStartOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)statement));
        int hostStart = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)host));
        if (hostStart < statementStartOffset || hostStart - statementStartOffset > 120) {
            return false;
        }
        if (hostStart - statementStartOffset > 2) {
            boolean bl;
            block4: {
                Sequence $receiver$iv = SequencesKt.takeWhile((Sequence)SequencesKt.asSequence(KotlinLanguageInjectionSupportKt.prevWalker((PsiElement)host, (PsiElement)statement)), (Function1)checkIsValidPlaceForInjectionWithLineComment.1.INSTANCE);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it instanceof PsiLanguageInjectionHost && ((PsiLanguageInjectionHost)it).isValidHost() && !StringUtil.isEmptyOrSpaces((String)((PsiLanguageInjectionHost)it).getText()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }

    private static final PsiElement firstNonCommentChild(@NotNull PsiElement $receiver) {
        PsiElement psiElement = $receiver.getFirstChild();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"firstChild");
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null), (Function1)firstNonCommentChild.1.INSTANCE));
    }

    private static final Iterator<PsiElement> prevWalker(PsiElement element, PsiElement scope) {
        return new Iterator<PsiElement>(scope, element){
            private PsiElement e;
            final /* synthetic */ PsiElement $scope;
            final /* synthetic */ PsiElement $element;

            public boolean hasNext() {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public PsiElement next() {
                void var3_3;
                PsiElement parent;
                PsiElement current = this.e;
                if (current == null || current == this.$scope) {
                    return null;
                }
                PsiElement prev = current.getPrevSibling();
                this.e = prev != null ? PsiTreeUtil.getDeepestLast((PsiElement)prev) : ((parent = current.getParent()) == this.$scope || parent instanceof PsiFile ? null : var3_3);
                return this.e;
            }
            {
                this.$scope = $captured_local_variable$0;
                this.$element = $captured_local_variable$1;
                this.e = $captured_local_variable$1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    static {
        KOTLIN_SUPPORT_ID = KOTLIN_SUPPORT_ID;
    }

    public static final /* synthetic */ boolean access$addInjectionInstructionInCode(@NotNull Language language, @NotNull PsiLanguageInjectionHost host) {
        return KotlinLanguageInjectionSupportKt.addInjectionInstructionInCode(language, host);
    }

    @Nullable
    public static final /* synthetic */ KtAnnotationEntry access$findAnnotationInjection(@NotNull KtElement host) {
        return KotlinLanguageInjectionSupportKt.findAnnotationInjection(host);
    }

    @Nullable
    public static final /* synthetic */ String access$extractLanguageFromInjectAnnotation(@NotNull KtAnnotationEntry annotationEntry) {
        return KotlinLanguageInjectionSupportKt.extractLanguageFromInjectAnnotation(annotationEntry);
    }

    @Nullable
    public static final /* synthetic */ String access$extractStringArgumentByName(@NotNull KtAnnotationEntry annotationEntry, @NotNull String name) {
        return KotlinLanguageInjectionSupportKt.extractStringArgumentByName(annotationEntry, name);
    }
}

