/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.inspections.AddKotlinLibQuickFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddScriptRuntimeQuickFix;", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getFamilyName", "", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "getText", "Companion", "idea-jvm"})
public final class AddScriptRuntimeQuickFix
extends AddKotlinLibQuickFix {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message((String)"add.script.runtime.to.classpath", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    protected AddKotlinLibQuickFix.MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String string = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion((Module)module);
        if (string == null) {
            string = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
        }
        return new AddKotlinLibQuickFix.MavenExternalLibraryDescriptor("org.jetbrains.kotlin", "kotlin-script-runtime", string);
    }

    public AddScriptRuntimeQuickFix(@NotNull KtElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super(element, CollectionsKt.listOf((Object)LibraryJarDescriptor.SCRIPT_RUNTIME_JAR));
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddScriptRuntimeQuickFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea-jvm"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Nullable
        protected KotlinQuickFixAction<KtElement> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Diagnostic diagnostic2 = Errors.MISSING_SCRIPT_BASE_CLASS.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnostic2, (String)"Errors.MISSING_SCRIPT_BASE_CLASS.cast(diagnostic)");
            PsiElement psiElement = ((DiagnosticWithParameters1)diagnostic2).getPsiElement();
            if (!(psiElement instanceof KtScript)) {
                psiElement = null;
            }
            KtScript ktScript = (KtScript)psiElement;
            if (ktScript == null) {
                return null;
            }
            KtScript ktScript2 = ktScript;
            String string = ((KotlinScriptDefinition)ktScript2.kotlinScriptDefinition.getValue()).getTemplate().getQualifiedName();
            if (string == null) {
                return null;
            }
            String templateClassName = string;
            if (StringsKt.startsWith$default((String)templateClassName, (String)"kotlin.script.templates.standard", (boolean)false, (int)2, null)) {
                KotlinQuickFixAction kotlinQuickFixAction;
                Diagnostic $receiver$iv = diagnostic;
                PsiElement psiElement2 = $receiver$iv.getPsiElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"psiElement");
                PsiElement $receiver$iv$iv = psiElement2;
                PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtElement.class, (boolean)false);
                if (psiElement3 != null) {
                    PsiElement psiElement4 = psiElement3;
                    KtElement p1 = (KtElement)psiElement4;
                    kotlinQuickFixAction = new AddScriptRuntimeQuickFix(p1);
                } else {
                    kotlinQuickFixAction = null;
                }
                return kotlinQuickFixAction;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

