/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.api;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.api.AddToIncompatibleApiDialog;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIInspectionKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/api/AddIncompatibleApiInspectionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "()V", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "idea-jvm"})
final class AddIncompatibleApiInspectionHandler
extends EditorActionHandler {
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
        ScopeToolState incompatibleAPIToolState;
        Project project;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)caret, (String)"caret");
        if (!super.isEnabledForCaret(editor, caret, dataContext)) {
            return false;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        ScopeToolState scopeToolState = incompatibleAPIToolState = ProjectInspectionProfileManager.Companion.getInstance(project3).getCurrentProfile().getToolDefaultState("IncompatibleAPI", project);
        Intrinsics.checkExpressionValueIsNotNull((Object)scopeToolState, (String)"incompatibleAPIToolState");
        return scopeToolState.isEnabled();
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        PsiElement element;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        PsiElement psiElement = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = element = psiElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
        String string = IncompatibleAPIInspectionKt.getQualifiedNameFromProviders(psiElement2);
        if (string == null) {
            return;
        }
        String qualified = string;
        new AddToIncompatibleApiDialog(project2, qualified).show();
    }
}

