/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.api;

import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIInspection;

public class AddToIncompatibleApiDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JTextField referenceTextField;
    private JTextField reasonTextField;
    private final Project project;

    public AddToIncompatibleApiDialog(@NotNull Project project, @NotNull String qualifiedReference) {
        if (project == null) {
            AddToIncompatibleApiDialog.$$$reportNull$$$0(0);
        }
        if (qualifiedReference == null) {
            AddToIncompatibleApiDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.project = project;
        this.$$$setupUI$$$();
        this.setModal(true);
        this.setTitle("Report as Incompatible API");
        this.referenceTextField.setText(qualifiedReference);
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.reasonTextField;
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    protected void doOKAction() {
        String reference = this.referenceTextField.getText();
        String reason = this.reasonTextField.getText();
        reference = reference != null ? reference.trim() : null;
        String string = reason = reason != null ? reason.trim() : null;
        if (reference != null && !reference.isEmpty()) {
            String finalReference = reference;
            String finalReason = reason == null || reason.isEmpty() ? null : reason;
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)this.project, inspectionProfileModifiableModel -> {
                ToolsImpl toolImpl = inspectionProfileModifiableModel.getToolsOrNull("IncompatibleAPI", this.project);
                if (toolImpl != null) {
                    IncompatibleAPIInspection incompatibleAPIInspection = (IncompatibleAPIInspection)toolImpl.getDefaultState().getTool().getTool();
                    incompatibleAPIInspection.addProblem(finalReference, finalReason);
                }
            });
        }
        super.doOKAction();
    }

    public void dispose() {
        super.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 3, new Dimension(600, -1), null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Reference");
        jLabel.setDisplayedMnemonic('F');
        jLabel.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.referenceTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Reason");
        jLabel2.setDisplayedMnemonic('R');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.reasonTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "qualifiedReference";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/inspections/api/AddToIncompatibleApiDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

