/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.api;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIInspection;
import org.jetbrains.kotlin.idea.inspections.api.ProblemsCache;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\"\u0010\t\u001a\u00020\n2\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\"\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u00a8\u0006\u0011"}, d2={"findProblem", "Lorg/jetbrains/kotlin/idea/inspections/api/IncompatibleAPIInspection$Problem;", "resolvedTo", "Lcom/intellij/psi/PsiElement;", "problemsCache", "Lorg/jetbrains/kotlin/idea/inspections/api/ProblemsCache;", "getQualifiedNameFromProviders", "", "element", "registerProblemForElement", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "problem", "registerProblemForReference", "reference", "Lcom/intellij/psi/PsiReference;", "idea-jvm"})
public final class IncompatibleAPIInspectionKt {
    public static final void registerProblemForReference(@Nullable PsiReference reference, @NotNull ProblemsHolder holder, @NotNull IncompatibleAPIInspection.Problem problem) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)problem, (String)"problem");
        if (reference == null) {
            return;
        }
        String string = problem.getReason();
        if (string == null) {
            string = "Incompatible API";
        }
        holder.registerProblem(reference, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    public static final void registerProblemForElement(@Nullable PsiElement element, @NotNull ProblemsHolder holder, @NotNull IncompatibleAPIInspection.Problem problem) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)problem, (String)"problem");
        if (element == null) {
            return;
        }
        String string = problem.getReason();
        if (string == null) {
            string = "Incompatible API";
        }
        holder.registerProblem(element, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final IncompatibleAPIInspection.Problem findProblem(@Nullable PsiElement resolvedTo, @NotNull ProblemsCache problemsCache) {
        boolean bl;
        CharSequence classFqName;
        Intrinsics.checkParameterIsNotNull((Object)problemsCache, (String)"problemsCache");
        if (resolvedTo == null) {
            return null;
        }
        String string = IncompatibleAPIInspectionKt.getQualifiedNameFromProviders(resolvedTo);
        if (string == null) return null;
        String referenceStr = string;
        Map<String, IncompatibleAPIInspection.Problem> forbiddenApiReferences = problemsCache.getForbiddenApiReferences();
        IncompatibleAPIInspection.Problem problem = forbiddenApiReferences.get(referenceStr);
        if (problem == null) {
            String className;
            String lastPart = StringsKt.substringAfterLast((String)referenceStr, (char)'#', (String)"");
            CharSequence charSequence = lastPart;
            problem = charSequence.length() > 0 && StringsKt.startsWith$default((String)lastPart, (String)((className = StringsKt.substringAfterLast$default((String)(classFqName = StringsKt.substringBeforeLast$default((String)referenceStr, (char)'#', null, (int)2, null)), (char)'.', null, (int)2, null)) + '('), (boolean)false, (int)2, null) ? forbiddenApiReferences.get(classFqName) : null;
        }
        IncompatibleAPIInspection.Problem problem2 = problem;
        if (problem != null) return problem2;
        String beforeParams = StringsKt.substringBeforeLast((String)referenceStr, (char)'(', (String)"");
        classFqName = beforeParams;
        if (classFqName.length() <= 0) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        String overloadSignatureKey = beforeParams + '(';
        Iterable $receiver$iv = forbiddenApiReferences.keySet();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                if (!StringsKt.startsWith$default((String)it, (String)overloadSignatureKey, (boolean)false, (int)2, null)) continue;
                return null;
            }
            bl = false;
        }
        boolean particularOverloadPresent = bl;
        if (particularOverloadPresent) return null;
        problem2 = forbiddenApiReferences.get(beforeParams);
        return problem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String getQualifiedNameFromProviders(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        DumbService dumbService = DumbService.getInstance((Project)element.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(element.project)");
        dumbService.setAlternativeResolveEnabled(true);
        try {
            for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions((ExtensionPointName)QualifiedNameProvider.EP_NAME)) {
                String result2 = provider.getQualifiedName(element);
                if (result2 == null) continue;
                String string = result2;
                return string;
            }
        }
        finally {
            DumbService dumbService2 = DumbService.getInstance((Project)element.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)dumbService2, (String)"DumbService.getInstance(element.project)");
            dumbService2.setAlternativeResolveEnabled(false);
        }
        return null;
    }
}

