/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.jvm.JvmIrCodegenFactory;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.DefaultCodegenFactory;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.internal.BytecodeGenerationResult;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerAdapterKt;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerService;
import org.jetbrains.kotlin.idea.internal.Location;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.InfinitePeriodicalTask;
import org.jetbrains.kotlin.idea.util.LongRunningReadTask;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.kotlin.utils.StringsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "decompile", "Ljavax/swing/JButton;", "enableAssertions", "Ljavax/swing/JCheckBox;", "enableInline", "enableOptimization", "ir", "jvm8Target", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "myEditor$annotations", "()V", "dispose", "", "setText", "resultText", "", "Companion", "UpdateBytecodeToolWindowTask", "idea-jvm"})
public final class KotlinBytecodeToolWindow
extends JPanel
implements Disposable {
    private final Editor myEditor;
    private final JCheckBox enableInline;
    private final JCheckBox enableOptimization;
    private final JCheckBox enableAssertions;
    private final JButton decompile;
    private final JCheckBox jvm8Target;
    private final JCheckBox ir;
    private final Project myProject;
    private final ToolWindow toolWindow;
    private static final Logger LOG;
    private static final int UPDATE_DELAY = 1000;
    private static final String DEFAULT_TEXT = "/*\nGenerated bytecode for Kotlin source file.\nNo Kotlin source file is opened.\n*/";
    public static final Companion Companion;

    private static /* synthetic */ void myEditor$annotations() {
    }

    private final void setText(String resultText) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(this, resultText){
            final /* synthetic */ KotlinBytecodeToolWindow this$0;
            final /* synthetic */ String $resultText;

            public final void run() {
                KotlinBytecodeToolWindow.access$getMyEditor$p(this.this$0).getDocument().setText((CharSequence)StringUtil.convertLineSeparators((String)this.$resultText));
            }
            {
                this.this$0 = kotlinBytecodeToolWindow;
                this.$resultText = string;
            }
        });
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    public KotlinBytecodeToolWindow(@NotNull Project myProject, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)toolWindow, (String)"toolWindow");
        super(new BorderLayout());
        this.myProject = myProject;
        this.toolWindow = toolWindow;
        Editor editor = EditorFactory.getInstance().createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.myProject, (FileType)JavaFileType.INSTANCE, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"EditorFactory.getInstanc\u2026.INSTANCE, true\n        )");
        this.myEditor = editor;
        this.add(this.myEditor.getComponent());
        JPanel optionPanel = new JPanel(new FlowLayout());
        this.add((Component)optionPanel, "North");
        this.decompile = new JButton("Decompile");
        if (KotlinDecompilerService.Companion.getInstance() != null) {
            optionPanel.add(this.decompile);
            this.decompile.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    Location location2;
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)myProject);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(myProject)");
                    Location location3 = location2 = Location.fromEditor((Editor)fileEditorManager.getSelectedTextEditor(), (Project)myProject);
                    Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"location");
                    KtFile file2 = location3.getKFile();
                    if (file2 != null) {
                        try {
                            KotlinDecompilerAdapterKt.showDecompiledCode((KtFile)file2);
                        }
                        catch (DecompileFailedException ex) {
                            LOG.info((Throwable)ex);
                            Messages.showErrorDialog((Project)myProject, (String)("Failed to decompile " + file2.getName() + ": " + (Object)((Object)ex)), (String)"Kotlin Bytecode Decompiler");
                        }
                    }
                }
            });
        }
        this.enableInline = new JCheckBox("Inline", true);
        this.enableOptimization = new JCheckBox("Optimization", true);
        this.enableAssertions = new JCheckBox("Assertions", true);
        this.jvm8Target = new JCheckBox("JVM 8 target", false);
        this.ir = new JCheckBox("IR", false);
        optionPanel.add(this.enableInline);
        optionPanel.add(this.enableOptimization);
        optionPanel.add(this.enableAssertions);
        optionPanel.add(this.ir);
        optionPanel.add(this.jvm8Target);
        new InfinitePeriodicalTask((long)1000, Alarm.ThreadToUse.SWING_THREAD, (Disposable)this, new Computable<LongRunningReadTask<?, ?>>(){

            @NotNull
            public final UpdateBytecodeToolWindowTask compute() {
                return new UpdateBytecodeToolWindowTask();
            }
        }).start();
        this.setText(DEFAULT_TEXT);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinBytecodeToolWindow.class);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask;", "Lorg/jetbrains/kotlin/idea/util/LongRunningReadTask;", "Lorg/jetbrains/kotlin/idea/internal/Location;", "Lorg/jetbrains/kotlin/idea/internal/BytecodeGenerationResult;", "(Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow;)V", "cloneRequestInfo", "location", "hideResultOnInvalidLocation", "", "onResultReady", "requestInfo", "result", "prepareRequestInfo", "processRequest", "idea-jvm"})
    private final class UpdateBytecodeToolWindowTask
    extends LongRunningReadTask<Location, BytecodeGenerationResult> {
        @Nullable
        protected Location prepareRequestInfo() {
            if (!KotlinBytecodeToolWindow.this.toolWindow.isVisible()) {
                return null;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)KotlinBytecodeToolWindow.this.myProject);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(myProject)");
            Location location2 = Location.fromEditor((Editor)fileEditorManager.getSelectedTextEditor(), (Project)KotlinBytecodeToolWindow.this.myProject);
            if (location2.getEditor() == null) {
                return null;
            }
            Location location3 = location2;
            Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"location");
            KtFile file2 = location3.getKFile();
            return file2 == null || !ProjectRootsUtil.isInProjectSource((PsiElement)((PsiElement)file2)) ? null : location2;
        }

        @NotNull
        protected Location cloneRequestInfo(@NotNull Location location2) {
            Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
            Location newLocation = (Location)super.cloneRequestInfo((Object)location2);
            boolean bl = Intrinsics.areEqual((Object)location2, (Object)newLocation);
            if (_Assertions.ENABLED && !bl) {
                String string = "cloneRequestInfo should generate same location object";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Location location3 = newLocation;
            Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"newLocation");
            return location3;
        }

        protected void hideResultOnInvalidLocation() {
            KotlinBytecodeToolWindow.this.setText(KotlinBytecodeToolWindow.DEFAULT_TEXT);
        }

        @NotNull
        protected BytecodeGenerationResult processRequest(@NotNull Location location2) {
            Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
            KtFile ktFile = location2.getKFile();
            if (ktFile == null) {
                Intrinsics.throwNpe();
            }
            KtFile ktFile2 = ktFile;
            CompilerConfiguration configuration = new CompilerConfiguration();
            if (!KotlinBytecodeToolWindow.this.enableInline.isSelected()) {
                configuration.put(CommonConfigurationKeys.DISABLE_INLINE, (Object)true);
            }
            if (!KotlinBytecodeToolWindow.this.enableAssertions.isSelected()) {
                configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, (Object)true);
                configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, (Object)true);
            }
            if (!KotlinBytecodeToolWindow.this.enableOptimization.isSelected()) {
                configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, (Object)true);
            }
            if (KotlinBytecodeToolWindow.this.jvm8Target.isSelected()) {
                configuration.put(JVMConfigurationKeys.JVM_TARGET, (Object)JvmTarget.JVM_1_8);
            }
            if (KotlinBytecodeToolWindow.this.ir.isSelected()) {
                configuration.put(JVMConfigurationKeys.IR, (Object)true);
            }
            KtFile ktFile3 = ktFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile3, (String)"ktFile");
            CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration, (LanguageVersionSettings)PlatformKt.getLanguageVersionSettings((KtElement)((KtElement)ktFile3)));
            return Companion.getBytecodeForFile(ktFile2, configuration);
        }

        protected void onResultReady(@NotNull Location requestInfo, @Nullable BytecodeGenerationResult result2) {
            Intrinsics.checkParameterIsNotNull((Object)requestInfo, (String)"requestInfo");
            Editor editor = requestInfo.getEditor();
            if (editor == null) {
                Intrinsics.throwNpe();
            }
            Editor editor2 = editor;
            if (result2 == null) {
                return;
            }
            BytecodeGenerationResult bytecodeGenerationResult = result2;
            if (bytecodeGenerationResult instanceof BytecodeGenerationResult.Error) {
                KotlinBytecodeToolWindow.this.decompile.setEnabled(false);
                KotlinBytecodeToolWindow.this.setText(((BytecodeGenerationResult.Error)result2).getText());
            } else if (bytecodeGenerationResult instanceof BytecodeGenerationResult.Bytecode) {
                Document byteCodeDocument;
                KotlinBytecodeToolWindow.this.decompile.setEnabled(true);
                KotlinBytecodeToolWindow.this.setText(((BytecodeGenerationResult.Bytecode)result2).getText());
                int fileStartOffset = requestInfo.getStartOffset();
                int fileEndOffset = requestInfo.getEndOffset();
                Editor editor3 = editor2;
                Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor");
                Document document = editor3.getDocument();
                int startLine = document.getLineNumber(fileStartOffset);
                int endLine = document.getLineNumber(fileEndOffset);
                if (endLine > startLine && fileEndOffset > 0) {
                    Document document2 = document;
                    Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
                    if (document2.getCharsSequence().charAt(fileEndOffset - 1) == '\n') {
                        --endLine;
                    }
                }
                Document document3 = byteCodeDocument = KotlinBytecodeToolWindow.this.myEditor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"byteCodeDocument");
                String string = document3.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"byteCodeDocument.text");
                Pair linesRange = Companion.mapLines(string, startLine, endLine);
                int endSelectionLineIndex = Math.min(((Number)linesRange.second).intValue() + 1, byteCodeDocument.getLineCount());
                Object object = linesRange.first;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"linesRange.first");
                int startOffset = byteCodeDocument.getLineStartOffset(((Number)object).intValue());
                int endOffset = Math.min(byteCodeDocument.getLineStartOffset(endSelectionLineIndex), byteCodeDocument.getTextLength());
                KotlinBytecodeToolWindow.this.myEditor.getCaretModel().moveToOffset(endOffset);
                KotlinBytecodeToolWindow.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                KotlinBytecodeToolWindow.this.myEditor.getCaretModel().moveToOffset(startOffset);
                KotlinBytecodeToolWindow.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                KotlinBytecodeToolWindow.this.myEditor.getSelectionModel().setSelection(startOffset, endOffset);
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$Companion;", "", "()V", "DEFAULT_TEXT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "UPDATE_DELAY", "", "compileSingleFile", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getBytecodeForFile", "Lorg/jetbrains/kotlin/idea/internal/BytecodeGenerationResult;", "mapLines", "Lcom/intellij/openapi/util/Pair;", "text", "startLine", "endLine", "printStackTraceToString", "e", "", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final BytecodeGenerationResult getBytecodeForFile(@NotNull KtFile ktFile, @NotNull CompilerConfiguration configuration) {
            GenerationState state;
            Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            try {
                GenerationState generationState = this.compileSingleFile(ktFile, configuration);
                if (generationState == null) {
                    return new BytecodeGenerationResult.Error("Cannot compile " + ktFile.getName() + " to bytecode.");
                }
                state = generationState;
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                return new BytecodeGenerationResult.Error(this.printStackTraceToString(e));
            }
            StringBuilder answer = new StringBuilder();
            Collection diagnostics = state.getCollectedExtraJvmDiagnostics().all();
            if (!diagnostics.isEmpty()) {
                answer.append("// Backend Errors: \n");
                answer.append("// ================\n");
                for (Diagnostic diagnostic : diagnostics) {
                    StringBuilder stringBuilder = answer.append("// Error at ");
                    PsiFile psiFile = diagnostic.getPsiFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"diagnostic.psiFile");
                    StringBuilder stringBuilder2 = stringBuilder.append(psiFile.getName());
                    List list = diagnostic.getTextRanges();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"diagnostic.textRanges");
                    stringBuilder2.append(StringsKt.join((Iterable)list, (String)",")).append(": ").append(DefaultErrorMessages.render((Diagnostic)diagnostic)).append("\n");
                }
                answer.append("// ================\n\n");
            }
            ClassFileFactory outputFiles = state.getFactory();
            for (OutputFile outputFile : outputFiles.asList()) {
                answer.append("// ================");
                answer.append(outputFile.getRelativePath());
                answer.append(" =================\n");
                answer.append(outputFile.asText()).append("\n\n");
            }
            String string = answer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"answer.toString()");
            return new BytecodeGenerationResult.Bytecode(string);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final GenerationState compileSingleFile(@NotNull KtFile ktFile, @NotNull CompilerConfiguration configuration) {
            void bindingContext2;
            Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            TargetPlatform platform = PlatformKt.getPlatform((KtElement)((KtElement)ktFile));
            if (Intrinsics.areEqual((Object)platform, (Object)TargetPlatform.Common.INSTANCE) ^ true && Intrinsics.areEqual((Object)platform, (Object)JvmPlatform.INSTANCE) ^ true) {
                return null;
            }
            Project project = ktFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ktFile.project");
            ResolutionFacade resolutionFacade = KotlinCacheService.Companion.getInstance(project).getResolutionFacadeByFile((PsiFile)ktFile, (TargetPlatform)JvmPlatform.INSTANCE);
            if (resolutionFacade == null) {
                return null;
            }
            ResolutionFacade resolutionFacade2 = resolutionFacade;
            BindingContext bindingContextForFile = resolutionFacade2.analyzeWithAllCompilerChecks((Collection)CollectionsKt.listOf((Object)ktFile)).getBindingContext();
            kotlin.Pair<BindingContext, List<KtFile>> pair = DebuggerUtils.INSTANCE.analyzeInlinedFunctions(resolutionFacade2, ktFile, configuration.getBoolean(CommonConfigurationKeys.DISABLE_INLINE), bindingContextForFile);
            BindingContext bindingContext3 = (BindingContext)pair.component1();
            List toProcess = (List)pair.component2();
            GenerationState.GenerateClassFilter generateClassFilter2 = new GenerationState.GenerateClassFilter(ktFile){
                final /* synthetic */ KtFile $ktFile;

                public boolean shouldGeneratePackagePart(@NotNull KtFile file2) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    return file2 == this.$ktFile;
                }

                public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
                    Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                    return true;
                }

                public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
                    Intrinsics.checkParameterIsNotNull((Object)processingClassOrObject, (String)"processingClassOrObject");
                    return processingClassOrObject.getContainingKtFile() == this.$ktFile;
                }

                public boolean shouldGenerateScript(@NotNull KtScript script) {
                    Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                    return script.getContainingKtFile() == this.$ktFile;
                }
                {
                    this.$ktFile = $captured_local_variable$0;
                }
            };
            Project project2 = ktFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"ktFile.project");
            ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.TEST;
            Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.TEST");
            GenerationState state = new GenerationState.Builder(project2, classBuilderFactory, resolutionFacade2.getModuleDescriptor(), (BindingContext)bindingContext2, toProcess, configuration).generateDeclaredClassFilter(generateClassFilter2).codegenFactory(configuration.getBoolean(JVMConfigurationKeys.IR) ? (CodegenFactory)JvmIrCodegenFactory.INSTANCE : (CodegenFactory)DefaultCodegenFactory.INSTANCE).build();
            KotlinCodegenFacade.compileCorrectFiles((GenerationState)state, (CompilationErrorHandler)CompilationErrorHandler.THROW_EXCEPTION);
            return state;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> mapLines(String text2, int startLine, int endLine) {
            void $receiver$iv$iv;
            List list;
            String string;
            String string2;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            CharSequence $receiver$iv$iv2;
            void $receiver$iv;
            void line;
            Collection collection;
            String $i$f$dropLastWhile;
            String $receiver$iv$iv22;
            Iterable $receiver$iv2;
            List list2;
            Object object;
            Object iterator$iv;
            int startLine2 = startLine;
            int byteCodeLine = 0;
            int byteCodeStartLine = -1;
            int byteCodeEndLine = -1;
            ArrayList<Integer> lines = new ArrayList<Integer>();
            Iterable $receiver$iv22 = kotlin.text.StringsKt.split$default((CharSequence)text2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            if (!$receiver$iv22.isEmpty()) {
                iterator$iv = $receiver$iv22.listIterator($receiver$iv22.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    object = it2;
                    if (object.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$receiver$iv22, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $receiver$iv22 = list2;
            iterator$iv = $receiver$iv2;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            object = $receiver$iv$iv22.iterator();
            while (object.hasNext()) {
                Object item$iv$iv = object.next();
                $i$f$dropLastWhile = (String)item$iv$iv;
                collection = destination$iv$iv22;
                $receiver$iv = line;
                $receiver$iv$iv2 = (CharSequence)$receiver$iv;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $receiver$iv$iv2.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $receiver$iv$iv2.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string2 = ((Object)$receiver$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                collection.add(string2);
            }
            for (String string3 : (List)destination$iv$iv22) {
                if (!kotlin.text.StringsKt.startsWith$default((String)string3, (String)"LINENUMBER", (boolean)false, (int)2, null)) continue;
                $receiver$iv$iv22 = string3;
                int destination$iv$iv22 = "LINENUMBER".length();
                String string4 = $receiver$iv$iv22;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(destination$iv$iv22), (String)"(this as java.lang.String).substring(startIndex)");
                String string5 = string;
                int ktLineNum = new Scanner(string5).nextInt() - 1;
                lines.add(ktLineNum);
            }
            CollectionsKt.sort((List)lines);
            for (Integer n : lines) {
                if (Intrinsics.compare((int)n, (int)startLine2) < 0) continue;
                Integer n2 = n;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"line");
                startLine2 = n2;
                break;
            }
            if (!($receiver$iv2 = kotlin.text.StringsKt.split$default((CharSequence)text2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)).isEmpty()) {
                iterator$iv = $receiver$iv2.listIterator($receiver$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    object = it2;
                    if (object.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv2, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $receiver$iv2 = list;
            iterator$iv = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                $i$f$dropLastWhile = (String)item$iv$iv;
                collection = destination$iv$iv;
                $receiver$iv = line;
                $receiver$iv$iv2 = (CharSequence)$receiver$iv;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $receiver$iv$iv2.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $receiver$iv$iv2.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string2 = ((Object)$receiver$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                collection.add(string2);
            }
            for (String string6 : (List)destination$iv$iv) {
                CharSequence charSequence;
                if (kotlin.text.StringsKt.startsWith$default((String)string6, (String)"LINENUMBER", (boolean)false, (int)2, null)) {
                    String object3 = string6;
                    int n = "LINENUMBER".length();
                    String string7 = object3;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    String string8 = string;
                    int ktLineNum = new Scanner(string8).nextInt() - 1;
                    if (byteCodeStartLine < 0 && ktLineNum == startLine2) {
                        byteCodeStartLine = byteCodeLine;
                    }
                    if (byteCodeStartLine > 0 && ktLineNum > endLine) {
                        byteCodeEndLine = byteCodeLine - 1;
                        break;
                    }
                }
                if (byteCodeStartLine >= 0 && (kotlin.text.StringsKt.startsWith$default((String)string6, (String)"MAXSTACK", (boolean)false, (int)2, null) || kotlin.text.StringsKt.startsWith$default((String)string6, (String)"LOCALVARIABLE", (boolean)false, (int)2, null) || (charSequence = (CharSequence)string6).length() == 0)) {
                    byteCodeEndLine = byteCodeLine - 1;
                    break;
                }
                ++byteCodeLine;
            }
            return byteCodeStartLine == -1 || byteCodeEndLine == -1 ? new Pair((Object)0, (Object)0) : new Pair((Object)byteCodeStartLine, (Object)byteCodeEndLine);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String printStackTraceToString(Throwable e) {
            StringWriter out = new StringWriter(1024);
            Closeable closeable = new PrintWriter(out);
            Throwable throwable = null;
            try {
                PrintWriter printWriter = (PrintWriter)closeable;
                e.printStackTrace(printWriter);
                String string = out.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
                String string2 = kotlin.text.StringsKt.replace$default((String)string, (String)"\r", (String)"", (boolean)false, (int)4, null);
                return string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

