/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.actions.DecompileKotlinToJavaActionKt;
import org.jetbrains.kotlin.idea.internal.BaseDecompilerKt;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.internal.KotlinBytecodeToolWindow;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerService;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerServiceImpl;", "Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerService;", "()V", "bytecodeMapForExistingClassfile", "", "Ljava/io/File;", "Lkotlin/Function0;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "bytecodeMapForSourceFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "decompile", "", "KotlinResultSaver", "idea-jvm"})
public final class KotlinDecompilerServiceImpl
implements KotlinDecompilerService {
    @Nullable
    public String decompile(@NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        try {
            Map map = (Map)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Map<File, ? extends Function0<? extends byte[]>>>(this, file2){
                final /* synthetic */ KotlinDecompilerServiceImpl this$0;
                final /* synthetic */ KtFile $file;

                @Nullable
                public final Map<File, Function0<byte[]>> invoke() {
                    Map map;
                    if (DecompileKotlinToJavaActionKt.canBeDecompiledToJava((KtFile)this.$file)) {
                        VirtualFile virtualFile2 = this.$file.getVirtualFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
                        map = KotlinDecompilerServiceImpl.access$bytecodeMapForExistingClassfile(this.this$0, virtualFile2);
                    } else {
                        map = !this.$file.isCompiled() ? KotlinDecompilerServiceImpl.access$bytecodeMapForSourceFile(this.this$0, this.$file) : null;
                    }
                    return map;
                }
                {
                    this.this$0 = kotlinDecompilerServiceImpl;
                    this.$file = ktFile;
                    super(0);
                }
            }));
            if (map == null) {
                return null;
            }
            Map bytecodeMap2 = map;
            KotlinResultSaver resultSaver = new KotlinResultSaver();
            HashMap options = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"rbr", (Object)"0")});
            IBytecodeProvider bytecodeProvider2 = new IBytecodeProvider(bytecodeMap2){
                final /* synthetic */ Map $bytecodeMap;

                @Nullable
                public final byte[] getBytecode(String externalPath, String $noName_1) {
                    File path = new File(FileUtil.toSystemIndependentName((String)externalPath));
                    Function0 function0 = (Function0)this.$bytecodeMap.get(path);
                    return (byte[])(function0 != null ? (byte[])function0.invoke() : null);
                }
                {
                    this.$bytecodeMap = map;
                }
            };
            BaseDecompiler decompiler = new BaseDecompiler(bytecodeProvider2, (IResultSaver)resultSaver, (Map)options, (IFernflowerLogger)new IdeaLogger());
            for (File path : bytecodeMap2.keySet()) {
                BaseDecompilerKt.addSpaceEx(decompiler, path, true);
            }
            decompiler.decompileContext();
            return resultSaver.getResultText();
        }
        catch (IdeaLogger.InternalException ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            throw (Throwable)new DecompileFailedException(string, (Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, Function0<byte[]>> bytecodeMapForExistingClassfile(VirtualFile file2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        String mask = file2.getNameWithoutExtension() + '$';
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)file2.getPath(), (Object)file2));
        VirtualFile virtualFile2 = file2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.parent");
        VirtualFile[] virtualFileArray = virtualFile2.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"file.parent.children");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        Map map2 = map;
        void var5_5 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            void it;
            void v3 = it = element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            String string = v3.getNameWithoutExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.nameWithoutExtension");
            if (!(StringsKt.startsWith$default((String)string, (String)mask, (boolean)false, (int)2, null) && it.getFileType() == StdFileTypes.CLASS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Pair> collection = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            Pair pair = TuplesKt.to((Object)v5.getPath(), (Object)it);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Map files = MapsKt.plus((Map)map2, (Iterable)collection);
        $receiver$iv = files.entrySet();
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map3 = destination$iv$iv2;
            Map.Entry it = (Map.Entry)element$iv$iv;
            Pair pair = new Pair((Object)new File((String)it.getKey()), (Object)new Function0<byte[]>(it){
                final /* synthetic */ Map.Entry $it;

                @NotNull
                public final byte[] invoke() {
                    return ((VirtualFile)this.$it.getValue()).contentsToByteArray(false);
                }
                {
                    this.$it = entry;
                    super(0);
                }
            });
            map3.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, Function0<byte[]>> bytecodeMapForSourceFile(KtFile file2) {
        void $receiver$iv$iv;
        CompilerConfiguration compilerConfiguration;
        CompilerConfiguration $receiver = compilerConfiguration = new CompilerConfiguration();
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)$receiver, (LanguageVersionSettings)PlatformKt.getLanguageVersionSettings((KtElement)((KtElement)file2)));
        CompilerConfiguration configuration = compilerConfiguration;
        GenerationState generationState = KotlinBytecodeToolWindow.Companion.compileSingleFile(file2, configuration);
        if (generationState == null) {
            return MapsKt.emptyMap();
        }
        GenerationState generationState2 = generationState;
        HashMap bytecodeMap2 = new HashMap();
        List list = generationState2.getFactory().asList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"generationState.factory.asList()");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            OutputFile it = (OutputFile)element$iv$iv;
            if (!FileUtilRt.extensionEquals((String)it.getRelativePath(), (String)"class")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            File file3;
            OutputFile it = (OutputFile)element$iv;
            Map map = bytecodeMap2;
            Intrinsics.checkExpressionValueIsNotNull((Object)new File('/' + it.getRelativePath()).getAbsoluteFile(), (String)"File(\"/${it.relativePath}\").absoluteFile");
            Function0<byte[]> function0 = new Function0<byte[]>(it){
                final /* synthetic */ OutputFile $it;

                @NotNull
                public final byte[] invoke() {
                    return this.$it.asByteArray();
                }
                {
                    this.$it = outputFile;
                    super(0);
                }
            };
            map.put(file3, function0);
        }
        return bytecodeMap2;
    }

    @NotNull
    public static final /* synthetic */ Map access$bytecodeMapForExistingClassfile(KotlinDecompilerServiceImpl $this, @NotNull VirtualFile file2) {
        return $this.bytecodeMapForExistingClassfile(file2);
    }

    @NotNull
    public static final /* synthetic */ Map access$bytecodeMapForSourceFile(KotlinDecompilerServiceImpl $this, @NotNull KtFile file2) {
        return $this.bytecodeMapForSourceFile(file2);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J0\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J&\u0010\u0010\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J&\u0010\u0012\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J:\u0010\u0015\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016J:\u0010\u0018\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J&\u0010\u001b\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u001c\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerServiceImpl$KotlinResultSaver;", "Lorg/jetbrains/java/decompiler/main/extern/IResultSaver;", "()V", "decompiledText", "", "", "resultText", "getResultText", "()Ljava/lang/String;", "closeArchive", "", "path", "archiveName", "copyEntry", "source", "entry", "copyFile", "entryName", "createArchive", "manifest", "Ljava/util/jar/Manifest;", "saveClassEntry", "qualifiedName", "content", "saveClassFile", "mapping", "", "saveDirEntry", "saveFolder", "idea-jvm"})
    public static final class KotlinResultSaver
    implements IResultSaver {
        private final Map<String, String> decompiledText;

        @NotNull
        public final String getResultText() {
            StringBuilder stringBuilder;
            String string = (String)CollectionsKt.singleOrNull((Iterable)this.decompiledText.values());
            if (string != null) {
                String string2;
                String it = string2 = string;
                return it;
            }
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            Map<String, String> $i$a$1$let = this.decompiledText;
            for (Map.Entry<String, String> entry : $i$a$1$let.entrySet()) {
                Object object = entry;
                String filename = object.getKey();
                object = entry;
                String content = object.getValue();
                object = $receiver;
                String string3 = "// " + filename;
                StringBuilder stringBuilder2 = ((StringBuilder)object).append(string3);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                $receiver.append(content);
            }
            String string4 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
            return string4;
        }

        public void saveFolder(@Nullable String path) {
        }

        public void closeArchive(@Nullable String path, @Nullable String archiveName) {
        }

        public void copyEntry(@Nullable String source, @Nullable String path, @Nullable String archiveName, @Nullable String entry) {
        }

        public void createArchive(@Nullable String path, @Nullable String archiveName, @Nullable Manifest manifest) {
        }

        public void saveClassFile(@Nullable String path, @Nullable String qualifiedName, @Nullable String entryName, @Nullable String content, @Nullable int[] mapping) {
            if (entryName != null && content != null) {
                Map<String, String> map = this.decompiledText;
                String string = content;
                map.put(entryName, string);
            }
        }

        public void copyFile(@Nullable String source, @Nullable String path, @Nullable String entryName) {
        }

        public void saveClassEntry(@Nullable String path, @Nullable String archiveName, @Nullable String qualifiedName, @Nullable String entryName, @Nullable String content) {
        }

        public void saveDirEntry(@Nullable String path, @Nullable String archiveName, @Nullable String entryName) {
        }

        public KotlinResultSaver() {
            Map map;
            KotlinResultSaver kotlinResultSaver = this;
            kotlinResultSaver.decompiledText = map = (Map)new LinkedHashMap();
        }
    }
}

