/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.AbstractTestClassConfigurationProducer;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducerKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u0013\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/intellij/execution/junit/JUnitConfiguration;", "()V", "fixJdkForCommonModule", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "configuration", "isConfigurationFromContext", "", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "onFirstRun", "fromContext", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "performRunnable", "Ljava/lang/Runnable;", "settingsMatchTemplate", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "shouldReplace", "self", "other", "Companion", "idea-jvm"})
public final class KotlinJUnitRunConfigurationProducer
extends RunConfigurationProducer<JUnitConfiguration> {
    public static final Companion Companion = new Companion(null);

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.isProducedBy(JUnitConfigurationProducer.class) || other.isProducedBy(PatternConfigurationProducer.class);
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context) {
        Location leaf;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location location2 = context.getLocation();
        if (location2 == null || (location2 = location2.getPsiElement()) == null) {
            return false;
        }
        Location location3 = leaf = location2;
        Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"leaf");
        Location<PsiMethod> methodLocation = Companion.getTestMethodLocation((PsiElement)location3);
        PsiClass testClass = Companion.getTestClass((PsiElement)leaf);
        TestObject testObject = configuration.getTestObject();
        Location<PsiMethod> location4 = methodLocation;
        if (!testObject.isConfiguredByElement(configuration, testClass, (PsiMethod)(location4 != null ? (PsiMethod)location4.getPsiElement() : null), null, null)) {
            return false;
        }
        return this.settingsMatchTemplate(configuration, context);
    }

    private final boolean settingsMatchTemplate(JUnitConfiguration configuration, ConfigurationContext context) {
        String vmParameters;
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration((ConfigurationType)JUnitConfigurationType.getInstance());
        RunConfiguration runConfiguration = predefinedConfiguration;
        if (!(runConfiguration instanceof CommonJavaRunConfigurationParameters)) {
            runConfiguration = null;
        }
        CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters = (CommonJavaRunConfigurationParameters)runConfiguration;
        String string = vmParameters = commonJavaRunConfigurationParameters != null ? commonJavaRunConfigurationParameters.getVMParameters() : null;
        if (vmParameters != null && Intrinsics.areEqual((Object)configuration.getVMParameters(), (Object)vmParameters) ^ true) {
            return false;
        }
        Project project = configuration.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"configuration.project");
        RunManager runManager = RunManager.Companion.getInstance(project);
        ConfigurationFactory configurationFactory = this.getConfigurationFactory();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"configurationFactory");
        RunnerAndConfigurationSettings template = runManager.getConfigurationTemplate(configurationFactory);
        RunConfiguration runConfiguration2 = template.getConfiguration();
        if (runConfiguration2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.configurations.ModuleBasedConfiguration<*>");
        }
        RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)runConfiguration2).getConfigurationModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)runConfigurationModule, (String)"(template.configuration \u2026n<*>).configurationModule");
        Module predefinedModule = runConfigurationModule.getModule();
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration.getConfigurationModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
        Module configurationModule = javaRunConfigurationModule.getModule();
        Location location2 = context.getLocation();
        return Intrinsics.areEqual((Object)configurationModule, (Object)(location2 != null ? location2.getModule() : null)) || Intrinsics.areEqual((Object)configurationModule, (Object)predefinedModule);
    }

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement leaf;
        Location location2;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        DumbService dumbService = DumbService.getInstance((Project)context.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(context.project)");
        if (dumbService.isDumb()) {
            return false;
        }
        Location location3 = context.getLocation();
        if (location3 == null) {
            return false;
        }
        Location location4 = location2 = location3;
        Intrinsics.checkExpressionValueIsNotNull((Object)location4, (String)"location");
        PsiElement psiElement = leaf = location4.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"leaf");
        if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)psiElement)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        PsiFile psiFile = leaf.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile ktFile = (KtFile)psiFile;
        TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform((KtFile)ktFile);
        if (Intrinsics.areEqual((Object)targetPlatform, (Object)JvmPlatform.INSTANCE) ^ true && Intrinsics.areEqual((Object)targetPlatform, (Object)TargetPlatform.Common.INSTANCE) ^ true) {
            return false;
        }
        Location<PsiMethod> methodLocation = Companion.getTestMethodLocation(leaf);
        if (methodLocation != null) {
            JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration.getConfigurationModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
            Module originalModule = javaRunConfigurationModule.getModule();
            configuration.beMethodConfiguration(methodLocation);
            configuration.restoreOriginalModule(originalModule);
            JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location2);
            this.fixJdkForCommonModule(ktFile, configuration);
            return true;
        }
        PsiClass testClass = Companion.getTestClass(leaf);
        if (testClass != null) {
            JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration.getConfigurationModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
            Module originalModule = javaRunConfigurationModule.getModule();
            configuration.beClassConfiguration(testClass);
            configuration.restoreOriginalModule(originalModule);
            JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location2);
            this.fixJdkForCommonModule(ktFile, configuration);
            return true;
        }
        return false;
    }

    private final void fixJdkForCommonModule(KtFile ktFile, JUnitConfiguration configuration) {
        Module module = ProjectRootsUtilKt.getModule((PsiElement)((PsiElement)ktFile));
        if (module == null || (module = KotlinRunConfigurationProducerKt.findJvmImplementationModule(module)) == null) {
            return;
        }
        Module implModule = module;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)implModule);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(implModule)");
        Sdk sdk = moduleRootManager.getSdk();
        if (sdk != null) {
            configuration.setModule(implModule);
            configuration.setAlternativeJrePathEnabled(true);
            configuration.setAlternativeJrePath(sdk.getHomePath());
        }
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        PsiElement leaf;
        Intrinsics.checkParameterIsNotNull((Object)fromContext, (String)"fromContext");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)performRunnable, (String)"performRunnable");
        PsiElement psiElement = leaf = fromContext.getSourceElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"leaf");
        PsiClass psiClass = Companion.getTestClass(psiElement);
        if (psiClass != null) {
            PsiClass psiClass2;
            PsiClass testClass = psiClass2 = psiClass;
            ConfigurationFromContext fromContextSubstitute = new ConfigurationFromContext(testClass, fromContext, context, performRunnable){
                final /* synthetic */ PsiClass $testClass;
                final /* synthetic */ ConfigurationFromContext $fromContext$inlined;
                final /* synthetic */ ConfigurationContext $context$inlined;
                final /* synthetic */ Runnable $performRunnable$inlined;
                {
                    this.$testClass = $captured_local_variable$1;
                    this.$fromContext$inlined = configurationFromContext;
                    this.$context$inlined = configurationContext;
                    this.$performRunnable$inlined = runnable;
                }

                @NotNull
                public RunnerAndConfigurationSettings getConfigurationSettings() {
                    return this.$fromContext$inlined.getConfigurationSettings();
                }

                public void setConfigurationSettings(@NotNull RunnerAndConfigurationSettings configurationSettings) {
                    Intrinsics.checkParameterIsNotNull((Object)configurationSettings, (String)"configurationSettings");
                    this.$fromContext$inlined.setConfigurationSettings(configurationSettings);
                }

                @NotNull
                public PsiClass getSourceElement() {
                    return this.$testClass;
                }
            };
            new AbstractTestClassConfigurationProducer((ConfigurationType)JUnitConfigurationType.getInstance()){}.onFirstRun(fromContextSubstitute, context, performRunnable);
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }

    public KotlinJUnitRunConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer$Companion;", "", "()V", "getTestClass", "Lcom/intellij/psi/PsiClass;", "leaf", "Lcom/intellij/psi/PsiElement;", "getTestClassInFile", "Lorg/jetbrains/kotlin/psi/KtClass;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getTestMethodLocation", "Lcom/intellij/execution/Location;", "Lcom/intellij/psi/PsiMethod;", "isJUnitTestClass", "", "idea-jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PsiClass getTestClass(@NotNull PsiElement leaf) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)leaf, (String)"leaf");
            PsiFile psiFile = leaf.getContainingFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile = (KtFile)psiFile;
            if (ktFile == null) {
                return null;
            }
            KtFile containingFile = ktFile;
            PsiElement psiElement = leaf;
            boolean strict$iv = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)strict$iv);
            if (!this.isJUnitTestClass(ktClass)) {
                ktClass = this.getTestClassInFile(containingFile);
            }
            KtClass ktClass2 = ktClass;
            return (PsiClass)(ktClass2 != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass2)) : null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Location<PsiMethod> getTestMethodLocation(@NotNull PsiElement leaf) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)leaf, (String)"leaf");
            PsiElement psiElement = leaf;
            boolean strict$iv = false;
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNamedFunction.class, (boolean)strict$iv);
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function = ktNamedFunction;
            KtTypeParameterListOwner owner = (KtTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)function), (Class[])new Class[]{KtFunction.class, KtClass.class});
            if (owner instanceof KtClass) {
                PsiMethod psiMethod;
                block6: {
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)owner));
                    if (ktLightClass == null) {
                        return null;
                    }
                    KtLightClass delegate = ktLightClass;
                    PsiMethod[] psiMethodArray = delegate.getMethods();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"delegate.methods");
                    PsiMethod[] $receiver$iv2 = psiMethodArray;
                    int n = $receiver$iv2.length;
                    for (int i = 0; i < n; ++i) {
                        PsiMethod element$iv;
                        PsiMethod it;
                        PsiMethod psiMethod2 = it = (element$iv = $receiver$iv2[i]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"it");
                        if (!Intrinsics.areEqual((Object)psiMethod2.getNavigationElement(), (Object)function)) continue;
                        psiMethod = element$iv;
                        break block6;
                    }
                    psiMethod = null;
                }
                if (psiMethod == null) {
                    return null;
                }
                PsiMethod method = psiMethod;
                Location methodLocation = PsiLocation.fromPsiElement((PsiElement)((PsiElement)method));
                if (JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) {
                    return methodLocation;
                }
            }
            return null;
        }

        private final boolean isJUnitTestClass(@Nullable KtClass $receiver) {
            boolean bl;
            KtClass ktClass = $receiver;
            if (ktClass != null && (ktClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass))) != null) {
                KtClass ktClass2;
                KtClass it = ktClass2 = ktClass;
                bl = JUnitUtil.isTestClass((PsiClass)((PsiClass)it), (boolean)false, (boolean)true);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final KtClass getTestClassInFile(KtFile ktFile) {
            Iterable iterable;
            block3: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable2 = $receiver$iv = (Iterable)ktFile.getDeclarations();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof KtClass)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $receiver$iv) {
                    KtClass it = (KtClass)element$iv;
                    if (!Companion.isJUnitTestClass(it)) continue;
                    if (found$iv) {
                        iterable = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                iterable = !found$iv ? null : iterable2;
            }
            return (KtClass)iterable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

