/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.JUnitRecognizer;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.run.KotlinMultiplatformJUnitRecognizerKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinMultiplatformJUnitRecognizer;", "Lcom/intellij/execution/JUnitRecognizer;", "()V", "isTestAnnotated", "", "method", "Lcom/intellij/psi/PsiMethod;", "idea-jvm"})
public final class KotlinMultiplatformJUnitRecognizer
extends JUnitRecognizer {
    public boolean isTestAnnotated(@NotNull PsiMethod method) {
        boolean bl;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            if (!(method instanceof KtLightMethod)) {
                return false;
            }
            KtDeclaration ktDeclaration = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration origin = ktDeclaration;
            Module module = ProjectRootsUtilKt.getModule((PsiElement)((PsiElement)origin));
            if (!((module != null ? PlatformKt.getTargetPlatform((Module)module) : null) instanceof TargetPlatformKind.Common)) {
                return false;
            }
            KtFile ktFile = origin.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"origin.containingKtFile");
            ModuleDescriptor moduleDescriptor = ResolutionUtils.findModuleDescriptor((KtElement)((KtElement)ktFile));
            List implModules = MultiplatformUtilKt.getImplementingDescriptors((ModuleDescriptor)moduleDescriptor);
            if (implModules.isEmpty()) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)origin, null, (int)1, null);
            if (declarationDescriptor == null) {
                return false;
            }
            DeclarationDescriptor methodDescriptor = declarationDescriptor;
            Iterable $receiver$iv = methodDescriptor.getAnnotations().getAllAnnotations();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    AnnotationWithTarget it = (AnnotationWithTarget)element$iv;
                    if (!KotlinMultiplatformJUnitRecognizerKt.access$isExpectOfAnnotation(it, "org.junit.Test", implModules)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }
}

