/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandler;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "()V", "maxInsertOffset", "", "maxLineLength", "minSpaceCount", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "clearInlays", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "createInlay", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "error", "message", "", "handle", "onFinish", "onStart", "printToToolWindow", "idea-jvm"})
public final class InlayScratchOutputHandler
implements ScratchOutputHandler {
    private static final int maxLineLength = 120;
    private static final int maxInsertOffset = 60;
    private static final int minSpaceCount = 4;
    public static final InlayScratchOutputHandler INSTANCE;

    @Override
    public void onStart(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.clear(file2);
    }

    @Override
    public void handle(@NotNull ScratchFile file2, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        if (StringsKt.isBlank((CharSequence)output.getText())) {
            return;
        }
        this.createInlay(file2, expression, output);
        if (output.getType() == ScratchOutputType.ERROR) {
            ToolWindowScratchOutputHandler.INSTANCE.handle(file2, expression, output);
        }
    }

    @Override
    public void error(@NotNull ScratchFile file2, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ToolWindowScratchOutputHandler.INSTANCE.error(file2, message);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
    }

    @Override
    public void clear(@NotNull ScratchFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.clearInlays(file2.getEditor());
        ToolWindowScratchOutputHandler.INSTANCE.clear(file2);
    }

    private final void createInlay(ScratchFile file2, ScratchExpression expression, ScratchOutput output) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(file2, expression, output){
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ ScratchExpression $expression;
            final /* synthetic */ ScratchOutput $output;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                Object v3;
                Function1<String, Unit> addInlay$;
                void spaceCount;
                block6: {
                    void $receiver$iv;
                    Editor editor = this.$file.getEditor().getEditor();
                    int line = this.$expression.getLineStart();
                    Editor editor2 = editor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
                    int lineStartOffset = editor2.getDocument().getLineStartOffset(line);
                    int lineEndOffset = editor.getDocument().getLineEndOffset(line);
                    int lineLength = lineEndOffset - lineStartOffset;
                    Ref.IntRef intRef = new Ref.IntRef();
                    intRef.element = InlayScratchOutputHandler.access$maxLineLength(InlayScratchOutputHandler.INSTANCE, this.$file) - lineLength + 4;
                    while (spaceCount.element + lineLength > 60 && spaceCount.element > 4) {
                        int n = spaceCount.element;
                        spaceCount.element = n + -1;
                    }
                    addInlay$ = new Function1<String, Unit>(this, (Ref.IntRef)spaceCount, lineLength, editor, lineEndOffset){
                        final /* synthetic */ createInlay.1 this$0;
                        final /* synthetic */ Ref.IntRef $spaceCount;
                        final /* synthetic */ int $lineLength;
                        final /* synthetic */ Editor $editor;
                        final /* synthetic */ int $lineEndOffset;

                        public final void invoke(@NotNull String text2) {
                            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
                            String textBeforeNewLine = StringUtil.containsLineBreak((CharSequence)text2) ? StringsKt.substringBefore$default((String)text2, (String)"\n", null, (int)2, null) + "..." : text2;
                            Integer n = 120 - this.$spaceCount.element - this.$lineLength;
                            int it = ((Number)n).intValue();
                            Integer n2 = it > 5 ? n : null;
                            int maxInlayLength = n2 != null ? n2 : 5;
                            String shortText = StringUtil.shortenTextWithEllipsis((String)textBeforeNewLine, (int)maxInlayLength, (int)0);
                            if (Intrinsics.areEqual((Object)shortText, (Object)text2) ^ true) {
                                InlayScratchOutputHandler.access$printToToolWindow(InlayScratchOutputHandler.INSTANCE, this.this$0.$file, this.this$0.$expression, this.this$0.$output);
                            }
                            Editor editor = this.$editor;
                            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
                            editor.getInlayModel().addInlineElement(this.$lineEndOffset, (EditorCustomElementRenderer)new InlayScratchFileRenderer(StringsKt.repeat((CharSequence)" ", (int)this.$spaceCount.element) + shortText, this.this$0.$output.getType()));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$spaceCount = intRef;
                            this.$lineLength = n;
                            this.$editor = editor;
                            this.$lineEndOffset = n2;
                            super(1);
                        }
                    };
                    List list = editor.getInlayModel().getInlineElementsInRange(lineEndOffset, lineEndOffset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"editor.inlayModel\n      \u2026EndOffset, lineEndOffset)");
                    Iterable iterable = list;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $receiver$iv) {
                        Inlay it;
                        Inlay inlay = it = (Inlay)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)inlay, (String)"it");
                        if (!(inlay.getRenderer() instanceof InlayScratchFileRenderer)) continue;
                        if (found$iv) {
                            v3 = null;
                            break block6;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v3 = !found$iv ? null : single$iv;
                }
                Inlay existing = v3;
                if (existing != null) {
                    existing.dispose();
                    EditorCustomElementRenderer editorCustomElementRenderer = existing.getRenderer();
                    if (editorCustomElementRenderer == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer");
                    }
                    addInlay$.invoke(StringsKt.drop((String)(((InlayScratchFileRenderer)editorCustomElementRenderer).getText() + "; " + this.$output.getText()), (int)spaceCount.element));
                } else {
                    addInlay$.invoke(this.$output.getText());
                }
            }
            {
                this.$file = scratchFile;
                this.$expression = scratchExpression;
                this.$output = scratchOutput;
            }
        });
    }

    private final void printToToolWindow(ScratchFile file2, ScratchExpression expression, ScratchOutput output) {
        if (output.getType() != ScratchOutputType.ERROR) {
            ToolWindowScratchOutputHandler.INSTANCE.handle(file2, expression, output);
        }
    }

    private final int maxLineLength(ScratchFile file2) {
        Iterable $receiver$iv$iv;
        Editor editor = file2.getEditor().getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"file.editor.editor");
        Document doc = editor.getDocument();
        Iterable $receiver$iv = file2.getExpressions();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ScratchExpression it = (ScratchExpression)element$iv$iv;
            int n = it.getLineStart();
            Iterable list$iv$iv = (Iterable)new IntRange(n, it.getLineEnd());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            int it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            Integer n = doc.getLineEndOffset(it) - doc.getLineStartOffset(it);
            collection.add(n);
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        return n != null ? n : 0;
    }

    private final void clearInlays(TextEditor editor) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(editor){
            final /* synthetic */ TextEditor $editor;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $receiver$iv$iv;
                Editor editor = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor\n                .editor");
                InlayModel inlayModel = editor.getInlayModel();
                Editor editor2 = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                Document document = editor2.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.editor.document");
                List list = inlayModel.getInlineElementsInRange(0, document.getTextLength());
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"editor\n                .\u2026itor.document.textLength)");
                Iterable $receiver$iv = list;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    Inlay it;
                    Inlay inlay = it = (Inlay)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)inlay, (String)"it");
                    if (!(inlay.getRenderer() instanceof InlayScratchFileRenderer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (E element$iv : $receiver$iv) {
                    Inlay it = (Inlay)element$iv;
                    Disposer.dispose((Disposable)((Disposable)it));
                }
            }
            {
                this.$editor = textEditor;
            }
        });
    }

    private InlayScratchOutputHandler() {
    }

    static {
        InlayScratchOutputHandler inlayScratchOutputHandler;
        INSTANCE = inlayScratchOutputHandler = new InlayScratchOutputHandler();
    }

    public static final /* synthetic */ int access$maxLineLength(InlayScratchOutputHandler $this, @NotNull ScratchFile file2) {
        return $this.maxLineLength(file2);
    }

    public static final /* synthetic */ void access$printToToolWindow(InlayScratchOutputHandler $this, @NotNull ScratchFile file2, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
        $this.printToToolWindow(file2, expression, output);
    }
}

