/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.actions.AnnotateTask;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInferNullityAnnotationAction
extends InferNullityAnnotationsAction {
    private static final Logger LOG = Logger.getInstance(AndroidInferNullityAnnotationAction.class);
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    private static final String ADD_DEPENDENCY = "Add Support Dependency";
    private static final int MIN_SDK_WITH_NULLABLE = 19;

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(1);
        }
        AndroidInferNullityAnnotationAction.setUpNullityAnnotationDefaults(project);
        if (!GradleProjects.isBuildWithGradle(project)) {
            super.analyze(project, scope);
            return;
        }
        int[] fileCount = new int[]{0};
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageInfo[] usageInfos = this.findUsages(project, scope, fileCount[0]);
        if (usageInfos == null) {
            return;
        }
        Map<Module, PsiFile> modules = AndroidInferNullityAnnotationAction.findModulesFromUsage(usageInfos);
        if (!this.checkModules(project, scope, modules)) {
            return;
        }
        if (usageInfos.length < 5) {
            ApplicationManager.getApplication().invokeLater(AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> usageInfos)));
        } else {
            AndroidInferNullityAnnotationAction.showUsageView(project, usageInfos, scope, this);
        }
    }

    private static void setUpNullityAnnotationDefaults(@NotNull Project project) {
        if (project == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(2);
        }
        NullableNotNullManager nullityManager = NullableNotNullManager.getInstance((Project)project);
        if (Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).anyMatch(module -> DependencyManagementUtil.dependsOnAndroidx(module))) {
            nullityManager.setDefaultNotNull("androidx.annotation.NonNull");
            nullityManager.setDefaultNullable("androidx.annotation.Nullable");
        } else {
            nullityManager.setDefaultNotNull("android.support.annotation.NonNull");
            nullityManager.setDefaultNullable("android.support.annotation.Nullable");
        }
    }

    private static Map<Module, PsiFile> findModulesFromUsage(UsageInfo[] infos) {
        HashMap<Module, PsiFile> modules = new HashMap<Module, PsiFile>();
        for (UsageInfo info : infos) {
            PsiElement element = info.getElement();
            assert (element != null);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            PsiFile file = element.getContainingFile();
            modules.put(module, file);
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkModules(final @NotNull Project project, final @NotNull AnalysisScope scope, @NotNull Map<Module, PsiFile> modules) {
        if (project == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(4);
        }
        if (modules == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(5);
        }
        final HashSet<Module> modulesWithoutAnnotations = new HashSet<Module>();
        HashSet<Module> modulesWithLowVersion = new HashSet<Module>();
        for (Module module : modules.keySet()) {
            GradleBuildModel buildModel;
            AndroidModuleInfo info = AndroidModuleInfo.getInstance(module);
            if (info != null && info.getBuildSdkVersion() != null && info.getBuildSdkVersion().getFeatureLevel() < 19) {
                modulesWithLowVersion.add(module);
            }
            if ((buildModel = GradleBuildModel.get(module)) == null) {
                LOG.warn("Unable to find Gradle build model for module " + module.getModuleFilePath());
                continue;
            }
            boolean dependencyFound = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            if (dependenciesModel != null) {
                String configurationName = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                for (ArtifactDependencyModel dependency : dependenciesModel.artifacts(configurationName)) {
                    String notation = dependency.compactNotation();
                    if (!notation.startsWith(GoogleMavenArtifactId.APP_COMPAT_V7.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7.toString()) && !notation.startsWith(GoogleMavenArtifactId.SUPPORT_V4.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_SUPPORT_V4.toString()) && !notation.startsWith(GoogleMavenArtifactId.SUPPORT_ANNOTATIONS.toString()) && !notation.startsWith(GoogleMavenArtifactId.ANDROIDX_SUPPORT_ANNOTATIONS.toString())) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            modulesWithoutAnnotations.add(module);
        }
        if (!modulesWithLowVersion.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)String.format("Infer Nullity Annotations requires the project sdk level be set to %1$d or greater.", 19), (String)INFER_NULLITY_ANNOTATIONS);
            return false;
        }
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String moduleNames = StringUtil.join(modulesWithoutAnnotations, Module::getName, (String)", ");
        int count = modulesWithoutAnnotations.size();
        String message = String.format("The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android nullity annotations. \n\nWould you like to add the %5$s now?", StringUtil.pluralize((String)"module", (int)count), moduleNames, count > 1 ? "do" : "does", GoogleMavenArtifactId.SUPPORT_ANNOTATIONS.getMavenArtifactId(), StringUtil.pluralize((String)"dependency", (int)count));
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(ADD_DEPENDENCY);
            try {
                new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        RepositoryUrlManager manager = RepositoryUrlManager.get();
                        GoogleMavenArtifactId annotation = (Boolean)StudioFlags.NELE_USE_ANDROIDX_DEFAULT.get() != false ? GoogleMavenArtifactId.ANDROIDX_SUPPORT_ANNOTATIONS : GoogleMavenArtifactId.SUPPORT_ANNOTATIONS;
                        String annotationsLibraryCoordinate = manager.getArtifactStringCoordinate(annotation, true);
                        for (Module module : modulesWithoutAnnotations) {
                            AndroidInferNullityAnnotationAction.addDependency(module, annotationsLibraryCoordinate);
                        }
                        AndroidInferNullityAnnotationAction.this.syncAndRestartAnalysis(project, scope);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction$1", "run"));
                    }
                }.execute();
            }
            finally {
                action2.finish();
            }
        }
        return false;
    }

    private void syncAndRestartAnalysis(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(7);
        }
        assert (ApplicationManager.getApplication().isDispatchThread());
        ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, false);
        Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

            public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult syncResult) {
                if (syncResult != null && syncResult.isSuccessful()) {
                    AndroidInferNullityAnnotationAction.this.restartAnalysis(project, scope);
                }
            }

            public void onFailure(@Nullable Throwable t) {
                throw new RuntimeException(t);
            }
        });
    }

    private static Runnable applyRunnable(final Project project, final Computable<UsageInfo[]> computable) {
        return () -> {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(INFER_NULLITY_ANNOTATIONS);
            try {
                new WriteCommandAction(project, INFER_NULLITY_ANNOTATIONS, new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        UsageInfo[] infos;
                        if (result2 == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if ((infos = (UsageInfo[])computable.compute()).length > 0) {
                            LinkedHashSet elements = new LinkedHashSet();
                            for (UsageInfo info : infos) {
                                PsiElement element = info.getElement();
                                if (element == null) continue;
                                ContainerUtil.addIfNotNull(elements, (Object)element.getContainingFile());
                            }
                            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                                return;
                            }
                            SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, AndroidInferNullityAnnotationAction.INFER_NULLITY_ANNOTATIONS, false);
                            progressTask.setMinIterationTime(200L);
                            progressTask.setTask((SequentialTask)new AnnotateTask(project, progressTask, infos));
                            ProgressManager.getInstance().run((Task)progressTask);
                        } else {
                            NullityInferrer.nothingFoundMessage((Project)project);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction$3", "run"));
                    }
                }.execute();
            }
            finally {
                action2.finish();
            }
        };
    }

    protected void restartAnalysis(Project project, AnalysisScope scope) {
        ApplicationManager.getApplication().invokeLater(() -> this.analyze(project, scope));
    }

    private static void showUsageView(@NotNull Project project, UsageInfo[] usageInfos, @NotNull AnalysisScope scope, AndroidInferNullityAnnotationAction action2) {
        if (project == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(9);
        }
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), "Preprocess Usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, AndroidInferNullityAnnotationAction.rerunFactory(project, scope, action2));
        Runnable refactoringRunnable = AndroidInferNullityAnnotationAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> {
            Set infos = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
            return infos.toArray(UsageInfo.EMPTY_ARRAY);
        }));
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable, INFER_NULLITY_ANNOTATIONS, canNotMakeString, INFER_NULLITY_ANNOTATIONS, false);
    }

    @NotNull
    private static Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope, final AndroidInferNullityAnnotationAction action2) {
        if (project == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(11);
        }
        Factory factory = () -> {
            if (project == null) {
                AndroidInferNullityAnnotationAction.$$$reportNull$$$0(15);
            }
            if (scope == null) {
                AndroidInferNullityAnnotationAction.$$$reportNull$$$0(16);
            }
            return new UsageInfoSearcherAdapter(){

                protected UsageInfo[] findUsages() {
                    return action2.findUsages(project, scope, scope.getFileCount());
                }

                public void generate(@NotNull Processor<Usage> processor) {
                    if (processor == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    this.processUsages(processor, project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction$4", "generate"));
                }
            };
        };
        if (factory == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(12);
        }
        return factory;
    }

    private static void addDependency(@NotNull Module module, @Nullable String libraryCoordinate) {
        if (module == null) {
            AndroidInferNullityAnnotationAction.$$$reportNull$$$0(13);
        }
        if (StringUtil.isNotEmpty((String)libraryCoordinate)) {
            ModuleRootModificationUtil.updateModel((Module)module, model -> {
                GradleBuildModel buildModel;
                if (module == null) {
                    AndroidInferNullityAnnotationAction.$$$reportNull$$$0(14);
                }
                if ((buildModel = GradleBuildModel.get(module)) != null) {
                    String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                    buildModel.dependencies().addArtifact(name, libraryCoordinate);
                    buildModel.applyChanges();
                }
            });
        }
    }

    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        JComponent panel = super.getAdditionalActionSettings(project, dialog);
        if (panel != null && GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            panel.setVisible(false);
        }
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/AndroidInferNullityAnnotationAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "rerunFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setUpNullityAnnotationDefaults";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkModules";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "syncAndRestartAnalysis";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showUsageView";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rerunFactory";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addDependency$8";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$rerunFactory$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

