/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import java.util.List;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidOpenFileAction
extends DumbAwareAction {
    public AndroidOpenFileAction() {
        this("Open...");
    }

    public AndroidOpenFileAction(@NotNull String text) {
        if (text == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(0);
        }
        super(text);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(1);
        }
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.Welcome.OpenProject);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        boolean showFiles = project != null || PlatformProjectOpenProcessor.getInstanceIfItExists() != null;
        OpenProjectFileChooserDescriptor descriptor = showFiles ? new ProjectOrFileChooserDescriptor() : new ProjectOnlyFileChooserDescriptor();
        descriptor.putUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT, (Object)showFiles);
        VirtualFile explicitPreferredDirectory = project != null && !project.isDefault() ? project.getBaseDir() : VfsUtil.getUserHomeDir();
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)explicitPreferredDirectory, arg_0 -> AndroidOpenFileAction.lambda$actionPerformed$0((FileChooserDescriptor)descriptor, project, e, arg_0));
    }

    @NotNull
    static ValidationIssue validateFiles(List<VirtualFile> files2, FileChooserDescriptor descriptor) {
        for (VirtualFile file : files2) {
            if (descriptor.isFileSelectable(file)) continue;
            Validator.Result result2 = new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("title.cannot.open.file", file.getPresentableUrl()));
            ValidationIssue validationIssue = new ValidationIssue(result2, file);
            if (validationIssue == null) {
                AndroidOpenFileAction.$$$reportNull$$$0(2);
            }
            return validationIssue;
        }
        ValidationIssue validationIssue = new ValidationIssue(Validator.Result.OK, null);
        if (validationIssue == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(3);
        }
        return validationIssue;
    }

    private static void doOpenFile(@NotNull AnActionEvent e, @NotNull List<VirtualFile> result2) {
        if (e == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(5);
        }
        Project project = e.getProject();
        for (VirtualFile file : result2) {
            if (file.isDirectory()) {
                if (project != null && !project.isDefault() && file.equals(project.getBaseDir())) {
                    ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
                    return;
                }
                if (ProjectAttachProcessor.canAttachToProject()) {
                    Project openedProject = PlatformProjectOpenProcessor.doOpenProject((VirtualFile)file, (Project)project, (boolean)false, (int)-1, null, (boolean)false);
                    FileChooserUtil.setLastOpenedFile((Project)openedProject, (VirtualFile)file);
                } else {
                    AndroidOpenFileAction.openOrImportProject(file, project);
                }
                return;
            }
            if ((project == null || !file.equals(project.getProjectFile())) && OpenProjectFileChooserDescriptor.isProjectFile((VirtualFile)file) && AndroidOpenFileAction.openOrImportProject(file, project)) {
                return;
            }
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file, (Project)project);
            if (type == null) {
                return;
            }
            if (project != null) {
                OpenFileAction.openFile((VirtualFile)file, (Project)project);
                continue;
            }
            PlatformProjectOpenProcessor processor = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor == null) continue;
            processor.doOpenProject(file, null, false);
        }
    }

    private static boolean openOrImportProject(@NotNull VirtualFile file, @Nullable Project project) {
        VirtualFile target;
        if (file == null) {
            AndroidOpenFileAction.$$$reportNull$$$0(6);
        }
        if (GradleProjects.canImportAsGradleProject(file) && (target = ProjectImportUtil.findImportTarget(file)) != null) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            if (openProjects.length > 0) {
                int exitCode = ProjectUtil.confirmOpenNewProject((boolean)false);
                if (exitCode == 1) {
                    Project toClose;
                    Project project2 = toClose = project != null && !project.isDefault() ? project : openProjects[openProjects.length - 1];
                    if (!ProjectUtil.closeAndDispose((Project)toClose)) {
                        return false;
                    }
                } else if (exitCode != 0) {
                    return false;
                }
            }
            GradleProjectImporter gradleImporter = GradleProjectImporter.getInstance();
            gradleImporter.importProject(file);
            return true;
        }
        Project opened = ProjectUtil.openOrImport((String)file.getPath(), (Project)project, (boolean)false);
        if (opened != null) {
            FileChooserUtil.setLastOpenedFile((Project)opened, (VirtualFile)file);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$actionPerformed$0(FileChooserDescriptor descriptor, Project project, AnActionEvent e, List files2) {
        ValidationIssue issue2 = AndroidOpenFileAction.validateFiles(files2, descriptor);
        if (issue2.result.getSeverity() != Validator.Severity.OK) {
            boolean isError = issue2.result.getSeverity() == Validator.Severity.ERROR;
            String title = isError ? IdeBundle.message((String)"title.cannot.open.project", (Object[])new Object[0]) : "Warning Opening Project";
            Messages.showInfoMessage((Project)project, (String)issue2.result.getMessage(), (String)title);
            if (isError) {
                return;
            }
        }
        AndroidOpenFileAction.doOpenFile(e, files2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/AndroidOpenFileAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/AndroidOpenFileAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doOpenFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openOrImportProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectOrFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        private final FileChooserDescriptor myStandardDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withHideIgnored(false);

        public ProjectOrFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.file.or.project", (Object[])new Object[0]));
        }

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            return file.isDirectory() ? super.isFileVisible(file, showHiddenFiles) : this.myStandardDescriptor.isFileVisible(file, showHiddenFiles);
        }

        public boolean isFileSelectable(VirtualFile file) {
            return file.isDirectory() ? super.isFileSelectable(file) : this.myStandardDescriptor.isFileSelectable(file);
        }

        public boolean isChooseMultiple() {
            return true;
        }
    }

    private static class ProjectOnlyFileChooserDescriptor
    extends OpenProjectFileChooserDescriptor {
        public ProjectOnlyFileChooserDescriptor() {
            super(true);
            this.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        }
    }

    static final class ValidationIssue {
        @NotNull
        Validator.Result result;
        @Nullable
        VirtualFile file;

        public ValidationIssue(@NotNull Validator.Result result2, @Nullable VirtualFile file) {
            if (result2 == null) {
                ValidationIssue.$$$reportNull$$$0(0);
            }
            this.result = result2;
            this.file = file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/AndroidOpenFileAction$ValidationIssue", "<init>"));
        }
    }
}

