/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ConvertLayoutToDataBindingAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        if ("Convert to data binding layout" == null) {
            ConvertLayoutToDataBindingAction.$$$reportNull$$$0(0);
        }
        return "Convert to data binding layout";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ConvertLayoutToDataBindingAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ConvertLayoutToDataBindingAction.$$$reportNull$$$0(2);
        }
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.LAYOUT) {
            return false;
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)file;
        XmlTag tag = xmlFile.getRootTag();
        if (tag == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        if (!tag.equals(element.getParent()) && offset >= tag.getTextOffset()) {
            return false;
        }
        if (tag.getName().equals("layout")) {
            return false;
        }
        return this.isUsingDataBinding(project);
    }

    protected boolean isUsingDataBinding(@NotNull Project project) {
        DataBindingProjectComponent component;
        if (project == null) {
            ConvertLayoutToDataBindingAction.$$$reportNull$$$0(3);
        }
        return (component = (DataBindingProjectComponent)project.getComponent(DataBindingProjectComponent.class)) != null && component.hasAnyDataBindingEnabledFacet();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ConvertLayoutToDataBindingAction.$$$reportNull$$$0(4);
        }
        XmlFile xmlFile = (XmlFile)file;
        XmlTag root = xmlFile.getRootTag();
        assert (root != null);
        XmlElementFactory factory = XmlElementFactory.getInstance((Project)project);
        XmlTag newRoot = factory.createTagFromText((CharSequence)"<layout>\n<data>\n\n</data></layout>");
        String rootText = root.getText();
        newRoot = (XmlTag)root.replace((PsiElement)newRoot);
        root = factory.createTagFromText((CharSequence)rootText);
        for (XmlAttribute attribute : root.getAttributes()) {
            String name = attribute.getName();
            if (!name.startsWith("xmlns:")) continue;
            newRoot.setAttribute(name, attribute.getValue());
            attribute.delete();
        }
        XmlAttribute context = root.getAttribute("context", "http://schemas.android.com/tools");
        if (context != null) {
            root.setAttribute("context", "http://schemas.android.com/tools", context.getValue());
            context.delete();
        }
        newRoot.addSubTag(root, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/ConvertLayoutToDataBindingAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/ConvertLayoutToDataBindingAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUsingDataBinding";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

