/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.ide.projectView.actions.MarkLibraryRootAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.DefaultLibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SortedListModel;
import com.intellij.util.ui.FormBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLibraryFromFilesAction
extends AnAction {
    AnAction myDelegate = new MarkLibraryRootAction();

    public CreateLibraryFromFilesAction() {
        super("Add As Library...");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            CreateLibraryFromFilesAction.$$$reportNull$$$0(0);
        }
        if ((project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        if (!AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
            this.myDelegate.actionPerformed(e);
            return;
        }
        List<VirtualFile> jars = CreateLibraryFromFilesAction.getRoots(e);
        if (jars.isEmpty()) {
            return;
        }
        List roots = RootDetectionUtil.detectRoots(jars, null, (Project)project, (LibraryRootsComponentDescriptor)new DefaultLibraryRootsComponentDescriptor());
        new CreateGradleLibraryFromFilesDialog(project, roots).show();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateLibraryFromFilesAction.$$$reportNull$$$0(1);
        }
        Project project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e);
        boolean visible = false;
        if (project != null && ModuleManager.getInstance((Project)project).getModules().length > 0) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (VirtualFile root : CreateLibraryFromFilesAction.getRoots(e)) {
                if (root.isInLocalFileSystem() || !FileUtilRt.extensionEquals((String)root.getName(), (String)"jar") || fileIndex.isInLibraryClasses(root)) continue;
                visible = true;
                break;
            }
        }
        Presentation presentation = e.getPresentation();
        presentation.setVisible(visible);
        presentation.setEnabled(visible);
    }

    @NotNull
    private static List<VirtualFile> getRoots(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateLibraryFromFilesAction.$$$reportNull$$$0(2);
        }
        Project project = CreateLibraryFromFilesAction.getEventProject((AnActionEvent)e);
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null || files2 == null || files2.length == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                CreateLibraryFromFilesAction.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (VirtualFile file : files2) {
            VirtualFile root = JarFileSystem.getInstance().getJarRootForLocalFile(file);
            if (root == null) continue;
            roots.add(root);
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            CreateLibraryFromFilesAction.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/CreateLibraryFromFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/CreateLibraryFromFilesAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateGradleLibraryFromFilesDialog
    extends DialogWrapper {
        public static final String COMMAND_TITLE = "Create Library";
        private final ModulesComboBox myModulesComboBox;
        private final Project myProject;
        private final JPanel myPanel;
        private final List<OrderRoot> myRoots;
        private GradleSettingsFile mySettingsFile;

        public CreateGradleLibraryFromFilesDialog(@NotNull Project project, @NotNull List<OrderRoot> roots) {
            if (project == null) {
                CreateGradleLibraryFromFilesDialog.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                CreateGradleLibraryFromFilesDialog.$$$reportNull$$$0(1);
            }
            super(project, true);
            this.setTitle(COMMAND_TITLE);
            this.myProject = project;
            this.myRoots = roots;
            this.mySettingsFile = GradleSettingsFile.get(this.myProject);
            FormBuilder builder = LibraryNameAndLevelPanel.createFormBuilder();
            this.myModulesComboBox = new ModulesComboBox();
            this.myModulesComboBox.fillModules(this.myProject);
            this.myModulesComboBox.setSelectedModule(this.findModule(roots));
            Iterator iter = ((SortedListModel)this.myModulesComboBox.getModel()).iterator();
            while (iter.hasNext()) {
                Module module = (Module)iter.next();
                String path = GradleSettingsFile.getModuleGradlePath(module);
                if (path != null && this.mySettingsFile.hasBuildFile(path)) continue;
                iter.remove();
            }
            builder.addLabeledComponent("&Add to module:", (JComponent)this.myModulesComboBox);
            this.myPanel = builder.getPanel();
            this.init();
        }

        @Nullable
        private Module findModule(List<OrderRoot> roots) {
            for (OrderRoot root : roots) {
                Module module = null;
                VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(root.getFile());
                if (local != null) {
                    module = ModuleUtilCore.findModuleForFile((VirtualFile)local, (Project)this.myProject);
                }
                if (module == null) {
                    module = ModuleUtilCore.findModuleForFile((VirtualFile)root.getFile(), (Project)this.myProject);
                }
                if (module == null) continue;
                return module;
            }
            return null;
        }

        protected void doOKAction() {
            WriteAction.run(() -> {
                Module module = this.myModulesComboBox.getSelectedModule();
                if (module == null) {
                    return;
                }
                String moduleGradlePath = GradleSettingsFile.getModuleGradlePath(module);
                if (moduleGradlePath == null) {
                    return;
                }
                final GradleBuildFile buildFile = this.mySettingsFile.getModuleBuildFile(moduleGradlePath);
                List value = (List)buildFile.getValue(BuildFileKey.DEPENDENCIES);
                final List dependencies = value != null ? value : new ArrayList();
                boolean added = false;
                for (OrderRoot root : this.myRoots) {
                    VirtualFile parent = buildFile.getFile().getParent();
                    VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(root.getFile());
                    if (local != null) {
                        Dependency.Scope scope;
                        Dependency newDependency;
                        String path = VfsUtilCore.getRelativePath((VirtualFile)local, (VirtualFile)parent, (char)'/');
                        if (path == null) {
                            path = local.getPath();
                        }
                        if (!dependencies.contains(newDependency = new Dependency(scope = Dependency.Scope.getDefaultScope(this.myProject), Dependency.Type.FILES, path))) {
                            dependencies.add(newDependency);
                            added = true;
                        }
                    }
                    if (!added) continue;
                    new WriteCommandAction<Void>(this.myProject, COMMAND_TITLE, new PsiFile[]{buildFile.getPsiFile()}){

                        protected void run(@NotNull Result<Void> result2) throws Throwable {
                            if (result2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            buildFile.setValue(BuildFileKey.DEPENDENCIES, dependencies);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/actions/CreateLibraryFromFilesAction$CreateGradleLibraryFromFilesDialog$1", "run"));
                        }
                    }.execute();
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> ProjectSystemUtil.getProjectSystem(this.myProject).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true));
            super.doOKAction();
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/actions/CreateLibraryFromFilesAction$CreateGradleLibraryFromFilesDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

