/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.FileUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendFeedbackAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(SendFeedbackAction.class);
    private static final Pattern CMAKE_VERSION_PATTERN = Pattern.compile("cmake version\\s+(.*)");

    public void actionPerformed(AnActionEvent e) {
        SendFeedbackAction.launchBrowser(e.getProject());
    }

    public static void launchBrowser(@Nullable Project project) {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        boolean eap = appInfo.isEAP();
        String urlTemplate = eap ? appInfo.getEAPFeedbackUrl() : appInfo.getReleaseFeedbackUrl();
        urlTemplate = urlTemplate.replace("$BUILD", eap ? appInfo.getBuild().asStringWithoutProductCode() : appInfo.getBuild().asString()).replace("$TIMEZONE", System.getProperty("user.timezone")).replace("$VERSION", appInfo.getFullVersion()).replace("$EVAL", "false").replace("$DESCR", SendFeedbackAction.getDescription(project));
        BrowserUtil.browse((String)urlTemplate, (Project)project);
    }

    private static String getBasicDescription() {
        String javaVendor;
        StringBuilder sb = new StringBuilder("\n\n");
        sb.append(ApplicationInfoEx.getInstanceEx().getBuild().asString()).append(", ");
        String javaVersion = System.getProperty("java.runtime.version", System.getProperty("java.version", "unknown"));
        sb.append("JRE ");
        sb.append(javaVersion);
        String archDataModel = System.getProperty("sun.arch.data.model");
        if (archDataModel != null) {
            sb.append("x").append(archDataModel);
        }
        if ((javaVendor = System.getProperty("java.vm.vendor")) != null) {
            sb.append(" ").append(javaVendor);
        }
        sb.append(", OS ").append(System.getProperty("os.name"));
        String osArch = System.getProperty("os.arch");
        if (osArch != null) {
            sb.append("(").append(osArch).append(")");
        }
        String osVersion = System.getProperty("os.version");
        String osPatchLevel = System.getProperty("sun.os.patch.level");
        if (osVersion != null) {
            sb.append(" v").append(osVersion);
            if (osPatchLevel != null) {
                sb.append(" ").append(osPatchLevel);
            }
        }
        if (!GraphicsEnvironment.isHeadless()) {
            sb.append(", screens ");
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            for (int i = 0; i < devices.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                GraphicsDevice device = devices[i];
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                sb.append(bounds.width).append("x").append(bounds.height);
            }
            if (UIUtil.isRetina()) {
                sb.append(SystemInfo.isMac ? "; Retina" : "; HiDPI");
            }
        }
        return sb.toString();
    }

    public static String getDescription(@Nullable Project project) {
        return SendFeedbackAction.safeCall(() -> {
            StringBuilder sb = new StringBuilder(SendFeedbackAction.getBasicDescription());
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SendFeedbackAction.class);
            AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            sb.append("\n\n");
            if (project != null) {
                sb.append(String.format("Android Gradle Plugin: %1$s\n", SendFeedbackAction.safeCall(() -> SendFeedbackAction.getGradlePluginDetails(project))));
                sb.append(String.format("Gradle: %1$s\n", SendFeedbackAction.safeCall(() -> SendFeedbackAction.getGradleDetails(project))));
            }
            sb.append(String.format("NDK: %1$s\n", SendFeedbackAction.safeCall(() -> SendFeedbackAction.lambda$null$2(project, sdkHandler, (ProgressIndicator)progress))));
            sb.append(String.format("LLDB: %1$s\n", SendFeedbackAction.safeCall(() -> SendFeedbackAction.lambda$null$3(sdkHandler, (ProgressIndicator)progress))));
            sb.append(String.format("CMake: %1$s\n", SendFeedbackAction.safeCall(() -> SendFeedbackAction.lambda$null$4(project, sdkHandler, (ProgressIndicator)progress))));
            return sb.toString();
        });
    }

    private static String safeCall(@NotNull Supplier<String> runnable) {
        if (runnable == null) {
            SendFeedbackAction.$$$reportNull$$$0(0);
        }
        try {
            return runnable.get();
        }
        catch (Throwable e) {
            LOG.info("Unable to prepopulate additional version information - proceeding with sending feedback anyway. ", e);
            return "(unable to retrieve additional version information)";
        }
    }

    private static String getGradlePluginDetails(@NotNull Project project) {
        GradleVersion androidPluginVersion;
        AndroidPluginInfo androidPluginInfo;
        if (project == null) {
            SendFeedbackAction.$$$reportNull$$$0(1);
        }
        if ((androidPluginInfo = AndroidPluginInfo.find(project)) != null && (androidPluginVersion = androidPluginInfo.getPluginVersion()) != null) {
            return androidPluginVersion.toString();
        }
        return "(plugin information not found)";
    }

    private static String getGradleDetails(@NotNull Project project) {
        GradleVersion gradleVersion;
        if (project == null) {
            SendFeedbackAction.$$$reportNull$$$0(2);
        }
        if ((gradleVersion = GradleVersions.getInstance().getGradleVersion(project)) != null) {
            return gradleVersion.toString();
        }
        return "(gradle version information not found)";
    }

    private static String getNdkDetails(@Nullable Project project, @NotNull AndroidSdkHandler sdkHandler, @NotNull ProgressIndicator progress) {
        if (sdkHandler == null) {
            SendFeedbackAction.$$$reportNull$$$0(3);
        }
        if (progress == null) {
            SendFeedbackAction.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder();
        if (project != null) {
            try {
                String ndkDir = new LocalProperties(project).getProperty("ndk.dir");
                sb.append(String.format("from local.properties: %1$s; ", ndkDir == null ? "(not specified)" : SendFeedbackAction.getNdkVersion(ndkDir)));
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file of Project '%1$s'", project.getName()), (Throwable)e);
            }
        }
        LocalPackage p = sdkHandler.getLatestLocalPackageForPrefix("ndk-bundle", null, false, progress);
        sb.append(String.format("latest from SDK: %1$s; ", p == null ? "(not found)" : SendFeedbackAction.getNdkVersion(p.getLocation().getAbsolutePath())));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNdkVersion(@NotNull String ndkDir) {
        File sourcePropertiesFile;
        if (ndkDir == null) {
            SendFeedbackAction.$$$reportNull$$$0(5);
        }
        if ((sourcePropertiesFile = new File(ndkDir, "source.properties")).exists()) {
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(sourcePropertiesFile);
                Properties props = new Properties();
                props.load(fileInput);
                String string = props.getProperty("Pkg.Revision");
                return string;
            }
            catch (Exception e) {
                LOG.info("Could not read NDK version", (Throwable)e);
                String string = "(unable to read)";
                return string;
            }
            finally {
                if (fileInput != null) {
                    try {
                        ((InputStream)fileInput).close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close '" + sourcePropertiesFile.getPath() + "'", (Throwable)e);
                    }
                }
            }
        }
        File releaseTxtFile = new File(ndkDir, "RELEASE.TXT");
        if (releaseTxtFile.exists()) {
            try {
                byte[] content = Files.readAllBytes(releaseTxtFile.toPath());
                return new String(content).trim();
            }
            catch (IOException e) {
                LOG.info("Could not read NDK version", (Throwable)e);
                return "(unable to read)";
            }
        }
        return "UNKNOWN";
    }

    private static String getLldbDetails(@NotNull AndroidSdkHandler sdkHandler, @NotNull ProgressIndicator progress) {
        String path;
        LocalPackage p;
        if (sdkHandler == null) {
            SendFeedbackAction.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            SendFeedbackAction.$$$reportNull$$$0(7);
        }
        if ((p = sdkHandler.getLocalPackage(path = DetailsTypes.getLldbPath((Revision)Revision.parseRevision((String)"3.1")), progress)) == null) {
            p = sdkHandler.getLatestLocalPackageForPrefix("lldb", null, false, progress);
            return String.format("pinned revision %1$s not found; latest from SDK: %2$s; ", "3.1", SendFeedbackAction.getLocalPackageDisplayInfo(p));
        }
        return SendFeedbackAction.getLocalPackageDisplayInfo(p);
    }

    private static String getCMakeDetails(@Nullable Project project, @NotNull AndroidSdkHandler sdkHandler, @NotNull ProgressIndicator progress) {
        if (sdkHandler == null) {
            SendFeedbackAction.$$$reportNull$$$0(8);
        }
        if (progress == null) {
            SendFeedbackAction.$$$reportNull$$$0(9);
        }
        StringBuilder sb = new StringBuilder();
        if (project != null) {
            try {
                String cmakeDir = new LocalProperties(project).getProperty("cmake.dir");
                sb.append(String.format("from local.properties: %1$s; ", cmakeDir == null ? "(not specified)" : SendFeedbackAction.runAndGetCMakeVersion(SendFeedbackAction.getCMakeExecutablePath(cmakeDir))));
            }
            catch (IOException e) {
                LOG.info(String.format("Unable to read local.properties file of Project '%1$s'", project.getName()), (Throwable)e);
            }
        }
        LocalPackage p = sdkHandler.getLatestLocalPackageForPrefix("cmake", null, false, progress);
        sb.append(String.format("latest from SDK: %1$s; ", p == null ? "(not found)" : SendFeedbackAction.runAndGetCMakeVersion(SendFeedbackAction.getCMakeExecutablePath(p.getLocation().getAbsolutePath()))));
        String cmakeBinFromPath = SendFeedbackAction.findOnPath("cmake");
        sb.append(String.format("from PATH: %1$s; ", cmakeBinFromPath == null ? "(not found)" : SendFeedbackAction.runAndGetCMakeVersion(cmakeBinFromPath)));
        return sb.toString();
    }

    @Nullable
    private static String findOnPath(@NotNull String executableName) {
        String path;
        if (executableName == null) {
            SendFeedbackAction.$$$reportNull$$$0(10);
        }
        if ((path = EnvironmentUtil.getValue((String)"PATH")) != null) {
            for (String dir : StringUtil.tokenize((String)path, (String)File.pathSeparator)) {
                File candidate = new File(dir, executableName);
                if (!candidate.canExecute()) continue;
                return candidate.getAbsolutePath();
            }
        }
        return null;
    }

    private static String getCMakeExecutableName() {
        String cmakeExecutableName = "cmake";
        if (SystemInfo.isWindows) {
            cmakeExecutableName = cmakeExecutableName + ".exe";
        }
        return cmakeExecutableName;
    }

    private static String getCMakeExecutablePath(@NotNull String cmakeDir) {
        String cmakeExecutableName;
        String cmakeBinDirectory;
        File cmakeExecutableFile;
        if (cmakeDir == null) {
            SendFeedbackAction.$$$reportNull$$$0(11);
        }
        if (!(cmakeExecutableFile = new File(FileUtils.join((String[])new String[]{cmakeBinDirectory = FileUtils.join((String[])new String[]{cmakeDir, "bin"}), cmakeExecutableName = SendFeedbackAction.getCMakeExecutableName()}))).exists() || !cmakeExecutableFile.canExecute()) {
            return "(binary doesn't exist or is not executable)";
        }
        return cmakeExecutableFile.getAbsolutePath();
    }

    private static String runAndGetCMakeVersion(@NotNull String cmakeExecutableFile) {
        if (cmakeExecutableFile == null) {
            SendFeedbackAction.$$$reportNull$$$0(12);
        }
        LOG.info("CMake binary: " + cmakeExecutableFile);
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{cmakeExecutableFile});
        commandLine.addParameter("-version");
        try {
            Matcher m;
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            final StringBuffer output = new StringBuffer();
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/idea/actions/SendFeedbackAction$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            int exitCode = process.runProcess().getExitCode();
            if (exitCode == 0 && (m = CMAKE_VERSION_PATTERN.matcher(output.toString())).find()) {
                return m.group(1);
            }
            return output.length() > 0 ? output.toString() : "(empty output)";
        }
        catch (ExecutionException e) {
            LOG.info("Could not invoke 'cmake -version'", (Throwable)e);
            return "(unable to invoke cmake)";
        }
    }

    private static String getLocalPackageDisplayInfo(@Nullable LocalPackage p) {
        if (p == null) {
            return "(package not found)";
        }
        return String.format("%1$s (revision: %2$s)", p.getDisplayName(), p.getVersion());
    }

    public void update(AnActionEvent e) {
        super.update(e);
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setEnabled(SystemInfo.isMac || SystemInfo.isLinux || SystemInfo.isWindows);
        }
    }

    private static /* synthetic */ String lambda$null$4(@Nullable Project project, AndroidSdkHandler sdkHandler, ProgressIndicator progress) {
        return SendFeedbackAction.getCMakeDetails(project, sdkHandler, progress);
    }

    private static /* synthetic */ String lambda$null$3(AndroidSdkHandler sdkHandler, ProgressIndicator progress) {
        return SendFeedbackAction.getLldbDetails(sdkHandler, progress);
    }

    private static /* synthetic */ String lambda$null$2(@Nullable Project project, AndroidSdkHandler sdkHandler, ProgressIndicator progress) {
        return SendFeedbackAction.getNdkDetails(project, sdkHandler, progress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeExecutableFile";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/actions/SendFeedbackAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "safeCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getGradlePluginDetails";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getGradleDetails";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNdkDetails";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNdkVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getLldbDetails";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCMakeDetails";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findOnPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getCMakeExecutablePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "runAndGetCMakeVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

