/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.StepElementData;
import com.android.tools.idea.assistant.datamodel.StepElementType;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.templates.recipe.Recipe;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.IconLoader;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;

@XmlRootElement(name="tutorialBundle")
public class DefaultTutorialBundle
implements TutorialBundleData {
    @XmlAttribute(name="name")
    private String myName;
    @XmlAttribute(name="icon")
    @Nullable
    private String myIconName;
    @XmlAttribute(name="logo")
    @Nullable
    private String myLogoName;
    @XmlAttribute(name="id")
    private String myId;
    @XmlAttribute(name="delete")
    private int myDeleteme;
    @XmlAttribute(name="contentRoot")
    private String myContentRoot;
    @XmlAttribute(name="resourceRoot")
    private String myResourceRoot;
    @XmlElement(name="welcome")
    private String myWelcome;
    @XmlElement(name="learnMoreLink")
    private String myLearnMoreLink;
    @XmlAttribute(name="stepByStep")
    private boolean myStepByStep;
    @XmlAttribute(name="hideStepIndex")
    private boolean myHideStepIndex;
    private Icon myIcon;
    private Icon myLogo;
    private Class myResourceClass;
    @XmlElements(value={@XmlElement(name="feature", type=Feature.class)})
    private List<Feature> myFeatures = Lists.newArrayList();

    public static TutorialBundleData parse(@NotNull InputStream stream) throws JAXBException {
        if (stream == null) {
            DefaultTutorialBundle.$$$reportNull$$$0(0);
        }
        return DefaultTutorialBundle.parse(stream, DefaultTutorialBundle.class);
    }

    public static <T> T parse(@NotNull InputStream stream, Class<T> clazz) throws JAXBException {
        if (stream == null) {
            DefaultTutorialBundle.$$$reportNull$$$0(1);
        }
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{clazz}).createUnmarshaller();
        unmarshaller.setEventHandler(event -> {
            DefaultTutorialBundle.getLog().info("Found unhandled xml", event.getLinkedException());
            return true;
        });
        return (T)unmarshaller.unmarshal((Source)new StreamSource(stream), clazz).getValue();
    }

    private static Logger getLog() {
        return Logger.getInstance(TutorialBundleData.class);
    }

    @Override
    public void setResourceClass(@NotNull Class clazz) {
        if (clazz == null) {
            DefaultTutorialBundle.$$$reportNull$$$0(2);
        }
        this.myResourceClass = clazz;
        this.myFeatures.forEach(feature -> {
            if (clazz == null) {
                DefaultTutorialBundle.$$$reportNull$$$0(7);
            }
            feature.getTutorials().forEach(tutorial -> {
                if (clazz == null) {
                    DefaultTutorialBundle.$$$reportNull$$$0(8);
                }
                tutorial.setResourceClass(clazz);
            });
        });
    }

    @Nullable
    private Icon getIconResource(@NotNull String path) {
        if (path == null) {
            DefaultTutorialBundle.$$$reportNull$$$0(3);
        }
        return IconLoader.findIcon((String)path, (Class)this.myResourceClass);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DefaultTutorialBundle.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isStepByStep() {
        return this.myStepByStep;
    }

    @Override
    public boolean hideStepIndex() {
        return this.myHideStepIndex;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        if (this.myIcon != null) {
            return this.myIcon;
        }
        if (this.myIconName == null || this.myResourceRoot == null) {
            return null;
        }
        this.myIcon = this.getIconResource(this.myResourceRoot + "/" + this.myIconName);
        return this.myIcon;
    }

    @Override
    @Nullable
    public Icon getLogo() {
        if (this.myLogo != null) {
            return this.myLogo;
        }
        if (this.myLogoName == null || this.myResourceRoot == null) {
            return null;
        }
        this.myLogo = this.getIconResource(this.myResourceRoot + "/" + this.myLogoName);
        return this.myLogo;
    }

    @NotNull
    public List<Feature> getFeatures() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myFeatures);
        if (immutableList == null) {
            DefaultTutorialBundle.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public String getWelcome() {
        String string = this.myWelcome;
        if (string == null) {
            DefaultTutorialBundle.$$$reportNull$$$0(6);
        }
        return string;
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        this.myFeatures.forEach(feature -> feature.getTutorials().forEach(tutorial -> {
            tutorial.myResourceRoot = this.myResourceRoot;
        }));
    }

    public String toString() {
        return "TutorialBundle{myName='" + this.myName + '\'' + ", myIcon='" + this.myIcon + '\'' + ", myLogo='" + this.myLogo + '\'' + ", myId='" + this.myId + '\'' + ", myContentRoot='" + this.myContentRoot + '\'' + ", myResourceRoot='" + this.myResourceRoot + '\'' + ", myWelcome='" + this.myWelcome + '\'' + ", myLearnMoreLink='" + this.myLearnMoreLink + '\'' + ", myFeatures=" + this.myFeatures + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/assistant/DefaultTutorialBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/assistant/DefaultTutorialBundle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWelcome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setResourceClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIconResource";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setResourceClass$2";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Action
    implements ActionData {
        @XmlAttribute(name="label")
        private String myLabel;
        @XmlAttribute(name="key")
        private String myKey;
        @XmlAttribute(name="actionArgument")
        private String myActionArgument;
        @XmlAttribute(name="successMessage")
        private String mySuccessMessage;
        @XmlAttribute(name="editAction")
        private String myEditAction;
        @XmlElement(name="recipe", type=Recipe.class)
        private Recipe myRecipe;

        @Override
        @NotNull
        public String getLabel() {
            String string = this.myLabel;
            if (string == null) {
                Action.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getKey() {
            String string = this.myKey;
            if (string == null) {
                Action.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public String getActionArgument() {
            return this.myActionArgument;
        }

        @Override
        public String getSuccessMessage() {
            return this.mySuccessMessage;
        }

        @Override
        public Recipe getRecipe() {
            return this.myRecipe;
        }

        public String toString() {
            return "Action{myLabel='" + this.myLabel + "', myKey='" + this.myKey + "', myActionArgument='" + this.myActionArgument + "', mySuccessMessage='" + this.mySuccessMessage + "', myEditAction='" + this.myEditAction + "', myRecipe='" + this.myRecipe + "'" + '}';
        }

        private void afterUnmarshal(Unmarshaller u, Object parent) {
            if (this.myRecipe != null) {
                this.myRecipe.addUpdateAndSyncGradleInstruction();
            }
        }

        public boolean equals(@Nullable Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Action)) {
                return false;
            }
            Action otherAction = (Action)that;
            return this.toString().equals(otherAction.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/assistant/DefaultTutorialBundle$Action";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static final class Image {
        @XmlAttribute(name="src")
        private String mySource;
        @XmlAttribute(name="height")
        private int myHeight;
        @XmlAttribute(name="width")
        private int myWidth;
        @XmlAttribute(name="description")
        private String myDescription;

        @Nullable
        public String getSource() {
            return this.mySource;
        }

        public int getHeight() {
            return this.myHeight;
        }

        public int getWidth() {
            return this.myWidth;
        }

        @Nullable
        public String getDescription() {
            return this.myDescription;
        }
    }

    public static final class Code {
        @XmlValue
        private String myCode;
        @XmlAttribute(name="fileType")
        private String myCodeType;

        public String getCode() {
            return this.myCode;
        }

        public FileType getCodeType() {
            if (this.myCodeType == null) {
                return null;
            }
            String type = this.myCodeType.trim().toUpperCase(Locale.ENGLISH);
            if (type.equals("JAVA")) {
                return StdFileTypes.JAVA;
            }
            if (type.equals("XML")) {
                return StdFileTypes.XML;
            }
            if (type.equals("GROOVY")) {
                return GroovyFileType.GROOVY_FILE_TYPE;
            }
            if (type.equals("PLAIN_TEXT")) {
                return FileTypes.PLAIN_TEXT;
            }
            return null;
        }
    }

    public static final class StepElement
    implements StepElementData {
        private StepElementType myType;
        @XmlElement(name="code", type=Code.class)
        private Code myCode;
        @XmlElement(name="section")
        private String mySection;
        @XmlElement(name="action", type=Action.class)
        private Action myAction;
        @XmlElement(name="image", type=Image.class)
        private Image myImage;

        @Override
        @NotNull
        public StepElementType getType() {
            if (this.myType != null) {
                StepElementType stepElementType = this.myType;
                if (stepElementType == null) {
                    StepElement.$$$reportNull$$$0(0);
                }
                return stepElementType;
            }
            if (this.myAction != null) {
                this.myType = StepElementType.ACTION;
            } else if (this.mySection != null) {
                this.myType = StepElementType.SECTION;
            } else if (this.myCode != null) {
                this.myType = StepElementType.CODE;
            } else if (this.myImage != null) {
                this.myType = StepElementType.IMAGE;
            }
            if (this.myType == null) {
                throw new RuntimeException("Unsupported StepElement.");
            }
            StepElementType stepElementType = this.myType;
            if (stepElementType == null) {
                StepElement.$$$reportNull$$$0(1);
            }
            return stepElementType;
        }

        @Override
        public String getCode() {
            return this.myCode.getCode();
        }

        @Override
        public FileType getCodeType() {
            return this.myCode == null ? null : this.myCode.getCodeType();
        }

        @Override
        public String getSection() {
            return this.mySection;
        }

        @Override
        public Action getAction() {
            return this.myAction;
        }

        @Override
        @Nullable
        public Image getImage() {
            return this.myImage;
        }

        public String toString() {
            return "StepElement{myType='" + (Object)((Object)this.getType()) + "'" + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/assistant/DefaultTutorialBundle$StepElement", "getType"));
        }
    }

    public static final class Step
    implements StepData {
        @XmlElements(value={@XmlElement(name="stepElement", type=StepElement.class)})
        private List<StepElement> myStepElements = Lists.newArrayList();
        @XmlAttribute(name="label")
        private String myLabel;

        @NotNull
        public List<StepElement> getStepElements() {
            ImmutableList immutableList = ImmutableList.copyOf(this.myStepElements);
            if (immutableList == null) {
                Step.$$$reportNull$$$0(0);
            }
            return immutableList;
        }

        @Override
        @NotNull
        public String getLabel() {
            String string = this.myLabel;
            if (string == null) {
                Step.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return "Step{myLabel='" + this.myLabel + "'" + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/assistant/DefaultTutorialBundle$Step";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStepElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabel";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Tutorial
    implements TutorialData {
        @XmlAttribute(name="label")
        private String myLabel;
        @XmlElement(name="description")
        private String myDescription;
        @XmlAttribute(name="remoteLink")
        private String myRemoteLink;
        @XmlAttribute(name="remoteLinkLabel")
        private String myRemoteLinkLabel;
        @XmlAttribute(name="key")
        private String myKey;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIconName;
        protected String myResourceRoot;
        @XmlElements(value={@XmlElement(name="step", type=Step.class)})
        private List<Step> mySteps = Lists.newArrayList();
        private Icon myIcon;
        private Class myResourceClass;

        public void setResourceClass(@NotNull Class clazz) {
            if (clazz == null) {
                Tutorial.$$$reportNull$$$0(0);
            }
            this.myResourceClass = clazz;
        }

        @Override
        @NotNull
        public String getLabel() {
            String string = this.myLabel;
            if (string == null) {
                Tutorial.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        @Override
        @NotNull
        public String getRemoteLink() {
            String string = this.myRemoteLink;
            if (string == null) {
                Tutorial.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getRemoteLinkLabel() {
            String string = this.myRemoteLinkLabel;
            if (string == null) {
                Tutorial.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getKey() {
            String string = this.myKey;
            if (string == null) {
                Tutorial.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            if (this.myIcon != null) {
                return this.myIcon;
            }
            if (this.myIconName == null || this.myResourceRoot == null) {
                return null;
            }
            this.myIcon = IconLoader.findIcon((String)(this.myResourceRoot + "/" + this.myIconName), (Class)this.myResourceClass);
            return this.myIcon;
        }

        @NotNull
        public List<Step> getSteps() {
            ImmutableList immutableList = ImmutableList.copyOf(this.mySteps);
            if (immutableList == null) {
                Tutorial.$$$reportNull$$$0(5);
            }
            return immutableList;
        }

        public String toString() {
            return "Tutorial{myLabel='" + this.myLabel + '\'' + ", myDescription='" + this.myDescription + '\'' + ", myRemoteLink='" + this.myRemoteLink + '\'' + ", myRemoteLinkLabel='" + this.myRemoteLinkLabel + '\'' + ", myKey='" + this.myKey + '\'' + ", mySteps=" + this.mySteps + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/assistant/DefaultTutorialBundle$Tutorial";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/assistant/DefaultTutorialBundle$Tutorial";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteLink";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteLinkLabel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSteps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setResourceClass";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Feature
    implements FeatureData {
        @XmlAttribute(name="name")
        @NotNull
        private String myName;
        @XmlAttribute(name="icon")
        @Nullable
        private String myIcon;
        @Nullable
        private Icon myIconInstance;
        @XmlAttribute(name="resourceRoot")
        @NotNull
        private String myResourceRoot;
        @XmlElements(value={@XmlElement(name="resource", type=String.class)})
        private List<String> myResources = Lists.newArrayList();
        @XmlElement(name="description")
        private String myDescription;
        @XmlElements(value={@XmlElement(name="tutorial", type=Tutorial.class)})
        private List<Tutorial> myTutorials = Lists.newArrayList();
        private Class myResourceClass;

        @Override
        public void setResourceClass(@NotNull Class clazz) {
            if (clazz == null) {
                Feature.$$$reportNull$$$0(0);
            }
            this.myResourceClass = clazz;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Feature.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        private Icon getIconResource(@NotNull String path) {
            if (path == null) {
                Feature.$$$reportNull$$$0(2);
            }
            return IconLoader.findIcon((String)path, (Class)this.myResourceClass);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            if (this.myIconInstance != null) {
                return this.myIconInstance;
            }
            if (this.myIcon == null) {
                return null;
            }
            this.myIconInstance = this.getIconResource(this.myResourceRoot + "/" + this.myIcon);
            return this.myIconInstance;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                Feature.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public List<Tutorial> getTutorials() {
            ImmutableList immutableList = ImmutableList.copyOf(this.myTutorials);
            if (immutableList == null) {
                Feature.$$$reportNull$$$0(4);
            }
            return immutableList;
        }

        public String toString() {
            return "Feature{myName='" + this.myName + "', myResourceRoot='" + this.myResourceRoot + "', myResources=" + this.myResources + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/assistant/DefaultTutorialBundle$Feature";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/assistant/DefaultTutorialBundle$Feature";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTutorials";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setResourceClass";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIconResource";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

