/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.AssistToolWindowFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import icons.StudioIcons;

public class OpenAssistSidePanelAction
extends AnAction {
    public static final String TOOL_WINDOW_TITLE = "Assistant";

    public void actionPerformed(AnActionEvent event) {
        Project thisProject = event.getProject();
        String actionId = ActionManager.getInstance().getId((AnAction)this);
        this.openWindow(actionId, thisProject);
    }

    public final void openWindow(String actionId, Project project) {
        ApplicationManager.getApplication().invokeLater(() -> {
            AssistToolWindowFactory factory = new AssistToolWindowFactory(actionId);
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
            ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOL_WINDOW_TITLE);
            if (toolWindow == null) {
                toolWindow = toolWindowManager.registerToolWindow(TOOL_WINDOW_TITLE, false, ToolWindowAnchor.RIGHT, (Disposable)project, true);
            }
            toolWindow.setIcon(StudioIcons.Shell.ToolWindows.ASSISTANT);
            factory.createToolWindowContent(project, toolWindow);
            toolWindow.activate(null);
        });
    }
}

