/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant;

import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.RecipeMetadata;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RecipeUtils {
    private static Map<Pair<Recipe, Project>, List<RecipeMetadata>> myRecipeMetadataCache = new HashMap<Pair<Recipe, Project>, List<RecipeMetadata>>();

    @NotNull
    public static RecipeMetadata getRecipeMetadata(@NotNull Recipe recipe, @NotNull Module module) {
        Pair key;
        if (recipe == null) {
            RecipeUtils.$$$reportNull$$$0(0);
        }
        if (module == null) {
            RecipeUtils.$$$reportNull$$$0(1);
        }
        if (myRecipeMetadataCache.containsKey(key = new Pair((Object)recipe, (Object)module.getProject()))) {
            List<RecipeMetadata> metadataSet = myRecipeMetadataCache.get(key);
            for (RecipeMetadata metadata : metadataSet) {
                if (!metadata.getRecipe().equals(recipe)) continue;
                RecipeMetadata recipeMetadata = metadata;
                if (recipeMetadata == null) {
                    RecipeUtils.$$$reportNull$$$0(2);
                }
                return recipeMetadata;
            }
        }
        LinkedHashMultimap dependencies = LinkedHashMultimap.create();
        HashSet classpathEntries = Sets.newHashSet();
        HashSet plugins = Sets.newHashSet();
        ArrayList sourceFiles = Lists.newArrayList();
        ArrayList targetFiles = Lists.newArrayList();
        RecipeMetadata metadata = new RecipeMetadata(recipe, module);
        RenderingContext context = null;
        try {
            File moduleRoot = new File(module.getModuleFilePath()).getParentFile();
            File RootPath = new File(FileUtil.generateRandomTemporaryPath(), "unused");
            RootPath.deleteOnExit();
            context = RenderingContext.Builder.newContext(RootPath, module.getProject()).withOutputRoot(moduleRoot).withModuleRoot(moduleRoot).withFindOnlyReferences(true).withPerformSync(false).intoDependencies((SetMultimap<String, String>)dependencies).intoClasspathEntries(classpathEntries).intoPlugins(plugins).intoSourceFiles(sourceFiles).intoTargetFiles(targetFiles).build();
            RecipeExecutor recipeExecutor = context.getRecipeExecutor();
            recipe.execute(recipeExecutor);
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            RecipeUtils.getLog().warn("Template processing exception with context in the following state: " + context);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String d : dependencies.get((Object)"compile")) {
            metadata.addDependency(d);
        }
        for (String c : classpathEntries) {
            metadata.addClasspathEntry(c);
        }
        for (String p : plugins) {
            metadata.addPlugin(p);
        }
        for (File f : sourceFiles) {
            if (!f.getName().equals("AndroidManifest.xml")) continue;
            RecipeUtils.parseManifestForPermissions(f, metadata);
        }
        for (File f : targetFiles) {
            metadata.addModifiedFile(f);
        }
        RecipeMetadata recipeMetadata = metadata;
        if (recipeMetadata == null) {
            RecipeUtils.$$$reportNull$$$0(3);
        }
        return recipeMetadata;
    }

    @NotNull
    public static List<RecipeMetadata> getRecipeMetadata(@NotNull Recipe recipe, @NotNull Project project) {
        Pair key;
        if (recipe == null) {
            RecipeUtils.$$$reportNull$$$0(4);
        }
        if (project == null) {
            RecipeUtils.$$$reportNull$$$0(5);
        }
        if (!myRecipeMetadataCache.containsKey(key = new Pair((Object)recipe, (Object)project))) {
            ImmutableList.Builder cache = ImmutableList.builder();
            for (Module module : AssistActionStateManager.getAndroidModules(project)) {
                cache.add((Object)RecipeUtils.getRecipeMetadata(recipe, module));
            }
            myRecipeMetadataCache.put((Pair<Recipe, Project>)key, (List<RecipeMetadata>)cache.build());
        }
        List<RecipeMetadata> list = myRecipeMetadataCache.get(key);
        if (list == null) {
            RecipeUtils.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static void execute(final @NotNull Recipe recipe, @NotNull Module module) {
        if (recipe == null) {
            RecipeUtils.$$$reportNull$$$0(7);
        }
        if (module == null) {
            RecipeUtils.$$$reportNull$$$0(8);
        }
        ArrayList filesToOpen = Lists.newArrayList();
        File moduleRoot = new File(module.getModuleFilePath()).getParentFile();
        File RootPath = null;
        try {
            RootPath = new File(FileUtil.generateRandomTemporaryPath(), "unused");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        RenderingContext context = RenderingContext.Builder.newContext(RootPath, module.getProject()).withOutputRoot(moduleRoot).withModuleRoot(moduleRoot).intoOpenFiles(filesToOpen).build();
        final RecipeExecutor recipeExecutor = context.getRecipeExecutor();
        new WriteCommandAction.Simple(module.getProject(), "Executing recipe instructions", new PsiFile[0]){

            protected void run() throws Throwable {
                recipe.execute(recipeExecutor);
            }
        }.execute();
        TemplateUtils.openEditors(module.getProject(), filesToOpen, true);
    }

    private static void parseManifestForPermissions(@NotNull File f, final @NotNull RecipeMetadata metadata) {
        if (f == null) {
            RecipeUtils.$$$reportNull$$$0(9);
        }
        if (metadata == null) {
            RecipeUtils.$$$reportNull$$$0(10);
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(f, new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String tagName, Attributes attributes) throws SAXException {
                    if (tagName.equals("uses-permission") || tagName.equals("uses-permission-sdk-23") || tagName.equals("uses-permission-sdk-m")) {
                        String permission = attributes.getValue("android:name");
                        permission = permission.replace("android.permission.", "");
                        metadata.addPermission(permission);
                    }
                }
            });
        }
        catch (Exception e) {
            RecipeUtils.getLog().warn("Failed to read permissions from AndroidManifest.xml", (Throwable)e);
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(RecipeUtils.class);
        if (logger == null) {
            RecipeUtils.$$$reportNull$$$0(11);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recipe";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/assistant/RecipeUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/assistant/RecipeUtils";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecipeMetadata";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRecipeMetadata";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseManifestForPermissions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

