/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.TutorialButton;
import com.android.tools.idea.assistant.view.UIUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class FeatureEntryPoint
extends JPanel
implements Accessible {
    private boolean myExpanded;
    private JPanel myTutorialsList;
    private ActionListener myListener;
    private JLabel myArrow;
    private JPanel myTargetPane;
    private AnalyticsProvider myAnalyticsProvider;
    private FeatureData myFeature;
    private Project myProject;

    public FeatureEntryPoint(@NotNull FeatureData feature, @NotNull ActionListener listener2, @NotNull AnalyticsProvider analyticsProvider, @NotNull Project project) {
        if (feature == null) {
            FeatureEntryPoint.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            FeatureEntryPoint.$$$reportNull$$$0(1);
        }
        if (analyticsProvider == null) {
            FeatureEntryPoint.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FeatureEntryPoint.$$$reportNull$$$0(3);
        }
        super((LayoutManager)new VerticalFlowLayout(0, 0));
        this.myExpanded = false;
        this.setOpaque(false);
        this.myListener = listener2;
        this.myAnalyticsProvider = analyticsProvider;
        this.myFeature = feature;
        this.myProject = project;
        String label = this.myFeature.getName();
        String description = this.myFeature.getDescription();
        this.myTargetPane = new JPanel();
        this.myTargetPane.setOpaque(false);
        this.myTargetPane.setLayout(new BoxLayout(this.myTargetPane, 0));
        this.add(this.myTargetPane);
        SummaryHandler summaryMouseHandler = new SummaryHandler();
        KeyboardHandler keyboardhandler = new KeyboardHandler();
        this.myArrow = new JLabel();
        this.addHandlers(this.myArrow, summaryMouseHandler, keyboardhandler);
        this.myArrow.setIcon(AllIcons.Nodes.TreeRightArrow);
        this.myArrow.setFocusable(true);
        this.myArrow.setBorder(BorderFactory.createEmptyBorder(9, 5, 0, 10));
        this.myArrow.setAlignmentY(0.0f);
        this.myTargetPane.add(this.myArrow);
        JPanel summary = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        summary.setOpaque(false);
        summary.setAlignmentY(0.0f);
        this.myTargetPane.add(summary);
        int innerContentsOffset = 0;
        JBLabel featureLabel = new JBLabel();
        this.addHandlers((JComponent)featureLabel, summaryMouseHandler, keyboardhandler);
        featureLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        featureLabel.setFont(featureLabel.getFont().deriveFont(1));
        featureLabel.setText(label);
        Icon featureIcon = this.myFeature.getIcon();
        if (featureIcon != null) {
            featureLabel.setIcon(featureIcon);
            featureLabel.setIconTextGap(5);
            innerContentsOffset += featureIcon.getIconWidth() + featureLabel.getIconTextGap();
        }
        summary.add((Component)featureLabel);
        JTextPane descriptionPane = new JTextPane();
        descriptionPane.setOpaque(false);
        this.addHandlers(descriptionPane, summaryMouseHandler, keyboardhandler);
        UIUtils.setHtml(descriptionPane, description, "body {color: " + UIUtils.getCssColor(UIUtils.getSecondaryColor()) + "}");
        descriptionPane.setBorder(BorderFactory.createEmptyBorder(0, innerContentsOffset, 5, 10));
        summary.add(descriptionPane);
        this.myTutorialsList = new JPanel();
        this.myTutorialsList.setOpaque(false);
        this.myTutorialsList.setLayout(new BoxLayout(this.myTutorialsList, 1));
        this.myTutorialsList.setBorder(BorderFactory.createEmptyBorder(5, this.myArrow.getPreferredSize().width + innerContentsOffset, 0, 5));
        this.myTutorialsList.setVisible(false);
        for (TutorialData tutorialData : this.myFeature.getTutorials()) {
            this.addTutorial(tutorialData.getLabel(), tutorialData.getKey());
        }
        this.add(this.myTutorialsList);
    }

    private void addHandlers(JComponent component, SummaryHandler summaryMouseHandler, KeyboardHandler keyboardHandler) {
        component.addMouseListener(summaryMouseHandler);
        component.registerKeyboardAction(keyboardHandler, KeyStroke.getKeyStroke(32, 0), 0);
    }

    private static Logger getLog() {
        return Logger.getInstance(FeatureEntryPoint.class);
    }

    private void addTutorial(String label, String key) {
        TutorialButton t = new TutorialButton(label, key, this.myListener);
        this.myTutorialsList.add(t);
        this.myTutorialsList.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private void toggleTutorials() {
        this.myExpanded = !this.myExpanded;
        FeatureEntryPoint.getLog().debug("Toggled feature summary view to expand state: " + this.myExpanded);
        if (this.myExpanded) {
            this.myAnalyticsProvider.trackFeatureGroupExpanded(this.myFeature.getName(), this.myProject);
        }
        this.myArrow.setIcon(this.myExpanded ? AllIcons.Nodes.TreeDownArrow : AllIcons.Nodes.TreeRightArrow);
        this.myTutorialsList.setVisible(this.myExpanded);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFeatureEntryPoint();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "feature";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "analyticsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/assistant/view/FeatureEntryPoint";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AccessibleFeatureEntryPoint
    extends JComponent.AccessibleJComponent
    implements AccessibleAction {
        private AccessibleFeatureEntryPoint() {
            super(FeatureEntryPoint.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }

        @Override
        public String getAccessibleName() {
            return FeatureEntryPoint.this.myFeature.getName();
        }

        @Override
        public String getAccessibleDescription() {
            return AccessibleContextUtil.getUniqueDescription((AccessibleContext)this, (String)FeatureEntryPoint.this.myFeature.getDescription());
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext context;
            Icon icon = AllIcons.Nodes.TreeRightArrow;
            if (icon instanceof Accessible && (context = ((Accessible)((Object)icon)).getAccessibleContext()) != null && context instanceof AccessibleIcon) {
                return new AccessibleIcon[]{(AccessibleIcon)((Object)context)};
            }
            return null;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet stateSet = super.getAccessibleStateSet();
            stateSet.add(FeatureEntryPoint.this.myExpanded ? AccessibleState.EXPANDED : AccessibleState.EXPANDABLE);
            if (FeatureEntryPoint.this.isFocusOwner()) {
                stateSet.add(AccessibleState.FOCUSED);
            }
            return stateSet;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("AbstractButton.clickText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                FeatureEntryPoint.this.toggleTutorials();
                return true;
            }
            return false;
        }
    }

    private class KeyboardHandler
    implements ActionListener {
        private KeyboardHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FeatureEntryPoint.this.toggleTutorials();
        }
    }

    private class SummaryHandler
    extends MouseAdapter {
        private SummaryHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FeatureEntryPoint.this.toggleTutorials();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            FeatureEntryPoint.this.myTargetPane.setBackground(null);
            FeatureEntryPoint.this.myTargetPane.setOpaque(true);
            FeatureEntryPoint.this.myTargetPane.setBackground(UIUtils.getBackgroundHoverColor());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FeatureEntryPoint.this.myTargetPane.setOpaque(false);
            FeatureEntryPoint.this.myTargetPane.setBackground(null);
        }
    }
}

