/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.Navigation;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.sdklib.devices.ButtonType;
import com.android.sdklib.devices.CameraLocation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Sensor;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SkinLayoutDefinition;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.DoubleProperty;
import com.android.tools.idea.observable.core.DoubleValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableDouble;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.observable.expressions.double_.DoubleExpression;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvdDeviceData {
    private StringProperty myName = new StringValueProperty();
    private OptionalProperty<IdDisplay> myDeviceType = new OptionalValueProperty<IdDisplay>();
    private StringProperty myManufacturer = new StringValueProperty();
    private StringProperty myTagId = new StringValueProperty();
    private StringProperty myDeviceId = new StringValueProperty();
    private DoubleProperty myDiagonalScreenSize = new DoubleValueProperty();
    private IntProperty myScreenResolutionWidth = new IntValueProperty();
    private IntProperty myScreenResolutionHeight = new IntValueProperty();
    private ObjectProperty<Storage> myRamStorage = new ObjectValueProperty<Storage>(new Storage(0L, Storage.Unit.MiB));
    private BoolProperty myHasHardwareButtons = new BoolValueProperty();
    private BoolProperty myHasHardwareKeyboard = new BoolValueProperty();
    private OptionalProperty<Navigation> myNavigation = new OptionalValueProperty<Navigation>();
    private BoolProperty mySupportsLandscape = new BoolValueProperty();
    private BoolProperty mySupportsPortrait = new BoolValueProperty();
    private BoolProperty myNotLong = new BoolValueProperty();
    private BoolProperty myHasBackCamera = new BoolValueProperty();
    private BoolProperty myHasFrontCamera = new BoolValueProperty();
    private BoolProperty myHasAccelerometer = new BoolValueProperty();
    private BoolProperty myHasGyroscope = new BoolValueProperty();
    private BoolProperty myHasGps = new BoolValueProperty();
    private BoolProperty myHasProximitySensor = new BoolValueProperty();
    private OptionalProperty<File> myCustomSkinFile = new OptionalValueProperty<File>();
    private OptionalProperty<File> mySelectedSnapshotFile = new OptionalValueProperty<File>(new File(""));
    private BoolValueProperty myIsTv = new BoolValueProperty();
    private BoolValueProperty myIsWear = new BoolValueProperty();
    private BoolValueProperty myIsScreenRound = new BoolValueProperty();
    private IntValueProperty myScreenChinSize = new IntValueProperty();
    private State myDefaultState;
    private File myLastSkinFolder;
    private Dimension myLastSkinDimension;
    private ObjectProperty<Density> myDensity = new ObjectValueProperty<Density>(Density.MEDIUM);
    private OptionalProperty<Software> mySoftware = new OptionalValueProperty<Software>();
    private DoubleExpression myScreenDpi = new DoubleExpression(new ObservableValue[]{this.myScreenResolutionWidth, this.myScreenResolutionHeight, this.myDiagonalScreenSize}){

        @Override
        @NotNull
        public Double get() {
            Double d = AvdScreenData.calculateDpi(((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue(), ((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue(), (Double)AvdDeviceData.this.myDiagonalScreenSize.get(), AvdDeviceData.this.myIsScreenRound.get());
            if (d == null) {
                1.$$$reportNull$$$0(0);
            }
            return d;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData$1", "get"));
        }
    };
    private ObservableBool mySkinSizeIsCompatible = new BooleanExpression(new ObservableValue[]{this.myScreenResolutionWidth, this.myScreenResolutionHeight, this.myCustomSkinFile}){

        @Override
        @NotNull
        public Boolean get() {
            if (!((Optional)AvdDeviceData.this.myCustomSkinFile.get()).isPresent()) {
                Boolean bl = true;
                if (bl == null) {
                    2.$$$reportNull$$$0(0);
                }
                return bl;
            }
            Dimension dimension2 = AvdDeviceData.this.getSkinDimension((File)AvdDeviceData.this.myCustomSkinFile.getValueOrNull());
            Boolean bl = dimension2 == null || dimension2.getWidth() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue() && dimension2.getHeight() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue() || dimension2.getHeight() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionWidth.get()).intValue() && dimension2.getWidth() >= (double)((Integer)AvdDeviceData.this.myScreenResolutionHeight.get()).intValue();
            if (bl == null) {
                2.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/AvdDeviceData$2", "get"));
        }
    };

    public AvdDeviceData() {
        Software software = new Software();
        software.setLiveWallpaperSupport(true);
        software.setGlVersion("2.0");
        this.mySoftware.setValue(software);
        this.myManufacturer.set("User");
        this.initDefaultValues();
        this.myDiagonalScreenSize.addConstraint(value -> Math.max(0.1, value));
        this.myScreenResolutionWidth.addConstraint(value -> Math.max(1, value));
        this.myScreenResolutionHeight.addConstraint(value -> Math.max(1, value));
    }

    public AvdDeviceData(@Nullable Device device, @Nullable SystemImageDescription systemImage) {
        this();
        if (device != null) {
            this.updateValuesFromDevice(device, systemImage);
        }
    }

    private static String getUniqueId(@Nullable String id) {
        return DeviceManagerConnection.getDefaultDeviceManagerConnection().getUniqueId(id);
    }

    public void setUniqueName(@NotNull String name) {
        if (name == null) {
            AvdDeviceData.$$$reportNull$$$0(0);
        }
        this.myName.set(AvdDeviceData.getUniqueId(name));
    }

    @NotNull
    public StringProperty name() {
        StringProperty stringProperty = this.myName;
        if (stringProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(1);
        }
        return stringProperty;
    }

    @NotNull
    public OptionalProperty<IdDisplay> deviceType() {
        OptionalProperty<IdDisplay> optionalProperty = this.myDeviceType;
        if (optionalProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(2);
        }
        return optionalProperty;
    }

    @NotNull
    public StringProperty manufacturer() {
        StringProperty stringProperty = this.myManufacturer;
        if (stringProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(3);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty tagId() {
        StringProperty stringProperty = this.myTagId;
        if (stringProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(4);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty deviceId() {
        StringProperty stringProperty = this.myDeviceId;
        if (stringProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(5);
        }
        return stringProperty;
    }

    @NotNull
    public DoubleProperty diagonalScreenSize() {
        DoubleProperty doubleProperty = this.myDiagonalScreenSize;
        if (doubleProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(6);
        }
        return doubleProperty;
    }

    @NotNull
    public IntProperty screenResolutionWidth() {
        IntProperty intProperty = this.myScreenResolutionWidth;
        if (intProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(7);
        }
        return intProperty;
    }

    @NotNull
    public IntProperty screenResolutionHeight() {
        IntProperty intProperty = this.myScreenResolutionHeight;
        if (intProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(8);
        }
        return intProperty;
    }

    @NotNull
    public ObservableDouble screenDpi() {
        DoubleExpression doubleExpression = this.myScreenDpi;
        if (doubleExpression == null) {
            AvdDeviceData.$$$reportNull$$$0(9);
        }
        return doubleExpression;
    }

    @NotNull
    public ObjectProperty<Storage> ramStorage() {
        ObjectProperty<Storage> objectProperty = this.myRamStorage;
        if (objectProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(10);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty hasHardwareButtons() {
        BoolProperty boolProperty = this.myHasHardwareButtons;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(11);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasHardwareKeyboard() {
        BoolProperty boolProperty = this.myHasHardwareKeyboard;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(12);
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<Navigation> navigation() {
        OptionalProperty<Navigation> optionalProperty = this.myNavigation;
        if (optionalProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(13);
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty supportsLandscape() {
        BoolProperty boolProperty = this.mySupportsLandscape;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(14);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty notLong() {
        BoolProperty boolProperty = this.myNotLong;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(15);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty supportsPortrait() {
        BoolProperty boolProperty = this.mySupportsPortrait;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(16);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasFrontCamera() {
        BoolProperty boolProperty = this.myHasFrontCamera;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(17);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasBackCamera() {
        BoolProperty boolProperty = this.myHasBackCamera;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(18);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasAccelerometer() {
        BoolProperty boolProperty = this.myHasAccelerometer;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(19);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasGyroscope() {
        BoolProperty boolProperty = this.myHasGyroscope;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(20);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasGps() {
        BoolProperty boolProperty = this.myHasGps;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(21);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty hasProximitySensor() {
        BoolProperty boolProperty = this.myHasProximitySensor;
        if (boolProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(22);
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<Software> software() {
        OptionalProperty<Software> optionalProperty = this.mySoftware;
        if (optionalProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(23);
        }
        return optionalProperty;
    }

    @NotNull
    public OptionalProperty<File> customSkinFile() {
        OptionalProperty<File> optionalProperty = this.myCustomSkinFile;
        if (optionalProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(24);
        }
        return optionalProperty;
    }

    @NotNull
    public OptionalProperty<File> selectedSnapshotFile() {
        OptionalProperty<File> optionalProperty = this.mySelectedSnapshotFile;
        if (optionalProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(25);
        }
        return optionalProperty;
    }

    @NotNull
    public BoolProperty isTv() {
        BoolValueProperty boolValueProperty = this.myIsTv;
        if (boolValueProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(26);
        }
        return boolValueProperty;
    }

    @NotNull
    public BoolProperty isWear() {
        BoolValueProperty boolValueProperty = this.myIsWear;
        if (boolValueProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(27);
        }
        return boolValueProperty;
    }

    @NotNull
    public BoolProperty isScreenRound() {
        BoolValueProperty boolValueProperty = this.myIsScreenRound;
        if (boolValueProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(28);
        }
        return boolValueProperty;
    }

    @NotNull
    public IntProperty screenChinSize() {
        IntValueProperty intValueProperty = this.myScreenChinSize;
        if (intValueProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(29);
        }
        return intValueProperty;
    }

    @NotNull
    public ObservableBool compatibleSkinSize() {
        ObservableBool observableBool = this.mySkinSizeIsCompatible;
        if (observableBool == null) {
            AvdDeviceData.$$$reportNull$$$0(30);
        }
        return observableBool;
    }

    @NotNull
    public ObjectProperty<Density> density() {
        ObjectProperty<Density> objectProperty = this.myDensity;
        if (objectProperty == null) {
            AvdDeviceData.$$$reportNull$$$0(31);
        }
        return objectProperty;
    }

    private void initDefaultValues() {
        this.myName.set(AvdDeviceData.getUniqueId(null));
        this.myDiagonalScreenSize.set(5.0);
        this.myScreenResolutionWidth.set(1080);
        this.myScreenResolutionHeight.set(1920);
        this.myRamStorage.set(new Storage(2L, Storage.Unit.GiB));
        this.myHasHardwareButtons.set(false);
        this.myHasHardwareKeyboard.set(false);
        this.myNavigation.setValue(Navigation.NONAV);
        this.mySupportsPortrait.set(true);
        this.mySupportsLandscape.set(true);
        this.myNotLong.set(false);
        this.myDensity.set(Density.MEDIUM);
        this.myHasFrontCamera.set(true);
        this.myHasBackCamera.set(true);
        this.myHasAccelerometer.set(true);
        this.myHasGyroscope.set(true);
        this.myHasGps.set(true);
        this.myHasProximitySensor.set(true);
    }

    @Nullable
    private Dimension getSkinDimension(@Nullable File skinFolder) {
        if (!FileUtil.filesEqual((File)skinFolder, (File)this.myLastSkinFolder)) {
            this.myLastSkinDimension = AvdDeviceData.computeSkinDimension(skinFolder);
            this.myLastSkinFolder = skinFolder;
        }
        return this.myLastSkinDimension;
    }

    @Nullable
    private static Dimension computeSkinDimension(@Nullable File skinFolder) {
        if (skinFolder == null || FileUtil.filesEqual((File)skinFolder, (File)AvdWizardUtils.NO_SKIN)) {
            return null;
        }
        File skinLayoutFile = new File(skinFolder, "layout");
        if (!skinLayoutFile.isFile()) {
            return null;
        }
        FileOp fop = FileOpUtils.create();
        SkinLayoutDefinition skin = SkinLayoutDefinition.parseFile(skinLayoutFile, fop);
        if (skin == null) {
            return null;
        }
        int height = StringUtil.parseInt((String)skin.get("parts.device.display.height"), (int)-1);
        int width = StringUtil.parseInt((String)skin.get("parts.device.display.width"), (int)-1);
        if (height <= 0 || width <= 0) {
            return null;
        }
        return new Dimension(width, height);
    }

    public void updateValuesFromDevice(@NotNull Device device, @Nullable SystemImageDescription systemImage) {
        if (device == null) {
            AvdDeviceData.$$$reportNull$$$0(32);
        }
        this.myName.set(device.getDisplayName());
        String tagId = device.getTagId();
        if (((String)this.myTagId.get()).isEmpty()) {
            this.myTagId.set(SystemImage.DEFAULT_TAG.getId());
            this.myDeviceType.setValue(SystemImage.DEFAULT_TAG);
        } else {
            for (IdDisplay tag : AvdWizardUtils.ALL_DEVICE_TAGS) {
                if (!tag.getId().equals(tagId)) continue;
                this.myDeviceType.setValue(tag);
                break;
            }
        }
        this.myDeviceId.set(device.getId());
        Hardware defaultHardware = device.getDefaultHardware();
        Screen screen = defaultHardware.getScreen();
        this.myDiagonalScreenSize.set(screen.getDiagonalLength());
        this.myScreenResolutionWidth.set(screen.getXDimension());
        this.myScreenResolutionHeight.set(screen.getYDimension());
        this.myRamStorage.set(AvdWizardUtils.getDefaultRam(defaultHardware));
        this.myHasHardwareButtons.set(defaultHardware.getButtonType() == ButtonType.HARD);
        this.myHasHardwareKeyboard.set(defaultHardware.getKeyboard() != Keyboard.NOKEY);
        this.myNavigation.setValue(defaultHardware.getNav());
        this.myDensity.set(defaultHardware.getScreen().getPixelDensity());
        List states = device.getAllStates();
        this.mySupportsPortrait.set(false);
        this.mySupportsLandscape.set(false);
        for (State state : states) {
            if (state.isDefaultState()) {
                this.myDefaultState = state;
            }
            if (state.getOrientation().equals((Object)ScreenOrientation.PORTRAIT)) {
                this.mySupportsPortrait.set(true);
            }
            if (state.getOrientation().equals((Object)ScreenOrientation.LANDSCAPE)) {
                this.mySupportsLandscape.set(true);
            }
            if (!state.getHardware().getScreen().getRatio().equals((Object)ScreenRatio.NOTLONG)) continue;
            this.myNotLong.set(true);
        }
        this.myHasFrontCamera.set(defaultHardware.getCamera(CameraLocation.FRONT) != null);
        this.myHasBackCamera.set(defaultHardware.getCamera(CameraLocation.BACK) != null);
        this.myHasAccelerometer.set(defaultHardware.getSensors().contains(Sensor.ACCELEROMETER));
        this.myHasGyroscope.set(defaultHardware.getSensors().contains(Sensor.GYROSCOPE));
        this.myHasGps.set(defaultHardware.getSensors().contains(Sensor.GPS));
        this.myHasProximitySensor.set(defaultHardware.getSensors().contains(Sensor.PROXIMITY_SENSOR));
        this.myIsTv.set(HardwareConfigHelper.isTv((Device)device));
        this.myIsWear.set(HardwareConfigHelper.isWear((Device)device));
        this.myIsScreenRound.set(device.isScreenRound());
        this.myScreenChinSize.set(device.getChinSize());
        this.updateSkinFromDeviceAndSystemImage(device, systemImage);
    }

    public void updateSkinFromDeviceAndSystemImage(@NotNull Device device, @Nullable SystemImageDescription systemImage) {
        Hardware defaultHardware;
        File skinFile;
        if (device == null) {
            AvdDeviceData.$$$reportNull$$$0(33);
        }
        this.myCustomSkinFile.setValue((skinFile = AvdWizardUtils.pathToUpdatedSkins((defaultHardware = device.getDefaultHardware()).getSkinFile(), systemImage, FileOpUtils.create())) == null ? AvdWizardUtils.NO_SKIN : skinFile);
    }

    @NotNull
    public Dimension getDeviceScreenDimension() {
        int finalHeight;
        int finalWidth;
        int width = (Integer)this.myScreenResolutionWidth.get();
        int height = (Integer)this.myScreenResolutionHeight.get();
        ScreenOrientation orientation = this.getDefaultDeviceOrientation();
        assert (width > 0 && height > 0);
        if (((Boolean)this.myNotLong.get()).booleanValue()) {
            finalWidth = width;
            finalHeight = height;
        } else if (orientation == ScreenOrientation.LANDSCAPE) {
            finalWidth = Math.max(width, height);
            finalHeight = Math.min(width, height);
        } else {
            finalWidth = Math.min(width, height);
            finalHeight = Math.max(width, height);
        }
        Dimension dimension2 = new Dimension(finalWidth, finalHeight);
        if (dimension2 == null) {
            AvdDeviceData.$$$reportNull$$$0(34);
        }
        return dimension2;
    }

    @NotNull
    public ScreenOrientation getDefaultDeviceOrientation() {
        if (this.myDefaultState != null && this.myDefaultState.getOrientation() == ScreenOrientation.LANDSCAPE && ((Boolean)this.mySupportsLandscape.get()).booleanValue()) {
            ScreenOrientation screenOrientation = ScreenOrientation.LANDSCAPE;
            if (screenOrientation == null) {
                AvdDeviceData.$$$reportNull$$$0(35);
            }
            return screenOrientation;
        }
        ScreenOrientation screenOrientation = (Boolean)this.mySupportsPortrait.get() != false ? ScreenOrientation.PORTRAIT : ((Boolean)this.mySupportsLandscape.get() != false ? ScreenOrientation.LANDSCAPE : ScreenOrientation.SQUARE);
        if (screenOrientation == null) {
            AvdDeviceData.$$$reportNull$$$0(36);
        }
        return screenOrientation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/avdmanager/AvdDeviceData";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/avdmanager/AvdDeviceData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deviceType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "manufacturer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tagId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deviceId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "diagonalScreenSize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "screenResolutionWidth";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "screenResolutionHeight";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "screenDpi";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "ramStorage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "hasHardwareButtons";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "hasHardwareKeyboard";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "navigation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "supportsLandscape";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "notLong";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "supportsPortrait";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "hasFrontCamera";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "hasBackCamera";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "hasAccelerometer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "hasGyroscope";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "hasGps";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "hasProximitySensor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "software";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "customSkinFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedSnapshotFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "isTv";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isWear";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "isScreenRound";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "screenChinSize";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "compatibleSkinSize";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "density";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceScreenDimension";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDeviceOrientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setUniqueName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateValuesFromDevice";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateSkinFromDeviceAndSystemImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

