/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.ArrayList;
import java.util.List;

public class SwitchDeviceAction
extends AnAction {
    private final DesignSurface mySurface;

    public SwitchDeviceAction(DesignSurface surface) {
        this.mySurface = surface;
    }

    public void actionPerformed(AnActionEvent e) {
        Configuration configuration = this.mySurface.getConfiguration();
        if (configuration == null) {
            return;
        }
        List<Device> devices = ConfigurationManager.getOrCreateInstance(configuration.getModule()).getDevices();
        ArrayList applicable = Lists.newArrayList();
        for (Device device : devices) {
            if (!HardwareConfigHelper.isNexus((Device)device)) continue;
            applicable.add(device);
        }
        Device currentDevice = configuration.getDevice();
        int n = applicable.size();
        for (int i = 0; i < n; ++i) {
            if (applicable.get(i) != currentDevice) continue;
            Device newDevice = (Device)applicable.get((i + 1) % applicable.size());
            configuration.setDevice(newDevice, true);
            break;
        }
    }
}

