/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.common.surface.DesignSurface;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ZoomLabelAction
extends AnAction
implements CustomComponentAction {
    @NotNull
    private final DesignSurface mySurface;

    public ZoomLabelAction(@NotNull DesignSurface surface) {
        if (surface == null) {
            ZoomLabelAction.$$$reportNull$$$0(0);
        }
        this.mySurface = surface;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Current Zoom Level");
        this.updatePresentation(presentation);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public void actionPerformed(AnActionEvent e) {
    }

    private void updatePresentation(Presentation presentation) {
        double scale = this.mySurface.getScale() * (double)this.mySurface.getScreenScalingFactor();
        String label = String.format("%d%% ", (int)(100.0 * scale));
        presentation.setText(label);
    }

    public JComponent createCustomComponent(final Presentation presentation) {
        JBLabel label = new JBLabel(){
            private PropertyChangeListener myPresentationSyncer;
            private Presentation myPresentation;
            {
                this.myPresentation = presentation;
            }

            public void addNotify() {
                super.addNotify();
                if (this.myPresentationSyncer == null) {
                    this.myPresentationSyncer = new PresentationSyncer();
                    this.myPresentation.addPropertyChangeListener(this.myPresentationSyncer);
                }
                this.setText(this.myPresentation.getText());
            }

            public void removeNotify() {
                if (this.myPresentationSyncer != null) {
                    this.myPresentation.removePropertyChangeListener(this.myPresentationSyncer);
                    this.myPresentationSyncer = null;
                }
                super.removeNotify();
            }

            class PresentationSyncer
            implements PropertyChangeListener {
                PresentationSyncer() {
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propertyName = evt.getPropertyName();
                    if ("text".equals(propertyName)) {
                        this.setText((String)evt.getNewValue());
                        this.getParent().getParent().validate();
                        this.repaint();
                    }
                }
            }
        };
        label.setFont(UIUtil.getToolTipFont());
        return label;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/common/actions/ZoomLabelAction", "<init>"));
    }
}

