/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidAttribute;
import com.google.wireless.android.sdk.stats.AndroidView;
import com.google.wireless.android.sdk.stats.LayoutAttributeChangeEvent;
import com.google.wireless.android.sdk.stats.LayoutPaletteEvent;
import com.google.wireless.android.sdk.stats.SearchOption;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTrackerUtil {
    private static final Pattern STYLE_PATTERN = Pattern.compile("style=\"(.*)\"");
    private static final Pattern INPUT_STYLE_PATTERN = Pattern.compile("android:inputType=\"(.*)\"");
    private static final Pattern ORIENTATION_PATTERN = Pattern.compile("android:orientation=\"(.*)\"");
    private static final Map<String, LayoutPaletteEvent.ViewOption> PALETTE_VIEW_OPTION_MAP = ImmutableMap.builder().put((Object)"textPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD).put((Object)"numberPassword", (Object)LayoutPaletteEvent.ViewOption.PASSWORD_NUMERIC).put((Object)"textEmailAddress", (Object)LayoutPaletteEvent.ViewOption.EMAIL).put((Object)"phone", (Object)LayoutPaletteEvent.ViewOption.PHONE).put((Object)"textPostalAddress", (Object)LayoutPaletteEvent.ViewOption.POSTAL_ADDRESS).put((Object)"textMultiLine", (Object)LayoutPaletteEvent.ViewOption.MULTILINE_TEXT).put((Object)"time", (Object)LayoutPaletteEvent.ViewOption.TIME_EDITOR).put((Object)"date", (Object)LayoutPaletteEvent.ViewOption.DATE_EDITOR).put((Object)"number", (Object)LayoutPaletteEvent.ViewOption.NUMBER).put((Object)"numberSigned", (Object)LayoutPaletteEvent.ViewOption.SIGNED_NUMBER).put((Object)"numberDecimal", (Object)LayoutPaletteEvent.ViewOption.DECIMAL_NUMBER).build();
    @VisibleForTesting
    static final String CUSTOM_NAME = "CUSTOM";

    private UsageTrackerUtil() {
    }

    @NotNull
    static AndroidAttribute convertAttribute(@NotNull NlProperty property2) {
        if (property2 == null) {
            UsageTrackerUtil.$$$reportNull$$$0(0);
        }
        AndroidFacet facet = property2.getModel().getFacet();
        AttributeDefinition definition = property2.getDefinition();
        String libraryName = definition != null ? definition.getLibraryName() : null;
        AndroidAttribute.AttributeNamespace namespace = UsageTrackerUtil.convertNamespace(property2.getNamespace());
        AndroidAttribute androidAttribute = AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(property2.getName(), namespace, libraryName, facet)).setAttributeNamespace(namespace).build();
        if (androidAttribute == null) {
            UsageTrackerUtil.$$$reportNull$$$0(1);
        }
        return androidAttribute;
    }

    @NotNull
    static AndroidAttribute convertAttribute(@NotNull NelePropertyItem property2) {
        if (property2 == null) {
            UsageTrackerUtil.$$$reportNull$$$0(2);
        }
        AndroidFacet facet = property2.getModel().getFacet();
        AndroidAttribute.AttributeNamespace namespace = UsageTrackerUtil.convertNamespace(property2.getNamespace());
        AndroidAttribute androidAttribute = AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(property2.getName(), namespace, property2.getLibraryName(), facet)).setAttributeNamespace(namespace).build();
        if (androidAttribute == null) {
            UsageTrackerUtil.$$$reportNull$$$0(3);
        }
        return androidAttribute;
    }

    @NotNull
    static AndroidAttribute convertAttribute(@NotNull String attributeName, @NotNull AndroidFacet facet) {
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(4);
        }
        if (facet == null) {
            UsageTrackerUtil.$$$reportNull$$$0(5);
        }
        AndroidAttribute.AttributeNamespace namespace = null;
        if (attributeName.startsWith("tools:")) {
            namespace = AndroidAttribute.AttributeNamespace.TOOLS;
            attributeName = StringUtil.trimStart((String)attributeName, (String)"tools:");
        }
        NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet, attributeName);
        if (namespace == null) {
            namespace = lookup.getNamespace();
        }
        AndroidAttribute androidAttribute = AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet)).setAttributeNamespace(namespace).build();
        if (androidAttribute == null) {
            UsageTrackerUtil.$$$reportNull$$$0(6);
        }
        return androidAttribute;
    }

    @NotNull
    @VisibleForTesting
    static AndroidAttribute.AttributeNamespace convertNamespace(@Nullable String namespace) {
        if (StringUtil.isEmpty((String)namespace)) {
            AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.ANDROID;
            if (attributeNamespace == null) {
                UsageTrackerUtil.$$$reportNull$$$0(7);
            }
            return attributeNamespace;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.TOOLS;
                if (attributeNamespace == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(8);
                }
                return attributeNamespace;
            }
            case "http://schemas.android.com/apk/res/android": {
                AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.ANDROID;
                if (attributeNamespace == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(9);
                }
                return attributeNamespace;
            }
        }
        AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.APPLICATION;
        if (attributeNamespace == null) {
            UsageTrackerUtil.$$$reportNull$$$0(10);
        }
        return attributeNamespace;
    }

    @NotNull
    static LayoutPaletteEvent.ViewGroup convertGroupName(@NotNull String groupName) {
        if (groupName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(11);
        }
        switch (groupName) {
            case "All": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.ALL_GROUPS;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(12);
                }
                return viewGroup;
            }
            case "All Results": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.ALL_RESULTS;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(13);
                }
                return viewGroup;
            }
            case "Common": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.COMMON;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(14);
                }
                return viewGroup;
            }
            case "Buttons": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.BUTTONS;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(15);
                }
                return viewGroup;
            }
            case "Widgets": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.WIDGETS;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(16);
                }
                return viewGroup;
            }
            case "Text": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.TEXT;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(17);
                }
                return viewGroup;
            }
            case "Layouts": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.LAYOUTS;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(18);
                }
                return viewGroup;
            }
            case "Containers": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.CONTAINERS;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(19);
                }
                return viewGroup;
            }
            case "Images": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.IMAGES;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(20);
                }
                return viewGroup;
            }
            case "Date": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.DATES;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(21);
                }
                return viewGroup;
            }
            case "Transitions": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.TRANSITIONS;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(22);
                }
                return viewGroup;
            }
            case "Advanced": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.ADVANCED;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(23);
                }
                return viewGroup;
            }
            case "Google": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.GOOGLE;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(24);
                }
                return viewGroup;
            }
            case "Design": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.DESIGN;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(25);
                }
                return viewGroup;
            }
            case "AppCompat": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.APP_COMPAT;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(26);
                }
                return viewGroup;
            }
            case "Legacy": {
                LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.LEGACY;
                if (viewGroup == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(27);
                }
                return viewGroup;
            }
        }
        LayoutPaletteEvent.ViewGroup viewGroup = LayoutPaletteEvent.ViewGroup.CUSTOM;
        if (viewGroup == null) {
            UsageTrackerUtil.$$$reportNull$$$0(28);
        }
        return viewGroup;
    }

    @NotNull
    static LayoutPaletteEvent.ViewOption convertViewOption(@NotNull String tagName, @NotNull String representation) {
        if (tagName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(29);
        }
        if (representation == null) {
            UsageTrackerUtil.$$$reportNull$$$0(30);
        }
        switch (tagName) {
            case "ProgressBar": {
                LayoutPaletteEvent.ViewOption viewOption = UsageTrackerUtil.convertProgressBarViewOption(representation);
                if (viewOption == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(31);
                }
                return viewOption;
            }
            case "SeekBar": {
                LayoutPaletteEvent.ViewOption viewOption = UsageTrackerUtil.convertSeekBarViewOption(representation);
                if (viewOption == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(32);
                }
                return viewOption;
            }
            case "EditText": {
                LayoutPaletteEvent.ViewOption viewOption = UsageTrackerUtil.convertEditTextViewOption(representation);
                if (viewOption == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(33);
                }
                return viewOption;
            }
            case "LinearLayout": {
                LayoutPaletteEvent.ViewOption viewOption = UsageTrackerUtil.convertLinearLayoutViewOption(representation);
                if (viewOption == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(34);
                }
                return viewOption;
            }
        }
        LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.NORMAL;
        if (viewOption == null) {
            UsageTrackerUtil.$$$reportNull$$$0(35);
        }
        return viewOption;
    }

    @NotNull
    static LayoutAttributeChangeEvent.ViewType convertPropertiesMode(@NotNull NlPropertiesPanel.PropertiesViewMode propertiesMode) {
        if (propertiesMode == null) {
            UsageTrackerUtil.$$$reportNull$$$0(36);
        }
        switch (propertiesMode) {
            case TABLE: {
                LayoutAttributeChangeEvent.ViewType viewType = LayoutAttributeChangeEvent.ViewType.PROPERTY_TABLE;
                if (viewType == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(37);
                }
                return viewType;
            }
        }
        LayoutAttributeChangeEvent.ViewType viewType = LayoutAttributeChangeEvent.ViewType.INSPECTOR;
        if (viewType == null) {
            UsageTrackerUtil.$$$reportNull$$$0(38);
        }
        return viewType;
    }

    @NotNull
    static SearchOption convertFilterMatches(int matches) {
        if (matches < 1) {
            SearchOption searchOption = SearchOption.NONE;
            if (searchOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(39);
            }
            return searchOption;
        }
        if (matches > 1) {
            SearchOption searchOption = SearchOption.MULTIPLE_MATCHES;
            if (searchOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(40);
            }
            return searchOption;
        }
        SearchOption searchOption = SearchOption.SINGLE_MATCH;
        if (searchOption == null) {
            UsageTrackerUtil.$$$reportNull$$$0(41);
        }
        return searchOption;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertProgressBarViewOption(@NotNull String representation) {
        String styleValue;
        if (representation == null) {
            UsageTrackerUtil.$$$reportNull$$$0(42);
        }
        if ((styleValue = UsageTrackerUtil.getStyleValue(representation)) == null || styleValue.equals("?android:attr/progressBarStyle")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.NORMAL;
            if (viewOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(43);
            }
            return viewOption;
        }
        if (styleValue.equals("?android:attr/progressBarStyleHorizontal")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.HORIZONTAL_PROGRESS_BAR;
            if (viewOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(44);
            }
            return viewOption;
        }
        LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
        if (viewOption == null) {
            UsageTrackerUtil.$$$reportNull$$$0(45);
        }
        return viewOption;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertSeekBarViewOption(@NotNull String representation) {
        String styleValue;
        if (representation == null) {
            UsageTrackerUtil.$$$reportNull$$$0(46);
        }
        if ((styleValue = UsageTrackerUtil.getStyleValue(representation)) == null) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.NORMAL;
            if (viewOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(47);
            }
            return viewOption;
        }
        if (styleValue.equals("@style/Widget.AppCompat.SeekBar.Discrete")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.DISCRETE_SEEK_BAR;
            if (viewOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(48);
            }
            return viewOption;
        }
        LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
        if (viewOption == null) {
            UsageTrackerUtil.$$$reportNull$$$0(49);
        }
        return viewOption;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertEditTextViewOption(@NotNull String representation) {
        Matcher matcher;
        if (representation == null) {
            UsageTrackerUtil.$$$reportNull$$$0(50);
        }
        if (!(matcher = INPUT_STYLE_PATTERN.matcher(representation)).find()) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.NORMAL;
            if (viewOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(51);
            }
            return viewOption;
        }
        LayoutPaletteEvent.ViewOption viewOption = PALETTE_VIEW_OPTION_MAP.get(matcher.group(1));
        LayoutPaletteEvent.ViewOption viewOption2 = viewOption != null ? viewOption : LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
        if (viewOption2 == null) {
            UsageTrackerUtil.$$$reportNull$$$0(52);
        }
        return viewOption2;
    }

    @NotNull
    @VisibleForTesting
    static LayoutPaletteEvent.ViewOption convertLinearLayoutViewOption(@NotNull String representation) {
        Matcher matcher;
        if (representation == null) {
            UsageTrackerUtil.$$$reportNull$$$0(53);
        }
        if (!(matcher = ORIENTATION_PATTERN.matcher(representation)).find()) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
            if (viewOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(54);
            }
            return viewOption;
        }
        String orientation = matcher.group(1);
        if (orientation.equals("horizontal")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.HORIZONTAL_LINEAR_LAYOUT;
            if (viewOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(55);
            }
            return viewOption;
        }
        if (orientation.equals("vertical")) {
            LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.VERTICAL_LINEAR_LAYOUT;
            if (viewOption == null) {
                UsageTrackerUtil.$$$reportNull$$$0(56);
            }
            return viewOption;
        }
        LayoutPaletteEvent.ViewOption viewOption = LayoutPaletteEvent.ViewOption.CUSTOM_OPTION;
        if (viewOption == null) {
            UsageTrackerUtil.$$$reportNull$$$0(57);
        }
        return viewOption;
    }

    @NotNull
    @VisibleForTesting
    static String convertAttributeName(@NotNull String attributeName, @NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName, @NotNull AndroidFacet facet) {
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(58);
        }
        if (namespace == null) {
            UsageTrackerUtil.$$$reportNull$$$0(59);
        }
        if (facet == null) {
            UsageTrackerUtil.$$$reportNull$$$0(60);
        }
        switch (namespace) {
            case ANDROID: {
                String string = attributeName;
                if (string == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(61);
                }
                return string;
            }
            case APPLICATION: {
                String string = libraryName != null && UsageTrackerUtil.acceptedGoogleLibraryNamespace(libraryName) ? attributeName : CUSTOM_NAME;
                if (string == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(62);
                }
                return string;
            }
            case TOOLS: {
                NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet, attributeName);
                assert (lookup.getNamespace() != AndroidAttribute.AttributeNamespace.TOOLS);
                String string = UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet);
                if (string == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(63);
                }
                return string;
            }
        }
        if (CUSTOM_NAME == null) {
            UsageTrackerUtil.$$$reportNull$$$0(64);
        }
        return CUSTOM_NAME;
    }

    @NotNull
    static AndroidView convertTagName(@NotNull String tagName) {
        if (tagName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(65);
        }
        tagName = UsageTrackerUtil.acceptedGoogleTagNamespace(tagName) ? StringUtil.getShortName((String)tagName, (char)'.') : CUSTOM_NAME;
        AndroidView androidView = AndroidView.newBuilder().setTagName(tagName).build();
        if (androidView == null) {
            UsageTrackerUtil.$$$reportNull$$$0(66);
        }
        return androidView;
    }

    @Nullable
    @VisibleForTesting
    static String getStyleValue(@NotNull String representation) {
        Matcher matcher;
        if (representation == null) {
            UsageTrackerUtil.$$$reportNull$$$0(67);
        }
        return (matcher = STYLE_PATTERN.matcher(representation)).find() ? matcher.group(1) : null;
    }

    @VisibleForTesting
    static boolean acceptedGoogleLibraryNamespace(@NotNull String libraryName) {
        if (libraryName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(68);
        }
        return libraryName.startsWith("com.android.") || libraryName.startsWith("com.google.") || libraryName.startsWith("constraint-layout") || libraryName.startsWith("flexbox") || libraryName.startsWith("design-") || libraryName.startsWith("appcompat-v7-") || libraryName.startsWith("cardview-v7-") || libraryName.startsWith("gridlayout-v7") || libraryName.startsWith("recyclerview-v7") || libraryName.startsWith("coordinatorlayout-v7") || libraryName.startsWith("play-services-maps-") || libraryName.startsWith("play-services-ads-") || libraryName.startsWith("leanback-v17-");
    }

    @VisibleForTesting
    static boolean acceptedGoogleTagNamespace(@NotNull String fullyQualifiedTagName) {
        if (fullyQualifiedTagName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(69);
        }
        return fullyQualifiedTagName.indexOf(46) < 0 || fullyQualifiedTagName.startsWith("com.android.") || fullyQualifiedTagName.startsWith("com.google.") || fullyQualifiedTagName.startsWith("android.support.") || fullyQualifiedTagName.startsWith("android.databinding.");
    }

    @NotNull
    @VisibleForTesting
    static NamespaceAndLibraryNamePair lookupAttributeResource(@NotNull AndroidFacet facet, @NotNull String attributeName) {
        ModuleResourceManagers resourceManagers;
        SystemResourceManager systemResourceManager;
        if (facet == null) {
            UsageTrackerUtil.$$$reportNull$$$0(70);
        }
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(71);
        }
        if ((systemResourceManager = (resourceManagers = ModuleResourceManagers.getInstance(facet)).getSystemResourceManager()) == null) {
            NamespaceAndLibraryNamePair namespaceAndLibraryNamePair = new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
            if (namespaceAndLibraryNamePair == null) {
                UsageTrackerUtil.$$$reportNull$$$0(72);
            }
            return namespaceAndLibraryNamePair;
        }
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        AttributeDefinitions localAttributeDefinitions = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttributeDefinitions = ((ResourceManager)systemResourceManager).getAttributeDefinitions();
        if (systemAttributeDefinitions != null && systemAttributeDefinitions.getAttributeNames().contains(attributeName)) {
            NamespaceAndLibraryNamePair namespaceAndLibraryNamePair = new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.ANDROID);
            if (namespaceAndLibraryNamePair == null) {
                UsageTrackerUtil.$$$reportNull$$$0(73);
            }
            return namespaceAndLibraryNamePair;
        }
        if (localAttributeDefinitions == null) {
            NamespaceAndLibraryNamePair namespaceAndLibraryNamePair = new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
            if (namespaceAndLibraryNamePair == null) {
                UsageTrackerUtil.$$$reportNull$$$0(74);
            }
            return namespaceAndLibraryNamePair;
        }
        AttributeDefinition definition = localAttributeDefinitions.getAttrDefByName(attributeName);
        if (definition == null) {
            NamespaceAndLibraryNamePair namespaceAndLibraryNamePair = new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
            if (namespaceAndLibraryNamePair == null) {
                UsageTrackerUtil.$$$reportNull$$$0(75);
            }
            return namespaceAndLibraryNamePair;
        }
        NamespaceAndLibraryNamePair namespaceAndLibraryNamePair = new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION, definition.getLibraryName());
        if (namespaceAndLibraryNamePair == null) {
            UsageTrackerUtil.$$$reportNull$$$0(76);
        }
        return namespaceAndLibraryNamePair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/analytics/UsageTrackerUtil";
                break;
            }
            case 4: 
            case 58: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: 
            case 60: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 29: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 30: 
            case 42: 
            case 46: 
            case 50: 
            case 53: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "representation";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesMode";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/analytics/UsageTrackerUtil";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttribute";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNamespace";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "convertGroupName";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "convertViewOption";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPropertiesMode";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFilterMatches";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "convertProgressBarViewOption";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeekBarViewOption";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "convertEditTextViewOption";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLinearLayoutViewOption";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttributeName";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTagName";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupAttributeResource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertAttribute";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertGroupName";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "convertViewOption";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "convertPropertiesMode";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "convertProgressBarViewOption";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "convertSeekBarViewOption";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "convertEditTextViewOption";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "convertLinearLayoutViewOption";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "convertAttributeName";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "convertTagName";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getStyleValue";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "acceptedGoogleLibraryNamespace";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "acceptedGoogleTagNamespace";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lookupAttributeResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class NamespaceAndLibraryNamePair {
        private final AndroidAttribute.AttributeNamespace myNamespace;
        private final String myLibraryName;

        @VisibleForTesting
        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace) {
            if (namespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(0);
            }
            this(namespace, null);
        }

        @VisibleForTesting
        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName) {
            if (namespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(1);
            }
            this.myNamespace = namespace;
            this.myLibraryName = libraryName;
        }

        @NotNull
        public AndroidAttribute.AttributeNamespace getNamespace() {
            AndroidAttribute.AttributeNamespace attributeNamespace = this.myNamespace;
            if (attributeNamespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(2);
            }
            return attributeNamespace;
        }

        @Nullable
        public String getLibraryName() {
            return this.myLibraryName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/analytics/UsageTrackerUtil$NamespaceAndLibraryNamePair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/analytics/UsageTrackerUtil$NamespaceAndLibraryNamePair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

