/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.command;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class NlWriteCommandAction
implements Runnable {
    private final List<NlComponent> myComponents;
    private final String myName;
    private final Runnable myRunnable;
    private final NlModel myModel;

    public NlWriteCommandAction(@NotNull List<NlComponent> components, @NotNull String name, @NotNull Runnable runnable) {
        if (components == null) {
            NlWriteCommandAction.$$$reportNull$$$0(0);
        }
        if (name == null) {
            NlWriteCommandAction.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            NlWriteCommandAction.$$$reportNull$$$0(2);
        }
        NlWriteCommandAction.checkComponents(components);
        this.myComponents = components;
        this.myName = name;
        this.myRunnable = runnable;
        this.myModel = this.myComponents.get(0).getModel();
    }

    private static void checkComponents(@NotNull List<NlComponent> components) {
        if (components == null) {
            NlWriteCommandAction.$$$reportNull$$$0(3);
        }
        int size = components.size();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException();
            }
            case 1: {
                break;
            }
            default: {
                NlModel model = components.get(0).getModel();
                for (NlComponent component : components.subList(1, size)) {
                    if (component.getModel() == model) continue;
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public static void run(@NotNull NlComponent component, @NotNull String name, @NotNull Runnable runnable) {
        if (component == null) {
            NlWriteCommandAction.$$$reportNull$$$0(4);
        }
        if (name == null) {
            NlWriteCommandAction.$$$reportNull$$$0(5);
        }
        if (runnable == null) {
            NlWriteCommandAction.$$$reportNull$$$0(6);
        }
        new NlWriteCommandAction(Collections.singletonList(component), name, runnable).run();
    }

    public static void run(@NotNull List<NlComponent> components, @NotNull String name, @NotNull Runnable runnable) {
        if (components == null) {
            NlWriteCommandAction.$$$reportNull$$$0(7);
        }
        if (name == null) {
            NlWriteCommandAction.$$$reportNull$$$0(8);
        }
        if (runnable == null) {
            NlWriteCommandAction.$$$reportNull$$$0(9);
        }
        new NlWriteCommandAction(components, name, runnable).run();
    }

    @Override
    public void run() {
        new WriteCommandActionImpl().execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/command/NlWriteCommandAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkComponents";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class WriteCommandActionImpl
    extends WriteCommandAction.Simple<Void> {
        private WriteCommandActionImpl() {
            super(NlWriteCommandAction.this.myModel.getProject(), NlWriteCommandAction.this.myName, new PsiFile[]{NlWriteCommandAction.this.myModel.getFile()});
        }

        protected void run() throws Throwable {
            NlWriteCommandAction.this.myRunnable.run();
            NlWriteCommandAction.this.myComponents.forEach(component -> {
                this.cleanUpAttributes((NlComponent)component);
                this.reformatAndRearrange((NlComponent)component);
            });
        }

        private void cleanUpAttributes(@NotNull NlComponent component) {
            ViewGroupHandler handler;
            if (component == null) {
                WriteCommandActionImpl.$$$reportNull$$$0(0);
            }
            if ((handler = ViewHandlerManager.get(this.getProject()).findLayoutHandler(component, true)) == null) {
                return;
            }
            AttributesTransaction transaction = component.startAttributeTransaction();
            handler.cleanUpAttributes(component, transaction);
            transaction.commit();
        }

        private void reformatAndRearrange(@NotNull NlComponent component) {
            XmlTag tag;
            if (component == null) {
                WriteCommandActionImpl.$$$reportNull$$$0(1);
            }
            if ((tag = component.getTag()) == null) {
                Logger.getInstance(NlWriteCommandAction.class).warn("Not reformatting " + component + " because its tag is null");
                return;
            }
            if (tag.getContainingFile().getVirtualFile() == null) {
                Logger.getInstance(NlWriteCommandAction.class).warn("Not reformatting " + component + " because its virtual file is null");
                return;
            }
            TemplateUtils.reformatAndRearrange(this.getProject(), (PsiElement)tag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "component";
            objectArray2[1] = "com/android/tools/idea/common/command/NlWriteCommandAction$WriteCommandActionImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cleanUpAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reformatAndRearrange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

