/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.NlEditor;
import com.android.tools.idea.common.error.IssuePanelSplitter;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.naveditor.property.NavPropertyPanelDefinition;
import com.android.tools.idea.naveditor.structure.StructurePanel;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.uibuilder.mockup.editor.MockupToolDefinition;
import com.android.tools.idea.uibuilder.palette2.PaletteDefinition;
import com.android.tools.idea.uibuilder.property.NlPropertyPanelDefinition;
import com.android.tools.idea.uibuilder.property2.NelePropertiesPanelDefinition;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeDefinition;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.util.SyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEditorPanel
extends JPanel
implements Disposable {
    private static final String DESIGN_UNAVAILABLE_MESSAGE = "Design editor is unavailable until after a successful project sync";
    private final NlEditor myEditor;
    private final Project myProject;
    private final VirtualFile myFile;
    private final DesignSurface mySurface;
    private final JPanel myContentPanel;
    private final WorkBench<DesignSurface> myWorkBench;
    private JBSplitter mySplitter;
    private JPanel myAccessoryPanel;

    public NlEditorPanel(@NotNull NlEditor editor, @NotNull Project project, @NotNull VirtualFile file) {
        if (editor == null) {
            NlEditorPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NlEditorPanel.$$$reportNull$$$0(1);
        }
        if (file == null) {
            NlEditorPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myWorkBench = new WorkBench(project, "NELE_EDITOR", (FileEditor)editor);
        this.myWorkBench.setOpaque(true);
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = file;
        this.myContentPanel = new AdtPrimaryPanel((LayoutManager)new BorderLayout());
        this.mySurface = this.createDesignSurface(editor, project);
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.myContentPanel.add((Component)NlEditorPanel.createSurfaceToolbar(this.mySurface), "North");
        this.myWorkBench.setLoadingText("Waiting for build to finish...");
        ClearResourceCacheAfterFirstBuild.getInstance(project).runWhenResourceCacheClean(this::initNeleModel, this::buildError);
        this.mySplitter = new IssuePanelSplitter(this.mySurface, (JComponent)this.myWorkBench);
        this.add((Component)this.mySplitter);
        Disposer.register((Disposable)editor, this.myWorkBench);
    }

    @NotNull
    private DesignSurface createDesignSurface(@NotNull NlEditor editor, @NotNull Project project) {
        if (editor == null) {
            NlEditorPanel.$$$reportNull$$$0(3);
        }
        if (project == null) {
            NlEditorPanel.$$$reportNull$$$0(4);
        }
        if (NlLayoutType.typeOf(this.getFile()) == NlLayoutType.NAV) {
            NavDesignSurface navDesignSurface = new NavDesignSurface(project, this, (Disposable)editor);
            if (navDesignSurface == null) {
                NlEditorPanel.$$$reportNull$$$0(5);
            }
            return navDesignSurface;
        }
        NlDesignSurface nlDesignSurface = new NlDesignSurface(project, false, (Disposable)editor);
        nlDesignSurface.setCentered(true);
        this.myAccessoryPanel = nlDesignSurface.getAccessoryPanel();
        NlDesignSurface nlDesignSurface2 = nlDesignSurface;
        if (nlDesignSurface2 == null) {
            NlEditorPanel.$$$reportNull$$$0(6);
        }
        return nlDesignSurface2;
    }

    @NotNull
    private static JComponent createSurfaceToolbar(@NotNull DesignSurface surface) {
        if (surface == null) {
            NlEditorPanel.$$$reportNull$$$0(7);
        }
        JComponent jComponent = surface.getActionManager().createToolbar();
        if (jComponent == null) {
            NlEditorPanel.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    private void buildError() {
        this.myWorkBench.loadingStopped(DESIGN_UNAVAILABLE_MESSAGE);
    }

    public void initNeleModel() {
        ProjectSystemSyncManager syncManager = ProjectSystemUtil.getSyncManager(this.myProject);
        if (!syncManager.isSyncInProgress()) {
            if (syncManager.getLastSyncResult().isSuccessful()) {
                DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> this.initNeleModelWhenSmart());
                return;
            }
            this.buildError();
        }
        SyncUtil.listenUntilNextSuccessfulSync(this.myProject, (Disposable)this.myEditor, result2 -> {
            if (result2.isSuccessful()) {
                DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> this.initNeleModelWhenSmart());
            } else {
                this.buildError();
            }
        });
    }

    private void initNeleModelWhenSmart() {
        if (Disposer.isDisposed((Disposable)this.myEditor)) {
            return;
        }
        NlModel model = (NlModel)ReadAction.compute(() -> {
            XmlFile file = this.getFile();
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
            assert (facet != null);
            return NlModel.create((Disposable)this.myEditor, facet, this.myFile, this.mySurface.getConfigurationManager(facet));
        });
        CompletableFuture<?> complete = this.mySurface.goingToSetModel(model);
        complete.whenComplete((unused, exception) -> {
            if (exception == null) {
                DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> this.initNeleModelOnEventDispatchThread(model));
            } else {
                this.myWorkBench.loadingStopped("Failed to initialize editor");
                Logger.getInstance(NlEditorPanel.class).warn("Failed to initialize NlEditorPanel", exception);
            }
        });
    }

    private void initNeleModelOnEventDispatchThread(@NotNull NlModel model) {
        if (model == null) {
            NlEditorPanel.$$$reportNull$$$0(9);
        }
        if (Disposer.isDisposed((Disposable)model)) {
            return;
        }
        this.mySurface.setModel(model);
        if (this.myAccessoryPanel != null) {
            boolean verticalSplitter = (Boolean)StudioFlags.NELE_MOTION_HORIZONTAL.get();
            OnePixelSplitter splitter = new OnePixelSplitter(verticalSplitter, 1.0f, 0.5f, 1.0f);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent((JComponent)((Object)this.mySurface));
            splitter.setSecondComponent((JComponent)this.myAccessoryPanel);
            this.myContentPanel.add((Component)splitter, "Center");
        } else {
            this.myContentPanel.add((Component)((Object)this.mySurface), "Center");
        }
        ArrayList<ToolWindowDefinition> tools = new ArrayList<ToolWindowDefinition>(4);
        if (NlLayoutType.typeOf(model.getFile()) == NlLayoutType.NAV) {
            tools.add(new NavPropertyPanelDefinition(model.getFacet(), Side.RIGHT, Split.TOP, AutoHide.DOCKED));
            tools.add(new StructurePanel.StructurePanelDefinition());
        } else {
            tools.add(new PaletteDefinition(this.myProject, Side.LEFT, Split.TOP, AutoHide.DOCKED));
            if (((Boolean)StudioFlags.NELE_NEW_PROPERTY_PANEL.get()).booleanValue()) {
                tools.add(new NelePropertiesPanelDefinition(model.getFacet(), Side.RIGHT, Split.TOP, AutoHide.DOCKED));
            } else {
                tools.add(new NlPropertyPanelDefinition(model.getFacet(), Side.RIGHT, Split.TOP, AutoHide.DOCKED));
            }
            tools.add(new NlComponentTreeDefinition(this.myProject, Side.LEFT, Split.BOTTOM, AutoHide.DOCKED));
            if (((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
                tools.add(new MockupToolDefinition(Side.RIGHT, Split.TOP, AutoHide.AUTO_HIDE));
            }
        }
        this.myWorkBench.init((JComponent)this.myContentPanel, (Object)this.mySurface, tools);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
    }

    public void deactivate() {
        this.mySurface.deactivate();
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            NlEditorPanel.$$$reportNull$$$0(10);
        }
        return designSurface;
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myFile);
        assert (file != null);
        XmlFile xmlFile = file;
        if (xmlFile == null) {
            NlEditorPanel.$$$reportNull$$$0(11);
        }
        return xmlFile;
    }

    public void setIssuePanelProportion(float proportion) {
        this.mySplitter.setProportion(proportion);
    }

    public void dispose() {
    }

    public WorkBench<DesignSurface> getWorkBench() {
        return this.myWorkBench;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/NlEditorPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/NlEditorPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDesignSurface";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSurfaceToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDesignSurface";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSurfaceToolbar";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initNeleModelOnEventDispatchThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

