/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentUtil;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.util.XmlTagUtil;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.naveditor.model.NavComponentHelper;
import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.model.NlModelHelper;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlModel
implements Disposable,
ResourceNotificationManager.ResourceChangeListener,
ModificationTracker {
    private static final boolean CHECK_MODEL_INTEGRITY = false;
    private static final String MATERIAL2_BASE_THEME = "@style/Platform.MaterialComponents";
    private final Set<String> myPendingIds;
    @NotNull
    private final AndroidFacet myFacet;
    private final VirtualFile myFile;
    private final Configuration myConfiguration;
    private final ListenerCollection<ModelListener> myListeners;
    private NlComponent myRootComponent;
    private LintAnnotationsModel myLintAnnotationsModel;
    private final long myId;
    private final Set<Object> myActivations;
    private final ModelVersion myModelVersion;
    private final NlLayoutType myType;
    private long myConfigurationModificationCount;
    private ThreeState myUsingMaterial2Theme;
    private ChangeType myModificationTrigger;

    @NotNull
    public static NlModel create(@Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull VirtualFile file, @NotNull ConfigurationManager configurationManager) {
        if (facet == null) {
            NlModel.$$$reportNull$$$0(0);
        }
        if (file == null) {
            NlModel.$$$reportNull$$$0(1);
        }
        if (configurationManager == null) {
            NlModel.$$$reportNull$$$0(2);
        }
        NlModel nlModel = new NlModel(parent, facet, file, configurationManager.getConfiguration(file));
        if (nlModel == null) {
            NlModel.$$$reportNull$$$0(3);
        }
        return nlModel;
    }

    @NotNull
    public static NlModel create(@Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull VirtualFile file) {
        if (facet == null) {
            NlModel.$$$reportNull$$$0(4);
        }
        if (file == null) {
            NlModel.$$$reportNull$$$0(5);
        }
        NlModel nlModel = NlModel.create(parent, facet, file, ConfigurationManager.getOrCreateInstance(facet));
        if (nlModel == null) {
            NlModel.$$$reportNull$$$0(6);
        }
        return nlModel;
    }

    @VisibleForTesting
    protected NlModel(@Nullable Disposable parent, @NotNull AndroidFacet facet, @NotNull VirtualFile file, @NotNull Configuration configuration) {
        if (facet == null) {
            NlModel.$$$reportNull$$$0(7);
        }
        if (file == null) {
            NlModel.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            NlModel.$$$reportNull$$$0(9);
        }
        this.myPendingIds = Sets.newHashSet();
        this.myListeners = ListenerCollection.createWithDirectExecutor();
        this.myActivations = Collections.newSetFromMap(new WeakHashMap());
        this.myModelVersion = new ModelVersion();
        this.myUsingMaterial2Theme = ThreeState.UNSURE;
        this.myFacet = facet;
        this.myFile = file;
        this.myConfiguration = configuration;
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
        this.myId = System.nanoTime() ^ (long)file.getName().hashCode();
        if (parent != null) {
            Disposer.register((Disposable)parent, (Disposable)this);
        }
        this.myType = NlLayoutType.typeOf(this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(@NotNull Object source) {
        boolean wasActive;
        if (source == null) {
            NlModel.$$$reportNull$$$0(10);
        }
        Set<Object> set = this.myActivations;
        synchronized (set) {
            wasActive = !this.myActivations.isEmpty();
            this.myActivations.add(source);
        }
        if (!wasActive) {
            if (this.myConfiguration.getModificationCount() != this.myConfigurationModificationCount) {
                this.updateTheme();
            }
            ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
            manager.addListener(this, this.myFacet, this.myFile, this.myConfiguration);
            this.myListeners.forEach(listener2 -> listener2.modelActivated(this));
        }
    }

    public void updateTheme() {
        ResourceResolver resolver;
        ResourceUrl themeUrl = ResourceUrl.parse((String)this.myConfiguration.getTheme());
        if (themeUrl != null && themeUrl.type == ResourceType.STYLE && ((resolver = this.myConfiguration.getResourceResolver()) == null || resolver.getTheme(themeUrl.name, themeUrl.isFramework()) == null)) {
            this.myConfiguration.setTheme(this.myConfiguration.getConfigurationManager().computePreferredTheme(this.myConfiguration));
        }
        this.myUsingMaterial2Theme = ThreeState.UNSURE;
    }

    public boolean usingMaterial2Theme() {
        if (this.myUsingMaterial2Theme == ThreeState.UNSURE) {
            this.myUsingMaterial2Theme = this.checkUsingMaterial2Theme();
        }
        return this.myUsingMaterial2Theme == ThreeState.YES;
    }

    private ThreeState checkUsingMaterial2Theme() {
        StyleResourceValue material2Theme = this.findTheme(MATERIAL2_BASE_THEME);
        StyleResourceValue appTheme = this.findTheme(this.myConfiguration.getTheme());
        ResourceResolver resolver = this.myConfiguration.getResourceResolver();
        if (resolver == null || material2Theme == null || appTheme == null) {
            return ThreeState.NO;
        }
        return ThreeState.fromBoolean((boolean)resolver.themeIsParentOf(material2Theme, appTheme));
    }

    @Nullable
    private StyleResourceValue findTheme(@NotNull String name) {
        ResourceReference reference2;
        ResourceUrl style;
        if (name == null) {
            NlModel.$$$reportNull$$$0(11);
        }
        if ((style = ResourceUrl.parse((String)name)) == null) {
            return null;
        }
        ResourceNamespace.Resolver namespaceResolver = ResourceNamespace.Resolver.EMPTY_RESOLVER;
        if (this.myRootComponent != null) {
            namespaceResolver = ResourceHelper.getNamespaceResolver((XmlElement)this.myRootComponent.getTag());
        }
        if ((reference2 = style.resolve(ResourceNamespace.TODO(), namespaceResolver)) == null) {
            return null;
        }
        ResourceResolver resolver = this.myConfiguration.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        return resolver.getStyle(reference2);
    }

    private void deactivate() {
        this.myListeners.forEach(listener2 -> listener2.modelDeactivated(this));
        ResourceNotificationManager manager = ResourceNotificationManager.getInstance(this.getProject());
        manager.removeListener(this, this.myFacet, this.myFile, this.myConfiguration);
        this.myConfigurationModificationCount = this.myConfiguration.getModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(@NotNull Object source) {
        boolean shouldDeactivate;
        if (source == null) {
            NlModel.$$$reportNull$$$0(12);
        }
        Set<Object> set = this.myActivations;
        synchronized (set) {
            boolean removed = this.myActivations.remove(source);
            shouldDeactivate = removed && this.myActivations.isEmpty();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            NlModel.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    @NotNull
    public XmlFile getFile() {
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.getProject(), this.myFile);
        assert (file != null);
        XmlFile xmlFile = file;
        if (xmlFile == null) {
            NlModel.$$$reportNull$$$0(14);
        }
        return xmlFile;
    }

    @NotNull
    public NlLayoutType getType() {
        NlLayoutType nlLayoutType = this.myType;
        if (nlLayoutType == null) {
            NlModel.$$$reportNull$$$0(15);
        }
        return nlLayoutType;
    }

    @Nullable
    public LintAnnotationsModel getLintAnnotationsModel() {
        return this.myLintAnnotationsModel;
    }

    public void setLintAnnotationsModel(@Nullable LintAnnotationsModel model) {
        this.myLintAnnotationsModel = model;
    }

    @NotNull
    public Set<String> getPendingIds() {
        Set<String> set = this.myPendingIds;
        if (set == null) {
            NlModel.$$$reportNull$$$0(16);
        }
        return set;
    }

    public void syncWithPsi(@NotNull XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
        if (newRoot == null) {
            NlModel.$$$reportNull$$$0(17);
        }
        if (roots == null) {
            NlModel.$$$reportNull$$$0(18);
        }
        new ModelUpdater(this).update(newRoot, roots);
    }

    public void checkStructure() {
    }

    private void checkUnique(NlComponent component, Set<NlComponent> unique) {
    }

    private void checkUnique(XmlTag tag, Set<XmlTag> unique) {
    }

    private void checkStructure(NlComponent component) {
    }

    public void addListener(@NotNull ModelListener listener2) {
        if (listener2 == null) {
            NlModel.$$$reportNull$$$0(19);
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull ModelListener listener2) {
        if (listener2 == null) {
            NlModel.$$$reportNull$$$0(20);
        }
        this.myListeners.remove(listener2);
    }

    public void notifyListenersModelUpdateComplete() {
        this.myListeners.forEach(listener2 -> listener2.modelDerivedDataChanged(this));
    }

    public void notifyListenersModelLayoutComplete(boolean animate) {
        this.myListeners.forEach(listener2 -> listener2.modelChangedOnLayout(this, animate));
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            NlModel.$$$reportNull$$$0(21);
        }
        return androidFacet;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myFacet.getModule();
        if (module == null) {
            NlModel.$$$reportNull$$$0(22);
        }
        return module;
    }

    @NotNull
    public Project getProject() {
        Project project = this.getModule().getProject();
        if (project == null) {
            NlModel.$$$reportNull$$$0(23);
        }
        return project;
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            NlModel.$$$reportNull$$$0(24);
        }
        return configuration;
    }

    @NotNull
    public ImmutableList<NlComponent> getComponents() {
        ImmutableList immutableList = this.myRootComponent != null ? ImmutableList.of((Object)this.myRootComponent) : ImmutableList.of();
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(25);
        }
        return immutableList;
    }

    @NotNull
    public Stream<NlComponent> flattenComponents() {
        Stream<NlComponent> stream = this.myRootComponent != null ? Stream.of(this.myRootComponent).flatMap(NlComponent::flatten) : Stream.empty();
        if (stream == null) {
            NlModel.$$$reportNull$$$0(26);
        }
        return stream;
    }

    public void notifyLiveUpdate(boolean animate) {
        this.myListeners.forEach(listener2 -> listener2.modelLiveUpdate(this, animate));
    }

    @NotNull
    public ImmutableList<NlComponent> findByOffset(int offset) {
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)this.getFile(), (int)offset, XmlTag.class, (boolean)false);
        ImmutableList<NlComponent> immutableList = tag != null ? this.findViewsByTag(tag) : ImmutableList.of();
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(27);
        }
        return immutableList;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(28);
        }
        return this.myRootComponent != null ? this.myRootComponent.findViewByTag(tag) : null;
    }

    @Nullable
    public NlComponent find(@NotNull String id) {
        if (id == null) {
            NlModel.$$$reportNull$$$0(29);
        }
        return this.flattenComponents().filter(c -> {
            if (id == null) {
                NlModel.$$$reportNull$$$0(71);
            }
            return id.equals(c.getId());
        }).findFirst().orElse(null);
    }

    @Nullable
    public NlComponent find(@NotNull Predicate<NlComponent> condition) {
        if (condition == null) {
            NlModel.$$$reportNull$$$0(30);
        }
        return this.flattenComponents().filter(condition).findFirst().orElse(null);
    }

    @NotNull
    private ImmutableList<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(31);
        }
        if (this.myRootComponent == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                NlModel.$$$reportNull$$$0(32);
            }
            return immutableList;
        }
        ImmutableList<NlComponent> immutableList = this.myRootComponent.findViewsByTag(tag);
        if (immutableList == null) {
            NlModel.$$$reportNull$$$0(33);
        }
        return immutableList;
    }

    @Nullable
    public NlComponent findViewByPsi(@Nullable PsiElement element) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        while (element != null) {
            if (element instanceof XmlTag) {
                return this.findViewByTag((XmlTag)element);
            }
            element = element.getParent();
        }
        return null;
    }

    public void delete(final Collection<NlComponent> components) {
        WriteCommandAction<Void> action2 = new WriteCommandAction<Void>(this.myFacet.getModule().getProject(), "Delete Component", new PsiFile[]{this.getFile()}){

            protected void run(@NotNull Result<Void> result2) {
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                NlModel.handleDeletion(components);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/common/model/NlModel$1", "run"));
            }
        };
        action2.execute();
        this.notifyModified(ChangeType.DELETE);
    }

    private static void handleDeletion(@NotNull Collection<NlComponent> components) {
        if (components == null) {
            NlModel.$$$reportNull$$$0(34);
        }
        Multimap<NlComponent, NlComponent> siblingLists = NlComponentUtil.groupSiblings(components);
        for (NlComponent parent : siblingLists.keySet()) {
            Collection children;
            if (parent == null || NlModelHelper.INSTANCE.handleDeletion(parent, children = siblingLists.get((Object)parent))) continue;
            for (NlComponent component : children) {
                XmlTag tag;
                NlComponent p = component.getParent();
                if (p != null) {
                    p.removeChild(component);
                }
                if (!(tag = component.getTag()).isValid()) continue;
                tag.delete();
            }
        }
    }

    public NlComponent createComponent(@Nullable DesignSurface surface, @NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(35);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(36);
        }
        if (parent != null) {
            XmlTag parentTag = parent.getTag();
            tag = before != null ? (XmlTag)parentTag.addBefore((PsiElement)tag, (PsiElement)before.getTag()) : parentTag.addSubTag(tag, false);
        }
        NlComponent child = this.createComponent(tag);
        if (parent != null) {
            parent.addChild(child, before);
        }
        if (child.postCreate(surface, insertType)) {
            return child;
        }
        return null;
    }

    public NlComponent createComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            NlModel.$$$reportNull$$$0(37);
        }
        NlComponent component = new NlComponent(this, tag);
        NlLayoutType layoutType = NlLayoutType.typeOf(this.getFile());
        switch (layoutType) {
            case NAV: {
                NavComponentHelper.INSTANCE.registerComponent(component);
                break;
            }
            default: {
                NlComponentHelper.INSTANCE.registerComponent(component);
            }
        }
        return component;
    }

    public List<NlComponent> createComponents(@NotNull DnDTransferItem item, @NotNull InsertType insertType, @NotNull DesignSurface surface) {
        if (item == null) {
            NlModel.$$$reportNull$$$0(38);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(39);
        }
        if (surface == null) {
            NlModel.$$$reportNull$$$0(40);
        }
        ArrayList<NlComponent> components = new ArrayList<NlComponent>(item.getComponents().size());
        for (DnDTransferComponent dndComponent : item.getComponents()) {
            XmlTag tag = XmlTagUtil.createTag(this.getProject(), dndComponent.getRepresentation());
            NlComponent component = this.createComponent(surface, tag, null, null, insertType);
            if (component == null) {
                return Collections.emptyList();
            }
            component.postCreateFromTransferrable(dndComponent);
            components.add(component);
        }
        return components;
    }

    public boolean canAddComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(41);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(42);
        }
        return this.canAddComponents(toAdd, receiver, before, false);
    }

    public boolean canAddComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, boolean ignoreMissingDependencies) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(43);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(44);
        }
        if (before != null && before.getParent() != receiver) {
            return false;
        }
        if (toAdd.isEmpty()) {
            return false;
        }
        if (toAdd.stream().anyMatch(c -> {
            if (receiver == null) {
                NlModel.$$$reportNull$$$0(70);
            }
            return !c.canAddTo(receiver);
        })) {
            return false;
        }
        for (NlComponent component : toAdd) {
            for (NlComponent same = receiver; same != null; same = same.getParent()) {
                if (same != component) continue;
                return false;
            }
        }
        return ignoreMissingDependencies || this.checkIfUserWantsToAddDependencies(toAdd);
    }

    private boolean checkIfUserWantsToAddDependencies(List<NlComponent> toAdd) {
        return NlDependencyManager.Companion.get().checkIfUserWantsToAddDependencies(toAdd, this.getFacet());
    }

    public void addComponents(@NotNull List<NlComponent> toAdd, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(45);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(46);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(47);
        }
        if (!this.canAddComponents(toAdd, receiver, before)) {
            return;
        }
        NlWriteCommandAction.run(toAdd, NlModel.generateAddComponentsDescription(toAdd, insertType), () -> {
            if (toAdd == null) {
                NlModel.$$$reportNull$$$0(67);
            }
            if (receiver == null) {
                NlModel.$$$reportNull$$$0(68);
            }
            if (insertType == null) {
                NlModel.$$$reportNull$$$0(69);
            }
            this.handleAddition(toAdd, receiver, before, insertType, surface);
        });
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    @NotNull
    private static String generateAddComponentsDescription(@NotNull List<NlComponent> toAdd, @NotNull InsertType insertType) {
        if (toAdd == null) {
            NlModel.$$$reportNull$$$0(48);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(49);
        }
        DragType dragType = insertType.getDragType();
        String componentType = "";
        if (toAdd.size() == 1) {
            String tagName = toAdd.get(0).getTagName();
            componentType = tagName.substring(tagName.lastIndexOf(46) + 1);
        }
        String string = dragType.getDescription(componentType);
        if (string == null) {
            NlModel.$$$reportNull$$$0(50);
        }
        return string;
    }

    public void addTags(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (added == null) {
            NlModel.$$$reportNull$$$0(51);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(52);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(53);
        }
        NlWriteCommandAction.run(added, NlModel.generateAddComponentsDescription(added, insertType), () -> {
            if (added == null) {
                NlModel.$$$reportNull$$$0(64);
            }
            if (receiver == null) {
                NlModel.$$$reportNull$$$0(65);
            }
            if (insertType == null) {
                NlModel.$$$reportNull$$$0(66);
            }
            for (NlComponent component : added) {
                component.addTags(receiver, before, insertType);
            }
        });
        this.notifyModified(ChangeType.ADD_COMPONENTS);
    }

    public Set<String> getIds() {
        LocalResourceRepository resources = ResourceRepositoryManager.getAppResources(this.getFacet());
        HashSet<String> ids = new HashSet<String>(resources.getItemsOfType(ResourceType.ID));
        Set<String> pendingIds = this.getPendingIds();
        if (!pendingIds.isEmpty()) {
            HashSet<String> all = new HashSet<String>(pendingIds.size() + ids.size());
            all.addAll(ids);
            all.addAll(pendingIds);
            ids = all;
        }
        return ids;
    }

    private void handleAddition(@NotNull List<NlComponent> added, @NotNull NlComponent receiver, @Nullable NlComponent before, @NotNull InsertType insertType, @Nullable DesignSurface surface) {
        if (added == null) {
            NlModel.$$$reportNull$$$0(54);
        }
        if (receiver == null) {
            NlModel.$$$reportNull$$$0(55);
        }
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(56);
        }
        NlDependencyManager.Companion.get().addDependencies(added, this.getFacet());
        Set<String> ids = this.getIds();
        for (NlComponent component : added) {
            component.moveTo(receiver, before, insertType, ids, surface);
        }
    }

    @NotNull
    public InsertType determineInsertType(@NotNull DragType dragType, @Nullable DnDTransferItem item, boolean asPreview) {
        if (dragType == null) {
            NlModel.$$$reportNull$$$0(57);
        }
        if (item != null && item.isFromPalette()) {
            InsertType insertType = asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
            if (insertType == null) {
                NlModel.$$$reportNull$$$0(58);
            }
            return insertType;
        }
        switch (dragType) {
            case CREATE: {
                InsertType insertType = asPreview ? InsertType.CREATE_PREVIEW : InsertType.CREATE;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(59);
                }
                return insertType;
            }
            case MOVE: {
                InsertType insertType = item != null && this.myId != item.getModelId() ? InsertType.COPY : InsertType.MOVE_INTO;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(60);
                }
                return insertType;
            }
            case COPY: {
                InsertType insertType = InsertType.COPY;
                if (insertType == null) {
                    NlModel.$$$reportNull$$$0(61);
                }
                return insertType;
            }
        }
        InsertType insertType = InsertType.PASTE;
        if (insertType == null) {
            NlModel.$$$reportNull$$$0(62);
        }
        return insertType;
    }

    public long getId() {
        return this.myId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean shouldDeactivate;
        Set<Object> set = this.myActivations;
        synchronized (set) {
            shouldDeactivate = !this.myActivations.isEmpty();
            this.myActivations.clear();
        }
        if (shouldDeactivate) {
            this.deactivate();
        }
        this.myListeners.clear();
    }

    public String toString() {
        return NlModel.class.getSimpleName() + " for " + this.myFile;
    }

    @Override
    public void resourcesChanged(@NotNull Set<ResourceNotificationManager.Reason> reason) {
        if (reason == null) {
            NlModel.$$$reportNull$$$0(63);
        }
        for (ResourceNotificationManager.Reason r : reason) {
            switch (r) {
                case RESOURCE_EDIT: {
                    this.notifyModified(ChangeType.RESOURCE_EDIT);
                    break;
                }
                case EDIT: {
                    this.notifyModified(ChangeType.EDIT);
                    break;
                }
                case IMAGE_RESOURCE_CHANGED: {
                    RefreshRenderAction.clearCache(this.getConfiguration());
                    this.notifyModified(ChangeType.RESOURCE_CHANGED);
                    break;
                }
                case GRADLE_SYNC: 
                case PROJECT_BUILD: 
                case VARIANT_CHANGED: 
                case SDK_CHANGED: {
                    this.notifyModified(ChangeType.BUILD);
                    break;
                }
                case CONFIGURATION_CHANGED: {
                    this.notifyModified(ChangeType.CONFIGURATION_CHANGE);
                }
            }
        }
    }

    public long getModificationCount() {
        return this.myModelVersion.getVersion();
    }

    public long getConfigurationModificationCount() {
        return this.myConfigurationModificationCount;
    }

    public void notifyModified(ChangeType reason) {
        this.myModelVersion.increase(reason);
        this.updateTheme();
        this.myModificationTrigger = reason;
        this.myListeners.forEach(listener2 -> listener2.modelChanged(this));
    }

    public ChangeType getLastChangeType() {
        return this.myModificationTrigger;
    }

    public void resetLastChange() {
        this.myModificationTrigger = null;
    }

    private /* synthetic */ void lambda$checkStructure$2() {
        Set unique = Sets.newIdentityHashSet();
        Set uniqueTags = Sets.newIdentityHashSet();
        this.checkUnique(this.getFile().getRootTag(), uniqueTags);
        uniqueTags.clear();
        if (this.myRootComponent != null) {
            this.checkUnique(this.myRootComponent.getTag(), uniqueTags);
            this.checkUnique(this.myRootComponent, unique);
            this.checkStructure(this.myRootComponent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 50: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 50: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationManager";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 50: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/NlModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 28: 
            case 31: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 29: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 36: 
            case 39: 
            case 47: 
            case 49: 
            case 53: 
            case 56: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 42: 
            case 44: 
            case 46: 
            case 52: 
            case 55: 
            case 65: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 51: 
            case 54: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragType";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/NlModel";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPendingIds";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenComponents";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findByOffset";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewsByTag";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAddComponentsDescription";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "determineInsertType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 50: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTheme";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "syncWithPsi";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findViewByTag";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findViewsByTag";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "handleDeletion";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createComponents";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "canAddComponents";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addComponents";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "generateAddComponentsDescription";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addTags";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "handleAddition";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "determineInsertType";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resourcesChanged";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTags$9";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addComponents$8";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$canAddComponents$7";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$find$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 33: 
            case 50: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModelVersion {
        private final AtomicLong myVersion = new AtomicLong();
        ChangeType mLastReason;

        ModelVersion() {
        }

        public void increase(ChangeType reason) {
            this.myVersion.incrementAndGet();
            this.mLastReason = reason;
        }

        public long getVersion() {
            return this.myVersion.get();
        }
    }

    public static enum ChangeType {
        RESOURCE_EDIT,
        EDIT,
        RESOURCE_CHANGED,
        ADD_COMPONENTS,
        DELETE,
        DND_COMMIT,
        DND_END,
        DROP,
        RESIZE_END,
        RESIZE_COMMIT,
        UPDATE_HIERARCHY,
        BUILD,
        CONFIGURATION_CHANGE;

    }

    private static class ModelUpdater {
        private final NlModel myModel;
        private final Map<XmlTag, NlComponent> myTagToComponentMap;
        private final Map<NlComponent, XmlTag> myComponentToTagMap;
        protected final Map<TagSnapshot, NlComponent> mySnapshotToComponent;
        private final Map<XmlTag, TagSnapshot> myTagToSnapshot;

        public ModelUpdater(@NotNull NlModel model) {
            if (model == null) {
                ModelUpdater.$$$reportNull$$$0(0);
            }
            this.myTagToComponentMap = Maps.newIdentityHashMap();
            this.myComponentToTagMap = Maps.newIdentityHashMap();
            this.mySnapshotToComponent = Maps.newIdentityHashMap();
            this.myTagToSnapshot = Maps.newHashMap();
            this.myModel = model;
        }

        private void recordComponentMapping(@NotNull XmlTag tag, @NotNull NlComponent component) {
            XmlTag prevTag;
            if (tag == null) {
                ModelUpdater.$$$reportNull$$$0(1);
            }
            if (component == null) {
                ModelUpdater.$$$reportNull$$$0(2);
            }
            if ((prevTag = this.myComponentToTagMap.get(component)) != null) {
                this.myTagToComponentMap.remove(prevTag);
            }
            this.myComponentToTagMap.put(component, tag);
            this.myTagToComponentMap.put(tag, component);
        }

        @VisibleForTesting
        public void update(@Nullable XmlTag newRoot, @NotNull List<TagSnapshotTreeNode> roots) {
            if (roots == null) {
                ModelUpdater.$$$reportNull$$$0(3);
            }
            if (newRoot == null) {
                this.myModel.myRootComponent = null;
                return;
            }
            this.myModel.myRootComponent = (NlComponent)ApplicationManager.getApplication().runReadAction(() -> {
                if (roots == null) {
                    ModelUpdater.$$$reportNull$$$0(11);
                }
                if (!newRoot.isValid()) {
                    return null;
                }
                for (TagSnapshotTreeNode tagSnapshotTreeNode : roots) {
                    ModelUpdater.gatherTagsAndSnapshots(tagSnapshotTreeNode, this.myTagToSnapshot);
                }
                this.mapOldToNew(newRoot);
                for (Map.Entry entry : this.myTagToComponentMap.entrySet()) {
                    XmlTag tag = (XmlTag)entry.getKey();
                    NlComponent component = (NlComponent)entry.getValue();
                    if (component.getTagName().equals(tag.getName())) continue;
                    this.myTagToComponentMap.clear();
                    this.myComponentToTagMap.clear();
                    break;
                }
                return this.createTree(newRoot);
            });
            for (NlComponent component : this.myTagToComponentMap.values()) {
                component.setSnapshot(null);
            }
            for (TagSnapshotTreeNode root : roots) {
                this.updateHierarchy(root);
            }
        }

        private void mapOldToNew(@NotNull XmlTag newRootTag) {
            XmlTag oldTag;
            TagSnapshot snapshot;
            NlComponent component;
            if (newRootTag == null) {
                ModelUpdater.$$$reportNull$$$0(4);
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (NlComponent component2 : this.myModel.getComponents()) {
                this.gatherTagsAndSnapshots(component2);
            }
            ArrayList missing = Lists.newArrayList();
            Set remaining = Sets.newIdentityHashSet();
            remaining.addAll(this.myTagToComponentMap.keySet());
            ModelUpdater.checkMissing(newRootTag, remaining, missing);
            if (missing.isEmpty()) {
                return;
            }
            if (remaining.isEmpty()) {
                return;
            }
            HashMap oldIds = Maps.newHashMap();
            for (Map.Entry<TagSnapshot, NlComponent> entry : this.mySnapshotToComponent.entrySet()) {
                String id;
                TagSnapshot snapshot2 = entry.getKey();
                if (snapshot2 == null || (id = snapshot2.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null) continue;
                oldIds.put(id, entry.getValue());
            }
            ListIterator missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                XmlTag tag = (XmlTag)missingIterator.next();
                String id = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                if (id == null || (component = (NlComponent)oldIds.get(id)) == null) continue;
                this.recordComponentMapping(tag, component);
                remaining.remove(component.getTag());
                missingIterator.remove();
            }
            if (missing.isEmpty() || remaining.isEmpty()) {
                return;
            }
            ArrayListMultimap snapshotIds = ArrayListMultimap.create();
            for (XmlTag old : remaining) {
                NlComponent component3 = this.myTagToComponentMap.get(old);
                if (component3 == null || (snapshot = component3.getSnapshot()) == null) continue;
                snapshotIds.put((Object)snapshot.getSignature(), (Object)snapshot);
            }
            missingIterator = missing.listIterator();
            while (missingIterator.hasNext()) {
                TagSnapshot first;
                NlComponent component4;
                long signature;
                Collection snapshots;
                XmlTag tag = (XmlTag)missingIterator.next();
                TagSnapshot snapshot3 = this.myTagToSnapshot.get(tag);
                if (snapshot3 == null || (snapshots = snapshotIds.get((Object)(signature = snapshot3.getSignature()))).isEmpty() || (component4 = this.mySnapshotToComponent.get(first = (TagSnapshot)snapshots.iterator().next())) == null) continue;
                this.recordComponentMapping(tag, component4);
                remaining.remove(component4.getTag());
                snapshotIds.remove((Object)tag, (Object)first);
                missingIterator.remove();
            }
            if (missing.size() == 1 && remaining.size() == 1 && (component = this.myTagToComponentMap.get(oldTag = (XmlTag)remaining.iterator().next())) != null) {
                XmlTag newTag = (XmlTag)missing.get(0);
                snapshot = component.getSnapshot();
                if (snapshot != null && snapshot.tagName.equals(newTag.getName())) {
                    this.recordComponentMapping(newTag, component);
                }
            }
        }

        private static void checkMissing(XmlTag tag, Set<XmlTag> remaining, List<XmlTag> missing) {
            boolean found = remaining.remove(tag);
            if (!found) {
                missing.add(tag);
            }
            for (XmlTag child : tag.getSubTags()) {
                ModelUpdater.checkMissing(child, remaining, missing);
            }
        }

        private void gatherTagsAndSnapshots(@NotNull NlComponent component) {
            if (component == null) {
                ModelUpdater.$$$reportNull$$$0(5);
            }
            XmlTag tag = component.getTag();
            this.recordComponentMapping(tag, component);
            this.mySnapshotToComponent.put(component.getSnapshot(), component);
            for (NlComponent child : component.getChildren()) {
                this.gatherTagsAndSnapshots(child);
            }
        }

        private static void gatherTagsAndSnapshots(@NotNull TagSnapshotTreeNode node, @NotNull Map<XmlTag, TagSnapshot> map2) {
            TagSnapshot snapshot;
            if (node == null) {
                ModelUpdater.$$$reportNull$$$0(6);
            }
            if (map2 == null) {
                ModelUpdater.$$$reportNull$$$0(7);
            }
            if ((snapshot = node.getTagSnapshot()) != null) {
                map2.put(snapshot.tag, snapshot);
            }
            for (TagSnapshotTreeNode child : node.getChildren()) {
                ModelUpdater.gatherTagsAndSnapshots(child, map2);
            }
        }

        @NotNull
        private NlComponent createTree(@NotNull XmlTag tag) {
            XmlTag[] subTags;
            NlComponent component;
            if (tag == null) {
                ModelUpdater.$$$reportNull$$$0(8);
            }
            if ((component = this.myTagToComponentMap.get(tag)) == null) {
                component = this.myModel.createComponent(tag);
                this.recordComponentMapping(tag, component);
            }
            if ((subTags = tag.getSubTags()).length > 0) {
                ArrayList<NlComponent> children = new ArrayList<NlComponent>(subTags.length);
                for (XmlTag subtag : subTags) {
                    NlComponent child = this.createTree(subtag);
                    children.add(child);
                }
                component.setChildren(children);
            } else {
                component.setChildren(null);
            }
            NlComponent nlComponent = component;
            if (nlComponent == null) {
                ModelUpdater.$$$reportNull$$$0(9);
            }
            return nlComponent;
        }

        private void updateHierarchy(@NotNull TagSnapshotTreeNode node) {
            TagSnapshot snapshot;
            if (node == null) {
                ModelUpdater.$$$reportNull$$$0(10);
            }
            if ((snapshot = node.getTagSnapshot()) != null) {
                NlComponent component = this.mySnapshotToComponent.get(snapshot);
                if (component == null) {
                    component = this.myTagToComponentMap.get(snapshot.tag);
                }
                if (component != null) {
                    component.setSnapshot(snapshot);
                    assert (snapshot.tag != null);
                    component.setTag(snapshot.tag);
                }
            }
            for (TagSnapshotTreeNode child : node.getChildren()) {
                this.updateHierarchy(child);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRootTag";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/model/NlModel$ModelUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/model/NlModel$ModelUpdater";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "recordComponentMapping";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "mapOldToNew";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "gatherTagsAndSnapshots";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createTree";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "updateHierarchy";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$update$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TagSnapshotTreeNode {
        @Nullable
        public TagSnapshot getTagSnapshot();

        @NotNull
        public List<TagSnapshotTreeNode> getChildren();
    }
}

