/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.util.ListenerCollection;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModel {
    @NotNull
    private ImmutableList<NlComponent> mySelection = ImmutableList.of();
    private NlComponent myPrimary;
    private final ListenerCollection<SelectionListener> myListeners = ListenerCollection.createWithDirectExecutor();

    @NotNull
    public ImmutableList<NlComponent> getSelection() {
        ImmutableList<NlComponent> immutableList = this.mySelection;
        if (immutableList == null) {
            SelectionModel.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Nullable
    public NlComponent getPrimary() {
        return this.myPrimary;
    }

    public void setSelection(@NotNull List<NlComponent> components) {
        if (components == null) {
            SelectionModel.$$$reportNull$$$0(1);
        }
        this.setSelection((List<NlComponent>)ImmutableList.copyOf(components), components.isEmpty() ? null : components.iterator().next());
    }

    public void setSelection(@NotNull List<NlComponent> components, @Nullable NlComponent primary) {
        if (components == null) {
            SelectionModel.$$$reportNull$$$0(2);
        }
        if (components.equals(this.mySelection)) {
            return;
        }
        this.mySelection = ImmutableList.copyOf(components);
        this.myPrimary = primary;
        this.notifySelectionChanged();
    }

    public void clear() {
        if (this.mySelection.isEmpty()) {
            return;
        }
        this.mySelection = ImmutableList.of();
        this.myPrimary = null;
        this.notifySelectionChanged();
    }

    public void toggle(@NotNull NlComponent component) {
        NlComponent newPrimary;
        ImmutableList newSelection;
        int size;
        if (component == null) {
            SelectionModel.$$$reportNull$$$0(3);
        }
        if ((size = this.mySelection.size()) == 0) {
            newSelection = ImmutableList.of((Object)component);
            newPrimary = component;
        } else if (this.mySelection.contains((Object)component)) {
            if (size == 1) {
                newSelection = ImmutableList.of();
                newPrimary = null;
            } else {
                newSelection = (ImmutableList)this.mySelection.stream().filter(selection -> {
                    if (component == null) {
                        SelectionModel.$$$reportNull$$$0(6);
                    }
                    return !selection.equals(component);
                }).collect(ImmutableCollectors.toImmutableList());
                newPrimary = this.myPrimary == component ? null : this.myPrimary;
            }
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.mySelection);
            builder.add((Object)component);
            newSelection = builder.build();
            newPrimary = this.myPrimary;
        }
        this.setSelection((List<NlComponent>)newSelection, newPrimary);
    }

    private void notifySelectionChanged() {
        this.myListeners.forEach(l -> l.selectionChanged(this, (List<NlComponent>)this.mySelection));
    }

    public void addListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            SelectionModel.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@Nullable SelectionListener listener2) {
        this.myListeners.remove(listener2);
    }

    public boolean isEmpty() {
        return this.mySelection.isEmpty();
    }

    public boolean isSelected(@NotNull NlComponent component) {
        if (component == null) {
            SelectionModel.$$$reportNull$$$0(5);
        }
        return this.mySelection.contains((Object)component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/SelectionModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/SelectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toggle";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$toggle$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

