/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesPanel;
import com.android.tools.idea.common.property.editors.PropertyEditors;
import com.android.tools.idea.common.property.inspector.InspectorProviders;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertiesManager<Self extends PropertiesManager<Self>>
implements ToolContent<DesignSurface>,
DesignSurfaceListener,
ModelListener,
Disposable {
    public static final int UPDATE_DELAY_MSECS = 250;
    private static final int START_DELAY_MSECS = 20;
    public static final int MINIMUM_WIDTH = 250;
    private final Project myProject;
    private final AndroidFacet myFacet;
    private final PropertyEditors myEditors;
    protected boolean myLoading;
    private JBLoadingPanel myLoadingPanel;
    private PropertiesPanel<Self> myPropertiesPanel;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    protected SceneView mySceneView;
    private MergingUpdateQueue myUpdateQueue;
    private boolean myFirstLoad;
    private int myUpdateCount;
    private JBSplitter mySplitter;
    private Runnable myStopFilteringCallback;

    public PropertiesManager(@NotNull AndroidFacet facet, @Nullable DesignSurface designSurface, @NotNull PropertyEditors editors) {
        if (facet == null) {
            PropertiesManager.$$$reportNull$$$0(0);
        }
        if (editors == null) {
            PropertiesManager.$$$reportNull$$$0(1);
        }
        this.myFirstLoad = true;
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.mySurface = designSurface;
        this.myEditors = editors;
        this.setToolContextWithoutCheck(designSurface);
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        if (designSurface == this.mySurface) {
            return;
        }
        this.setToolContextWithoutCheck(designSurface);
    }

    public void setStopFiltering(@NotNull Runnable callback) {
        if (callback == null) {
            PropertiesManager.$$$reportNull$$$0(2);
        }
        this.myStopFilteringCallback = callback;
    }

    @NotNull
    private JBLoadingPanel getLoadingPanel() {
        if (this.myLoadingPanel == null) {
            this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 20);
            this.myLoadingPanel.setMinimumSize(new Dimension(JBUI.scale((int)250), 0));
            this.myLoadingPanel.add((Component)this.getContentPanel());
        }
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            PropertiesManager.$$$reportNull$$$0(3);
        }
        return jBLoadingPanel;
    }

    @NotNull
    protected PropertiesPanel<Self> getPropertiesPanel() {
        if (this.myPropertiesPanel == null) {
            this.myPropertiesPanel = this.createPropertiesPanel();
        }
        PropertiesPanel<Self> propertiesPanel = this.myPropertiesPanel;
        if (propertiesPanel == null) {
            PropertiesManager.$$$reportNull$$$0(4);
        }
        return propertiesPanel;
    }

    @NotNull
    protected abstract PropertiesPanel<Self> createPropertiesPanel();

    @NotNull
    protected JBSplitter getContentPanel() {
        if (this.mySplitter == null) {
            this.mySplitter = new JBSplitter(true, 0.8f){
                {
                    this.setDividerWidth(9);
                }

                protected Divider createDivider() {
                    Splitter.DividerImpl divider = new Splitter.DividerImpl((Splitter)this);
                    divider.setBorder(IdeBorderFactory.createBorder((int)10));
                    return divider;
                }
            };
            this.mySplitter.setFirstComponent(this.getPropertiesPanel());
        }
        JBSplitter jBSplitter = this.mySplitter;
        if (jBSplitter == null) {
            PropertiesManager.$$$reportNull$$$0(5);
        }
        return jBSplitter;
    }

    private void setToolContextWithoutCheck(@Nullable DesignSurface designSurface) {
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface == null) {
            this.setSceneView(null);
        } else {
            this.mySurface.addListener(this);
            SceneView sceneView = this.mySurface.getCurrentSceneView();
            this.setSceneView(sceneView);
            List<NlComponent> selection = sceneView != null ? sceneView.getSelectionModel().getSelection() : Collections.emptyList();
            this.componentSelectionChanged(this.mySurface, selection);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.getLoadingPanel();
        if (jBLoadingPanel == null) {
            PropertiesManager.$$$reportNull$$$0(6);
        }
        return jBLoadingPanel;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        JBSplitter jBSplitter = this.getContentPanel();
        if (jBSplitter == null) {
            PropertiesManager.$$$reportNull$$$0(7);
        }
        return jBSplitter;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            PropertiesManager.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            PropertiesManager.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    public boolean supportsFiltering() {
        return false;
    }

    @Nullable
    public DesignSurface getDesignSurface() {
        return this.mySurface;
    }

    protected void setSceneView(@Nullable SceneView sceneView) {
        if (sceneView == this.mySceneView) {
            return;
        }
        if (this.mySceneView != null) {
            this.mySceneView.getModel().removeListener(this);
        }
        this.mySceneView = sceneView;
        if (this.mySceneView != null) {
            this.mySceneView.getModel().addListener(this);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PropertiesManager.$$$reportNull$$$0(10);
        }
        return project;
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            PropertiesManager.$$$reportNull$$$0(11);
        }
        return androidFacet;
    }

    @NotNull
    public PropertyEditors getPropertyEditors() {
        PropertyEditors propertyEditors = this.myEditors;
        if (propertyEditors == null) {
            PropertiesManager.$$$reportNull$$$0(12);
        }
        return propertyEditors;
    }

    @NotNull
    private MergingUpdateQueue getUpdateQueue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUpdateQueue == null) {
            this.myUpdateQueue = new MergingUpdateQueue("android.layout.propertysheet", 250, true, null, (Disposable)this.mySurface, null, Alarm.ThreadToUse.SWING_THREAD);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myUpdateQueue;
        if (mergingUpdateQueue == null) {
            PropertiesManager.$$$reportNull$$$0(13);
        }
        return mergingUpdateQueue;
    }

    private void setSelectedComponents(@NotNull List<NlComponent> components, @Nullable Runnable postUpdateRunnable) {
        if (components == null) {
            PropertiesManager.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (components == null) {
                PropertiesManager.$$$reportNull$$$0(34);
            }
            Table<String, String, NlPropertyItem> properties = NlProperties.getInstance().getProperties(this.myFacet, this, components);
            UIUtil.invokeLaterIfNeeded(() -> {
                if (components == null) {
                    PropertiesManager.$$$reportNull$$$0(35);
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.getPropertiesPanel().setItems(components, properties);
                if (this.myStopFilteringCallback != null) {
                    this.myStopFilteringCallback.run();
                }
                if (postUpdateRunnable != null) {
                    this.myLoading = false;
                    postUpdateRunnable.run();
                }
            });
        });
    }

    public boolean isLoading() {
        return this.myLoading;
    }

    @NotNull
    public PropertiesMap getDefaultProperties(@NotNull List<NlComponent> components) {
        if (components == null) {
            PropertiesManager.$$$reportNull$$$0(15);
        }
        if (components.isEmpty()) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                PropertiesManager.$$$reportNull$$$0(16);
            }
            return propertiesMap;
        }
        if (this.mySurface == null) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                PropertiesManager.$$$reportNull$$$0(17);
            }
            return propertiesMap;
        }
        SceneView view = this.mySurface.getCurrentSceneView();
        if (view == null) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                PropertiesManager.$$$reportNull$$$0(18);
            }
            return propertiesMap;
        }
        Map<Object, PropertiesMap> map2 = view.getSceneManager().getDefaultProperties();
        ArrayList<PropertiesMap> propertiesMaps = new ArrayList<PropertiesMap>(components.size());
        for (NlComponent component : components) {
            PropertiesMap propertiesMap = map2.get(component.getSnapshot());
            if (propertiesMap == null) {
                PropertiesMap propertiesMap2 = PropertiesMap.EMPTY_MAP;
                if (propertiesMap2 == null) {
                    PropertiesManager.$$$reportNull$$$0(19);
                }
                return propertiesMap2;
            }
            propertiesMaps.add(propertiesMap);
        }
        PropertiesMap first = (PropertiesMap)propertiesMaps.get(0);
        if (propertiesMaps.size() == 1) {
            PropertiesMap propertiesMap = first;
            if (propertiesMap == null) {
                PropertiesManager.$$$reportNull$$$0(20);
            }
            return propertiesMap;
        }
        PropertiesMap commonProperties = new PropertiesMap();
        for (Map.Entry property2 : first.entrySet()) {
            boolean include = true;
            for (int index = 1; index < propertiesMaps.size(); ++index) {
                PropertiesMap other = (PropertiesMap)propertiesMaps.get(index);
                if (((PropertiesMap.Property)property2.getValue()).equals(other.get(property2.getKey()))) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonProperties.put(property2.getKey(), property2.getValue());
        }
        PropertiesMap propertiesMap = commonProperties;
        if (propertiesMap == null) {
            PropertiesManager.$$$reportNull$$$0(21);
        }
        return propertiesMap;
    }

    @NotNull
    public abstract InspectorProviders<Self> getInspectorProviders(@NotNull Disposable var1);

    public void setValue(@NotNull NlProperty property2, @Nullable String value) {
        if (property2 == null) {
            PropertiesManager.$$$reportNull$$$0(22);
        }
        property2.setValue(value);
    }

    public void updateSelection() {
        if (this.mySurface == null || this.mySceneView == null) {
            return;
        }
        ImmutableList<NlComponent> selection = this.mySceneView.getSelectionModel().getSelection();
        this.componentSelectionChanged(this.mySurface, (List<NlComponent>)selection);
        ++this.myUpdateCount;
    }

    public int getUpdateCount() {
        return this.myUpdateCount;
    }

    public void propertyChanged(@NotNull NlProperty property2, @Nullable String oldValue, @Nullable String newValue) {
        if (property2 == null) {
            PropertiesManager.$$$reportNull$$$0(23);
        }
    }

    public void starStateChanged() {
        this.updateSelection();
    }

    public void resourceChanged(@NotNull ResourceItem item, @Nullable String oldValue, @Nullable String newValue) {
        if (item == null) {
            PropertiesManager.$$$reportNull$$$0(24);
        }
    }

    public abstract void logPropertyChange(@NotNull NlProperty var1);

    public void logFavoritesChange(@NotNull String added, @NotNull String removed, @NotNull List<String> favorites) {
        if (added == null) {
            PropertiesManager.$$$reportNull$$$0(25);
        }
        if (removed == null) {
            PropertiesManager.$$$reportNull$$$0(26);
        }
        if (favorites == null) {
            PropertiesManager.$$$reportNull$$$0(27);
        }
        if (this.mySceneView == null) {
            return;
        }
        NlUsageTrackerManager.getInstance(this.mySurface).logFavoritesChange(added, removed, favorites, this.mySceneView.getModel().getFacet());
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, final @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            PropertiesManager.$$$reportNull$$$0(28);
        }
        if (newSelection == null) {
            PropertiesManager.$$$reportNull$$$0(29);
        }
        if (surface != this.mySurface) {
            return;
        }
        if (!newSelection.isEmpty() && this.myFirstLoad) {
            this.myFirstLoad = false;
            this.getLoadingPanel().startLoading();
        }
        this.myLoading = true;
        MergingUpdateQueue queue = this.getUpdateQueue();
        queue.queue(new Update("updateProperties"){

            public void run() {
                PropertiesManager.this.setSelectedComponents(newSelection, () -> ((JBLoadingPanel)PropertiesManager.this.getLoadingPanel()).stopLoading());
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            PropertiesManager.$$$reportNull$$$0(30);
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        if (surface == null) {
            PropertiesManager.$$$reportNull$$$0(31);
        }
        if (component == null) {
            PropertiesManager.$$$reportNull$$$0(32);
        }
        return false;
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            PropertiesManager.$$$reportNull$$$0(33);
        }
        this.getPropertiesPanel().modelRendered();
    }

    public void dispose() {
        this.setToolContext(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/property/PropertiesManager";
                break;
            }
            case 14: 
            case 15: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "favorites";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/property/PropertiesManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGearActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyEditors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateQueue";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setStopFiltering";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedComponents";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperties";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resourceChanged";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "logFavoritesChange";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "componentSelectionChanged";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setSelectedComponents$1";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

