/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property.editors;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.BaseComponentEditor;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.Quantity;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.TextUI;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnumEditor
extends BaseComponentEditor
implements NlComponentEditor {
    private EnumSupport myEnumSupport;
    private final JPanel myPanel;
    private final CustomComboBox myCombo;
    private final JTextField myEditor;
    private final BrowsePanel myBrowsePanel;
    private NlProperty myProperty;
    private int myAddedValueIndex;
    private boolean myPopupValueChanged;
    private boolean myDisplayRealValue;

    public static EnumEditor createForTest(@NotNull NlEditingListener listener2, CustomComboBox comboBox) {
        if (listener2 == null) {
            EnumEditor.$$$reportNull$$$0(0);
        }
        return new EnumEditor(listener2, comboBox, null, false, true){

            @Override
            protected EnumSupport getEnumSupport(@NotNull NlProperty property2) {
                if (property2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new EnumSupport(property2){

                    @Override
                    @NotNull
                    public List<ValueWithDisplayString> getAllValues() {
                        ImmutableList immutableList = ImmutableList.of((Object)new ValueWithDisplayString("foo", "bar"));
                        if (immutableList == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return immutableList;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/common/property/editors/EnumEditor$1$1", "getAllValues"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/common/property/editors/EnumEditor$1", "getEnumSupport"));
            }
        };
    }

    protected EnumEditor(@NotNull NlEditingListener listener2, @NotNull CustomComboBox comboBox, @Nullable BrowsePanel browsePanel, boolean includeBorder, boolean comboEditable) {
        if (listener2 == null) {
            EnumEditor.$$$reportNull$$$0(1);
        }
        if (comboBox == null) {
            EnumEditor.$$$reportNull$$$0(2);
        }
        super(listener2);
        this.myAddedValueIndex = -1;
        this.myPanel = new JPanel(new BorderLayout(JBUI.scale((int)HORIZONTAL_COMPONENT_GAP), 0));
        this.myPanel.setFocusable(false);
        this.myBrowsePanel = browsePanel;
        this.myCombo = comboBox;
        this.myCombo.setEditable(comboEditable);
        this.myCombo.addPopupMenuListener(new PopupMenuHandler());
        this.myCombo.addActionListener(this::comboValuePicked);
        if (includeBorder) {
            this.myCombo.setBorderPanel(this.myPanel);
        }
        this.myPanel.add((Component)((Object)this.myCombo), "Center");
        if (browsePanel != null) {
            if (includeBorder) {
                browsePanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)1));
            }
            this.myPanel.add((Component)((Object)browsePanel), "After");
        }
        this.myEditor = (JTextField)this.myCombo.getEditor().getEditorComponent();
        this.myEditor.registerKeyboardAction(event -> this.enter(), KeyStroke.getKeyStroke(10, 0), 0);
        this.myEditor.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 0);
        this.myEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EnumEditor.this.myDisplayRealValue = true;
                ValueWithDisplayString value = EnumEditor.this.myCombo.getSelectedItem();
                value.setUseValueForToString(EnumEditor.this.myDisplayRealValue);
                EnumEditor.this.myEditor.setText(value.toString());
                EnumEditor.this.myEditor.selectAll();
                EnumEditor.this.myEditor.setForeground((Color)BaseComponentEditor.CHANGED_VALUE_TEXT_COLOR);
            }

            @Override
            public void focusLost(FocusEvent event) {
                EnumEditor.this.myDisplayRealValue = false;
                ValueWithDisplayString value = EnumEditor.this.createFromEditorValue(EnumEditor.this.myEditor.getText());
                if (!Objects.equals(value.getValue(), EnumEditor.this.myProperty.getValue())) {
                    EnumEditor.this.stopEditing(value.getValue());
                }
                value.setUseValueForToString(EnumEditor.this.myDisplayRealValue);
                EnumEditor.this.myEditor.setText(value.toString());
                EnumEditor.this.myEditor.setForeground((Color)(value.getValue() != null ? BaseComponentEditor.CHANGED_VALUE_TEXT_COLOR : BaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR));
                EnumEditor.this.myEditor.select(0, 0);
            }
        });
        this.myCombo.setRenderer((ListCellRenderer)((Object)new EnumRenderer()));
        this.myProperty = EmptyProperty.INSTANCE;
    }

    @Override
    public void setProperty(@NotNull NlProperty property2) {
        if (property2 == null) {
            EnumEditor.$$$reportNull$$$0(3);
        }
        this.setProperty(property2, false);
    }

    public void setProperty(@NotNull NlProperty property2, boolean force) {
        if (property2 == null) {
            EnumEditor.$$$reportNull$$$0(4);
        }
        if (property2 != this.myProperty || force) {
            this.setModel(property2);
        }
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setProperty(property2);
        }
        this.selectItem(this.createFromEditorValue(property2.getValue()));
    }

    @Override
    public void setEnabled(boolean en) {
        this.myCombo.setEnabled(en);
    }

    @Override
    public void requestFocus() {
        this.myCombo.requestFocus();
    }

    protected abstract EnumSupport getEnumSupport(@NotNull NlProperty var1);

    protected void setModel(@NotNull NlProperty property2) {
        if (property2 == null) {
            EnumEditor.$$$reportNull$$$0(5);
        }
        this.myProperty = property2;
        this.myEnumSupport = this.getEnumSupport(property2);
        List<ValueWithDisplayString> values2 = this.myEnumSupport.getAllValues();
        ValueWithDisplayString[] valueArray = values2.toArray(new ValueWithDisplayString[0]);
        DefaultComboBoxModel<ValueWithDisplayString> newModel = new DefaultComboBoxModel<ValueWithDisplayString>(valueArray){

            @Override
            public void setSelectedItem(Object object) {
                if (object instanceof String) {
                    object = EnumEditor.this.createFromEditorValue((String)object);
                }
                if (object instanceof ValueWithDisplayString) {
                    ValueWithDisplayString value = (ValueWithDisplayString)object;
                    ValueWithDisplayString.ValueSelector selector = value.getValueSelector();
                    if (selector != null) {
                        value = selector.selectValue(EnumEditor.this.myProperty.getValue());
                        if (value == null) {
                            return;
                        }
                        String selectedValue = value.getValue();
                        ApplicationManager.getApplication().invokeLater(() -> EnumEditor.this.stopEditing(selectedValue));
                    }
                    value.setUseValueForToString(EnumEditor.this.myDisplayRealValue);
                    object = value;
                }
                super.setSelectedItem(object);
            }
        };
        ValueWithDisplayString defaultValue = this.createFromEditorValue(null);
        newModel.insertElementAt(defaultValue, 0);
        this.myCombo.setModel(newModel);
        this.myAddedValueIndex = -1;
    }

    private void updateModel() {
        ValueWithDisplayString selected = this.myCombo.getSelectedItem();
        ValueWithDisplayString added = this.myAddedValueIndex >= 0 ? (ValueWithDisplayString)this.myCombo.getModel().getElementAt(this.myAddedValueIndex) : null;
        this.setModel(this.myProperty);
        if (added != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCombo.getModel();
            this.myAddedValueIndex = this.findBestInsertionPoint(added);
            model.insertElementAt(added, this.myAddedValueIndex);
        }
        this.myCombo.setSelectedItem(selected);
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        NlProperty nlProperty = this.myProperty;
        if (nlProperty == null) {
            EnumEditor.$$$reportNull$$$0(6);
        }
        return nlProperty;
    }

    private void selectItem(@NotNull ValueWithDisplayString value) {
        DefaultComboBoxModel model;
        int index;
        if (value == null) {
            EnumEditor.$$$reportNull$$$0(7);
        }
        if ((index = (model = (DefaultComboBoxModel)this.myCombo.getModel()).getIndexOf(value)) == -1) {
            if (this.myAddedValueIndex >= 0) {
                model.removeElementAt(this.myAddedValueIndex);
            }
            this.myAddedValueIndex = this.findBestInsertionPoint(value);
            model.insertElementAt(value, this.myAddedValueIndex);
        }
        value.setUseValueForToString(this.myDisplayRealValue);
        if (!value.equals(model.getSelectedItem())) {
            model.setSelectedItem(value);
        }
        this.myEditor.setText(value.toString());
        this.myEditor.setForeground((Color)(value.getValue() != null ? CHANGED_VALUE_TEXT_COLOR : DEFAULT_VALUE_TEXT_COLOR));
    }

    public void selectItem(@Nullable String value) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCombo.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ValueWithDisplayString candidate = (ValueWithDisplayString)model.getElementAt(i);
            if (!Objects.equals(candidate.getValue(), value)) continue;
            model.setSelectedItem(candidate);
            return;
        }
    }

    private int findBestInsertionPoint(@NotNull ValueWithDisplayString newValue) {
        AttributeDefinition definition;
        if (newValue == null) {
            EnumEditor.$$$reportNull$$$0(8);
        }
        boolean isDimension = (definition = this.myProperty.getDefinition()) != null && definition.getFormats().contains((Object)AttributeFormat.Dimension);
        int startIndex = 1;
        if (!isDimension) {
            return startIndex;
        }
        String newTextValue = newValue.getDisplayString();
        if (StringUtil.isEmpty((String)newTextValue)) {
            return startIndex;
        }
        Quantity newQuantity = Quantity.parse(newTextValue);
        if (newQuantity == null) {
            return startIndex;
        }
        ComboBoxModel<ValueWithDisplayString> model = this.myCombo.getModel();
        int size = model.getSize();
        for (int index = startIndex; index < size; ++index) {
            Quantity quantity;
            String textValue = ((ValueWithDisplayString)model.getElementAt(index)).getValue();
            if (textValue == null || newQuantity.compareTo(quantity = Quantity.parse(textValue)) > 0) continue;
            return index;
        }
        return model.getSize();
    }

    @Override
    @Nullable
    public Object getValue() {
        ValueWithDisplayString value = this.myCombo.getSelectedItem();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            EnumEditor.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @NotNull
    public Component getKeySource() {
        JTextField jTextField = this.myEditor;
        if (jTextField == null) {
            EnumEditor.$$$reportNull$$$0(10);
        }
        return jTextField;
    }

    private void enter() {
        if (!this.myCombo.isPopupVisible()) {
            ValueWithDisplayString value = this.createFromEditorValue(this.myEditor.getText());
            this.selectItem(value);
            this.stopEditing(value.getValue());
            this.myCombo.getEditor().selectAll();
        }
        this.myCombo.hidePopup();
    }

    private void cancel() {
        String text = this.myProperty.getValue();
        this.myCombo.getEditor().setItem(text);
        ValueWithDisplayString value = this.createFromEditorValue(this.myProperty.getValue());
        this.selectItem(value);
        this.myPopupValueChanged = false;
        this.cancelEditing();
        this.myCombo.getEditor().selectAll();
        this.myCombo.hidePopup();
    }

    @NotNull
    private ValueWithDisplayString createFromEditorValue(@Nullable String editorValue) {
        assert (this.myEnumSupport != null) : "EnumSupport should have been setup by setModel";
        ValueWithDisplayString valueWithDisplayString = this.myEnumSupport.createValue(StringUtil.notNullize((String)editorValue));
        if (valueWithDisplayString == null) {
            EnumEditor.$$$reportNull$$$0(11);
        }
        return valueWithDisplayString;
    }

    private void comboValuePicked(@NotNull ActionEvent event) {
        if (event == null) {
            EnumEditor.$$$reportNull$$$0(12);
        }
        if ("comboBoxChanged".equals(event.getActionCommand())) {
            this.myPopupValueChanged = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/property/editors/EnumEditor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/property/editors/EnumEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeySource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromEditorValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBestInsertionPoint";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "comboValuePicked";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CustomDarculaComboBoxUI
    extends DarculaComboBoxUI {
        public CustomDarculaComboBoxUI(@NotNull JComboBox comboBox) {
            if (comboBox == null) {
                CustomDarculaComboBoxUI.$$$reportNull$$$0(0);
            }
        }

        protected Insets getInsets() {
            return JBUI.insets((int)2, (int)7, (int)2, (int)4).asUIResource();
        }

        @NotNull
        protected Color getArrowButtonFillColor(@NotNull Color defaultColor) {
            if (defaultColor == null) {
                CustomDarculaComboBoxUI.$$$reportNull$$$0(1);
            }
            JBColor jBColor = JBColor.LIGHT_GRAY;
            if (jBColor == null) {
                CustomDarculaComboBoxUI.$$$reportNull$$$0(2);
            }
            return jBColor;
        }

        protected void configureEditor() {
            super.configureEditor();
            if (this.editor instanceof JTextField) {
                JTextField tf = (JTextField)this.editor;
                tf.setUI((TextUI)DarculaTextFieldUI.createUI((JComponent)tf));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!JBColor.isBright()) {
                super.paintBorder(c, g, x, y, width, height);
                return;
            }
            Color panelBefore = UIManager.getColor("Panel.background");
            Color comboBefore = UIManager.getColor("ComboBox.background");
            try {
                UIManager.getLookAndFeelDefaults().put("Panel.background", c.getBackground());
                UIManager.getLookAndFeelDefaults().put("ComboBox.background", c.getBackground());
                super.paintBorder(c, g, x, y, width, height);
            }
            finally {
                UIManager.getLookAndFeelDefaults().put("Panel.background", panelBefore);
                UIManager.getLookAndFeelDefaults().put("ComboBox.background", comboBefore);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comboBox";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultColor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/property/editors/EnumEditor$CustomDarculaComboBoxUI";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/property/editors/EnumEditor$CustomDarculaComboBoxUI";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrowButtonFillColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getArrowButtonFillColor";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CustomComboBox
    extends ComboBox {
        private JPanel myBorderPanel;
        private boolean myUseDarculaUI;

        public CustomComboBox() {
            this.setBackground((Color)JBColor.WHITE);
            this.setBorders();
        }

        public void setBorderPanel(@NotNull JPanel borderPanel) {
            if (borderPanel == null) {
                CustomComboBox.$$$reportNull$$$0(0);
            }
            this.myBorderPanel = borderPanel;
            this.setBorders();
        }

        public ComboBoxModel<ValueWithDisplayString> getModel() {
            return super.getModel();
        }

        public ValueWithDisplayString getSelectedItem() {
            return (ValueWithDisplayString)super.getSelectedItem();
        }

        private void setBorders() {
            int horizontalSpacing = 4 + (this.myUseDarculaUI ? 0 : 1);
            if (this.myBorderPanel != null) {
                this.myBorderPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)horizontalSpacing, (int)2, (int)0));
            }
        }

        public void setUI(ComboBoxUI ui) {
            boolean bl = this.myUseDarculaUI = !(ui instanceof WindowsComboBoxUI) && !ApplicationManager.getApplication().isUnitTestMode();
            if (this.myUseDarculaUI) {
                ui = new CustomDarculaComboBoxUI((JComboBox)((Object)this));
            }
            super.setUI(ui);
            this.setBorders();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderPanel", "com/android/tools/idea/common/property/editors/EnumEditor$CustomComboBox", "setBorderPanel"));
        }
    }

    private class PopupMenuHandler
    implements PopupMenuListener {
        private PopupMenuHandler() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            EnumEditor.this.myPopupValueChanged = false;
            EnumEditor.this.updateModel();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            if (EnumEditor.this.myPopupValueChanged) {
                EnumEditor.this.myPopupValueChanged = false;
                ValueWithDisplayString value = (ValueWithDisplayString)EnumEditor.this.myCombo.getModel().getSelectedItem();
                value.setUseValueForToString(EnumEditor.this.myDisplayRealValue);
                EnumEditor.this.stopEditing(value.getValue());
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent event) {
            EnumEditor.this.myPopupValueChanged = false;
        }
    }

    private class EnumRenderer
    extends ColoredListCellRenderer<ValueWithDisplayString> {
        private EnumRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends ValueWithDisplayString> list, ValueWithDisplayString value, int index, boolean selected, boolean hasFocus) {
            if (value == ValueWithDisplayString.SEPARATOR) {
                return new JSeparator();
            }
            return super.getListCellRendererComponent(list, (Object)value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList list, ValueWithDisplayString value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                EnumRenderer.$$$reportNull$$$0(0);
            }
            if (value != null) {
                boolean skipDefault = EnumEditor.this.myEnumSupport.customizeCellRenderer(this, value, selected);
                if (skipDefault) {
                    return;
                }
                String displayString = value.getDisplayString();
                String actualValue = value.getValue();
                String hint = value.getHint();
                boolean isDefaultValue = EnumEditor.this.myProperty.isDefaultValue(actualValue);
                if (!selected && !isDefaultValue && Objects.equals(actualValue, EnumEditor.this.getValue())) {
                    this.myForeground = BaseComponentEditor.CHANGED_VALUE_TEXT_COLOR;
                } else if (index == 0 || isDefaultValue) {
                    this.myForeground = BaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR;
                }
                if (!StringUtil.isEmpty((String)displayString)) {
                    this.append(displayString);
                    if (!StringUtil.isEmpty((String)hint)) {
                        this.myForeground = BaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR;
                        this.append(" [");
                        this.append(hint);
                        this.append("]");
                    }
                } else if (actualValue != null) {
                    this.append(actualValue);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/common/property/editors/EnumEditor$EnumRenderer", "customizeCellRenderer"));
        }
    }
}

