/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.property.inspector;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorProviders;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.html.HtmlEscapers;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectorPanel<PropMgr extends PropertiesManager<PropMgr>>
extends AdtSecondaryPanel
implements KeyEventDispatcher {
    private static final int MAX_LABEL_WIDTH = JBUI.scale((int)200);
    private static final int HORIZONTAL_SPACING = 6;
    private static final int COLUMN_COUNT = 2;
    @Nullable
    private final JComponent myBottomLink;
    private final Font myBoldLabelFont;
    private final GridInspectorPanel myInspector;
    private final SpeedSearchComparator myComparator;
    private final Map<Component, ExpandableGroup> mySource2GroupMap;
    private final Map<JLabel, ExpandableGroup> myLabel2GroupMap;
    private final Multimap<JLabel, Component> myLabel2ComponentMap;
    private final JLabel myDefaultLabel;
    private final InspectorExpandableItemsHandler myExpandableItemsHandler;
    private final Disposable myParentDisposable;
    private InspectorProviders<PropMgr> myInspectorProviders;
    private List<InspectorComponent<PropMgr>> myInspectors;
    private ExpandableGroup myGroup;
    private GridConstraints myConstraints;
    private int myRow;
    private boolean myActivateEditorAfterLoad;
    private String myPropertyNameForActivation;
    private String myFilter;

    public InspectorPanel(@NotNull Disposable parentDisposable, @Nullable JComponent bottomLink) {
        if (parentDisposable == null) {
            InspectorPanel.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new BorderLayout());
        this.myBoldLabelFont = UIUtil.getLabelFont().deriveFont(1);
        this.mySource2GroupMap = new IdentityHashMap<Component, ExpandableGroup>(4);
        this.myLabel2GroupMap = new IdentityHashMap<JLabel, ExpandableGroup>(4);
        this.myLabel2ComponentMap = HashMultimap.create();
        this.myDefaultLabel = new JLabel();
        this.myInspectors = Collections.emptyList();
        this.myConstraints = new GridConstraints();
        this.myBottomLink = bottomLink;
        if (this.myBottomLink != null) {
            this.myBottomLink.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        }
        this.myParentDisposable = parentDisposable;
        this.myInspector = new GridInspectorPanel();
        this.myInspector.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.myComparator = new SpeedSearchComparator(false);
        this.myExpandableItemsHandler = new InspectorExpandableItemsHandler(this);
        this.myFilter = "";
        this.add((Component)((Object)this.myInspector), "Center");
    }

    public void requestFocus() {
        List<NlComponentEditor> editors;
        if (!this.myInspectors.isEmpty() && !(editors = this.myInspectors.get(0).getEditors()).isEmpty()) {
            editors.get(0).requestFocus();
        }
    }

    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.myExpandableItemsHandler.install(this.myParentDisposable);
    }

    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.myExpandableItemsHandler.remove();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Component source;
        ExpandableGroup group;
        if (event.getKeyCode() == 9 && event.getModifiers() == 0 && event.getID() == 401 && event.getSource() instanceof Component && (group = this.mySource2GroupMap.get(source = (Component)event.getSource())) != null && !group.isExpanded()) {
            group.setExpanded(true, true);
            ApplicationManager.getApplication().invokeLater(source::transferFocus);
            return true;
        }
        return false;
    }

    public void setFilter(@NotNull String filter2) {
        if (filter2 == null) {
            InspectorPanel.$$$reportNull$$$0(1);
        }
        this.myFilter = filter2;
        ApplicationManager.getApplication().invokeLater(this::updateAfterFilterChange);
    }

    @NotNull
    public String getFilter() {
        String string = this.myFilter;
        if (string == null) {
            InspectorPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void enterInFilter(@NotNull KeyEvent event) {
        if (event == null) {
            InspectorPanel.$$$reportNull$$$0(3);
        }
        if (this.myFilter.isEmpty()) {
            return;
        }
        Set visibleLabels = this.myLabel2ComponentMap.keySet().stream().filter(Component::isVisible).collect(Collectors.toSet());
        if (visibleLabels.size() != 1) {
            return;
        }
        Collection components = this.myLabel2ComponentMap.get(visibleLabels.iterator().next());
        if (components.size() != 1) {
            return;
        }
        Component editor = (Component)components.iterator().next();
        editor.transferFocus();
        event.consume();
    }

    public void expandGroup(@NotNull JLabel label) {
        ExpandableGroup group;
        if (label == null) {
            InspectorPanel.$$$reportNull$$$0(4);
        }
        if ((group = this.myLabel2GroupMap.get(label)) != null) {
            group.setExpanded(true, true);
        }
    }

    private void updateAfterFilterChange() {
        if (this.myFilter.isEmpty()) {
            this.restoreGroups();
        } else {
            this.applyFilter();
        }
        this.myInspector.invalidate();
        this.myInspector.repaint();
    }

    private void applyFilter() {
        for (JLabel label : this.myLabel2ComponentMap.keySet()) {
            boolean display2 = this.isMatch(label);
            label.setVisible(display2);
            this.myLabel2ComponentMap.get((Object)label).forEach(component -> component.setVisible(display2));
            ExpandableGroup group = this.myLabel2GroupMap.get(label);
            if (group == null) continue;
            label.setIcon(null);
        }
    }

    private void restoreGroups() {
        HashSet<Component> toShow = new HashSet<Component>(Arrays.asList(this.myInspector.getComponents()));
        for (ExpandableGroup group : this.myLabel2GroupMap.values()) {
            toShow.removeAll(group.myComponents);
            group.setExpanded(group.isExpanded(), false);
        }
        toShow.forEach(component -> component.setVisible(true));
        this.myInspectors.forEach(InspectorComponent::updateVisibility);
    }

    private boolean isMatch(@NotNull JLabel label) {
        if (label == null) {
            InspectorPanel.$$$reportNull$$$0(5);
        }
        if (this.myFilter.isEmpty()) {
            return true;
        }
        String text = StringUtil.removeHtmlTags((String)label.getText());
        if (StringUtil.isEmpty((String)text) || label.getFont() == this.myBoldLabelFont) {
            return false;
        }
        return this.myComparator.matchingFragments(this.myFilter, text) != null;
    }

    @NotNull
    private static GridLayoutManager createLayoutManager(int rows) {
        JBInsets margin = new JBInsets(0, 0, 0, 0);
        GridLayoutManager gridLayoutManager = new GridLayoutManager(rows, 2, (Insets)margin, 0, 0);
        if (gridLayoutManager == null) {
            InspectorPanel.$$$reportNull$$$0(6);
        }
        return gridLayoutManager;
    }

    public void setComponent(@NotNull List<NlComponent> components, @NotNull Table<String, String, ? extends NlProperty> properties, @NotNull PropMgr propertiesManager) {
        if (components == null) {
            InspectorPanel.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            InspectorPanel.$$$reportNull$$$0(8);
        }
        if (propertiesManager == null) {
            InspectorPanel.$$$reportNull$$$0(9);
        }
        this.myInspector.setLayout(null);
        this.myInspector.removeAll();
        this.mySource2GroupMap.clear();
        this.myLabel2GroupMap.clear();
        this.myLabel2ComponentMap.clear();
        this.myRow = 0;
        if (!components.isEmpty()) {
            HashMap propertiesByName = Maps.newHashMapWithExpectedSize((int)properties.size());
            for (NlProperty property2 : properties.row((Object)"http://schemas.android.com/apk/res/android").values()) {
                propertiesByName.put(property2.getName(), property2);
            }
            for (NlProperty property2 : properties.row((Object)"http://schemas.android.com/apk/res-auto").values()) {
                propertiesByName.put(property2.getName(), property2);
            }
            for (NlProperty property2 : properties.row((Object)"").values()) {
                propertiesByName.put(property2.getName(), property2);
            }
            this.collectExtraProperties(components, propertiesManager, propertiesByName);
            if (this.myInspectorProviders != null) {
                Disposer.dispose(this.myInspectorProviders);
            }
            this.myInspectorProviders = ((PropertiesManager)propertiesManager).getInspectorProviders(this.myParentDisposable);
            this.myInspectors = this.myInspectorProviders.createInspectorComponents(components, propertiesByName, propertiesManager);
            int rows = 0;
            for (InspectorComponent<PropMgr> inspector : this.myInspectors) {
                rows += inspector.getMaxNumberOfRows();
            }
            rows += this.myInspectors.size();
            this.myInspector.setLayout((LayoutManager)InspectorPanel.createLayoutManager(rows += 2));
            for (InspectorComponent<PropMgr> inspector : this.myInspectors) {
                this.addSeparator();
                inspector.attachToInspector(this);
            }
            this.endGroup();
            this.addSeparator();
            this.myInspector.add((Component)new Spacer(), new GridConstraints(this.myRow++, 0, 1, 2, 0, 1, 2, 6, null, null, null, 0, false));
            if (this.myBottomLink != null) {
                this.addLineComponent(this.myBottomLink, this.myRow++);
            }
        }
        this.myInspector.updateGridConstraints();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myFilter.isEmpty()) {
                this.applyFilter();
            }
            if (this.myActivateEditorAfterLoad) {
                this.activatePreferredEditor(this.myPropertyNameForActivation);
            }
            this.repaint();
        });
    }

    protected void collectExtraProperties(@NotNull List<NlComponent> components, @NotNull PropMgr propertiesManager, Map<String, NlProperty> propertiesByName) {
        if (components == null) {
            InspectorPanel.$$$reportNull$$$0(10);
        }
        if (propertiesManager == null) {
            InspectorPanel.$$$reportNull$$$0(11);
        }
    }

    public void refresh() {
        ApplicationManager.getApplication().invokeLater(() -> this.myInspectors.forEach(InspectorComponent::refresh));
    }

    public void activatePreferredEditor(@NotNull String propertyName, boolean activateAfterLoading) {
        if (propertyName == null) {
            InspectorPanel.$$$reportNull$$$0(12);
        }
        if (activateAfterLoading) {
            this.myActivateEditorAfterLoad = true;
            this.myPropertyNameForActivation = propertyName;
        } else {
            this.activatePreferredEditor(propertyName);
        }
    }

    private void activatePreferredEditor(@NotNull String propertyName) {
        if (propertyName == null) {
            InspectorPanel.$$$reportNull$$$0(13);
        }
        this.myActivateEditorAfterLoad = false;
        this.myPropertyNameForActivation = null;
        boolean designPropertyRequired = propertyName.startsWith("tools:");
        propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:");
        for (InspectorComponent<PropMgr> component : this.myInspectors) {
            for (NlComponentEditor editor : component.getEditors()) {
                NlProperty property2 = editor.getProperty();
                if (!propertyName.equals(property2.getName()) || designPropertyRequired && !"http://schemas.android.com/tools".equals(property2.getNamespace())) continue;
                editor.requestFocus();
                return;
            }
        }
    }

    public JLabel addTitle(@NotNull String title) {
        if (title == null) {
            InspectorPanel.$$$reportNull$$$0(14);
        }
        return this.addTitle(title, null);
    }

    public JLabel addTitle(@NotNull String title, @Nullable Component rightComponent) {
        if (title == null) {
            InspectorPanel.$$$reportNull$$$0(15);
        }
        JLabel label = InspectorPanel.createLabel(title, null, null);
        label.setFont(this.myBoldLabelFont);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)label, "West");
        if (rightComponent != null) {
            panel.add(rightComponent, "East");
        }
        this.addLineComponent(panel, this.myRow++);
        this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)panel);
        this.startGroup(label, true, null);
        this.myLabel2GroupMap.put(label, this.myGroup);
        return label;
    }

    public void addSeparator() {
        this.endGroup();
        if (this.myRow > 0) {
            JSeparator component = new JSeparator();
            this.addLineComponent(component, this.myRow++);
            this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)component);
        }
    }

    public JLabel addExpandableComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component, @NotNull Component keySource) {
        if (labelText == null) {
            InspectorPanel.$$$reportNull$$$0(16);
        }
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(17);
        }
        if (keySource == null) {
            InspectorPanel.$$$reportNull$$$0(18);
        }
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component, this.myRow++);
        this.startGroup(label, false, keySource);
        this.myLabel2GroupMap.put(label, this.myGroup);
        this.myLabel2ComponentMap.put((Object)label, (Object)component);
        return label;
    }

    public JLabel addComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component) {
        if (labelText == null) {
            InspectorPanel.$$$reportNull$$$0(19);
        }
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(20);
        }
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component, this.myRow++);
        this.myLabel2ComponentMap.put((Object)label, (Object)component);
        return label;
    }

    public void addPanel(@NotNull JComponent panel) {
        if (panel == null) {
            InspectorPanel.$$$reportNull$$$0(21);
        }
        this.addLineComponent(panel, this.myRow++);
        this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)panel);
    }

    private static JLabel createLabel(@NotNull String labelText, @Nullable String tooltip, @Nullable Component component) {
        if (labelText == null) {
            InspectorPanel.$$$reportNull$$$0(22);
        }
        JBLabel label = new JBLabel("<html><nobr>" + HtmlEscapers.htmlEscaper().escape(labelText) + "</nobr></html>");
        label.setLabelFor(component);
        label.setToolTipText(tooltip);
        label.setSize(label.getPreferredSize());
        return label;
    }

    private void addLineComponent(@NotNull Component component, int row) {
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(23);
        }
        this.addComponent(component, row, 0, 2, 8, 1);
    }

    private void addLabelComponent(@NotNull Component component, int row) {
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(24);
        }
        this.addComponent(component, row, 0, 1, 8, 1);
    }

    private void addValueComponent(@NotNull Component component, int row) {
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(25);
        }
        this.addComponent(component, row, 1, 1, 4, 1);
    }

    private void addComponent(@NotNull Component component, int row, int column, int columnSpan, int anchor, int fill2) {
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(26);
        }
        this.addToGridPanel((JPanel)((Object)this.myInspector), component, row, column, columnSpan, anchor, fill2);
        if (this.myGroup != null) {
            this.myGroup.addComponent(component);
        }
    }

    private void addToGridPanel(@NotNull JPanel panel, @NotNull Component component, int row, int column, int columnSpan, int anchor, int fill2) {
        if (panel == null) {
            InspectorPanel.$$$reportNull$$$0(27);
        }
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(28);
        }
        this.myConstraints.setRow(row);
        this.myConstraints.setColumn(column);
        this.myConstraints.setColSpan(columnSpan);
        this.myConstraints.setAnchor(anchor);
        this.myConstraints.setFill(fill2);
        panel.add(component, this.myConstraints);
    }

    private void startGroup(@NotNull JLabel label, boolean initiallyExpanded, @Nullable Component keySource) {
        if (label == null) {
            InspectorPanel.$$$reportNull$$$0(29);
        }
        this.myGroup = new ExpandableGroup(label, this.myGroup, initiallyExpanded);
        if (keySource != null) {
            this.mySource2GroupMap.put(keySource, this.myGroup);
        }
    }

    private void endGroup() {
        this.myGroup = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/property/inspector/InspectorPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 5: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 17: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keySource";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/property/inspector/InspectorPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayoutManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enterInFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMatch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setComponent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectExtraProperties";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTitle";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addExpandableComponent";
                break;
            }
            case 19: 
            case 20: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addPanel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addLineComponent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addLabelComponent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addValueComponent";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addToGridPanel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "startGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InspectorExpandableItemsHandler
    extends AbstractExpandableItemsHandler<JLabel, JPanel> {
        private final MousePreprocessor myMousePreprocessor;
        private final JLabel myRenderer;

        protected InspectorExpandableItemsHandler(@NotNull InspectorPanel component) {
            if (component == null) {
                InspectorExpandableItemsHandler.$$$reportNull$$$0(0);
            }
            super((JComponent)((Object)component.myInspector));
            this.myMousePreprocessor = new MousePreprocessor();
            this.myRenderer = new JLabel();
        }

        private void install(@NotNull Disposable parent) {
            if (parent == null) {
                InspectorExpandableItemsHandler.$$$reportNull$$$0(1);
            }
            IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)this.myComponent);
            glassPane.addMouseMotionPreprocessor((MouseMotionListener)this.myMousePreprocessor, parent);
        }

        private void remove() {
            IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)this.myComponent);
            glassPane.removeMouseMotionPreprocessor((MouseMotionListener)this.myMousePreprocessor);
        }

        @Nullable
        protected Pair<Component, Rectangle> getCellRendererAndBounds(@NotNull JLabel key) {
            if (key == null) {
                InspectorExpandableItemsHandler.$$$reportNull$$$0(2);
            }
            this.myRenderer.setText(key.getText());
            this.myRenderer.setFont(key.getFont());
            this.myRenderer.setForeground(key.getForeground());
            this.myRenderer.setBackground(key.getBackground());
            Rectangle bounds = new Rectangle(key.getLocation(), key.getPreferredSize());
            return Pair.create((Object)this.myRenderer, (Object)bounds);
        }

        @NotNull
        protected Rectangle getVisibleRect(@NotNull JLabel key) {
            if (key == null) {
                InspectorExpandableItemsHandler.$$$reportNull$$$0(3);
            }
            Rectangle rectangle = SwingUtilities.convertRectangle(key, key.getVisibleRect(), this.myComponent);
            if (rectangle == null) {
                InspectorExpandableItemsHandler.$$$reportNull$$$0(4);
            }
            return rectangle;
        }

        @Nullable
        protected JLabel getCellKeyForPoint(@NotNull Point point) {
            if (point == null) {
                InspectorExpandableItemsHandler.$$$reportNull$$$0(5);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/property/inspector/InspectorPanel$InspectorExpandableItemsHandler";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/property/inspector/InspectorPanel$InspectorExpandableItemsHandler";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVisibleRect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "install";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCellRendererAndBounds";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getVisibleRect";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCellKeyForPoint";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MousePreprocessor
        extends MouseMotionAdapter {
            private MousePreprocessor() {
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                Component component;
                if (event == null) {
                    MousePreprocessor.$$$reportNull$$$0(0);
                }
                Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), InspectorExpandableItemsHandler.this.myComponent);
                if (((JPanel)InspectorExpandableItemsHandler.this.myComponent).contains(point) && (component = ((JPanel)InspectorExpandableItemsHandler.this.myComponent).getComponentAt(point.x, point.y)) instanceof JLabel) {
                    InspectorExpandableItemsHandler.this.handleSelectionChange((JLabel)component, true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/common/property/inspector/InspectorPanel$InspectorExpandableItemsHandler$MousePreprocessor", "mouseMoved"));
            }
        }
    }

    private static class GridInspectorPanel
    extends AdtSecondaryPanel {
        private int myWidth;

        private GridInspectorPanel() {
        }

        public void setLayout(LayoutManager layoutManager) {
            this.myWidth = -1;
            super.setLayout(layoutManager);
        }

        public void invalidate() {
            this.myWidth = -1;
            super.invalidate();
        }

        public void doLayout() {
            this.updateGridConstraints();
            super.doLayout();
        }

        private void updateGridConstraints() {
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                if (this.getWidth() != this.myWidth) {
                    this.myWidth = this.getWidth();
                    int labelWidth = Math.min((int)((double)(this.myWidth - 12) * 0.4), MAX_LABEL_WIDTH);
                    int editorWidth = this.myWidth - 12 - labelWidth;
                    for (Component component : this.getComponents()) {
                        GridConstraints constraints = gridLayoutManager.getConstraintsForComponent(component);
                        if (constraints == null) continue;
                        GridInspectorPanel.updateMinimumSize(constraints, labelWidth, editorWidth);
                    }
                }
            }
        }

        private static void updateMinimumSize(@NotNull GridConstraints constraints, int labelWidth, int editorWidth) {
            if (constraints == null) {
                GridInspectorPanel.$$$reportNull$$$0(0);
            }
            if (constraints.getColSpan() == 1) {
                if (constraints.getColumn() == 0) {
                    constraints.myMinimumSize.setSize(labelWidth, -1);
                } else if (constraints.getColumn() == 1) {
                    constraints.myMinimumSize.setSize(editorWidth, -1);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/android/tools/idea/common/property/inspector/InspectorPanel$GridInspectorPanel", "updateMinimumSize"));
        }
    }

    private static class ExpandableGroup {
        private static final String KEY_PREFIX = "inspector.open.";
        private static final Icon EXPANDED_ICON = (Icon)UIManager.get("Tree.expandedIcon");
        private static final Icon COLLAPSED_ICON = (Icon)UIManager.get("Tree.collapsedIcon");
        private final JLabel myLabel;
        private final ExpandableGroup myParent;
        private final List<Component> myComponents;
        private final List<ExpandableGroup> myChildren;
        private boolean myExpanded;

        public ExpandableGroup(final @NotNull JLabel label, @Nullable ExpandableGroup parent, boolean defaultValue) {
            if (label == null) {
                ExpandableGroup.$$$reportNull$$$0(0);
            }
            this.myLabel = label;
            this.myParent = parent;
            this.myComponents = new ArrayList<Component>(4);
            this.myChildren = new ArrayList<ExpandableGroup>();
            this.myExpanded = PropertiesComponent.getInstance().getBoolean(KEY_PREFIX + StringUtil.removeHtmlTags((String)label.getText()), defaultValue);
            label.setIcon(this.myExpanded ? EXPANDED_ICON : COLLAPSED_ICON);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (label.getIcon() != null) {
                        this.setExpanded(!this.isExpanded(), true);
                    }
                }
            });
            if (parent != null) {
                parent.myChildren.add(this);
            }
        }

        public void addComponent(@NotNull Component component) {
            if (component == null) {
                ExpandableGroup.$$$reportNull$$$0(1);
            }
            if (this.myParent != null) {
                this.myParent.addComponent(component);
            }
            this.myComponents.add(component);
            if (!this.myExpanded) {
                component.setVisible(false);
            }
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        public void setExpanded(boolean expanded, boolean updateProperties) {
            this.myExpanded = expanded;
            this.myLabel.setIcon(expanded ? EXPANDED_ICON : COLLAPSED_ICON);
            this.myComponents.forEach(component -> component.setVisible(expanded));
            if (expanded) {
                for (ExpandableGroup group : this.myChildren) {
                    group.setExpanded(group.isExpanded(), false);
                }
            }
            if (updateProperties) {
                PropertiesComponent.getInstance().setValue(KEY_PREFIX + StringUtil.removeHtmlTags((String)this.myLabel.getText()), expanded);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/common/property/inspector/InspectorPanel$ExpandableGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

